/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.MainView;
import translator.TranslationUnitMap;
import translator.database.DBConnection;
import translator.database.DatabaseView;
import translator.database.TermBase;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXFilterDialog;
import translator.ui.GridPanel;

public class TMXImportDialog
extends JDialog
implements ActionListener {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JTextField jTextField0 = null;
    private JTextField jTextField1 = null;
    private JTextField jTextField2 = null;
    private JComboBox combo1;
    private JComboBox combo2;
    private JComboBox combo5;
    private Memory tm;
    private MainView topui;

    public TMXImportDialog(MainView owner, Memory tm, String title) {
        super(owner, title, true);
        DBConnection conn;
        TranslationUnitMap map;
        this.tm = tm;
        this.topui = owner;
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel0 = new JPanel();
        jPanel0.setOpaque(false);
        jPanel0.setLayout(new FlowLayout(2));
        jPanel0.setBorder(new EmptyBorder(new Insets(10, 0, 0, 0)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(new Insets(3, 3, 6, 3)));
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridLayout(0, 2, 10, 5));
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LANGUAGE PAIR") + " (TMX)"), new EmptyBorder(new Insets(3, 3, 3, 3))));
        jPanel4.setLayout(new FlowLayout(1));
        this.jTextField0 = new JTextField();
        if (tm.encoding != null) {
            this.jTextField0.setText(tm.encoding);
        }
        this.jTextField0.setMargin(new Insets(0, 2, 0, 0));
        this.jTextField0.setPreferredSize(new Dimension(30, this.jTextField0.getPreferredSize().height));
        Vector slangs = null;
        Vector tlangs = null;
        TMX tmx = tm.getTMX();
        if (tmx != null && (map = tmx.getTUMap()) != null) {
            slangs = map.getSourceLangs();
            tlangs = map.getTargetLangs();
        }
        if (slangs != null && slangs.size() > 0) {
            this.combo1 = new JComboBox(slangs);
        } else {
            String slang = tm.getSourceLangCode();
            String tlang = tm.getTargetLangCode();
            this.combo1 = new JComboBox();
            if (slang != null && slang.length() > 0) {
                this.combo1.addItem(slang);
            } else {
                this.combo1.addItem(AppPreferences.fileSLang);
            }
        }
        this.combo1.setEditable(true);
        if (tlangs != null && tlangs.size() > 0) {
            this.combo2 = new JComboBox(tlangs);
        } else {
            this.combo2 = new JComboBox();
            String tlang = tm.getTargetLangCode();
            if (tlang != null && tlang.length() > 0) {
                this.combo2.addItem(tlang);
            } else {
                this.combo2.addItem(AppPreferences.fileTLang);
            }
        }
        this.combo2.setEditable(true);
        JLabel label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ENCODING:"));
        label.setFont(label.getFont().deriveFont(1));
        label.setHorizontalAlignment(4);
        jPanel3.add(label);
        jPanel3.add(this.jTextField0);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY TABLE:"));
        label.setFont(label.getFont().deriveFont(1));
        label.setHorizontalAlignment(4);
        DatabaseView dv = this.topui.getDatabaseView();
        List list = dv.getTableNames();
        this.combo5 = new JComboBox<Object>(list.toArray());
        TermBase base = dv.getTermBase();
        if (base != null) {
            this.combo5.setSelectedItem(base.getName());
        }
        jPanel3.add(label);
        jPanel3.add(this.combo5);
        JPanel jPanelCol = new JPanel();
        jPanelCol.setOpaque(false);
        jPanelCol.setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COLUMNS")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        jPanelCol.setLayout(new GridLayout(0, 2, 10, 3));
        this.jTextField1 = new JTextField();
        this.jTextField1.setMargin(new Insets(0, 2, 0, 0));
        this.jTextField1.setPreferredSize(new Dimension(30, this.jTextField1.getPreferredSize().height));
        this.jTextField2 = new JTextField();
        this.jTextField2.setMargin(new Insets(0, 2, 0, 0));
        this.jTextField2.setPreferredSize(new Dimension(30, this.jTextField2.getPreferredSize().height));
        if (base != null && (conn = base.getConnection()) != null) {
            String s = conn.getSourceLang();
            String t = conn.getTargetLang();
            if (s != null) {
                this.jTextField1.setText(s);
            }
            if (t != null) {
                this.jTextField2.setText(t);
            }
        }
        jPanelCol.add(this.jTextField1);
        jPanelCol.add(this.jTextField2);
        this.setResizable(false);
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton3.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setMnemonic(87);
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SWITCH"));
        this.jButton2.addActionListener(this);
        jPanel4.add(this.combo1);
        jPanel4.add(this.jButton2);
        jPanel4.add(this.combo2);
        jPanel0.add(this.jButton1);
        jPanel0.add(this.jButton3);
        jPanel2.add((Component)jPanel4, "Center");
        jPanel2.add((Component)jPanelCol, "North");
        GridPanel con = new GridPanel();
        this.setContentPane(con);
        Border border = BorderFactory.createEmptyBorder(20, 20, 10, 20);
        con.setBorder(border);
        con.setLayout(new BorderLayout());
        con.add((Component)jPanel3, "North");
        con.add((Component)jPanel2, "Center");
        con.add((Component)jPanel0, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXImportDialog.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXImportDialog.this.jButton3.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TMXImportDialog.this.cancel();
            }
        });
        this.pack();
    }

    void showStartDialog() {
        TMXFilterDialog dlg = new TMXFilterDialog(this, this.topui, this.tm, "Memory Filter");
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.tm.cancelLoad();
        this.closeDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            this.tm.encoding = this.jTextField0.getText();
            String slang = (String)this.combo1.getSelectedItem();
            String tlang = (String)this.combo2.getSelectedItem();
            this.tm.setSourceLangCode(slang);
            this.tm.setTargetLangCode(tlang);
            DatabaseView dv = this.topui.getDatabaseView();
            String baseName = (String)this.combo5.getSelectedItem();
            if (baseName != null) {
                TermBase base = dv.getTermBase();
                if (base != null) {
                    String name = base.getName();
                    if (name.equalsIgnoreCase(baseName)) {
                        this.tm.setTable(base);
                    } else {
                        base = null;
                    }
                }
                if (base == null) {
                    String t;
                    String s = this.jTextField1.getText();
                    if (s.length() == 0) {
                        s = slang;
                    }
                    if ((t = this.jTextField2.getText()).length() == 0) {
                        t = tlang;
                    }
                    if ((base = dv.connectToTermBase(baseName, s, t)) != null) {
                        base.setMainView(this.topui);
                        this.tm.setTable(base);
                    }
                }
            }
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            String s1 = (String)this.combo1.getSelectedItem();
            String s2 = (String)this.combo2.getSelectedItem();
            this.combo1.setSelectedItem(s2);
            this.combo2.setSelectedItem(s1);
        } else {
            this.cancel();
        }
    }
}

