/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.Serializable;
import translator.TranslationUnit;
import translator.XMLHelper;

public class TMXReadOnlyUnit
implements TranslationUnit,
Serializable {
    private static final long serialVersionUID = 1L;
    private TranslationUnit parentTU;
    private TranslationUnit link;
    TranslationUnit previousTU;
    TranslationUnit nextTU;
    private String sourceLang;
    private String targetLang;
    private char[] sourceSegment;
    private char[] targetSegment;
    private Object[] properties = null;
    private String perfectMatch;
    public boolean state;
    private int propIndex = 0;

    public void setParentTranslationUnit(TranslationUnit ptu) {
        this.parentTU = ptu;
    }

    public TranslationUnit getParentTranslationUnit() {
        return this.parentTU;
    }

    @Override
    public boolean hasParent() {
        return this.parentTU != null;
    }

    @Override
    public boolean getState() {
        return this.state;
    }

    @Override
    public TranslationUnit getPreviousTranslationUnit() {
        return this.previousTU;
    }

    @Override
    public TranslationUnit getNextTranslationUnit() {
        return this.nextTU;
    }

    @Override
    public String getSegment(String lang) {
        int i = lang.indexOf(45);
        if (i != -1) {
            lang = lang.substring(0, i);
        }
        if (lang.toLowerCase().equals(this.sourceLang)) {
            return new String(this.sourceSegment);
        }
        if (lang.toLowerCase().equals(this.targetLang)) {
            return new String(this.targetSegment);
        }
        return "";
    }

    public void setSegment(String lang, String seg) {
        int i = (lang = lang.toLowerCase()).indexOf(45);
        if (i != -1) {
            lang = lang.substring(0, i);
        }
        if (this.sourceLang == null) {
            this.sourceLang = lang.intern();
            this.sourceSegment = seg.toCharArray();
        } else if (this.targetLang == null) {
            this.targetLang = lang.intern();
            this.targetSegment = seg.toCharArray();
        } else if (lang.equals(this.sourceLang)) {
            this.sourceSegment = seg.toCharArray();
        } else if (lang.equals(this.targetLang)) {
            this.targetSegment = seg.toCharArray();
        }
    }

    @Override
    public void setLink(TranslationUnit tu) {
        this.link = tu;
    }

    @Override
    public TranslationUnit getLink() {
        return this.link;
    }

    @Override
    public boolean hasLink() {
        return this.link != null;
    }

    @Override
    public String getPerfectMatch() {
        return this.perfectMatch;
    }

    @Override
    public void setPerfectMatch(String s) {
        this.perfectMatch = s;
    }

    public void addProperty(String type, String content) {
        if (this.properties == null) {
            this.properties = new Object[4];
        } else if (this.propIndex == this.properties.length) {
            Object[] propertiesTemp = new Object[this.propIndex + 4];
            for (int i = 0; i < this.properties.length; ++i) {
                propertiesTemp[i] = this.properties[i];
            }
            this.properties = propertiesTemp;
        }
        String[] p = new String[]{type.intern(), content.intern()};
        this.properties[this.propIndex] = p;
        ++this.propIndex;
    }

    @Override
    public Object[] getProperties() {
        return this.properties;
    }

    @Override
    public String getXMLFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n<tu>");
        if (this.properties != null) {
            for (int i = 0; i < this.properties.length; ++i) {
                Object o = this.properties[i];
                if (o == null) continue;
                String[] p = (String[])o;
                sb.append("\n<prop ");
                sb.append("type");
                sb.append('=');
                sb.append('\"');
                String pt = p[0];
                pt = XMLHelper.resolveXMLEntities(pt);
                sb.append(pt);
                sb.append('\"');
                sb.append('>');
                pt = p[1];
                pt = XMLHelper.resolveXMLEntities(pt);
                sb.append(pt);
                sb.append("</prop>");
            }
        }
        sb.append("\n<tuv ");
        sb.append("xml:lang");
        sb.append('=');
        sb.append('\"');
        sb.append(this.sourceLang);
        sb.append('\"');
        sb.append('>');
        sb.append("\n<seg>");
        String s = new String(this.sourceSegment);
        s = XMLHelper.resolveXMLEntities(s);
        sb.append(s);
        sb.append("</seg>");
        sb.append("\n</tuv>");
        sb.append("\n<tuv ");
        sb.append("xml:lang");
        sb.append('=');
        sb.append('\"');
        sb.append(this.targetLang);
        sb.append('\"');
        sb.append('>');
        sb.append("\n<seg>");
        s = new String(this.targetSegment);
        s = XMLHelper.resolveXMLEntities(s);
        sb.append(s);
        sb.append("</seg>");
        sb.append("\n</tuv>");
        sb.append("\n</tu>");
        return sb.toString();
    }
}

