/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.util.Collection;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.CaseInsensitiveString;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXUnitMap;

public class TMXReadOnlyUnitMap
extends TMXUnitMap
implements TranslationUnitMap {
    private TMXReadOnlyUnit newTU;
    private TMXReadOnlyUnit loadedTU;

    TMXReadOnlyUnitMap(int capacity) {
        super(capacity);
    }

    @Override
    public void createTU(String id) {
        this.newTU = new TMXReadOnlyUnit();
    }

    @Override
    public TMXReadOnlyUnit getNewTU() {
        return this.newTU;
    }

    @Override
    public void switchLang(Collection units) {
        this.clear();
        this.sourceMap.clear();
        this.targetMap.clear();
        this.prefixes.clear();
        if (this.roots != null) {
            this.roots.clear();
        }
        this.initProgress(0, units.size(), "Switching the languages");
        this.loadedSize = 0;
        this.counter = 0;
        for (TranslationUnit tu : units) {
            String key = tu.getSegment(this.sourceLanguage);
            if (key.length() > 0) {
                if (this.loadedSize <= this.sample) {
                    String value = tu.getSegment(this.targetLanguage);
                    this.fillFunctionSourceMap(key);
                    if (value.length() > 0) {
                        this.fillFunctionTargetMap(value);
                    }
                }
                key = key.replaceAll(AppPreferences.punctuation, "");
                key = key.trim();
                key = key.replaceAll("\\s+", " ");
                if (this.prefMatch) {
                    key = this.makePrefixes(key);
                }
                if (key.length() > 0) {
                    ++this.loadedSize;
                    CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
                    TranslationUnit obj = this.put(cisKey, tu);
                    if (obj != null) {
                        TranslationUnit link = obj;
                        tu.setLink(link);
                    }
                }
            }
            if (this.counter % 1000 == 0) {
                this.updateProgress(this.counter);
            }
            ++this.counter;
        }
    }

    public void load(TMXReadOnlyUnit tu) {
        if (AppPreferences.isTrialVersion && Memory.totalTUsLoaded > 1000) {
            return;
        }
        ++Memory.totalTUsLoaded;
        if (this.loadedTU != null) {
            this.loadedTU.nextTU = tu;
            tu.previousTU = this.loadedTU;
        }
        this.loadedTU = tu;
        String key = tu.getSegment(this.sourceLanguage);
        if (key.length() > 0) {
            char q = key.charAt(0);
            if (q == '?') {
                String value = tu.getSegment(this.targetLanguage);
                if (value.length() > 0) {
                    boolean isTerms = !this.isSegmentsMode();
                    AssembleParser.addToSegmentPatterns(key, value, isTerms);
                }
                return;
            }
            if (this.loadedSize <= this.sample) {
                String value = tu.getSegment(this.targetLanguage);
                this.fillFunctionSourceMap(key);
                if (value.length() > 0) {
                    this.fillFunctionTargetMap(value);
                }
            }
            key = XMLHelper.normalizeSpace(key);
            key = key.replaceAll(AppPreferences.punctuation, "");
            key = key.trim();
            key = key.replaceAll("\\s+", " ");
            if (this.prefMatch) {
                key = this.makePrefixes(key);
            }
            if (key.length() > 0) {
                ++this.loadedSize;
                CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
                TMXReadOnlyUnit obj = this.put(cisKey, tu);
                if (obj != null) {
                    TranslationUnit link = obj;
                    tu.setLink(link);
                }
            }
        }
        ++this.size;
        if (this.counter != -1) {
            ++this.counter;
            if (this.counter == 10000) {
                this.counter = 0;
                this.pm.setNote(Integer.toString(this.size));
                this.updateProgress(9999);
            } else if (this.counter % 1000 == 0) {
                this.pm.setNote(Integer.toString(this.size));
                this.updateProgress(this.counter);
            }
        }
    }

    @Override
    public synchronized void setUnitContents(String key, String value) {
        this.newTU.setSegment(this.sourceLanguage, key);
        this.newTU.setSegment(this.targetLanguage, value);
        CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
        this.virtual.remove(cisKey);
        this.load(this.newTU);
    }

    public void updateTranslationUnitSynonyms(TranslationUnit tu) {
        String slang = this.getSourceLang();
        String tlang = this.getTargetLang();
        String source = tu.getSegment(slang);
        String target = tu.getSegment(tlang);
        if (source != null && source.length() > 0 && target != null) {
            int pipe = source.indexOf(AppPreferences.alternativesSeparator);
            String[] sources = pipe != -1 ? Pattern.compile(AppPreferences.alternativesSeparator, 16).split(source) : new String[]{source};
            pipe = target.indexOf(AppPreferences.alternativesSeparator);
            String[] targets = pipe != -1 ? Pattern.compile(AppPreferences.alternativesSeparator, 16).split(target) : new String[]{target};
            if (sources.length == 1 && targets.length == 1) {
                return;
            }
            for (int k = 0; k < sources.length; ++k) {
                String src = sources[k];
                if (src.length() <= 0) continue;
                for (int m = 0; m < targets.length; ++m) {
                    String trg = targets[m];
                    TMXReadOnlyUnit atu = new TMXReadOnlyUnit();
                    atu.setSegment(slang, src);
                    atu.setSegment(tlang, trg);
                    atu.setParentTranslationUnit(tu);
                    this.load(atu);
                }
            }
        }
    }

    public void removeTranslationUnitSynonyms(TranslationUnit tu) {
        String slang = this.getSourceLang();
        String tlang = this.getTargetLang();
        String source = tu.getSegment(slang);
        String target = tu.getSegment(tlang);
        if (source != null && source.length() > 0 && target != null) {
            int pipe = source.indexOf(AppPreferences.alternativesSeparator);
            String[] sources = pipe != -1 ? Pattern.compile(AppPreferences.alternativesSeparator, 16).split(source) : new String[]{source};
            pipe = target.indexOf(AppPreferences.alternativesSeparator);
            String[] targets = pipe != -1 ? Pattern.compile(AppPreferences.alternativesSeparator, 16).split(target) : new String[]{target};
            if (sources.length == 1 && targets.length == 1) {
                return;
            }
            for (int k = 0; k < sources.length; ++k) {
                TranslationUnit atu;
                String src = sources[k];
                if (src.length() <= 0 || (atu = this.getTU(src)) == null || !atu.hasParent()) continue;
                this.removeTU(atu);
                while (atu.hasLink()) {
                    if ((atu = atu.getLink()).hasParent()) continue;
                    TMXReadOnlyUnit turo = (TMXReadOnlyUnit)atu;
                    this.load(turo);
                }
            }
        }
    }
}

