/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.TranslationUnitMap;
import translator.database.DatabaseView;
import translator.database.TermBase;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXFilterDialog;
import translator.ui.GridPanel;

public class TMXStartDialog
extends JDialog
implements ActionListener {
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton4;
    private JTextField jTextField0 = null;
    private JComboBox combo1;
    private JComboBox combo2;
    private JComboBox combo3;
    private JComboBox combo4;
    private JComboBox combo5;
    private JComboBox combo6;
    private Memory tm;
    private MainView topui;
    private JCheckBox mbox;
    private JCheckBox tbox;
    private JCheckBox termcheckbox;
    private JCheckBox tagBox;
    private JCheckBox robox;
    private JCheckBox pretranslationbox;
    private JCheckBox memPrefixMatch;
    private JComboBox memPrefixMatchAccuracy;
    private JComboBox memDuplicates;
    private JCheckBox casecheckbox;
    private JCheckBox greedyExactMatchingBox;
    private JTextField prefixLenghTextField = null;
    private JCheckBox recallInContextBox;
    private JTextField recallInContextHitsField = null;

    public TMXStartDialog(MainView owner, Memory tm, String title) {
        super(owner, title, true);
        String val;
        TranslationUnitMap map;
        this.tm = tm;
        this.topui = owner;
        this.memPrefixMatch = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREFIX MATCH") + " (%):");
        this.memPrefixMatch.setFont(this.memPrefixMatch.getFont().deriveFont(1));
        this.memPrefixMatch.setOpaque(false);
        this.memPrefixMatch.setSelected(tm.getPrefixMatch());
        Object[] prefixMatchAccuracy = new Object[]{10, 20, 30, 40, 50, 60, 70, 80, 90};
        this.memPrefixMatchAccuracy = new JComboBox<Object>(prefixMatchAccuracy);
        this.memPrefixMatchAccuracy.insertItemAt(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIXED LENGTH"), 0);
        if (AppPreferences.memPrefixAccuracy == 0) {
            this.memPrefixMatchAccuracy.setSelectedIndex(0);
        } else {
            this.memPrefixMatchAccuracy.setSelectedItem(AppPreferences.memPrefixAccuracy);
        }
        this.casecheckbox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MATCH CASE"));
        this.casecheckbox.setFont(this.casecheckbox.getFont().deriveFont(1));
        this.casecheckbox.setOpaque(false);
        this.casecheckbox.setSelected(tm.getCaseMatch());
        this.greedyExactMatchingBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GREEDY EXACT MATCHES"));
        this.greedyExactMatchingBox.setFont(this.greedyExactMatchingBox.getFont().deriveFont(1));
        this.greedyExactMatchingBox.setOpaque(false);
        this.greedyExactMatchingBox.setSelected(tm.isGreedyMatching());
        this.prefixLenghTextField = new JTextField();
        this.prefixLenghTextField.setText("" + AppPreferences.memPrefixLength);
        this.prefixLenghTextField.setMargin(new Insets(0, 2, 0, 0));
        JLabel prefixLenghLabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MINIMAL PREFIX LENGTH") + ":");
        prefixLenghLabel.setFont(prefixLenghLabel.getFont().deriveFont(1));
        prefixLenghLabel.setHorizontalAlignment(4);
        String[] searchType = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FUZZY & HITS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FUZZY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FUZZY WITHOUT WORD SEPARATOR")};
        this.combo3 = new JComboBox<String>(searchType);
        this.combo3.setEditable(false);
        this.combo3.setSelectedIndex(tm.getMatchType());
        String[] translationType = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MANUAL")};
        this.combo4 = new JComboBox<String>(translationType);
        int transtype = tm.getWorkflowMode();
        this.combo4.setSelectedIndex(transtype);
        String[] duplicates = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEEP ALL DUPLICATES"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEEP NEWER DUPLICATES"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEEP OLDER DUPLICATES")};
        this.memDuplicates = new JComboBox<String>(duplicates);
        this.memDuplicates.setEditable(false);
        int d = tm.getDuplicatesMode();
        if (d != -1) {
            this.memDuplicates.setSelectedIndex(d);
        } else {
            this.memDuplicates.setSelectedIndex(1);
        }
        String[] priorities = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOW PRIORITY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEDIUM PRIORITY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIGH PRIORITY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEEP OUT OF AUTO-ASSEMBLING")};
        this.combo6 = new JComboBox<String>(priorities);
        this.combo6.setEditable(false);
        if (tm.isAutoAssemblingStopped()) {
            this.combo6.setSelectedIndex(priorities.length - 1);
        } else {
            this.combo6.setSelectedIndex(tm.getPriority());
        }
        JPanel jPanel1 = new JPanel();
        Border border = new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPTIONS"));
        jPanel1.setBorder(border);
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new GridLayout(0, 2, 10, 5));
        JLabel mlabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ENCODING:"));
        mlabel.setFont(mlabel.getFont().deriveFont(1));
        mlabel.setHorizontalAlignment(4);
        this.jTextField0 = new JTextField();
        if (tm.encoding != null) {
            this.jTextField0.setText(tm.encoding);
        }
        this.jTextField0.setMargin(new Insets(0, 2, 0, 0));
        this.jTextField0.setPreferredSize(new Dimension(30, 24));
        jPanel1.add(mlabel);
        jPanel1.add(this.jTextField0);
        mlabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRIORITY") + ":");
        mlabel.setFont(mlabel.getFont().deriveFont(1));
        mlabel.setHorizontalAlignment(4);
        jPanel1.add(mlabel);
        jPanel1.add(this.combo6);
        mlabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORKFLOW INTEGRATION:"));
        mlabel.setFont(mlabel.getFont().deriveFont(1));
        mlabel.setHorizontalAlignment(4);
        jPanel1.add(mlabel);
        jPanel1.add(this.combo4);
        mlabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MATCHING TYPE:"));
        mlabel.setFont(mlabel.getFont().deriveFont(1));
        mlabel.setHorizontalAlignment(4);
        jPanel1.add(mlabel);
        jPanel1.add(this.combo3);
        jPanel1.add(prefixLenghLabel);
        jPanel1.add(this.prefixLenghTextField);
        jPanel1.add(this.memPrefixMatch);
        jPanel1.add(this.memPrefixMatchAccuracy);
        jPanel1.add(this.casecheckbox);
        jPanel1.add(this.memDuplicates);
        jPanel1.add(this.greedyExactMatchingBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel0 = new JPanel();
        jPanel0.setOpaque(false);
        jPanel0.setLayout(new GridLayout(0, 3, 10, 0));
        jPanel0.setBorder(new EmptyBorder(new Insets(10, 2, 0, 2)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LANGUAGE PAIR")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        jPanel4.setLayout(new GridLayout(0, 2, 10, 5));
        String display = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE-LANGUAGE:");
        JLabel slabel = new JLabel(display);
        slabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setBorder(BorderFactory.createMatteBorder(0, 4, 0, 0, Color.RED));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setBorder(BorderFactory.createEmptyBorder());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setBorder(BorderFactory.createMatteBorder(0, 4, 0, 0, Color.BLUE));
            }
        });
        slabel.setHorizontalAlignment(4);
        slabel.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SWITCH LANGUAGES"));
        slabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String src = (String)TMXStartDialog.this.combo1.getSelectedItem();
                String trg = (String)TMXStartDialog.this.combo2.getSelectedItem();
                if (src != null && trg != null) {
                    TMXStartDialog.this.combo1.setSelectedItem(trg);
                    TMXStartDialog.this.combo2.setSelectedItem(src);
                }
            }
        });
        slabel.setFont(slabel.getFont().deriveFont(1));
        display = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET-LANGUAGE:");
        JLabel tlabel = new JLabel(display);
        tlabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setBorder(BorderFactory.createMatteBorder(0, 4, 0, 0, Color.RED));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setBorder(BorderFactory.createEmptyBorder());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setBorder(BorderFactory.createMatteBorder(0, 4, 0, 0, Color.BLUE));
            }
        });
        tlabel.setHorizontalAlignment(4);
        tlabel.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SWITCH LANGUAGES"));
        tlabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String src = (String)TMXStartDialog.this.combo1.getSelectedItem();
                String trg = (String)TMXStartDialog.this.combo2.getSelectedItem();
                if (src != null && trg != null) {
                    TMXStartDialog.this.combo1.setSelectedItem(trg);
                    TMXStartDialog.this.combo2.setSelectedItem(src);
                }
            }
        });
        tlabel.setFont(tlabel.getFont().deriveFont(1));
        Vector slangs = null;
        Vector tlangs = null;
        TMX tmx = tm.getTMX();
        if (tmx != null && (map = tmx.getTUMap()) != null) {
            slangs = map.getSourceLangs();
            tlangs = map.getTargetLangs();
        }
        if (slangs != null && slangs.size() > 0) {
            this.combo1 = new JComboBox(slangs);
            this.combo1.setEditable(true);
        } else {
            String slang = tm.getSourceLangCode();
            this.combo1 = new JComboBox<String>(LanguageCodes.getNames());
            this.combo1.setEditable(true);
            if (slang != null && slang.length() > 0) {
                val = LanguageCodes.getName(slang);
                if (val != null) {
                    this.combo1.setSelectedItem(val);
                } else {
                    this.combo1.setSelectedItem(slang);
                }
            } else {
                val = LanguageCodes.getName(AppPreferences.fileSLang);
                if (val != null) {
                    this.combo1.setSelectedItem(val);
                } else {
                    this.combo1.setSelectedItem(AppPreferences.fileSLang);
                }
            }
        }
        if (tlangs != null && tlangs.size() > 0) {
            this.combo2 = new JComboBox(tlangs);
            this.combo2.setEditable(true);
        } else {
            this.combo2 = new JComboBox<String>(LanguageCodes.getNames());
            this.combo2.setEditable(true);
            String tlang = tm.getTargetLangCode();
            if (tlang != null && tlang.length() > 0) {
                val = LanguageCodes.getName(tlang);
                if (val != null) {
                    this.combo2.setSelectedItem(val);
                } else {
                    this.combo2.setSelectedItem(tlang);
                }
            } else {
                val = LanguageCodes.getName(AppPreferences.fileTLang);
                if (val != null) {
                    this.combo2.setSelectedItem(val);
                } else {
                    this.combo2.setSelectedItem(AppPreferences.fileTLang);
                }
            }
        }
        this.mbox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTS MEMORY"));
        this.mbox.setOpaque(false);
        this.mbox.setFont(this.mbox.getFont().deriveFont(1));
        this.tbox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS MEMORY"));
        this.tbox.setOpaque(false);
        this.tbox.setFont(this.tbox.getFont().deriveFont(1));
        this.tagBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROCESSING TAGS"));
        this.tagBox.setOpaque(false);
        this.tagBox.setFont(this.tbox.getFont().deriveFont(1));
        this.termcheckbox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS CONSISTENCY CHECK"));
        this.termcheckbox.setOpaque(false);
        this.termcheckbox.setFont(this.tbox.getFont().deriveFont(1));
        this.robox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("READ ONLY"));
        this.robox.setOpaque(false);
        this.robox.setFont(this.robox.getFont().deriveFont(1));
        this.pretranslationbox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING ONLY"));
        this.pretranslationbox.setOpaque(false);
        this.pretranslationbox.setFont(this.pretranslationbox.getFont().deriveFont(1));
        this.pretranslationbox.setSelected(tm.isPretranslateOnly());
        this.mbox.setSelected(tm.getSegmentsMode());
        this.tbox.setSelected(tm.getTermsMode());
        this.tagBox.setSelected(tm.hasTagPostions());
        if (tm.isReadOnly()) {
            this.robox.setSelected(true);
        } else {
            this.robox.setSelected(tm.fromDatabase);
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        border = new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY TYPE"));
        jPanel5.setBorder(border);
        jPanel5.setLayout(new GridLayout(3, 2, 5, 5));
        jPanel5.add(this.mbox);
        jPanel5.add(this.tbox);
        jPanel5.add(this.tagBox);
        jPanel5.add(this.termcheckbox);
        jPanel5.add(this.robox);
        jPanel5.add(this.pretranslationbox);
        this.setResizable(false);
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton3.addActionListener(this);
        this.jButton4 = new JButton();
        if (tmx != null) {
            this.jButton4.setEnabled(false);
        }
        this.jButton4.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILTER"));
        this.jButton4.addActionListener(this);
        JPanel jPanel3 = null;
        if (tm.fromDatabase) {
            jPanel3 = new JPanel();
            jPanel3.setOpaque(false);
            jPanel3.setLayout(new GridLayout(0, 2, 10, 5));
            border = new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE") + " - " + AppPreferences.database);
            jPanel3.setBorder(border);
            String tableName = tm.getName();
            if (tableName != null) {
                JLabel label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY TABLE:"));
                label.setFont(label.getFont().deriveFont(1));
                label.setHorizontalAlignment(4);
                jPanel3.add(label);
                DatabaseView dv = this.topui.getDatabaseView();
                List list = dv.getTableNames();
                this.combo5 = new JComboBox<Object>(list.toArray());
                int lsize = list.size();
                if (lsize > 1) {
                    String all = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALL TABLES");
                    this.combo5.insertItemAt(all, 0);
                }
                jPanel3.add(this.combo5);
                TermBase base = dv.getTermBase();
                if (base != null) {
                    this.combo5.setSelectedItem(base.getName());
                } else if (tableName != null && tableName.length() > 0) {
                    if (tableName.equals("Total Recall")) {
                        this.combo5.setSelectedIndex(0);
                    } else {
                        this.combo5.setSelectedItem(tableName);
                    }
                }
            }
            this.recallInContextBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECALL IN CONTEXT (HITS PER WORD):"), true);
            this.recallInContextBox.setFont(this.recallInContextBox.getFont().deriveFont(1));
            this.recallInContextHitsField = new JTextField();
            this.recallInContextHitsField.setText("" + AppPreferences.recallInContextHits);
            this.recallInContextHitsField.setMargin(new Insets(0, 2, 0, 0));
            jPanel3.add(this.recallInContextBox);
            jPanel3.add(this.recallInContextHitsField);
        }
        jPanel4.add(slabel);
        jPanel4.add(this.combo1);
        jPanel4.add(tlabel);
        jPanel4.add(this.combo2);
        jPanel0.add(this.jButton1);
        jPanel0.add(this.jButton4);
        jPanel0.add(this.jButton3);
        jPanel2.add((Component)jPanel5, "North");
        jPanel2.add((Component)jPanel4, "Center");
        jPanel2.add((Component)jPanel1, "South");
        GridPanel con = new GridPanel();
        this.setContentPane(con);
        border = BorderFactory.createEmptyBorder(10, 20, 10, 20);
        con.setBorder(border);
        con.setLayout(new BorderLayout());
        if (tm.fromDatabase) {
            con.add((Component)jPanel3, "North");
        }
        con.add((Component)jPanel2, "Center");
        con.add((Component)jPanel0, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXStartDialog.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXStartDialog.this.jButton3.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TMXStartDialog.this.cancel();
            }
        });
        this.pack();
    }

    void showStartDialog() {
        TMXFilterDialog dlg = new TMXFilterDialog(this, this.topui, this.tm, "Memory Filter");
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.tm.cancelLoad();
        this.closeDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            int intDup;
            this.tm.encoding = this.jTextField0.getText();
            String slang = (String)this.combo1.getSelectedItem();
            String tlang = (String)this.combo2.getSelectedItem();
            String val = LanguageCodes.getCode(slang);
            if (val != null) {
                slang = val;
            }
            this.tm.setSourceLangCode(slang);
            val = LanguageCodes.getCode(tlang);
            if (val != null) {
                tlang = val;
            }
            this.tm.setTargetLangCode(tlang);
            String id = AppPreferences.userid;
            if (id.length() > 0) {
                this.tm.setUserID(id);
            }
            AppPreferences.matchType = this.combo3.getSelectedIndex();
            this.tm.setMatchType(AppPreferences.matchType);
            boolean prefixMatching = this.memPrefixMatch.isSelected();
            this.tm.setPrefixMatch(prefixMatching);
            int ind = this.memPrefixMatchAccuracy.getSelectedIndex();
            AppPreferences.memPrefixAccuracy = ind == 0 ? 0 : (Integer)this.memPrefixMatchAccuracy.getSelectedItem();
            if (prefixMatching) {
                this.tm.setPrefixAccuracy(AppPreferences.memPrefixAccuracy);
            }
            AppPreferences.memPrefixLength = Integer.parseInt(this.prefixLenghTextField.getText().trim());
            this.tm.setCaseMatch(this.casecheckbox.isSelected());
            this.tm.setGreedyMatching(this.greedyExactMatchingBox.isSelected());
            int priority = this.combo6.getSelectedIndex();
            if (priority == this.combo6.getItemCount() - 1) {
                if (!this.tm.isAutoAssemblingStopped()) {
                    this.tm.stopAutoassembling(true);
                }
            } else {
                if (this.tm.isAutoAssemblingStopped()) {
                    this.tm.stopAutoassembling(false);
                }
                this.tm.setPriority(priority);
            }
            int translationType = this.combo4.getSelectedIndex();
            this.tm.setWorkflowMode(translationType);
            this.tm.setTermsMode(this.tbox.isSelected());
            this.tm.setTermsCheck(this.termcheckbox.isSelected());
            this.tm.setSegmentsMode(this.mbox.isSelected());
            this.tm.setReadOnly(this.robox.isSelected());
            this.tm.setPretranslateOnly(this.pretranslationbox.isSelected());
            this.tm.setWithTagPositions(this.tagBox.isSelected());
            AppPreferences.duplicatesType = intDup = this.memDuplicates.getSelectedIndex();
            this.tm.setDuplicatesMode(intDup);
            this.tm.resetParserOptions();
            if (this.tm.fromDatabase) {
                String baseName;
                if (this.combo5 != null && (baseName = (String)this.combo5.getSelectedItem()) != null) {
                    DatabaseView dv = this.topui.getDatabaseView();
                    TermBase base = dv.getTermBase();
                    if (base != null) {
                        String name = base.getName();
                        if (name.equalsIgnoreCase(baseName)) {
                            this.tm.setTable(base);
                        } else {
                            base = null;
                        }
                    }
                    if (base == null) {
                        int i;
                        int csize = this.combo5.getItemCount();
                        if (csize > 1 && (i = this.combo5.getSelectedIndex()) == 0) {
                            baseName = "Total Recall";
                            if (!this.recallInContextBox.isSelected()) {
                                this.recallInContextBox.setSelected(true);
                            }
                        }
                        if ((base = dv.connectToTermBase(baseName, slang, tlang)) != null) {
                            base.setMainView(this.topui);
                            this.tm.setTable(base);
                        }
                    }
                }
                if (this.recallInContextBox.isSelected()) {
                    int i;
                    String s = this.recallInContextHitsField.getText().trim();
                    AppPreferences.recallInContextHits = i = Integer.parseInt(s);
                    this.tm.setRecallInContext(i);
                } else {
                    int i = -1;
                    this.tm.setRecallInContext(i);
                }
            }
            this.closeDialog();
        } else if (e.getSource() == this.jButton4) {
            this.showStartDialog();
        } else {
            this.cancel();
        }
    }
}

