/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.CaseInsensitiveString;
import translator.DefaultXMLElement;
import translator.SegmentParser;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLHelper;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;

public class TMXUnitMap
extends ConcurrentHashMap
implements TranslationUnitMap {
    protected String sourceLangCode;
    protected String targetLangCode;
    protected String sourceLanguage;
    protected String targetLanguage;
    protected ConcurrentHashMap virtual;
    private TMXUnit newTU;
    TranslationUnit currentTU;
    private TMXUnitVariant sourceTUV;
    private TMXUnitVariant targetTUV;
    int size = 0;
    int loadedSize = 0;
    private Vector slangs;
    private Vector tlangs;
    HashMap sourceMap;
    HashMap targetMap;
    List functionSourceWords;
    List functionTargetWords;
    ProgressMonitor pm;
    int counter = 0;
    Pattern p;
    int sample;
    String separator;
    private boolean segmentsMode = true;
    public boolean matchCase;
    public boolean prefMatch;
    private int prefAccuracy;
    protected ConcurrentHashMap prefixes = new ConcurrentHashMap();
    protected Set roots;
    private int projectID;
    private SegmentParser segmentParser;
    private TMXUnit loadedTU;

    TMXUnitMap(int capacity) {
        super(capacity);
        this.virtual = new ConcurrentHashMap();
        this.slangs = new Vector();
        this.tlangs = new Vector();
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            this.p = Pattern.compile("", 16);
            this.sample = 1;
            this.separator = "";
        } else {
            this.p = Pattern.compile("\\s+");
            this.sample = 5000;
            this.separator = " ";
        }
        double d = (double)this.sample / 0.75;
        int cap = (int)d;
        this.sourceMap = new HashMap(cap);
        this.targetMap = new HashMap(cap);
    }

    public void setSegmentParser(SegmentParser sparser) {
        this.segmentParser = sparser;
    }

    public void setProjectID(int id) {
        this.projectID = id;
    }

    @Override
    public void setCaseMatching(boolean mc) {
        this.matchCase = mc;
    }

    @Override
    public boolean isCaseMatching() {
        return this.matchCase;
    }

    @Override
    public void setSegmentsMode(boolean mode) {
        this.segmentsMode = mode;
    }

    @Override
    public boolean isSegmentsMode() {
        return this.segmentsMode;
    }

    @Override
    public void setPrefixMatching(int acc) {
        if (acc != -1) {
            this.roots = new HashSet(100);
            if (!AppPreferences.noWordSeparatorSourceLanguage) {
                this.prefMatch = true;
            }
            this.prefAccuracy = acc;
        }
    }

    @Override
    public boolean isPrefixMatching() {
        return this.prefMatch;
    }

    @Override
    public void setProgressMonitor(ProgressMonitor pmm) {
        this.pm = pmm;
    }

    @Override
    public void setLanguagePair(String source, String target) {
        int i;
        this.sourceLangCode = source;
        this.targetLangCode = target;
        if (source != null) {
            i = source.indexOf(45);
            this.sourceLanguage = i != -1 ? source.substring(0, i).toLowerCase() : source.toLowerCase();
        }
        if (target != null) {
            i = target.indexOf(45);
            this.targetLanguage = i != -1 ? target.substring(0, i).toLowerCase() : target.toLowerCase();
        }
    }

    @Override
    public void createTU(String id) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        this.newTU = new TMXUnit(this.projectID);
        this.newTU.setName("tu");
        int tuid = this.size + 1;
        this.newTU.setAttribute("tuid", Long.toString(tuid));
        this.newTU.setAttribute("creationdate", date);
        if (id != null) {
            this.newTU.setAttribute("creationid", id);
        }
        this.sourceTUV = new TMXUnitVariant();
        this.sourceTUV.setName("tuv");
        this.sourceTUV.setAttribute("xml:lang", this.sourceLangCode);
        DefaultXMLElement seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        this.sourceTUV.setSegment(seg);
        this.newTU.addTUV(this.sourceTUV);
        this.targetTUV = new TMXUnitVariant();
        this.targetTUV.setName("tuv");
        this.targetTUV.setAttribute("xml:lang", this.targetLangCode);
        seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        this.targetTUV.setSegment(seg);
        this.newTU.addTUV(this.targetTUV);
    }

    @Override
    public TranslationUnit getNewTU() {
        return this.newTU;
    }

    @Override
    public Vector getSourceLangs() {
        return this.slangs;
    }

    @Override
    public Vector getTargetLangs() {
        return this.tlangs;
    }

    @Override
    public String getSourceLang() {
        return this.sourceLangCode;
    }

    @Override
    public String getTargetLang() {
        return this.targetLangCode;
    }

    @Override
    public ProgressMonitor getProgresBar() {
        return this.pm;
    }

    @Override
    public void switchLang(Collection units) {
        this.clear();
        this.sourceMap.clear();
        this.targetMap.clear();
        this.prefixes.clear();
        if (this.roots != null) {
            this.roots.clear();
        }
        this.initProgress(0, units.size(), "Switching the languages");
        this.loadedSize = 0;
        this.counter = 0;
        for (TMXUnit tu : units) {
            String key;
            TMXUnitVariant tuv = tu.getTUV(this.sourceLanguage);
            TMXUnitVariant ttuv = tu.getTUV(this.targetLanguage);
            if (tuv != null && ttuv != null && (key = tuv.getSegmentText()).length() > 0) {
                if (this.loadedSize <= this.sample) {
                    String value = ttuv.getSegmentText();
                    this.fillFunctionSourceMap(key);
                    if (value.length() > 0) {
                        this.fillFunctionTargetMap(value);
                    }
                }
                key = key.replaceAll(AppPreferences.punctuation, "");
                key = key.trim();
                key = key.replaceAll("\\s+", " ");
                if (this.prefMatch) {
                    key = this.makePrefixes(key);
                }
                if (key.length() > 0) {
                    ++this.loadedSize;
                    CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
                    TMXUnit obj = this.put(cisKey, tu);
                    if (obj != null) {
                        TMXUnit link = obj;
                        tu.setLink(link);
                    }
                }
            }
            if (this.counter % 1000 == 0) {
                this.updateProgress(this.counter);
            }
            ++this.counter;
        }
    }

    synchronized void load(TMXUnit tu) {
        Collection col;
        if (this.loadedTU != null) {
            this.loadedTU.nextTU = tu;
            tu.previousTU = this.loadedTU;
        }
        this.loadedTU = tu;
        TMXUnitVariant tuv = tu.getTUV(this.sourceLanguage);
        TMXUnitVariant ttuv = tu.getTUV(this.targetLanguage);
        if (tuv != null && ttuv != null) {
            String key = tuv.getSegmentText();
            if (key.length() > 0) {
                char q = key.charAt(0);
                if (q == '?') {
                    String value = ttuv.getSegmentText();
                    if (value.length() > 0) {
                        boolean isTerms = !this.isSegmentsMode();
                        AssembleParser.addToSegmentPatterns(key, value, isTerms);
                    }
                    return;
                }
                if (this.loadedSize <= this.sample) {
                    String value = ttuv.getSegmentText();
                    this.fillFunctionSourceMap(key);
                    if (value.length() > 0) {
                        this.fillFunctionTargetMap(value);
                    }
                }
                key = XMLHelper.normalizeSpace(key);
                key = key.replaceAll(AppPreferences.punctuation, "");
                key = key.trim();
                key = key.replaceAll("\\s+", " ");
                if (this.prefMatch) {
                    key = this.makePrefixes(key);
                }
                if (key.length() > 0) {
                    ++this.loadedSize;
                    CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
                    TMXUnit obj = this.put(cisKey, tu);
                    if (obj != null) {
                        TMXUnit link = obj;
                        tu.setLink(link);
                    }
                }
            }
        } else if (this.slangs.isEmpty() && (col = tu.getTMXUnitVariants()).size() > 1) {
            Iterator iter = col.iterator();
            TMXUnitVariant tuv1 = (TMXUnitVariant)iter.next();
            TMXUnitVariant tuv2 = (TMXUnitVariant)iter.next();
            String sLang = tuv1.getLanguage();
            String tLang = tuv2.getLanguage();
            this.slangs.add(sLang);
            this.tlangs.add(tLang);
        }
        ++this.size;
        if (this.counter != -1) {
            ++this.counter;
            if (this.counter == 10000) {
                this.counter = 0;
                this.pm.setNote(Integer.toString(this.size));
                this.updateProgress(9999);
            } else if (this.counter % 1000 == 0) {
                this.pm.setNote(Integer.toString(this.size));
                this.updateProgress(this.counter);
            }
        }
    }

    @Override
    public void initProgress(int min, int max, String note) {
        this.counter = min;
        ProgressInit initProgress = new ProgressInit(min, max, note);
        SwingUtilities.invokeLater(initProgress);
    }

    @Override
    public void updateProgress(int counter) {
        ProgressUpdater updater = new ProgressUpdater(counter);
        SwingUtilities.invokeLater(updater);
    }

    @Override
    public void cancelProgress() {
        this.counter = -1;
        if (this.pm != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TMXUnitMap.this.pm.close();
                }
            });
        }
    }

    void fillFunctionSourceMap(String entry) {
        String[] str = this.p.split(entry);
        for (int i = 0; i < str.length; ++i) {
            String comp = str[i];
            if (comp.trim().length() <= 0) continue;
            Object o = this.sourceMap.get(comp);
            if (o != null) {
                Integer iobj = (Integer)o;
                int k = iobj + 1;
                this.sourceMap.put(comp, new Integer(k));
            } else {
                this.sourceMap.put(comp, new Integer(1));
            }
            StringBuilder buf = new StringBuilder(comp);
            int j = i + 1;
            if (j >= str.length) continue;
            buf.append(this.separator);
            buf.append(str[j]);
            String sub = buf.toString();
            o = this.sourceMap.get(sub);
            if (o != null) {
                Integer iobj = (Integer)o;
                int k = iobj + 1;
                this.sourceMap.put(sub, new Integer(k));
                continue;
            }
            this.sourceMap.put(sub, new Integer(1));
        }
    }

    void fillFunctionTargetMap(String entry) {
        String[] str = this.p.split(entry);
        for (int i = 0; i < str.length; ++i) {
            String comp = str[i];
            if (comp.trim().length() <= 0) continue;
            Object o = this.targetMap.get(comp);
            if (o != null) {
                Integer iobj = (Integer)o;
                int k = iobj + 1;
                this.targetMap.put(comp, new Integer(k));
            } else {
                this.targetMap.put(comp, new Integer(1));
            }
            StringBuilder buf = new StringBuilder(comp);
            int j = i + 1;
            if (j >= str.length) continue;
            buf.append(this.separator);
            buf.append(str[j]);
            String sub = buf.toString();
            o = this.targetMap.get(sub);
            if (o != null) {
                Integer iobj = (Integer)o;
                int k = iobj + 1;
                this.targetMap.put(sub, new Integer(k));
                continue;
            }
            this.targetMap.put(sub, new Integer(1));
        }
    }

    @Override
    public void setFunctionWords() {
        this.functionTargetWords = new ArrayList();
        this.functionSourceWords = new ArrayList();
        if (this.loadedSize > 10) {
            this.fillFunctionWordsTable(this.targetMap, this.functionTargetWords);
            this.fillFunctionWordsTable(this.sourceMap, this.functionSourceWords);
        }
    }

    private void fillFunctionWordsTable(HashMap hm, List list) {
        int lsize = this.size();
        if (lsize > this.sample) {
            lsize = this.sample;
        }
        Iterator it = hm.keySet().iterator();
        while (it.hasNext()) {
            String ex = it.next().toString();
            Integer i = (Integer)hm.get(ex);
            int j = 100 * i / lsize;
            if (j <= AppPreferences.functionwords || ex.length() <= 0) continue;
            list.add(ex);
        }
        hm.clear();
    }

    @Override
    public List getFunctionWordsSource() {
        return this.functionSourceWords;
    }

    @Override
    public List getFunctionWordsTarget() {
        return this.functionTargetWords;
    }

    @Override
    public TranslationUnit getTU(String skey) {
        TranslationUnit tu = (TranslationUnit)this.get(new CaseInsensitiveString(skey, this.matchCase));
        return tu;
    }

    @Override
    public synchronized void removeTU(TranslationUnit tu) {
        String key = tu.getSegment(this.sourceLanguage);
        if (key.length() > 0) {
            key = XMLHelper.normalizeSpace(key);
            key = key.replaceAll(AppPreferences.punctuation, "");
            key = key.trim();
            key = key.replaceAll("\\s+", " ");
            if (this.segmentParser != null) {
                this.segmentParser.removeFromCache(key);
            }
            if (this.prefMatch) {
                key = this.makePrefixes(key);
            }
            CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
            this.remove(cisKey);
        }
    }

    @Override
    public synchronized void setUnitContents(String key, String value) {
        this.sourceTUV.getSegment().setContent(0, key);
        this.targetTUV.getSegment().setContent(0, value);
        CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
        this.virtual.remove(cisKey);
    }

    @Override
    public String getMatchforRoot(String fullkey) {
        if (this.roots != null && !this.roots.isEmpty()) {
            Iterator it = this.roots.iterator();
            while (it.hasNext()) {
                String ss;
                String s = it.next().toString();
                if (fullkey.indexOf(s) == -1 || (ss = this.getMatch(s)) == null) continue;
                return ss;
            }
            return null;
        }
        return null;
    }

    @Override
    public synchronized void setVirtualMatch(String key, String value) {
        CaseInsensitiveString cisKey = new CaseInsensitiveString(key, this.matchCase);
        this.virtual.put(cisKey, value);
    }

    @Override
    public String getVirtualMatch(String key) {
        String s = (String)this.virtual.get(new CaseInsensitiveString(key, this.matchCase));
        if (s != null) {
            return s;
        }
        return null;
    }

    @Override
    public String getMatch(String key) {
        TranslationUnit tu;
        this.currentTU = tu = (TranslationUnit)super.get(new CaseInsensitiveString(key, this.matchCase));
        if (tu != null) {
            String s = tu.getSegment(this.targetLangCode);
            if (s.length() > 0) {
                return s;
            }
            return null;
        }
        return null;
    }

    @Override
    public Set getMatches(String key) {
        TranslationUnit tu;
        this.currentTU = tu = (TranslationUnit)this.get(new CaseInsensitiveString(key, this.matchCase));
        if (tu != null) {
            HashSet<String> segs = new HashSet<String>(2);
            String seg = tu.getSegment(this.targetLangCode);
            if (seg.length() > 0) {
                segs.add(seg);
            }
            while (tu.hasLink()) {
                seg = (tu = tu.getLink()).getSegment(this.targetLangCode);
                if (seg.length() <= 0) continue;
                segs.add(seg);
            }
            return segs;
        }
        return null;
    }

    @Override
    public Map getPrefixList() {
        return this.prefixes;
    }

    @Override
    public int[] getPrefixLength(String w) {
        int[] len = (int[])this.prefixes.get(w);
        if (len != null) {
            return len;
        }
        return null;
    }

    @Override
    public String makePrefixes(String key) {
        int min = AppPreferences.memPrefixLength;
        int proc = this.prefAccuracy;
        StringBuilder sb = new StringBuilder();
        String[] arr = key.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            String string = arr[i];
            int pipe = string.indexOf(124);
            if (pipe != -1) {
                int[] parr = new int[2];
                int pipe2 = string.indexOf(124, pipe + 1);
                if (pipe2 != -1) {
                    parr[0] = pipe;
                    parr[1] = pipe2 - 1;
                    this.prefixes.put(string.replace("|", ""), parr);
                    string = string.substring(pipe + 1, pipe2);
                } else {
                    parr[0] = pipe;
                    parr[1] = -1;
                    this.prefixes.put(string.replace("|", ""), parr);
                    string = string.substring(0, pipe);
                }
                this.roots.add(string);
            } else {
                int ai = string.indexOf(39);
                if (ai != -1) {
                    String s = string.substring(ai + 1);
                    int len = s.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = s.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = s.substring(0, newlen);
                        }
                    }
                } else {
                    int len = string.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = string.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = string.substring(0, newlen);
                        }
                    }
                }
            }
            sb.append(string);
            if (i >= arr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public TranslationUnit getCurrentTU() {
        return this.currentTU;
    }

    @Override
    public Set getSourceSegmentsSet() {
        return this.keySet();
    }

    @Override
    public Collection getMapTranslationUnits() {
        Collection c = this.values();
        ArrayList<TranslationUnit> l = new ArrayList<TranslationUnit>(c.size() + 512);
        for (TranslationUnit tu : c) {
            l.add(tu);
            while (tu.hasLink()) {
                tu = tu.getLink();
                l.add(tu);
            }
        }
        return l;
    }

    @Override
    public int getTotalSize() {
        return this.size;
    }

    @Override
    public int getLoadedSize() {
        return this.loadedSize;
    }

    public String getTMSegmentContext() {
        StringBuilder sb = new StringBuilder();
        if (this.currentTU != null) {
            // empty if block
        }
        return sb.toString();
    }

    @Override
    public void clearMap() {
        this.clear();
        this.size = 0;
        this.loadedSize = 0;
        this.counter = 0;
        if (this.functionSourceWords != null) {
            this.functionSourceWords.clear();
        }
        if (this.functionTargetWords != null) {
            this.functionTargetWords.clear();
        }
    }

    private class ProgressInit
    implements Runnable {
        private int min;
        private int max;
        private String note;

        ProgressInit(int min, int max, String note) {
            this.min = min;
            this.max = max;
            this.note = note;
        }

        @Override
        public void run() {
            TMXUnitMap.this.pm.setMinimum(this.min);
            TMXUnitMap.this.pm.setMaximum(this.max);
            TMXUnitMap.this.pm.setNote(this.note);
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private int _value;

        ProgressUpdater(int value) {
            this._value = value;
        }

        @Override
        public void run() {
            TMXUnitMap.this.pm.setProgress(this._value);
        }
    }
}

