/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.Project;
import translator.ProjectView;
import translator.SegmentParser;
import translator.TargetView;
import translator.Workflow;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.tmx.TMXView;

public class TMXWorkflow {
    private MainView topui;
    private ProjectView prview;
    private MemoryView mview;
    private WorkflowView wview;
    private Project project;
    private Workflow workflow;
    private TMXUnit tucheck;
    private TMXUnit tusplit;
    private int checkno = -1;
    private TMX tmx;
    private List tunits;
    private JProgressBar pb;
    private LinkedHashMap smap;
    private LinkedHashMap tmap;
    private int direction = 0;
    private boolean pretrans = false;
    private boolean noskip;
    private Pattern xtagsPattern;
    int stags;
    int ttags;
    String sourceText = "";
    String targetText = "";

    public TMXWorkflow(MainView topui, Workflow workflow, TMX tmx) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.mview = topui.getMemoryView();
        this.wview = topui.getWorkflowView();
        this.pb = this.prview.getProgressBar();
        this.project = this.prview.getProject();
        this.smap = new LinkedHashMap();
        this.tmap = new LinkedHashMap();
        this.xtagsPattern = Pattern.compile("<[/]*x.*?\\d+");
        this.workflow = workflow;
        this.tmx = tmx;
    }

    public void setCheckStart(int start) {
        this.checkno = start;
        this.tucheck = null;
        this.sourceText = "";
        this.targetText = "";
        this.direction = 0;
        this.pretrans = false;
        this.noskip = true;
    }

    public void cancelCheck() {
        this.tucheck = null;
        this.checkno = -1;
        this.direction = 0;
    }

    private void prepareTUSplit() {
        String createid;
        String slang = this.tmx.getTUMap().getSourceLang();
        String tlang = this.tmx.getTUMap().getTargetLang();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        TMXUnit tunit = new TMXUnit(this.tmx.getID());
        tunit.setName("tu");
        String tuid = this.tucheck.getAttribute("tuid");
        if (tuid != null) {
            tunit.setAttribute("tuid", tuid + "*");
        }
        if ((createid = this.tucheck.getAttribute("creationid")) != null) {
            tunit.setAttribute("creationid", createid);
        }
        tunit.setAttribute("creationdate", date);
        DefaultXMLElement tus = new DefaultXMLElement();
        tus.setName("source");
        DefaultXMLElement tut = new DefaultXMLElement();
        tut.setName("target");
        String id = this.tucheck.getAttribute("id");
        if (id != null) {
            tunit.setAttribute("id", id + "*");
        }
        TMXUnitVariant sourceTUV = new TMXUnitVariant();
        sourceTUV.setName("tuv");
        sourceTUV.setAttribute("xml:lang", slang);
        DefaultXMLElement seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        sourceTUV.setSegment(seg);
        tunit.addTUV(sourceTUV);
        TMXUnitVariant targetTUV = new TMXUnitVariant();
        targetTUV.setName("tuv");
        targetTUV.setAttribute("xml:lang", tlang);
        seg = new DefaultXMLElement(0, 1);
        seg.setName("seg");
        seg.setContent(0, "");
        targetTUV.setSegment(seg);
        tunit.addTUV(targetTUV);
        this.tusplit = tunit;
    }

    public void joinTU() {
        TMXUnit joinTU;
        if (this.tucheck == null || this.project.filter) {
            return;
        }
        int index = this.tunits.indexOf(this.tucheck) + 1;
        this.noskip = true;
        if (index < this.tunits.size() && (joinTU = (TMXUnit)this.tunits.get(index)) != null) {
            String slang = this.tmx.getTUMap().getSourceLang();
            String tlang = this.tmx.getTUMap().getTargetLang();
            XMLElement orgSource = this.tucheck.getTUV(slang).getSegment();
            XMLElement orgTarget = this.tucheck.getTUV(tlang).getSegment();
            XMLElement joinSource = joinTU.getTUV(slang).getSegment();
            XMLElement joinTarget = joinTU.getTUV(tlang).getSegment();
            if (orgSource != null && orgTarget != null && joinSource != null && joinTarget != null) {
                String text2;
                int tlen2;
                List orgSList = orgSource.getChildren();
                List orgTList = orgTarget.getChildren();
                List joinSList = joinSource.getChildren();
                List joinTList = joinTarget.getChildren();
                String orglen = orgSource.getAttribute("length");
                String joinlen = joinSource.getAttribute("length");
                if (orglen != null && joinlen != null) {
                    int len = Integer.parseInt(orglen) + Integer.parseInt(joinlen);
                    orgSource.setAttribute("length", Integer.toString(len));
                }
                if (joinSList.size() > 0) {
                    for (Object object : joinSList) {
                        orgSList.add(object);
                    }
                }
                if (joinTList.size() > 0) {
                    for (Object object : joinTList) {
                        orgTList.add(object);
                    }
                }
                this.tunits.remove(index);
                this.checkno = this.tunits.indexOf(this.tucheck);
                this.direction = 1;
                String text = this.workflow.getTarget();
                this.setNextTU();
                int tlen = text.length();
                if (tlen > 0 && (tlen2 = (text2 = this.workflow.getTarget()).length()) == 0) {
                    this.workflow.setTarget(text);
                    this.topui.getTargetPane().setCaretPosition(tlen);
                }
            }
        }
    }

    public void splitTU() {
        if (this.tucheck == null || this.project.filter) {
            return;
        }
        int index = this.tunits.indexOf(this.tucheck) + 1;
        String slang = this.tmx.getTUMap().getSourceLang();
        String tlang = this.tmx.getTUMap().getTargetLang();
        XMLElement orgSource = this.tucheck.getTUV(slang).getSegment();
        XMLElement orgTarget = this.tucheck.getTUV(tlang).getSegment();
        if (orgSource != null && orgTarget != null) {
            this.noskip = true;
            String pos = orgSource.getAttribute("position");
            String len = orgSource.getAttribute("length");
            this.prepareTUSplit();
            String orgSourceString = this.workflow.getSource();
            String orgTargetString = this.workflow.getTarget();
            int scaret = this.topui.getSourcePane().getCaretPosition();
            int tcaret = this.topui.getTargetPane().getCaretPosition();
            XMLElement splitSource = this.tusplit.getTUV(slang).getSegment();
            XMLElement splitTarget = this.tusplit.getTUV(tlang).getSegment();
            String newSourceOrg = scaret == 0 ? " " : (scaret == orgSourceString.length() ? orgSourceString : orgSourceString.substring(0, scaret));
            String newSplitSourceOrg = scaret == orgSourceString.length() ? " " : orgSourceString.substring(scaret);
            boolean ok = this.makeSplitTU(orgSource, newSourceOrg);
            if (!ok) {
                return;
            }
            ok = this.makeSplitTU(splitSource, newSplitSourceOrg);
            if (!ok) {
                return;
            }
            if (len != null && pos != null) {
                int opos = Integer.parseInt(pos);
                int nl = this.tucheck.getTUV(slang).getSegmentText().length();
                int snl = this.tusplit.getTUV(slang).getSegmentText().length();
                orgSource.setAttribute("length", String.valueOf(nl));
                splitSource.setAttribute("position", String.valueOf(opos + nl));
                splitSource.setAttribute("length", String.valueOf(snl));
            }
            if (orgTargetString.length() > 0) {
                String newTargetOrg = orgTargetString.substring(0, tcaret);
                String newSplitTargetOrg = orgTargetString.substring(tcaret);
                ok = this.makeSplitTU(orgTarget, newTargetOrg);
                if (!ok) {
                    return;
                }
                ok = this.makeSplitTU(splitTarget, newSplitTargetOrg);
                if (!ok) {
                    return;
                }
            }
            this.tunits.add(index, this.tusplit);
            this.checkno = this.tunits.indexOf(this.tucheck);
            this.direction = 1;
            this.setNextTU();
        }
    }

    private String[] getSourceElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("bpt") || name.equals("ept") || name.equals("g") || name.equals("x") || name.equals("ph") || name.equals("hi")) {
                    ed = false;
                }
                if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                    em = true;
                }
                int tagNo = ++this.stags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                this.smap.put(tname, object);
                fs = fs + stag;
                String[] arr = this.getSourceElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] getTargetElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("bpt") || name.equals("ept") || name.equals("g") || name.equals("x") || name.equals("ph") || name.equals("hi")) {
                    ed = false;
                }
                if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                    em = true;
                }
                int tagNo = ++this.ttags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                this.tmap.put(tname, object);
                fs = fs + stag;
                String[] arr = this.getTargetElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private void setNextTU() {
        this.tmx.saved = false;
        this.workflow.setSource("", false);
        this.workflow.setTarget("");
        String slang = this.tmx.getTUMap().getSourceLang();
        String tlang = this.tmx.getTUMap().getTargetLang();
        boolean isQA = this.project.isQAFilterWorkflow();
        while (this.checkno < this.tunits.size()) {
            Object o = this.tunits.get(this.checkno);
            if (o != null && o instanceof TMXUnit) {
                String ts;
                boolean state;
                this.tucheck = (TMXUnit)o;
                if ((AppPreferences.skipReviewedJump || AppPreferences.skipReviewed) && !this.noskip && !isQA && (state = this.tucheck.getState())) {
                    this.tucheck = null;
                    ++this.checkno;
                    continue;
                }
                TMXUnitVariant tus = this.tucheck.getTUV(slang);
                TMXUnitVariant tut = this.tucheck.getTUV(tlang);
                this.pb.setValue(this.checkno);
                this.sourceText = tus != null ? tus.getSegmentText() : "";
                this.targetText = tut != null ? tut.getSegmentText() : "";
                if ((AppPreferences.skipTranslatedJump || AppPreferences.skipTranslated) && !this.noskip && !isQA && (ts = this.targetText.trim()).length() > 0) {
                    this.tucheck = null;
                    ++this.checkno;
                    continue;
                }
                TMXView view = this.tmx.getView();
                if (AppPreferences.replaceAndEdit) {
                    view.replaceBeforeEdit(tus, tut);
                }
                this.noskip = false;
                AppPreferences.skipReviewedJump = false;
                AppPreferences.skipTranslatedJump = false;
                view.browseToUnit(this.checkno);
                ++this.checkno;
                break;
            }
            this.tucheck = null;
            ++this.checkno;
        }
        if (this.tucheck != null) {
            XMLElement sseg;
            TMXUnitVariant stuv = this.tucheck.getTUV(slang);
            TMXUnitVariant ttuv = this.tucheck.getTUV(tlang);
            if (stuv != null && (sseg = stuv.getSegment()) != null) {
                List slist = sseg.getChildren();
                List tlist = null;
                if (ttuv != null) {
                    XMLElement tseg = ttuv.getSegment();
                    if (tseg == null) {
                        tseg = new DefaultXMLElement(0, 1);
                        tseg.setName("seg");
                        ttuv.setSegment(tseg);
                    }
                    tlist = tseg.getChildren();
                } else {
                    ttuv = new TMXUnitVariant();
                    ttuv.setName("tuv");
                    String lang = tlang;
                    if (lang != null) {
                        ttuv.setAttribute("xml:lang", lang);
                    }
                    DefaultXMLElement tseg = new DefaultXMLElement(0, 1);
                    tseg.setName("seg");
                    ttuv.setSegment(tseg);
                    this.tucheck.addTUV(ttuv);
                    tlist = tseg.getChildren();
                }
                this.smap.clear();
                this.stags = 0;
                this.tmap.clear();
                this.ttags = 0;
                String[] sarr = this.getSourceElements(slist, true);
                String[] tarr = this.getTargetElements(tlist, true);
                String fsource = sarr[0];
                String ftarget = tarr[0];
                String esource = sarr[1];
                this.workflow.setTarget(ftarget);
                this.workflow.setSource(fsource, AppPreferences.automaticMatching);
            }
        }
    }

    private void setPrevTU() {
        this.tmx.saved = false;
        this.workflow.setSource("", false);
        this.workflow.setTarget("");
        String slang = this.tmx.getTUMap().getSourceLang();
        String tlang = this.tmx.getTUMap().getTargetLang();
        boolean isQA = this.project.isQAFilterWorkflow();
        while (this.checkno >= 0) {
            Object o = this.tunits.get(this.checkno);
            if (o != null && o instanceof TMXUnit) {
                String ts;
                boolean state;
                this.tucheck = (TMXUnit)o;
                if (AppPreferences.skipReviewed && !this.noskip && !isQA && (state = this.tucheck.getState())) {
                    this.tucheck = null;
                    --this.checkno;
                    continue;
                }
                TMXUnitVariant tus = this.tucheck.getTUV(slang);
                TMXUnitVariant tut = this.tucheck.getTUV(tlang);
                this.pb.setValue(this.checkno);
                this.sourceText = tus != null ? tus.getSegmentText() : "";
                this.targetText = tut != null ? tut.getSegmentText() : "";
                if (AppPreferences.skipTranslated && !this.noskip && !isQA && (ts = this.targetText.trim()).length() > 0) {
                    this.tucheck = null;
                    --this.checkno;
                    continue;
                }
                TMXView view = this.tmx.getView();
                if (AppPreferences.replaceAndEdit) {
                    view.replaceBeforeEdit(tus, tut);
                }
                view.browseToUnit(this.checkno);
                this.noskip = false;
                --this.checkno;
                break;
            }
            this.tucheck = null;
            --this.checkno;
        }
        if (this.tucheck != null) {
            XMLElement sseg;
            TMXUnitVariant stuv = this.tucheck.getTUV(slang);
            TMXUnitVariant ttuv = this.tucheck.getTUV(tlang);
            if (stuv != null && (sseg = stuv.getSegment()) != null) {
                List slist = sseg.getChildren();
                List tlist = null;
                if (ttuv != null) {
                    XMLElement tseg = ttuv.getSegment();
                    if (tseg == null) {
                        tseg = new DefaultXMLElement(0, 1);
                        tseg.setName("seg");
                        ttuv.setSegment(tseg);
                    }
                    tlist = tseg.getChildren();
                } else {
                    ttuv = new TMXUnitVariant();
                    ttuv.setName("tuv");
                    String lang = tlang;
                    if (lang != null) {
                        ttuv.setAttribute("xml:lang", lang);
                    }
                    DefaultXMLElement tseg = new DefaultXMLElement(0, 1);
                    tseg.setName("seg");
                    ttuv.setSegment(tseg);
                    this.tucheck.addTUV(ttuv);
                    tlist = tseg.getChildren();
                }
                this.smap.clear();
                this.stags = 0;
                this.tmap.clear();
                this.ttags = 0;
                String[] sarr = this.getSourceElements(slist, true);
                String[] tarr = this.getTargetElements(tlist, true);
                String fsource = sarr[0];
                String ftarget = tarr[0];
                String esource = sarr[1];
                this.workflow.setTarget(ftarget);
                this.workflow.setSource(fsource, AppPreferences.automaticMatching);
            }
        }
    }

    private boolean makeSplitTU(XMLElement elem, String text) {
        if (this.stags > 0 || this.ttags > 0) {
            boolean correct = XMLHelper.parseSegment(elem, this.smap, this.tmap, text, true);
            if (!correct) {
                return false;
            }
        } else {
            List list = elem.getChildren();
            list.clear();
            elem.setContent(0, text);
        }
        return true;
    }

    public boolean updateTU() {
        if (this.tucheck != null) {
            TargetView trview;
            int state;
            String slang = this.tmx.getTUMap().getSourceLang();
            String tlang = this.tmx.getTUMap().getTargetLang();
            TMXUnitVariant tus = this.tucheck.getTUV(slang);
            TMXUnitVariant tut = this.tucheck.getTUV(tlang);
            XMLElement tarXML = tut.getSegment();
            String target = this.workflow.getTarget();
            String source = this.workflow.getSource();
            boolean emptyTarget = false;
            if (target.length() == 0) {
                if (AppPreferences.copysource) {
                    target = source;
                } else {
                    emptyTarget = true;
                }
            }
            if (source.trim().length() == 0) {
                if (this.tunits != null) {
                    this.tunits.remove(this.tucheck);
                }
            } else if (this.stags > 0 || this.ttags > 0) {
                boolean correct = XMLHelper.parseSegment(tarXML, this.smap, this.tmap, target, true);
                if (!correct) {
                    WorkflowManager man = this.wview.getWorkflowManager();
                    man.stopTimer();
                    man.standByTimer(false);
                    return false;
                }
                if (AppPreferences.editSource) {
                    XMLElement srcXML = tus.getSegment();
                    XMLHelper.parseSegment(srcXML, this.smap, this.tmap, source, false);
                }
            } else {
                tarXML.getChildren().clear();
                tarXML.setContent(0, target);
                if (AppPreferences.editSource) {
                    XMLElement srcXML = tus.getSegment();
                    srcXML.getChildren().clear();
                    srcXML.setContent(0, source);
                }
            }
            if ((state = (trview = this.topui.getTargetView()).getTUState()) == 1) {
                this.tucheck.state = true;
            }
        }
        return true;
    }

    public void checkNextTU() {
        boolean correct;
        boolean filter = false;
        boolean glue = false;
        this.tmx.getView();
        this.tunits = TMXView.getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.tmx.getView().getGluedUnits();
            if (this.tunits == null) {
                this.tunits = this.tmx.getBody().getTransUnits();
            } else {
                glue = true;
            }
        } else {
            filter = true;
        }
        if (this.tunits.isEmpty()) {
            this.cancelCheck();
            WorkflowView wview = this.topui.getWorkflowView();
            wview.getWorkflowManager().setWorkflow(null);
            wview.start();
            return;
        }
        this.pb.setMinimum(0);
        this.pb.setMaximum(this.tunits.size());
        if (this.direction == -1) {
            this.checkno += 2;
        }
        if (this.checkno == -1) {
            this.setCheckStart(0);
        }
        this.direction = 1;
        if (!this.pretrans && !this.topui.getResourceLoader().isStartupLoading()) {
            this.pretranslateInMemories();
        }
        if (!(correct = this.updateTU())) {
            return;
        }
        if (this.checkno >= this.tunits.size()) {
            this.pb.setValue(this.pb.getMaximum());
            if (this.tunits.size() > 0) {
                TMXView view = this.tmx.getView();
                view.setLastTU(true);
                view.browseToUnit(this.tunits.size() - 1);
            }
            this.project.cancelReviewMode();
            return;
        }
        this.setNextTU();
        if (this.tucheck != null) {
            int currentID;
            int projectID = this.tucheck.getProjectID();
            if ((filter || glue) && (currentID = this.tmx.getID()) != projectID) {
                this.project.setTMX(projectID);
                this.tmx = this.project.getTMX();
                this.tmx.saved = false;
                String p = this.tmx.getPath();
                if (p != null) {
                    this.project.setTitleForFile(p);
                }
            }
        }
    }

    public void checkPreviousTU() {
        boolean correct;
        boolean filter = false;
        boolean glue = false;
        this.tmx.getView();
        this.tunits = TMXView.getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.tmx.getView().getGluedUnits();
            if (this.tunits == null) {
                this.tunits = this.tmx.getBody().getTransUnits();
            } else {
                glue = true;
            }
        } else {
            filter = true;
        }
        int size = this.tunits.size();
        if (size == 0) {
            this.cancelCheck();
            WorkflowView wview = this.topui.getWorkflowView();
            wview.getWorkflowManager().setWorkflow(null);
            wview.start();
            return;
        }
        this.pb.setMinimum(0);
        this.pb.setMaximum(size);
        if (this.direction == 1) {
            this.checkno -= 2;
        }
        if (this.checkno == -1) {
            if (this.tucheck == null) {
                int no = size - 1;
                this.setCheckStart(no);
            } else {
                boolean correct2 = this.updateTU();
                if (!correct2) {
                    return;
                }
                TMXView view = this.tmx.getView();
                view.setLastTU(true);
                view.browseToUnit(0);
                this.pb.setValue(this.pb.getMinimum());
                this.project.cancelReviewMode();
                return;
            }
        }
        this.direction = -1;
        if (!this.pretrans && !this.topui.getResourceLoader().isStartupLoading()) {
            this.pretranslateInMemories();
        }
        if (!(correct = this.updateTU())) {
            return;
        }
        this.setPrevTU();
        if (this.tucheck != null) {
            int currentID;
            int projectID = this.tucheck.getProjectID();
            if ((filter || glue) && (currentID = this.tmx.getID()) != projectID) {
                this.project.setTMX(projectID);
                this.tmx = this.project.getTMX();
                this.tmx.saved = false;
                String p = this.tmx.getPath();
                if (p != null) {
                    this.project.setTitleForFile(p);
                }
            }
        }
    }

    public TMXUnit getCheckTransUnit() {
        return this.tucheck;
    }

    public int getCheckTUIndex() {
        return this.checkno;
    }

    public boolean pretranslateInMemories() {
        int from = this.checkno;
        int to = this.tunits.size();
        boolean started = false;
        List mems = this.mview.getLocalMemories();
        if (mems.size() > 0) {
            this.pretrans = true;
            for (Object object : mems) {
                final Memory m = (Memory)object;
                if (m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isPretranslated()) continue;
                String procName = m.getName() + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
                m.initMemoryProgress(from, to, procName);
                SegmentParser cparser = m.getTMX().getParser();
                cparser.clearCache();
                this.mview.clearTMPane(m);
                m.setPretranslated(true);
                m.setActive(true);
                started = true;
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ TMXWorkflow this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        this.this$0.pretranslate(m);
                        return null;
                    }

                    @Override
                    protected void done() {
                        m.removeMemoryProgress();
                        m.update();
                        m.setActive(false);
                    }
                };
                worker.execute();
            }
        }
        return started;
    }

    public void pretranslate(Memory ctm) {
        this.tunits = TMXView.getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.tmx.getView().getGluedUnits();
            if (this.tunits == null) {
                this.tunits = this.tmx.getBody().getTransUnits();
            }
        }
        String slang = this.tmx.getTUMap().getSourceLang();
        int from = this.checkno;
        if (from == -1) {
            from = 0;
        }
        SegmentParser cparser = ctm.getTMX().getParser();
        try {
            TMXUnit[] units = new TMXUnit[this.tunits.size() - from];
            int n = 0;
            ListIterator it = this.tunits.listIterator(from);
            while (it.hasNext()) {
                TMXUnit u;
                units[n] = u = (TMXUnit)it.next();
                ++n;
            }
            for (TMXUnit tu : units) {
                if (!ctm.isClosed()) {
                    String cs;
                    TMXUnitVariant tus = tu.getTUV(slang);
                    String source = tus.getSegmentText();
                    if (source.length() > 0 && (cs = cparser.cleanSegment(source)).trim().length() > 0) {
                        cparser.translate(source, cs, null, true);
                        ctm.update();
                    }
                    if (++from % 10 != 0) continue;
                    ctm.updateMemoryProgress(from, ctm.getName(), true);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void analyse(Memory ctm) {
        List atunits = TMXView.getFilteredUnits();
        if (atunits == null && (atunits = this.tmx.getView().getGluedUnits()) == null) {
            atunits = this.tmx.getBody().getTransUnits();
        }
        String slang = this.tmx.getTUMap().getSourceLang();
        int from = 0;
        SegmentParser cparser = ctm.getTMX().getParser();
        cparser.setAnalyseMode(true);
        try {
            while (from < atunits.size()) {
                TMXUnit tu;
                TMXUnitVariant tus;
                String source;
                Object o = atunits.get(from);
                if (o != null && o instanceof TMXUnit && (source = (tus = (tu = (TMXUnit)o).getTUV(slang)).getSegmentText()).length() > 0) {
                    cparser.analyse(source, null);
                }
                if (++from % 10 != 0) continue;
                ctm.updateMemoryProgress(from, ctm.getName(), false);
            }
            cparser.setAnalyseMode(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getTagsXML(String tid, boolean source) {
        Matcher m = this.xtagsPattern.matcher(tid);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            Object ot;
            boolean endTag = false;
            String s = m.group();
            if (s.startsWith("</")) {
                s = s.substring(2);
                endTag = true;
            } else {
                s = s.substring(1);
            }
            if ((ot = source ? this.smap.get(s) : this.tmap.get(s)) == null) continue;
            XMLElement elem = (XMLElement)ot;
            String name = elem.getName();
            if (name.equals("ntr")) {
                sb.append(elem.getContent(0));
                continue;
            }
            sb.append('<');
            if (endTag) {
                sb.append('/');
                sb.append(name);
                sb.append('>');
                continue;
            }
            sb.append(name);
            LinkedHashMap attrMap = elem.getAttributes();
            if (attrMap != null) {
                Set set = attrMap.keySet();
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    sb.append(" ");
                    String s2 = (String)i.next();
                    sb.append(s2);
                    sb.append('=');
                    sb.append('\"');
                    s2 = (String)attrMap.get(s2);
                    sb.append(s2);
                    sb.append('\"');
                }
            }
            sb.append('>');
        }
        return sb.toString();
    }

    public void removeTU() {
        List gunits;
        this.tmx.getBody().getTransUnits().remove(this.tucheck);
        this.tmx.getTUMap().removeTU(this.tucheck);
        List ftunits = TMXView.getFilteredUnits();
        if (ftunits != null) {
            ftunits.remove(this.tucheck);
        }
        if ((gunits = this.tmx.getView().getGluedUnits()) != null) {
            gunits.remove(this.tucheck);
        }
        --this.checkno;
        this.checkNextTU();
    }
}

