/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class TXTHandler {
    private TMXReadOnlyUnitMap romap;
    private String slang;
    private String tlang;
    Memory memory;
    boolean readOnly;
    TMX tmx;
    String txtString;
    String enc;

    public TXTHandler(Memory memory) {
        this.memory = memory;
        this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slang = this.slang.substring(0, i);
        }
        this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlang = this.tlang.substring(0, i);
        }
        this.readOnly = memory.isReadOnly();
        this.enc = memory.encoding;
    }

    public void setTXTString(File file) {
        try {
            File temp = null;
            FileChannel srcChannel = new FileInputStream(file).getChannel();
            temp = File.createTempFile("tempTXT", ".txt");
            FileChannel dstChannel = new FileOutputStream(temp).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            RandomAccessFile raf = new RandomAccessFile(temp, "rw");
            raf.seek(0L);
            raf.writeBytes("{\\rtf1\\ansi \r\n");
            raf.seek(file.length());
            raf.writeBytes(" }");
            raf.close();
            FileInputStream fis = new FileInputStream(temp);
            InputStreamReader is = new InputStreamReader((InputStream)fis, this.enc);
            BufferedReader br = new BufferedReader(is);
            DefaultStyledDocument styledDoc = new DefaultStyledDocument();
            RTFEditorKit rtfKit = new RTFEditorKit();
            rtfKit.read(br, (Document)styledDoc, 0);
            Document doc = styledDoc.getDefaultRootElement().getDocument();
            this.txtString = doc.getText(0, doc.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void parse() {
        this.tmx = this.memory.getTMX();
        if (this.readOnly) {
            this.romap = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
        }
        String tuformat = "(<Seg.+?</TrU>)";
        String segformat = "(<Seg[^>]*>)|(<[/]*cf[^>]*>)|</TrU>";
        Pattern tuP = Pattern.compile(tuformat, 34);
        Pattern segP = Pattern.compile(segformat, 2);
        Matcher m = tuP.matcher(this.txtString);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String gr = m.group();
            Matcher mm = segP.matcher(gr);
            int inds = 0;
            String source = null;
            String target = null;
            String sslang = null;
            String ttlang = null;
            while (mm.find()) {
                int i;
                String sgr = mm.group();
                if (sgr.startsWith("<Seg ")) {
                    int i2;
                    int k;
                    int j;
                    if (sslang == null) {
                        j = sgr.indexOf("=");
                        sslang = sgr.substring(j + 1, k = sgr.length() - 1);
                        i2 = sslang.indexOf(45);
                        if (i2 != -1) {
                            sslang = sslang.substring(0, i2);
                        }
                    } else if (ttlang == null && (i2 = (ttlang = sgr.substring((j = sgr.indexOf("=")) + 1, k = sgr.length() - 1)).indexOf(45)) != -1) {
                        ttlang = ttlang.substring(0, i2);
                    }
                }
                if ((i = mm.start()) != 0) {
                    sb.append(gr.substring(inds, i));
                    if (sgr.startsWith("<Seg ")) {
                        source = sb.toString();
                        sb.setLength(0);
                    } else if (sgr.equals("</TrU>")) {
                        target = sb.toString();
                        sb.setLength(0);
                    }
                }
                inds = mm.end();
            }
            if (this.readOnly) {
                TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                if (sslang.equalsIgnoreCase(this.slang) && ttlang.equalsIgnoreCase(this.tlang)) {
                    tu.setSegment(this.slang, source);
                    tu.setSegment(this.tlang, target);
                } else if (sslang.equalsIgnoreCase(this.tlang) && ttlang.equalsIgnoreCase(this.slang)) {
                    tu.setSegment(this.slang, target);
                    tu.setSegment(this.tlang, source);
                } else {
                    tu.setSegment(this.slang, source);
                    tu.setSegment(this.tlang, target);
                }
                this.romap.load(tu);
                continue;
            }
            int dup = this.memory.getDuplicatesMode();
            if (sslang.equalsIgnoreCase(this.slang) && ttlang.equalsIgnoreCase(this.tlang)) {
                this.tmx.update(source, target, null, null, null, dup);
            } else if (sslang.equalsIgnoreCase(this.tlang) && ttlang.equalsIgnoreCase(this.slang)) {
                this.tmx.update(target, source, null, null, null, dup);
            } else {
                this.tmx.update(source, target, null, null, null, dup);
            }
            this.memory.setNewTU();
        }
    }
}

