/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class TabbedTMHandler {
    private TMXReadOnlyUnitMap romap;
    private String slang;
    private String tlang;
    private String slangvar;
    private String tlangvar;
    Memory memory;
    boolean textOnly;
    TMX tmx;
    String txtString;
    int sCol = 1;
    int tCol = 2;
    private boolean isCTGlossary;
    private String KeyEntrySeparator = "\t";
    private String TargetDelimiter = AppPreferences.alternativesSeparator;
    List fieldsList;

    public TabbedTMHandler(Memory memory) {
        this.memory = memory;
        this.slangvar = this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slang = this.slang.substring(0, i);
        }
        this.tlangvar = this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlang = this.tlang.substring(0, i);
        }
        this.textOnly = memory.tabbedTM ? true : memory.isReadOnly();
        this.fieldsList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file, String encoding) {
        FileInputStream fis = null;
        try {
            String line;
            this.tmx = this.memory.getTMX();
            if (this.textOnly) {
                this.romap = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
            }
            Pattern tabP = Pattern.compile("\t|\\z");
            fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
            int lineCounter = 0;
            Pattern pattern = Pattern.compile("#.+?(\t|\\z)");
            while ((line = in.readLine()) != null) {
                if (lineCounter == 0) {
                    if (line.indexOf(37) != -1) {
                        ++lineCounter;
                        this.sCol = 5;
                        this.tCol = 7;
                        this.tmx.setTabbedTextHeader(line);
                        continue;
                    }
                    if (line.indexOf(35) != -1) {
                        this.isCTGlossary = true;
                        ++lineCounter;
                        Matcher matcher = pattern.matcher(line);
                        int count = 0;
                        StringBuilder headerLine = new StringBuilder();
                        String sl = null;
                        String tl = null;
                        while (matcher.find()) {
                            String s = matcher.group();
                            if (s.length() <= 0) continue;
                            ++count;
                            String s2 = s.substring(1).trim();
                            if (this.slangvar != null && this.slangvar.equalsIgnoreCase(s2)) {
                                this.sCol = count;
                                sl = s.trim();
                            } else if (this.tlangvar != null && this.tlangvar.equalsIgnoreCase(s2)) {
                                this.tCol = count;
                                tl = s.trim();
                            } else {
                                if (headerLine.length() > 0) {
                                    headerLine.append('\t');
                                }
                                headerLine.append(s.trim());
                            }
                            this.fieldsList.add(s2);
                        }
                        StringBuffer header = new StringBuffer();
                        if (sl != null) {
                            header.append(sl);
                        }
                        if (tl != null) {
                            if (header.length() > 0) {
                                header.append('\t');
                            }
                            header.append(tl);
                        }
                        if (headerLine.length() > 0) {
                            if (header.length() > 0) {
                                header.append('\t');
                            }
                            header.append((CharSequence)headerLine);
                        }
                        if (header.length() > 0) {
                            this.tmx.setTabbedTextHeader(header.toString());
                            continue;
                        }
                        this.tmx.setTabbedTextHeader(line);
                        continue;
                    }
                    this.isCTGlossary = true;
                }
                if (this.isCTGlossary && line.length() > 0) {
                    this.loadCTGlossary(line);
                    ++lineCounter;
                    continue;
                }
                ++lineCounter;
                Matcher m = tabP.matcher(line);
                int i = 0;
                String s = null;
                String t = null;
                int e = 0;
                while (m.find()) {
                    if (++i == this.sCol) {
                        s = line.substring(e, m.start());
                    } else if (i == this.tCol) {
                        t = line.substring(e, m.start());
                        break;
                    }
                    e = m.end();
                }
                if (s == null || t == null) continue;
                s = s.replaceAll("&t\\w;", "");
                t = t.replaceAll("&t\\w;", "");
                this.load(s, t);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TabbedTMHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TabbedTMHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TabbedTMHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void load(String source, String target) {
        if (source.length() > 0 && target.length() > 0) {
            if (this.textOnly) {
                TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                tu.setSegment(this.slang, source);
                tu.setSegment(this.tlang, target);
                this.romap.load(tu);
            } else {
                int dup = this.memory.getDuplicatesMode();
                this.tmx.update(source, target, null, null, null, dup);
                this.memory.setNewTU();
            }
        }
    }

    private void loadCTGlossaryBackUp(String line) {
        int i = line.indexOf(this.KeyEntrySeparator);
        if (this.KeyEntrySeparator.length() > 0 && i != -1) {
            LinkedHashMap<String, String> attrs;
            String s;
            ArrayList<String> fields = new ArrayList<String>();
            int start = 0;
            while (i != -1) {
                s = line.substring(start, i);
                fields.add(s);
                start = i + 1;
                if (start >= line.length()) break;
                i = line.indexOf(this.KeyEntrySeparator, start);
            }
            if (start < line.length()) {
                s = line.substring(start);
                fields.add(s);
            }
            if (fields.size() <= 1) {
                return;
            }
            String source = (String)fields.get(this.sCol - 1);
            String target = (String)fields.get(this.tCol - 1);
            String note = null;
            if (this.fieldsList != null && fields.size() > 2) {
                attrs = new LinkedHashMap<String, String>(4);
                for (int j = 0; j < fields.size(); ++j) {
                    if (j == this.sCol - 1 || j == this.tCol - 1) continue;
                    String value = (String)fields.get(j);
                    if (j < this.fieldsList.size()) {
                        String fieldName = (String)this.fieldsList.get(j);
                        if (fieldName.equalsIgnoreCase("note") || fieldName.equalsIgnoreCase("comment")) {
                            note = value;
                            continue;
                        }
                        attrs.put(fieldName, value);
                        continue;
                    }
                    break;
                }
            } else {
                attrs = null;
            }
            if (source != null && source.length() > 0 && target != null) {
                int pipe = source.indexOf(this.TargetDelimiter);
                String[] sources = pipe != -1 ? Pattern.compile(this.TargetDelimiter, 16).split(source) : new String[]{source};
                pipe = target.indexOf(this.TargetDelimiter);
                String[] targets = pipe != -1 ? Pattern.compile(this.TargetDelimiter, 16).split(target) : new String[]{target};
                for (int k = 0; k < sources.length; ++k) {
                    char p;
                    String src = sources[k];
                    if (src.length() <= 0 || (p = src.charAt(0)) == '|' || p == '#') continue;
                    for (int m = 0; m < targets.length; ++m) {
                        String trg = targets[m];
                        this.tmx.update(src, trg, note, attrs, null, this.memory.getDuplicatesMode());
                        this.memory.setNewTU();
                    }
                }
            }
        }
    }

    private void loadCTGlossary(String line) {
        int i = line.indexOf(this.KeyEntrySeparator);
        if (this.KeyEntrySeparator.length() > 0 && i != -1) {
            String s;
            ArrayList<String> fields = new ArrayList<String>();
            int start = 0;
            while (i != -1) {
                s = line.substring(start, i);
                fields.add(s);
                start = i + 1;
                if (start >= line.length()) break;
                i = line.indexOf(this.KeyEntrySeparator, start);
            }
            if (start < line.length()) {
                s = line.substring(start);
                fields.add(s);
            }
            if (fields.size() <= 1) {
                return;
            }
            String source = (String)fields.get(this.sCol - 1);
            String target = (String)fields.get(this.tCol - 1);
            if (this.romap == null) {
                this.load(source, target);
                return;
            }
            TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
            tu.setSegment(this.slang, source);
            tu.setSegment(this.tlang, target);
            if (this.fieldsList != null && fields.size() > 2) {
                for (int j = 0; j < fields.size(); ++j) {
                    if (j == this.sCol - 1 || j == this.tCol - 1) continue;
                    String value = (String)fields.get(j);
                    if (j >= this.fieldsList.size()) break;
                    String fieldName = (String)this.fieldsList.get(j);
                    tu.addProperty(fieldName, value);
                }
            }
            this.romap.load(tu);
            if (source != null && source.length() > 0 && target != null) {
                int pipe = source.indexOf(this.TargetDelimiter);
                String[] sources = pipe != -1 ? Pattern.compile(this.TargetDelimiter, 16).split(source) : new String[]{source};
                pipe = target.indexOf(this.TargetDelimiter);
                String[] targets = pipe != -1 ? Pattern.compile(this.TargetDelimiter, 16).split(target) : new String[]{target};
                if (sources.length == 1 && targets.length == 1) {
                    return;
                }
                for (int k = 0; k < sources.length; ++k) {
                    char p;
                    String src = sources[k];
                    if (src.length() <= 0 || (p = src.charAt(0)) == '|' || p == '#') continue;
                    for (int m = 0; m < targets.length; ++m) {
                        String trg = targets[m];
                        TMXReadOnlyUnit atu = new TMXReadOnlyUnit();
                        atu.setSegment(this.slang, src);
                        atu.setSegment(this.tlang, trg);
                        atu.setParentTranslationUnit(tu);
                        this.romap.load(atu);
                    }
                }
            }
        }
    }
}

