/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.FormatChooser;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;

public class ITTSubtitles
extends TextDocument
implements Translatable {
    private HashMap comments = new HashMap();

    @Override
    public void loadFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    @Override
    public void openFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        boolean i = false;
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        boolean xml = false;
        if (format.indexOf("<[^>]") != -1) {
            xml = true;
        }
        Pattern p = Pattern.compile(format, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        int from = 0;
        int to = 0;
        int index = 1;
        String comment = null;
        StringBuffer inline = new StringBuffer();
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            if (group.startsWith("<p ")) {
                comment = group.substring(3, group.length() - 1);
                comment = comment.replace("\"", "");
            }
            if (to == from) {
                inline.append(group);
                to = matcher.end();
                continue;
            }
            String match = xhtml.substring(to, from);
            if (match.trim().length() > 0) {
                String s;
                int endformatIndex;
                if (xml) {
                    match = XMLHelper.resolveEntitiesXML(match);
                }
                int style = 0;
                String inlineLower = inline.toString().toLowerCase();
                int startformatIndex = inlineLower.lastIndexOf("<b>");
                if (startformatIndex != -1) {
                    endformatIndex = inlineLower.indexOf("</b>", startformatIndex);
                    if (endformatIndex == -1) {
                        style = 2;
                    }
                } else {
                    int endformatIndex2;
                    startformatIndex = inlineLower.lastIndexOf("<bold>");
                    if (startformatIndex != -1 && (endformatIndex2 = inlineLower.indexOf("</bold>", startformatIndex)) == -1) {
                        style = 2;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<i>");
                if (startformatIndex != -1) {
                    endformatIndex = inlineLower.indexOf("</i>", startformatIndex);
                    if (endformatIndex == -1) {
                        style += 4;
                    }
                } else {
                    startformatIndex = inlineLower.lastIndexOf("<italic");
                    if (startformatIndex != -1 && (endformatIndex = inlineLower.indexOf("</italic", startformatIndex)) == -1) {
                        style += 4;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<u>");
                if (startformatIndex != -1) {
                    endformatIndex = inlineLower.indexOf("</u>", startformatIndex);
                    if (endformatIndex == -1) {
                        style += 8;
                    }
                } else {
                    startformatIndex = inlineLower.lastIndexOf("<underline");
                    if (startformatIndex != -1 && (endformatIndex = inlineLower.indexOf("</underline", startformatIndex)) == -1) {
                        style += 8;
                    }
                }
                startformatIndex = inlineLower.lastIndexOf("<sub>");
                if (startformatIndex != -1 && (endformatIndex = inlineLower.indexOf("</sub>", startformatIndex)) == -1) {
                    style = 16;
                }
                if ((startformatIndex = inlineLower.lastIndexOf("<sup>")) != -1 && (endformatIndex = inlineLower.indexOf("</sup>", startformatIndex)) == -1) {
                    style = 18;
                }
                if ((startformatIndex = inlineLower.lastIndexOf("<s>")) != -1 && (endformatIndex = inlineLower.indexOf("</s>", startformatIndex)) == -1) {
                    style = 20;
                }
                StringBuilder typebuilder = new StringBuilder();
                String equivtext = null;
                if (!this.isNoBreak(inline.toString().toLowerCase())) {
                    typebuilder.append("break");
                    equivtext = " ";
                }
                if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                    if (typebuilder.length() > 0) {
                        typebuilder.append(';');
                    }
                    typebuilder.append(s);
                }
                StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                tagbuilder.append(index);
                tagbuilder.append("\"");
                if (typebuilder.length() > 0) {
                    tagbuilder.append(" ctype=\"x-");
                    tagbuilder.append((CharSequence)typebuilder);
                    tagbuilder.append("\"");
                }
                if (equivtext != null) {
                    tagbuilder.append(" equiv-text=\"");
                    tagbuilder.append(equivtext);
                    tagbuilder.append("\"");
                }
                tagbuilder.append("/>");
                String tags = tagbuilder.toString();
                skeleton.put(tags, inline.toString());
                this.styles.put(tags, style);
                if (comment != null) {
                    this.comments.put(tags, comment);
                    comment = null;
                }
                inline.setLength(0);
                content.append(tags);
                content.append(match);
                inline.append(group);
                ++index;
            } else {
                if (match.length() > 0 && content.length() > 0) {
                    inline.append(match);
                }
                inline.append(group);
            }
            to = matcher.end();
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            content.append(tags);
        }
        if (to < xhtml.length()) {
            String tags = "<x id=\"" + ++index + "\" ctype=\"x-break\"/>";
            content.append(xhtml.substring(to));
            content.append(tags);
        }
        return content.toString();
    }

    public Map getCommentsMap() {
        return this.comments;
    }
}

