/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.NaturalOrderComparator;
import translator.Project;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.IndesignIDMLDocument;
import translator.translatables.TextDocument;
import translator.translatables.ZipDocument;
import translator.xliff.XLIFF;

public class MSOfficeDocument
extends ZipDocument
implements Translatable {
    int tagIndex = 0;
    private Map commentsFiles = new HashMap();
    private List ctnotes;
    private boolean hasComments;
    private boolean isOCR;
    private String targetLanguage;
    private Pattern notesPattern = Pattern.compile("(&lt;/*?(ctnote)&gt;)");
    private String wNoteStart = "</w:t></w:r><w:commentRangeStart w:id=\"#\"/><w:r>$<w:t xml:space=\"preserve\">";
    private String wNoteEnd = "</w:t></w:r><w:commentRangeEnd w:id=\"#\"/><w:r><w:commentReference w:id=\"#\"/></w:r><w:r>$<w:t xml:space=\"preserve\">";
    private String wSegmentStart = "</w:t></w:r></w:p><w:p><w:r><w:rPr><w:b/></w:rPr><w:t xml:space=\"preserve\">Source: </w:t></w:r><w:r><w:t>";
    private String wBreak = "</w:t></w:r><w:br/><w:r><w:t xml:space=\"preserve\">";
    private String wComments = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\r\n<w:comments xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\" mc:Ignorable=\"w14 wp14\">#</w:comments>";
    private String wCommentsType = "<Override PartName=\"/word/comments.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml\"/>";
    private String wCommentRelationship = "<Relationship Id=\"rId1CT\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments\" Target=\"comments.xml\"/>";
    int noteID = 100;
    private String tags;

    public MSOfficeDocument() {
        this.isWord = true;
    }

    public void previewWithNotes(Project pr, String spath) {
        String prev;
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        if (this.isUncleaned) {
            prev = pr.previewUnclean(sdoc);
        } else {
            XLIFF xliff = pr.getXLIFF();
            prev = xliff.previewWithNotes(sdoc);
            this.ctnotes = xliff.getCTNotes();
        }
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            int i = name.lastIndexOf(".");
            String extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveZipXMLFileWithNotes(previewFile, file, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    private boolean saveZipXMLFileWithNotes(File newFile, File oldFile, Document doc) {
        try {
            ZipFile zipFile = oldFile == null ? new ZipFile(newFile) : new ZipFile(oldFile);
            String[] texts = this.insertContentWithNotes(doc);
            File tempFile = File.createTempFile("Exp", newFile.getName(), newFile.getParentFile());
            String[] names = new String[this.zipNames.size()];
            int index = 0;
            Iterator it = this.zipNames.iterator();
            while (it.hasNext()) {
                String zname;
                names[index] = zname = (String)it.next();
                ++index;
            }
            this.storeZipFileWithNotes(tempFile, zipFile, names, texts);
            if (newFile.exists()) {
                newFile.delete();
            }
            if (tempFile.renameTo(newFile)) {
                Boolean state = false;
                doc.putProperty("state", state);
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + newFile.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, "Source segments replacement error. The original source language document might have been changed.");
        }
        return false;
    }

    String[] insertContentWithNotes(Document doc) throws BadLocationException {
        int le;
        this.noteID = 100;
        int skelindex = 0;
        String[] contents = new String[this.skeletons.size()];
        LinkedHashMap skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
        StringBuilder all = new StringBuilder();
        String content = doc.getText(0, doc.getLength());
        String tsegFormat = "(<x id=[^>]*>+?)";
        Pattern ttags = Pattern.compile(tsegFormat);
        Matcher ma = ttags.matcher(content);
        int st = 0;
        String inline = null;
        while (ma.find()) {
            int b = ma.start();
            int e = ma.end();
            String group = ma.group();
            String cont = content.substring(st, b);
            if (group.indexOf("x-page") != -1 && all.length() > 0) {
                cont = "";
                contents[skelindex] = all.toString();
                all.setLength(0);
                if (++skelindex < this.skeletons.size()) {
                    skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
                }
            }
            if (cont.length() > 0) {
                int wrpe;
                int wrps;
                if (this.isXML) {
                    cont = XMLHelper.resolveXMLEntities(cont);
                }
                if (this.customFormatMap != null) {
                    cont = this.applyCustomFormat(cont, inline);
                }
                String wrprStyle = "";
                int x = all.lastIndexOf("<w:r");
                int y = all.lastIndexOf("</w:rPr>");
                if (x != -1 && y != -1 && y > x && (wrps = all.lastIndexOf("<w:rPr>")) != -1 && (wrpe = y) != -1) {
                    wrprStyle = all.substring(wrps, wrpe + 8);
                }
                cont = this.applyNotes(cont, wrprStyle);
            }
            if ((inline = (String)skeleton.get(group)) != null) {
                all.append(cont);
                all.append(inline);
            }
            st = e;
        }
        if (all.length() > 0) {
            contents[skelindex] = all.toString();
            all.setLength(0);
            if (++skelindex < this.skeletons.size()) {
                skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
            }
        }
        if (st < (le = content.length())) {
            int wrpe;
            int wrps;
            String cont = content.substring(st, le);
            if (this.isXML) {
                cont = XMLHelper.resolveXMLEntities(cont);
            }
            if (this.customFormatMap != null) {
                cont = this.applyCustomFormat(cont, inline);
            }
            String wrprStyle = "";
            int x = all.lastIndexOf("<w:r");
            int y = all.lastIndexOf("</w:rPr>");
            if (x != -1 && y != -1 && y > x && (wrps = all.lastIndexOf("<w:rPr>")) != -1 && (wrpe = y) != -1) {
                wrprStyle = all.substring(wrps, wrpe + 8);
            }
            cont = this.applyNotes(cont, wrprStyle);
            all.append(cont);
            contents[skelindex] = all.toString();
            all.setLength(0);
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeZipFileWithNotes(File tempFile, ZipFile zipFile, String[] names, String[] texts) {
        FileOutputStream fos = null;
        try {
            String wc;
            fos = new FileOutputStream(tempFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[1024];
            InputStream is = null;
            while (entries.hasMoreElements()) {
                int bytesRead;
                ZipEntry centry;
                byte[] buf;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String oname = entry.getName();
                boolean con = false;
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    if (!oname.equals(name)) continue;
                    con = true;
                }
                if (con) continue;
                if (!this.hasComments) {
                    String wc2;
                    if (oname.equals("[Content_Types].xml")) {
                        String wc3 = this.appendCommentsToContentType();
                        if (wc3 != null) {
                            buf = wc3.getBytes("UTF-8");
                            centry = new ZipEntry(oname);
                            zos.putNextEntry(centry);
                            zos.write(buf, 0, buf.length);
                            continue;
                        }
                    } else if (oname.equals("word/_rels/document.xml.rels") && (wc2 = this.appendCommentsToRelationships()) != null) {
                        buf = wc2.getBytes("UTF-8");
                        centry = new ZipEntry(oname);
                        zos.putNextEntry(centry);
                        zos.write(buf, 0, buf.length);
                        continue;
                    }
                }
                if (oname.equals("word/comments.xml")) {
                    String wc4 = this.createCommentsString();
                    if (wc4 == null) continue;
                    buf = wc4.getBytes("UTF-8");
                    centry = new ZipEntry(oname);
                    zos.putNextEntry(centry);
                    zos.write(buf, 0, buf.length);
                    continue;
                }
                is = zipFile.getInputStream(entry);
                zos.putNextEntry(new ZipEntry(oname));
                while ((bytesRead = is.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytesRead);
                }
            }
            if (is != null) {
                is.close();
            }
            zipFile.close();
            if (!this.hasComments && (wc = this.createCommentsString()) != null) {
                byte[] buf = wc.getBytes("UTF-8");
                ZipEntry centry = new ZipEntry("word/comments.xml");
                zos.putNextEntry(centry);
                zos.write(buf, 0, buf.length);
            }
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                String text = texts[i];
                byte[] buf = text.getBytes("UTF-8");
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                zos.write(buf, 0, buf.length);
            }
            zos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String applyNotes(String s, String style) {
        Matcher m = this.notesPattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String g = m.group();
            String sid = Integer.toString(this.noteID);
            if (g.equals("&lt;ctnote&gt;")) {
                String wwNoteStart = this.wNoteStart.replace("#", sid);
                wwNoteStart = wwNoteStart.replace("$", style);
                m.appendReplacement(sb, wwNoteStart);
                continue;
            }
            if (!g.equals("&lt;/ctnote&gt;")) continue;
            String wwNoteEnd = this.wNoteEnd.replace("#", sid);
            wwNoteEnd = wwNoteEnd.replace("$", style);
            m.appendReplacement(sb, wwNoteEnd);
            ++this.noteID;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String appendCommentsToContentType() {
        String s = (String)this.commentsFiles.get("[Content_Types].xml");
        if (s != null) {
            int ic = s.lastIndexOf("</Types>");
            StringBuilder d = new StringBuilder(s);
            d = d.insert(ic, this.wCommentsType);
            s = d.toString();
        }
        return s;
    }

    private String appendCommentsToRelationships() {
        String s = (String)this.commentsFiles.get("word/_rels/document.xml.rels");
        if (s != null) {
            int ic = s.lastIndexOf("</Relationships>");
            StringBuilder d = new StringBuilder(s);
            d = d.insert(ic, this.wCommentRelationship);
            s = d.toString();
        }
        return s;
    }

    private String createCommentsString() {
        if (this.ctnotes != null) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            String date = sdf.format(cal.getTime()).toString();
            int id = 100;
            StringBuilder sb = new StringBuilder();
            Iterator it = this.ctnotes.iterator();
            while (it.hasNext()) {
                String note = it.next().toString();
                StringBuilder wcbuilder = new StringBuilder();
                wcbuilder.append("<w:comment w:id=\"");
                wcbuilder.append(Integer.toString(id));
                if (AppPreferences.userid.length() > 0) {
                    wcbuilder.append("\" w:author=\"");
                    wcbuilder.append(AppPreferences.userid);
                    wcbuilder.append("\"");
                } else {
                    wcbuilder.append("\" w:author=\"CafeTran\"");
                }
                wcbuilder.append(" w:date=\"");
                wcbuilder.append(date);
                if (!AppPreferences.includeSourceinNotes) {
                    wcbuilder.append("\" w:initials=\"CT\"><w:p><w:r><w:annotationRef/></w:r><w:r><w:t>");
                } else {
                    wcbuilder.append("\" w:initials=\"CT\"><w:p><w:pPr><w:pBdr><w:bottom w:val=\"single\" w:sz=\"6\" w:space=\"1\" w:color=\"auto\"/></w:pBdr></w:pPr><w:r><w:annotationRef/></w:r><w:r><w:rPr><w:i/></w:rPr><w:t>");
                    note = note.replace("-seg-", this.wSegmentStart);
                }
                note = note.replace("\n", this.wBreak);
                wcbuilder.append(note);
                wcbuilder.append("</w:t></w:r></w:p></w:comment>");
                sb.append((CharSequence)wcbuilder);
                ++id;
            }
            String s = (String)this.commentsFiles.get("word/comments.xml");
            if (s != null) {
                int ic = s.lastIndexOf("</w:comments>");
                StringBuilder d = new StringBuilder(s);
                d = d.insert(ic, sb.toString());
                s = d.toString();
            } else {
                s = this.wComments.replace("#", sb.toString());
            }
            return s;
        }
        return null;
    }

    public void loadFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        String s;
        Object oi;
        if (format.equals("Ms Word OCR (*.docx/xml)")) {
            this.isOCR = true;
        }
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        if (filters != null && (oi = filters.get("target-language")) != null && (s = oi.toString()).indexOf(45) != -1) {
            this.targetLanguage = "<w:lang w:val=\"" + s + "\"/>";
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        for (ZipEntry zipEntry : list) {
            String regExp2;
            LinkedHashMap skeleton;
            String outString;
            String zipname;
            String s2 = zipEntry.getName();
            if (s2.equals("word/document.xml") || s2.equals("word/footnotes.xml") || s2.equals("word/endnotes.xml") || s2.equals("xl/sharedStrings.xml") || s2.startsWith("word/header") || s2.startsWith("word/footer") || s2.startsWith("ppt/slides/slide")) {
                zipname = s2;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                skeleton = null;
                if (regExp.length() <= 0 || (outString = this.getContent(outString, skeleton = new LinkedHashMap(), regExp)).trim().length() <= 0) continue;
                len += outString.length();
                this.skeletons.add(skeleton);
                stories.add(outString);
                this.zipNames.add(zipname);
                continue;
            }
            if (s2.equals("[Content_Types].xml") || s2.equals("word/_rels/document.xml.rels")) {
                zipname = s2;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                this.commentsFiles.put(zipname, outString);
                continue;
            }
            if (s2.equals("word/comments.xml")) {
                zipname = s2;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                this.commentsFiles.put(zipname, outString);
                this.hasComments = true;
                continue;
            }
            if (!s2.startsWith("word/diagrams/data") && !s2.startsWith("word/charts/chart")) continue;
            zipname = s2;
            outString = this.loadZipFile(zipFile, zipname, encoding);
            skeleton = null;
            if (regExp.length() <= 0 || (outString = this.getPPContent(outString, skeleton = new LinkedHashMap(), regExp2 = "<c:pt .*?</c:pt>|<c:f>.*?</c:f>|<c:formatCode>.*?</c:formatCode>|<[^>]*>")).trim().length() <= 0) continue;
            len += outString.length();
            this.skeletons.add(skeleton);
            stories.add(outString);
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String string = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", string);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    public void openFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        String s;
        Object oi;
        if (format.equals("Ms Word OCR (*.docx/xml)")) {
            this.isOCR = true;
        }
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        if (filters != null && (oi = filters.get("target-language")) != null && (s = oi.toString()).indexOf(45) != -1) {
            this.targetLanguage = "<w:lang w:val=\"" + s + "\"/>";
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        for (ZipEntry zipEntry : list) {
            String regExp2;
            LinkedHashMap skeleton;
            String outString;
            String zipname;
            String s2 = zipEntry.getName();
            if (s2.equals("word/document.xml") || s2.equals("word/footnotes.xml") || s2.equals("word/endnotes.xml") || s2.equals("xl/sharedStrings.xml") || s2.startsWith("word/header") || s2.startsWith("word/footer") || s2.startsWith("ppt/slides/slide")) {
                zipname = s2;
                outString = this.loadZipFile(zipFile, zipname, encoding);
                skeleton = null;
                if (regExp.length() <= 0 || (outString = this.getContent(outString, skeleton = new LinkedHashMap(), regExp)).trim().length() <= 0) continue;
                len += outString.length();
                this.skeletons.add(skeleton);
                stories.add(outString);
                this.zipNames.add(zipname);
                continue;
            }
            if (!s2.startsWith("word/diagrams/data") && !s2.startsWith("word/charts/chart")) continue;
            zipname = s2;
            outString = this.loadZipFile(zipFile, zipname, encoding);
            skeleton = null;
            if (regExp.length() <= 0 || (outString = this.getPPContent(outString, skeleton = new LinkedHashMap(), regExp2 = "<c:barChart>.*?</c:barChart>|<[^>]*>")).trim().length() <= 0) continue;
            len += outString.length();
            this.skeletons.add(skeleton);
            stories.add(outString);
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String string = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", string);
        this.doc.putProperty("name", name);
        String loadedPath = string;
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(loadedPath)) {
            docs.add(loadedPath);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
        this.setDocumentProperties(this.doc);
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String aformat) {
        this.isXML = true;
        if (aformat.startsWith("#")) {
            aformat = aformat.substring(1);
            this.isUncleaned = true;
        } else {
            this.isUncleaned = false;
        }
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuilder content = new StringBuilder();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        String standaloneSpace = null;
        boolean hasContent = false;
        boolean isPage = false;
        if (index > 0) {
            isPage = true;
        }
        boolean isPicture = false;
        ++index;
        StringBuffer inline = new StringBuffer();
        StringBuilder fgr = new StringBuilder();
        StringBuilder coll = new StringBuilder();
        int format = -1;
        int wstyle = 0;
        String wcolor = null;
        String whighlight = null;
        String wcolorCol = null;
        String whighlightCol = null;
        int textStyle = 0;
        boolean wrstyle = false;
        boolean wtcolumn = false;
        boolean wtcolumnProp = false;
        boolean wrProp = false;
        int wrPropStyle = 0;
        boolean wpProp = false;
        int wpPropStyle = 0;
        boolean wrPrChange = false;
        boolean change = false;
        boolean docSpace = false;
        boolean pexternal = false;
        boolean rexternal = false;
        String colorGroup = null;
        boolean colorChange = false;
        String fontGroup = null;
        boolean fontChange = false;
        String sizeGroup = null;
        boolean sizeChange = false;
        String styleGroup = null;
        boolean styleChange = false;
        String lastEdit = null;
        boolean XE = false;
        boolean runProps = false;
        boolean wrPrLang = false;
        boolean nonBreakHyphen = false;
        while (matcher.find()) {
            char ch;
            int j;
            int i;
            from = matcher.start();
            group = matcher.group();
            if (AppPreferences.RTLSource && !AppPreferences.RTLTarget && (group.equals("<w:bidi/>") || group.equals("<w:rtl/>"))) {
                to = matcher.end();
                continue;
            }
            if (group.equals("<w:softHyphen/>")) {
                to = matcher.end();
                continue;
            }
            if (group.equals("<w:noBreakHyphen/>")) {
                nonBreakHyphen = true;
                to = matcher.end();
                continue;
            }
            if (group.startsWith("<w:instrText")) {
                if (group.indexOf("XE \"<") != -1) {
                    XE = true;
                } else if (XE) {
                    XE = false;
                    i = group.indexOf(62) + 1;
                    String m = group.substring(i, j = group.indexOf(60, i));
                    if (m.trim().length() > 0) {
                        String s;
                        if (!hasContent) {
                            hasContent = true;
                        }
                        String sgroup = group.substring(0, i);
                        String ssgroup = group.substring(j);
                        inline.append(sgroup);
                        StringBuilder typebuilder = new StringBuilder();
                        String equivtext = null;
                        if (isPage) {
                            typebuilder.append("page");
                            isPage = false;
                        } else if (AppPreferences.segmentTags || this.isBreak(inline)) {
                            typebuilder.append("break");
                            equivtext = " ";
                        }
                        int style = wpPropStyle > 0 && !runProps ? wpPropStyle : wstyle;
                        if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                            if (typebuilder.length() > 0) {
                                typebuilder.append(';');
                            }
                            typebuilder.append(s);
                        }
                        StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                        tagbuilder.append(index);
                        tagbuilder.append("\"");
                        if (typebuilder.length() > 0) {
                            tagbuilder.append(" ctype=\"x-");
                            tagbuilder.append((CharSequence)typebuilder);
                            tagbuilder.append("\"");
                        }
                        if (equivtext != null) {
                            tagbuilder.append(" equiv-text=\"");
                            tagbuilder.append(equivtext);
                            tagbuilder.append("\"");
                        }
                        tagbuilder.append("/>");
                        this.tags = tagbuilder.toString();
                        ++index;
                        skeleton.put(this.tags, inline.toString());
                        this.styles.put(this.tags, style);
                        inline.setLength(0);
                        fgr.setLength(0);
                        m = XMLHelper.resolveEntitiesXML(m);
                        if (coll.length() > 0) {
                            content.append(coll.toString());
                            coll.setLength(0);
                        }
                        content.append(this.tags);
                        if (standaloneSpace != null) {
                            content.append(standaloneSpace);
                        }
                        content.append(m);
                        inline.append(ssgroup);
                        fgr.append(ssgroup);
                        change = false;
                        format = -1;
                        docSpace = false;
                        standaloneSpace = null;
                        to = matcher.end();
                        continue;
                    }
                }
            }
            if (group.endsWith("Style w:val=\"tw4winExternal\"/>") || !this.isUncleaned && group.startsWith("<w:vanish")) {
                if (group.startsWith("<w:rStyle") || wrProp) {
                    rexternal = true;
                    change = true;
                } else {
                    pexternal = true;
                }
            }
            if (group.equals("</w:p>")) {
                if (!isPicture) {
                    pexternal = false;
                    rexternal = false;
                }
                sizeGroup = null;
                colorGroup = null;
                styleGroup = null;
                wpPropStyle = 0;
            }
            if (group.startsWith("<w:t") && ((ch = group.charAt(4)) == '>' || ch == ' ')) {
                if (colorGroup != null && !colorChange) {
                    colorGroup = null;
                    change = true;
                }
                if (sizeGroup != null && !sizeChange) {
                    sizeGroup = null;
                    change = true;
                }
                if (styleGroup != null && !styleChange) {
                    styleGroup = null;
                    change = true;
                }
            }
            if (group.equals("<w:rPr>")) {
                if (!isPicture && !wrPrChange) {
                    rexternal = false;
                }
                wrProp = true;
                if (!wpProp) {
                    runProps = true;
                }
                wrPrLang = false;
            } else if (group.equals("</w:rPr>")) {
                if (wstyle != textStyle) {
                    change = true;
                }
                wrProp = false;
                wrPropStyle = 0;
                if (!wrPrLang && this.targetLanguage != null) {
                    group = this.targetLanguage + group;
                }
                wrPrLang = false;
            } else if (group.equals("</w:r>")) {
                if (!isPicture) {
                    rexternal = false;
                }
                colorChange = false;
                fontChange = false;
                sizeChange = false;
                styleChange = false;
                runProps = false;
            } else if (group.equals("<w:pPr>")) {
                wpProp = true;
            } else if (group.equals("</w:pPr>")) {
                wpProp = false;
                wstyle = 0;
                wrstyle = false;
            } else if (group.equals("<w:t xml:space=\"preserve\">")) {
                docSpace = true;
            } else if (group.indexOf("<w:tab") != -1 || group.equals("</w:p>") || group.equals("<w:br/>") || group.indexOf("<w:footnoteReference") != -1 || group.indexOf("<w:endnoteReference") != -1 || group.indexOf("<w:fldChar") != -1 || group.indexOf("<w:noBreakHyphen/>") != -1) {
                format = 0;
                wstyle = 0;
            } else if (group.equals("<w:b/>") || group.startsWith("<w:b ")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:i/>") || lastGroup.startsWith("<w:u ")) {
                    wstyle += 2;
                } else if (wstyle != 2 && wstyle != 6 && wstyle != 10 && wstyle != 14) {
                    change = true;
                    wstyle = 2;
                } else {
                    wstyle = 2;
                }
                if (wrProp) {
                    wrPropStyle = 2;
                }
                if (wpProp) {
                    wpPropStyle += 2;
                }
            } else if (group.equals("<w:i/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:b/>") || lastGroup.startsWith("<w:b ") || lastGroup.startsWith("<w:u ")) {
                    wstyle += 4;
                } else if (wstyle != 4 && wstyle != 6 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 4;
                } else {
                    wstyle = 4;
                }
                if (wrProp) {
                    wrPropStyle = 4;
                }
                if (wpProp) {
                    wpPropStyle += 4;
                }
            } else if (group.startsWith("<w:u ") || group.startsWith("<w:rStyle w:val=\"Hyperlink\"") || group.startsWith("<w:hlink ")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:b/>") || lastGroup.startsWith("<w:b ") || lastGroup.equals("<w:i/>")) {
                    wstyle += 8;
                } else if (wstyle != 8 && wstyle != 10 && wstyle != 12 && wstyle != 14) {
                    change = true;
                    wstyle = 8;
                } else {
                    wstyle = 8;
                }
                if (wrProp) {
                    wrPropStyle = 8;
                }
                if (wpProp) {
                    wpPropStyle += 8;
                }
            } else if (group.startsWith("<w:vertAlign w:val=\"subscript\"")) {
                wstyle = 16;
                format = 0;
            } else if (group.startsWith("<w:vertAlign w:val=\"superscript\"")) {
                wstyle = 18;
                format = 0;
            } else if (group.equals("<w:strike/>")) {
                wstyle = 20;
                format = 0;
            } else if (group.equals("<w:caps/>")) {
                wstyle = 22;
                format = 0;
            } else if (group.equals("<w:smallCaps/>")) {
                wstyle = 24;
                format = 0;
            } else if (group.startsWith("<w:color") || group.startsWith("<w:highlight") || group.startsWith("<w:shd")) {
                if (!this.isOCR) {
                    int j2;
                    int k;
                    i = group.indexOf("w:fill=\"");
                    if (i != -1) {
                        k = 8;
                    } else {
                        i = group.indexOf("w:val=\"");
                        k = 7;
                    }
                    if (i != -1 && group.indexOf("auto", i) == -1 && (j2 = group.indexOf(34, i + k)) != -1) {
                        String c = group.substring(i + k, j2);
                        char ch2 = group.charAt(3);
                        if (ch2 == 'c') {
                            if (wtcolumnProp) {
                                wcolorCol = c;
                                wcolor = null;
                            } else {
                                wcolor = c;
                            }
                        } else if (wtcolumnProp) {
                            whighlightCol = c;
                            whighlight = null;
                        } else {
                            whighlight = c;
                        }
                    }
                    if (colorGroup == null || !group.equals(colorGroup)) {
                        change = true;
                    }
                    colorGroup = group;
                    colorChange = true;
                } else if (!wpProp) {
                    group = "";
                }
            } else if (group.startsWith("<w:rFonts")) {
                if (!this.isOCR) {
                    if (fontGroup != null && !group.equals(fontGroup)) {
                        change = true;
                    }
                    fontGroup = group;
                    fontChange = true;
                } else if (!wpProp) {
                    group = "";
                }
            } else if (group.startsWith("<w:szCs ") || group.startsWith("<w:sz ")) {
                if (!this.isOCR) {
                    String val = group.substring(group.indexOf(32) + 1);
                    if (sizeGroup == null || !val.equals(sizeGroup)) {
                        change = true;
                    }
                    sizeGroup = val;
                    sizeChange = true;
                } else if (!wpProp) {
                    group = "";
                }
            } else if (group.startsWith("<w:rStyle")) {
                if (!this.isOCR) {
                    if (styleGroup == null || !group.equals(styleGroup)) {
                        change = true;
                    }
                    styleGroup = group;
                    styleChange = true;
                } else if (!wpProp) {
                    group = "";
                }
            } else if (group.startsWith("<w:txbxContent>") || group.startsWith("<w:sym ")) {
                change = true;
            } else if (group.equals("<w:drawing>") || group.equals("<w:pict>") || group.startsWith("<w:object")) {
                isPicture = true;
            } else if (group.equals("</w:drawing>") || group.equals("</w:pict>") || group.equals("</w:object>")) {
                isPicture = false;
                change = true;
            } else if (group.startsWith("<w:bookmark")) {
                i = group.indexOf("w:name=\"_GoBack\"");
                if (i != -1) {
                    j = group.indexOf("w:id=");
                    if (j != -1) {
                        int k = group.indexOf("\"", j + 6);
                        lastEdit = group.substring(j, k + 1);
                        group = "";
                    }
                } else if (lastEdit != null && group.indexOf(lastEdit) != -1) {
                    lastEdit = null;
                    group = "";
                }
            } else if (group.startsWith("<w:lang ") && this.targetLanguage != null) {
                group = this.targetLanguage;
                wrPrLang = true;
            } else if (group.equals("<w:tc>")) {
                wtcolumn = true;
            } else if (group.equals("</w:tc>")) {
                wtcolumn = false;
                wcolorCol = null;
                whighlightCol = null;
            } else if (group.equals("<w:tcPr>")) {
                wtcolumnProp = true;
            } else if (group.equals("</w:tcPr>")) {
                wtcolumnProp = false;
            } else if (group.startsWith("<w:rPrChange")) {
                wrPrChange = true;
            } else if (group.equals("</w:rPrChange>")) {
                wrPrChange = false;
            }
            if (to == from) {
                if (this.isOCR && group.equals("</w:rPr>")) {
                    int ind = inline.lastIndexOf("<w:rPr>");
                    int ind2 = fgr.lastIndexOf("<w:rPr>");
                    if (ind == inline.length() - 7 && ind2 == fgr.length() - 7) {
                        inline.setLength(ind);
                        fgr.setLength(ind2);
                        group = "";
                    }
                }
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                if (nonBreakHyphen) {
                    match = "\u2011" + match;
                    nonBreakHyphen = false;
                }
                if (pexternal || rexternal) {
                    inline.append(match);
                    inline.append(group);
                    fgr.append(match);
                    fgr.append(group);
                    to = matcher.end();
                    continue;
                }
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf("<w:b/>") == -1 && fgr.indexOf("<w:b ") == -1 && fgr.indexOf("<w:i/>") == -1 && fgr.indexOf("<w:u ") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1 && fgr.indexOf("<w:vertAlign") == -1 && fgr.indexOf("<w:strike/>") == -1 && fgr.indexOf("<w:caps/>") == -1 && fgr.indexOf("<w:smallCaps/>") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!wrstyle && !this.isUncleaned && !change && format == -1 && match.length() > 0 && (aftbreak.startsWith("</w:t></w:r><w:r") || aftbreak.startsWith("</w:t></w:r><w:proofErr") || aftbreak.startsWith("</w:t><w:t>"))) {
                    match = XMLHelper.resolveEntitiesXML(match);
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                int i2 = aftbreak.indexOf("<w:vertAlign");
                if (i2 != -1) {
                    if (aftbreak.indexOf("</w:r>", i2) == -1) {
                        wrstyle = true;
                    } else {
                        wrstyle = false;
                        wstyle = 0;
                    }
                } else {
                    wrstyle = false;
                }
                if (match.trim().length() > 0) {
                    String s;
                    String inl;
                    if (this.tags != null && (inl = (String)skeleton.get(this.tags)) != null && inl.endsWith("<w:t>")) {
                        StringBuffer sb = new StringBuffer(inl);
                        sb = sb.insert(sb.length() - 1, " xml:space=\"preserve\"");
                        skeleton.put(this.tags, sb.toString());
                    }
                    if (!hasContent) {
                        hasContent = true;
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags || this.isBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    int style = wpPropStyle > 0 && !runProps ? wpPropStyle : wstyle;
                    if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    if (wcolor != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append("fcolor:" + wcolor);
                        wcolor = null;
                    } else if (wcolorCol != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append("fcolor:" + wcolorCol);
                    }
                    if (whighlight != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append("hcolor:" + whighlight);
                        whighlight = null;
                    } else if (whighlightCol != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append("hcolor:" + whighlightCol);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    this.tags = tagbuilder.toString();
                    ++index;
                    String inlineString = inline.toString();
                    if (inlineString.endsWith("<w:t>")) {
                        inline = inline.insert(inline.length() - 1, " xml:space=\"preserve\"");
                    }
                    skeleton.put(this.tags, inline.toString());
                    this.styles.put(this.tags, style);
                    textStyle = wstyle;
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(this.tags);
                    if (standaloneSpace != null) {
                        content.append(standaloneSpace);
                    }
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    change = false;
                    format = -1;
                    docSpace = false;
                    standaloneSpace = null;
                } else {
                    if (match.length() > 0 && (content.length() > 0 || docSpace)) {
                        standaloneSpace = match;
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (!hasContent) {
            return "";
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            if (wpPropStyle > 0 && !runProps) {
                this.styles.put(tags, wpPropStyle);
            } else {
                this.styles.put(tags, wstyle);
            }
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    boolean isBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("<w:tab") != -1 || group.indexOf("</w:p>") != -1 || group.indexOf("<w:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</si>") != -1 || group.indexOf("<w:txbxContent>") != -1) {
            br = true;
        }
        return br;
    }

    String getPPContent(String xhtml, LinkedHashMap skeleton, String aformat) {
        this.isXML = true;
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        boolean hasContent = false;
        boolean isPage = false;
        if (index > 0) {
            isPage = true;
        }
        ++index;
        StringBuffer inline = new StringBuffer();
        StringBuffer fgr = new StringBuffer();
        StringBuffer coll = new StringBuffer();
        int format = -1;
        int wstyle = 0;
        boolean change = false;
        boolean docSpace = false;
        String colorGroup = null;
        boolean colorChange = false;
        boolean ap = false;
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            if (group.startsWith("<a:rPr")) {
                int gi = group.indexOf(" b=");
                if (gi != -1 && group.charAt(gi + 4) != '0') {
                    if (wstyle != 2 && wstyle != 14) {
                        change = true;
                        wstyle = 2;
                    } else {
                        wstyle = 2;
                    }
                }
                if ((gi = group.indexOf(" i=")) != -1 && group.charAt(gi + 4) != '0') {
                    if (wstyle != 4) {
                        change = true;
                        wstyle += 4;
                    } else {
                        wstyle = 4;
                    }
                }
                if ((gi = group.indexOf(" u=")) != -1 && group.charAt(gi + 4) != 'n') {
                    if (wstyle != 8) {
                        change = true;
                        wstyle += 8;
                    } else {
                        wstyle = 8;
                    }
                }
            } else if (group.startsWith("<a:t")) {
                char ch = group.charAt(4);
                if (!(ch != '>' && ch != ' ' || colorGroup == null || colorChange)) {
                    colorGroup = null;
                    change = true;
                }
            } else if (group.equals("</a:r>")) {
                colorChange = false;
            } else if (group.equals("</a:bodyPr>")) {
                wstyle = 0;
            } else if (group.equals("<a:p>")) {
                ap = true;
                colorGroup = null;
                colorChange = false;
            } else if (group.equals("</a:p>") || group.equals("<a:br/>")) {
                format = 0;
                wstyle = 0;
                ap = false;
            } else if (ap && group.startsWith("<a:srgbClr")) {
                if (colorGroup == null || !group.equals(colorGroup)) {
                    change = true;
                }
                colorGroup = group;
                colorChange = true;
            }
            if (to == from) {
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf(" b=") == -1 && fgr.indexOf(" i=") == -1 && fgr.indexOf(" u=") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!this.isUncleaned && !change && format == -1 && match.length() > 0 && aftbreak.startsWith("</a:t></a:r><a:r")) {
                    match = XMLHelper.resolveEntitiesXML(match);
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                if (match.trim().length() > 0) {
                    String s;
                    if (!hasContent) {
                        hasContent = true;
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags || this.isPPBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    if (wstyle > 0 && (s = this.createStyleAttribute(wstyle)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    String tags = tagbuilder.toString();
                    ++index;
                    skeleton.put(tags, inline.toString());
                    this.styles.put(tags, wstyle);
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(tags);
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    change = false;
                    format = -1;
                    docSpace = false;
                } else {
                    if (match.length() > 0 && content.length() > 0) {
                        inline.append(match);
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (!hasContent) {
            return "";
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            this.styles.put(tags, wstyle);
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    boolean isPPBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("</a:p>") != -1 || group.indexOf("<a:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</t>") != -1 || group.indexOf("</p:cm>") != -1) {
            br = true;
        }
        return br;
    }
}

