/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.NaturalOrderComparator;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.IndesignIDMLDocument;
import translator.translatables.ZipDocument;

public class MSOfficePPDocument
extends ZipDocument
implements Translatable {
    int tagIndex = 0;
    private String targetLanguage;

    public MSOfficePPDocument() {
        this.isPowerPoint = true;
    }

    public void loadFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        String s;
        Object oi;
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        if (filters != null && (oi = filters.get("target-language")) != null && (s = oi.toString()).indexOf(45) != -1) {
            this.targetLanguage = "lang=\"" + s + "\"";
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        for (ZipEntry zipEntry : list) {
            String s2 = zipEntry.getName();
            if (!s2.startsWith("ppt/slides/slide") && !s2.startsWith("ppt/comments/comment") && !s2.startsWith("ppt/notesSlides/notesSlide") && !s2.startsWith("ppt/charts/chart") && !s2.startsWith("ppt/diagrams/data")) continue;
            String zipname = s2;
            String outString = this.loadZipFile(zipFile, zipname, encoding);
            LinkedHashMap skeleton = null;
            if (regExp.length() <= 0 || (outString = this.getContent(outString, skeleton = new LinkedHashMap(), regExp)).trim().length() <= 0) continue;
            len += outString.length();
            this.skeletons.add(skeleton);
            stories.add(outString);
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String string = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", string);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    public void openFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        String s;
        Object oi;
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        if (filters != null && (oi = filters.get("target-language")) != null && (s = oi.toString()).indexOf(45) != -1) {
            this.targetLanguage = "lang=\"" + s + "\"";
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        for (ZipEntry zipEntry : list) {
            String s2 = zipEntry.getName();
            if (!s2.startsWith("ppt/slides/slide") && !s2.startsWith("ppt/comments/comment") && !s2.startsWith("ppt/notesSlides/notesSlide") && !s2.startsWith("ppt/charts/chart")) continue;
            String zipname = s2;
            String outString = this.loadZipFile(zipFile, zipname, encoding);
            LinkedHashMap skeleton = null;
            if (regExp.length() <= 0 || (outString = this.getContent(outString, skeleton = new LinkedHashMap(), regExp)).trim().length() <= 0) continue;
            len += outString.length();
            this.skeletons.add(skeleton);
            stories.add(outString);
            this.zipNames.add(zipname);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String string = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", string);
        this.doc.putProperty("name", name);
        String loadedPath = string;
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(loadedPath)) {
            docs.add(loadedPath);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String aformat) {
        this.isXML = true;
        Pattern languagePattern = Pattern.compile("lang=\".+?\"");
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        boolean hasContent = false;
        boolean isPage = false;
        if (index > 0) {
            isPage = true;
        }
        ++index;
        StringBuffer inline = new StringBuffer();
        StringBuffer fgr = new StringBuffer();
        StringBuffer coll = new StringBuffer();
        int format = -1;
        int wstyle = 0;
        String wcolor = null;
        boolean change = false;
        boolean docSpace = false;
        String colorGroup = null;
        boolean colorChange = false;
        boolean ap = false;
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            if (group.startsWith("<a:rPr")) {
                int gi;
                if (this.targetLanguage != null) {
                    group = languagePattern.matcher(group).replaceFirst(this.targetLanguage);
                }
                if ((gi = group.indexOf(" b=")) != -1 && group.charAt(gi + 4) != '0') {
                    if (wstyle != 2 && wstyle != 14) {
                        change = true;
                        wstyle = 2;
                    } else {
                        wstyle = 2;
                    }
                }
                if ((gi = group.indexOf(" i=")) != -1 && group.charAt(gi + 4) != '0') {
                    if (wstyle != 4) {
                        change = true;
                        wstyle += 4;
                    } else {
                        wstyle = 4;
                    }
                }
                if ((gi = group.indexOf(" u=")) != -1 && group.charAt(gi + 4) != 'n') {
                    if (wstyle != 8) {
                        change = true;
                        wstyle += 8;
                    } else {
                        wstyle = 8;
                    }
                }
            } else if (group.startsWith("<a:t")) {
                char ch = group.charAt(4);
                if (!(ch != '>' && ch != ' ' || colorGroup == null || colorChange)) {
                    colorGroup = null;
                    change = true;
                }
            } else if (group.equals("</a:r>")) {
                colorChange = false;
            } else if (group.equals("</a:bodyPr>")) {
                wstyle = 0;
            } else if (group.equals("<a:p>")) {
                ap = true;
                colorGroup = null;
                colorChange = false;
            } else if (group.equals("</a:p>") || group.equals("<a:br/>")) {
                format = 0;
                wstyle = 0;
                ap = false;
            } else if (ap && (group.startsWith("<a:srgbClr") || group.startsWith("<a:solidFill"))) {
                int j;
                int i = group.indexOf("val=\"");
                if (i != -1 && (j = group.indexOf(34, i + 5)) != -1) {
                    String c = group.substring(i + 5, j);
                    if (c.length() > 7) {
                        c = c.substring(2);
                    }
                    wcolor = c;
                }
                if (colorGroup == null || !group.equals(colorGroup)) {
                    change = true;
                }
                colorGroup = group;
                colorChange = true;
            }
            if (to == from) {
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf(" b=") == -1 && fgr.indexOf(" i=") == -1 && fgr.indexOf(" u=") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!this.isUncleaned && !change && format == -1 && match.length() > 0 && aftbreak.startsWith("</a:t></a:r><a:r")) {
                    match = XMLHelper.resolveEntitiesXML(match);
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                if (match.trim().length() > 0) {
                    String s;
                    if (!hasContent) {
                        hasContent = true;
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags || this.isBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    if (wstyle > 0 && (s = this.createStyleAttribute(wstyle)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    if (wcolor != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append("fcolor:" + wcolor);
                        wcolor = null;
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    String tags = tagbuilder.toString();
                    ++index;
                    skeleton.put(tags, inline.toString());
                    this.styles.put(tags, wstyle);
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(tags);
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    change = false;
                    format = -1;
                    docSpace = false;
                } else {
                    if (match.length() > 0 && content.length() > 0) {
                        inline.append(match);
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (!hasContent) {
            return "";
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            this.styles.put(tags, wstyle);
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    boolean isBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("</a:p>") != -1 || group.indexOf("<a:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</t>") != -1 || group.indexOf("</p:cm>") != -1 || group.indexOf("</c:v>") != -1) {
            br = true;
        }
        return br;
    }
}

