/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.FormatChooser;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;

public class SVGDocument
extends TextDocument
implements Translatable {
    @Override
    public void loadFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    @Override
    public void openFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        this.isXML = true;
        String aaformat = "(\u2029)+|(<[^>]*>)";
        Pattern p = Pattern.compile(format, 34);
        Pattern gp = Pattern.compile(aaformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        int from = 0;
        int to = 0;
        int index = 1;
        StringBuffer inline = new StringBuffer();
        while (matcher.find()) {
            from = matcher.start();
            inline.append(xhtml.substring(to, from));
            group = matcher.group();
            Matcher gmatcher = gp.matcher(group);
            int from2 = 0;
            int to2 = 0;
            boolean isBreak = true;
            while (gmatcher.find()) {
                String subgroup = gmatcher.group();
                from2 = gmatcher.start();
                if (from2 > 0) {
                    String cont = group.substring(to2, from2);
                    cont = XMLHelper.resolveEntitiesXML(cont);
                    String tags = isBreak ? "<x id=\"" + index + "\" ctype=\"x-break\"/>" : "<x id=\"" + index + "\" equiv-text=\" \"/>";
                    if (cont.trim().length() > 0) {
                        ++index;
                        skeleton.put(tags, inline.toString());
                        content.append(tags);
                        content.append(cont);
                        inline.setLength(0);
                    } else {
                        inline.append(cont);
                    }
                    inline.append(subgroup);
                    if (subgroup.equals("</tspan>")) {
                        isBreak = false;
                    }
                } else {
                    inline.append(subgroup);
                }
                to2 = gmatcher.end();
            }
            to = matcher.end();
        }
        if (to < xhtml.length()) {
            inline.append(xhtml.substring(to));
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            inline.setLength(0);
            content.append(tags);
        }
        return content.toString();
    }
}

