/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.XMLHelper;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;

public class ProcessTTXUnit {
    private TTX ttx;
    private LinkedHashMap smap;
    private LinkedHashMap tmap;
    private String firstSourceTag;
    private String firstTargetTag;
    private String lastTargetTag;
    private String lastSourceTag;
    private Pattern startTagsPattern;
    private Pattern endTagsPattern;
    private int stags;
    private int ttags;
    private String sourceString;
    private String targetString;

    public ProcessTTXUnit(TTX ttx) {
        this.ttx = ttx;
        this.startTagsPattern = Pattern.compile(AppPreferences.startTagRegEx);
        this.endTagsPattern = Pattern.compile(AppPreferences.endTagRegEx);
        this.smap = new LinkedHashMap();
        this.tmap = new LinkedHashMap();
    }

    public void processTU(TTXUnit tu) {
        XMLElement stuv = tu.getSource();
        XMLElement ttuv = tu.getTarget();
        if (stuv != null) {
            List slist = stuv.getChildren();
            List tlist = null;
            if (ttuv != null) {
                tlist = ttuv.getChildren();
            } else {
                ttuv = new DefaultXMLElement();
                ttuv.setName("Tuv");
                String lang = this.ttx.getTargetLang();
                if (lang != null) {
                    ttuv.setAttribute("Lang", lang);
                }
                tu.setTarget(ttuv);
                tlist = ttuv.getChildren();
            }
            this.smap.clear();
            this.stags = 0;
            this.tmap.clear();
            this.ttags = 0;
            this.firstSourceTag = null;
            this.firstTargetTag = null;
            this.lastTargetTag = null;
            this.lastSourceTag = null;
            String[] sarr = this.getSourceElements(slist, true);
            String[] tarr = this.getTargetElements(tlist, true);
            String fsource = sarr[0];
            String ftarget = tarr[0];
            if (ftarget.length() == 0) {
                int indxs;
                int exstag;
                while ((fsource.startsWith("<x") || fsource.startsWith("</x")) && (exstag = this.firstTagsIndex(fsource)) != -1) {
                    this.firstTargetTag = this.firstSourceTag == null && this.firstTargetTag == null ? (this.firstSourceTag = fsource.substring(0, exstag)) : (this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag));
                    fsource = fsource.substring(exstag);
                }
                while (fsource.endsWith(">") && (indxs = this.lastTagsIndex(fsource)) != -1) {
                    this.lastTargetTag = this.lastSourceTag == null && this.lastTargetTag == null ? (this.lastSourceTag = fsource.substring(indxs)) : (this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag);
                    fsource = fsource.substring(0, indxs);
                }
            }
            this.sourceString = fsource;
            this.targetString = ftarget;
        }
    }

    public String getSourceString() {
        return this.sourceString;
    }

    private String[] getSourceElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("ut")) {
                    ed = false;
                }
                int tagNo = ++this.stags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                this.smap.put(tname, object);
                fs = fs + stag;
                String[] arr = this.getSourceElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] getTargetElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("ut")) {
                    ed = false;
                }
                int tagNo = ++this.ttags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                this.tmap.put(tname, object);
                fs = fs + stag;
                String[] arr = this.getTargetElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private int firstTagsIndex(String s) {
        int i = -1;
        Matcher m = this.startTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.end();
        }
        return i;
    }

    private int lastTagsIndex(String s) {
        int i = -1;
        Matcher m = this.endTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.start();
        }
        return i;
    }

    public boolean updateTU(TTXUnit tu, String source, String target) {
        if (tu != null) {
            boolean emptyTarget = false;
            if (target.length() == 0) {
                emptyTarget = true;
            }
            if (this.firstSourceTag != null) {
                source = this.firstSourceTag + source;
            }
            if (target.length() > 0 && this.firstTargetTag != null) {
                target = this.firstTargetTag + target;
            }
            if (this.lastSourceTag != null) {
                source = source + this.lastSourceTag;
            }
            if (target.length() > 0 && this.lastTargetTag != null) {
                target = target + this.lastTargetTag;
            }
            XMLElement tarXML = tu.getTarget();
            if (this.stags > 0 || this.ttags > 0) {
                boolean correct = XMLHelper.parseSegment(tarXML, this.smap, this.tmap, target, true);
                if (!correct) {
                    return false;
                }
            } else {
                tarXML.getChildren().clear();
                tarXML.setContent(0, target);
            }
        }
        return true;
    }
}

