/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.io.CharArrayWriter;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.Project;
import translator.XMLElement;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;

public class TTXHandler
extends DefaultHandler
implements LexicalHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    private Project project;
    private TTX ttx;
    private boolean segmented = false;

    public TTXHandler(MainView topui, Project project) {
        this.project = project;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.ttx != null) {
            if (!this.segmented) {
                this.ttx.segment();
            }
            this.ttx.trimLines();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        DefaultXMLElement xml;
        if (qName.equals("Tu")) {
            xml = new TTXUnit(this.ttx.getID());
            this.segmented = true;
        } else if (qName.equals("TRADOStag")) {
            this.ttx = new TTX();
            this.project.setTTX(this.ttx);
            xml = this.ttx;
        } else if (qName.equals("Raw")) {
            Raw elem = new Raw();
            this.ttx.setCurrentFile(elem);
            xml = elem;
        } else {
            xml = new DefaultXMLElement();
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        xml.setName(qName);
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        TTXUnit xtu;
        String con;
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            childXml.addChild(this.contents.toString());
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        if (qName.equals("Tu") && (con = (xtu = (TTXUnit)childXml).getSourceText()).length() > 0) {
            this.ttx.addToMemory(con, xtu, false);
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }
}

