/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.MainView;
import translator.Project;
import translator.Workflow;
import translator.XMLElement;
import translator.XMLElementEditor;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ttx.TTXEditor;
import translator.ttx.TTXUnit;
import translator.ui.GridPanel;

public class TTXMenu {
    MainView topui;
    private JPopupMenu pop;
    Project project;

    public TTXMenu(MainView parent, Project project) {
        this.topui = parent;
        this.project = project;
    }

    public void showProjectsDialog(List files) {
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENTS"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (files.size() > 20) {
            scroll.setPreferredSize(new Dimension(800, 800));
        }
        dialog.add(scroll);
        if (files.size() > 1) {
            JButton menuGlueItem = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLUE ALL DOCUMENTS VIRTUALLY"));
            menuGlueItem.addActionListener(new ActionListener(){
                final /* synthetic */ TTXMenu this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    if (!this.this$0.project.glue) {
                        this.this$0.topui.getWorkflowView().getWorkflowManager().endTranslation();
                        this.this$0.project.setGluedWorkflow(true);
                        this.this$0.topui.getWorkflowView().next(0);
                    }
                }
            });
            menuGlueItem.setFocusPainted(false);
            menuGlueItem.setOpaque(false);
            menuGlueItem.setHorizontalAlignment(2);
            menuGlueItem.setFont(menuGlueItem.getFont().deriveFont(1));
            panel.add(menuGlueItem);
        }
        for (TTX pfile : files) {
            String p = pfile.getPath();
            String name = p;
            int fs = name.lastIndexOf(AppPreferences.fs);
            if (fs == -1 && (fs = name.lastIndexOf("/")) == -1) {
                fs = name.lastIndexOf("\\");
            }
            if (fs != -1) {
                name = name.substring(fs + 1);
            }
            JButton menuFileItem = new JButton(new AbstractAction(this, name){
                final /* synthetic */ TTXMenu this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    JButton menu = (JButton)a.getSource();
                    TTX file = (TTX)menu.getClientProperty("element");
                    this.this$0.project.setTTX(file);
                    file.saved = false;
                    String p = file.getPath();
                    if (p != null) {
                        this.this$0.project.setTitleForFile(p);
                    }
                    if (this.this$0.project.glue) {
                        this.this$0.project.setGluedWorkflow(false);
                    } else {
                        file.setWorkflow(null);
                    }
                    this.this$0.topui.getWorkflowView().next(0);
                }
            });
            TTX file = this.project.getTTX();
            if (file != null && file.equals(pfile)) {
                menuFileItem.setForeground(Color.RED);
                menuFileItem.setBackground(Color.WHITE);
                menuFileItem.setFont(menuFileItem.getFont().deriveFont(1));
            }
            menuFileItem.setHorizontalAlignment(2);
            menuFileItem.putClientProperty("element", pfile);
            menuFileItem.setToolTipText(p);
            panel.add(menuFileItem);
        }
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void showFilesDialog() {
        List files = this.project.getTTX().getFiles();
        if (files == null) {
            return;
        }
        final JDialog dialog = new JDialog((Frame)this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENTS"));
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        dialog.setResizable(false);
        GridPanel panel = new GridPanel();
        panel.setBorder(new EmptyBorder(new Insets(10, 20, 10, 20)));
        panel.setLayout(new GridLayout(0, 1, 0, 2));
        JScrollPane scroll = new JScrollPane(panel);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        if (files.size() > 20) {
            scroll.setPreferredSize(new Dimension(800, 800));
        }
        dialog.add(scroll);
        int no = 0;
        for (Raw pfile : files) {
            JButton menuFileItem = new JButton(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE") + " " + ++no){
                final /* synthetic */ TTXMenu this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent a) {
                    dialog.setVisible(false);
                    dialog.dispose();
                    JButton menu = (JButton)a.getSource();
                    Raw file = (Raw)menu.getClientProperty("element");
                    this.this$0.project.getTTX().setCurrentFile(file);
                }
            });
            menuFileItem.setHorizontalAlignment(2);
            menuFileItem.putClientProperty("element", pfile);
            panel.add(menuFileItem);
        }
        Dimension dlgSize = dialog.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void showTUPopupMenu(JPopupMenu menu, final TTXUnit tu) {
        JPopupMenu menuTU = menu;
        JMenuItem menuBookmark = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BOOKMARK SEGMENT")){
            final /* synthetic */ TTXMenu this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                this.this$0.toggleBookmark(tu);
            }
        });
        menuBookmark.setAccelerator(KeyStroke.getKeyStroke(66, AppPreferences.modifier));
        if (tu.bookmark) {
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_BOOKMARK_PLUS, (int)menuBookmark.getFont().getSize(), (Color)menuBookmark.getForeground());
            menuBookmark.setIcon((Icon)ficon);
        }
        menuTU.add(menuBookmark);
        JMenuItem menuPropagate = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROPAGATE")){

            @Override
            public void actionPerformed(ActionEvent a) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TTXMenu.this.propagate();
                    }
                });
            }
        });
        menuTU.add(menuPropagate);
    }

    public void showTTX() {
        TTXEditor dlg = new TTXEditor(this.topui, this, this.project, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TTX PROJECT"));
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public int showXMLElement(XMLElement elem) {
        XMLElementEditor dlg = new XMLElementEditor(this.topui, elem);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        return dlg.getStatus();
    }

    public void showPopUp(Component comp, int x, int y, Object o) {
        if (this.pop == null) {
            this.createPopupMenu();
        }
        this.pop.putClientProperty("type", o);
        this.pop.show(comp, x, y);
    }

    private void createPopupMenu() {
        this.pop = new JPopupMenu();
        this.pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object o = TTXMenu.this.pop.getClientProperty("type");
                if (o instanceof TTXUnit) {
                    TTXUnit tu = (TTXUnit)o;
                    TTXMenu.this.showTUPopupMenu(TTXMenu.this.pop, tu);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TTXMenu.this.pop.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                TTXMenu.this.pop.removeAll();
            }
        });
    }

    void toggleBookmark(TTXUnit tu) {
        tu.bookmark = !tu.bookmark;
    }

    private void propagate() {
        Workflow process = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
        if (process != null) {
            String source = process.getSource();
            String replacement = process.getTarget();
            int i = this.project.getTTX().propagate(source, replacement);
            if (i > 0) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROPAGATION TO SEGMENTS:") + " " + i);
            }
        }
    }
}

