/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.XMLHelper;
import translator.qa.Fixable;
import translator.qa.Issue;

public class TTXUnit
extends DefaultXMLElement
implements Comparable,
Fixable {
    public int sp = -1;
    public int tp = -1;
    private int projectID;
    public boolean bookmark;
    private int match = -1;
    private int matchType = -1;
    private int state = 0;
    public boolean repetition = false;
    public boolean number = false;
    TTXUnit previousTU;
    TTXUnit nextTU;
    private List issues;

    public TTXUnit(int projectID) {
        this.projectID = projectID;
    }

    public int geProjectID() {
        return this.projectID;
    }

    public TTXUnit getPreviousTranslationUnit() {
        return this.previousTU;
    }

    public TTXUnit getNextTranslationUnit() {
        return this.nextTU;
    }

    public int compareTo(Object compareObject) {
        TTXUnit tu = (TTXUnit)compareObject;
        String s1 = this.getSourceText().trim();
        String s2 = tu.getSourceText().trim();
        int i = s1.compareToIgnoreCase(s2);
        return i;
    }

    public void setMatch(int i, int t, boolean store) {
        if (this.match == -1) {
            this.match = i;
            this.matchType = t;
        }
    }

    public int getMatch() {
        return this.match;
    }

    public int getMatchType() {
        return this.matchType;
    }

    public void setState(int i) {
        this.state = i;
    }

    public int getState() {
        return this.state;
    }

    public void removeMatch(boolean store) {
        if (this.match != -1) {
            this.match = -1;
        }
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            super.addChild(o);
        }
    }

    void setSource(XMLElement elem) {
        List children = this.getChildren("Tuv");
        if (children.size() > 0) {
            children.set(0, elem);
        } else {
            this.addChild(elem);
        }
    }

    public void setTarget(XMLElement elem) {
        List children = this.getChildren("Tuv");
        if (children.size() > 1) {
            children.set(1, elem);
        } else {
            this.addChild(elem);
        }
    }

    public XMLElement getSource() {
        XMLElement elem = null;
        List children = this.getChildren("Tuv");
        if (children.size() > 0) {
            elem = (XMLElement)children.get(0);
        }
        return elem;
    }

    public XMLElement getTarget() {
        XMLElement elem = null;
        List children = this.getChildren("Tuv");
        if (children.size() > 1) {
            elem = (XMLElement)children.get(1);
        }
        return elem;
    }

    public String getSourceXMLText() {
        List list;
        XMLElement elem = this.getSource();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getXMLTextContent(list, sb);
        }
        return sb.toString();
    }

    public String getTargetXMLText() {
        List list;
        XMLElement elem = this.getTarget();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getXMLTextContent(list, sb);
        }
        return sb.toString();
    }

    public String getSourceText() {
        List list;
        XMLElement elem = this.getSource();
        StringBuffer sb = new StringBuffer();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getTextContent(list, sb);
        }
        return sb.toString();
    }

    public String getTargetText() {
        List list;
        XMLElement elem = this.getTarget();
        StringBuffer sb = new StringBuffer();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getTextContent(list, sb);
        }
        return sb.toString();
    }

    private void getTextContent(List children, StringBuffer sb) {
        for (Object object : children) {
            List list;
            if (object instanceof String) {
                String s = object.toString();
                s = XMLHelper.resolveEntitiesXML(s);
                sb.append(s);
                continue;
            }
            XMLElement elem = (XMLElement)object;
            String name = elem.getName();
            if (name.equals("ut") || (list = elem.getChildren()).size() <= 0) continue;
            this.getTextContent(list, sb);
        }
    }

    private void getXMLTextContent(List children, StringBuilder sb) {
        for (Object object : children) {
            List list;
            if (object instanceof String) {
                String s = object.toString();
                s = XMLHelper.resolveXMLEntities(s);
                sb.append(s);
                continue;
            }
            XMLElement elem = (XMLElement)object;
            String name = elem.getName();
            if (name.equals("ut") || (list = elem.getChildren()).size() <= 0) continue;
            this.getXMLTextContent(list, sb);
        }
    }

    public int[] getTargetTagsPositions() {
        List list;
        int[] pos = new int[20];
        XMLElement elem = this.getTarget();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getTagsPositions(list, pos, 0, 0);
        }
        return pos;
    }

    public int[] getSourceTagsPositions() {
        List list;
        int[] pos = new int[20];
        XMLElement elem = this.getSource();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getTagsPositions(list, pos, 0, 0);
        }
        return pos;
    }

    private void getTagsPositions(List children, int[] pos, int cpos, int ind) {
        for (Object object : children) {
            XMLElement elem;
            List list;
            if (object instanceof String) {
                String s = object.toString();
                s = XMLHelper.resolveEntitiesXML(s);
                cpos += s.length();
                continue;
            }
            if (cpos > 0 && ind < 20) {
                pos[ind] = cpos;
                ++ind;
            }
            if ((list = (elem = (XMLElement)object).getChildren()).size() <= 0) continue;
            this.getTagsPositions(list, pos, cpos, ind);
        }
    }

    public boolean propagate(String s, int[] tagpos) {
        List list;
        int j;
        ArrayList<String> subStrings = new ArrayList<String>();
        ArrayList<Object> elems = new ArrayList<Object>();
        int k = 0;
        boolean prop = false;
        int len = s.length();
        for (int i = 0; i < tagpos.length && (j = tagpos[i]) != 0 && j <= len; ++i) {
            String sub = s.substring(k, j);
            if (sub.length() > 0) {
                subStrings.add(sub);
            }
            k = j;
        }
        if (k < s.length()) {
            subStrings.add(s.substring(k));
        }
        int n = 0;
        XMLElement selem = this.getSource();
        if (selem != null && (list = selem.getChildren()).size() > 0) {
            for (Object object : list) {
                String empty;
                if (object instanceof XMLElement) {
                    XMLElement e = (XMLElement)object;
                    elems.add(e);
                    continue;
                }
                if (n >= subStrings.size() || (empty = object.toString()).length() <= 0) continue;
                String sub = subStrings.get(n).toString();
                elems.add(sub);
                ++n;
            }
            while (n < subStrings.size()) {
                String sub = subStrings.get(n).toString();
                elems.add(sub);
                ++n;
            }
        }
        if (elems.size() > 0) {
            XMLElement telem = this.getTarget();
            List list2 = telem.getChildren();
            list2.clear();
            Iterator it = elems.iterator();
            while (it.hasNext()) {
                list2.add(it.next());
            }
            prop = true;
        }
        return prop;
    }

    @Override
    public void addIssue(Issue issue) {
        this.issues.add(issue);
    }

    @Override
    public List getIssues() {
        return this.issues;
    }

    @Override
    public void setIssues() {
        this.issues = new ArrayList(2);
    }
}

