/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.Project;
import translator.ProjectView;
import translator.SegmentParser;
import translator.TargetView;
import translator.TranslateEvent;
import translator.Workflow;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ttx.TTXUnit;
import translator.ttx.TTXView;

public class TTXWorkflow {
    private MainView topui;
    private ProjectView prview;
    private MemoryView mview;
    private WorkflowView wview;
    private Project project;
    private Workflow workflow;
    private TTXUnit tucheck;
    private TTXUnit tusplit;
    private int checkno = -1;
    private TTX ttx;
    private List tunits;
    private JProgressBar pb;
    private LinkedHashMap smap;
    private LinkedHashMap tmap;
    private int direction = 0;
    private boolean pretranslationStarted = false;
    private String firstSourceTag;
    private String firstTargetTag;
    private String lastTargetTag;
    private String lastSourceTag;
    private Pattern startTagsPattern;
    private Pattern endTagsPattern;
    private Pattern xtagsPattern;
    int stags;
    int ttags;
    String sourceText = "";
    String targetText = "";

    public TTXWorkflow(MainView topui, Workflow workflow, TTX ttx) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.mview = topui.getMemoryView();
        this.wview = topui.getWorkflowView();
        this.project = this.prview.getProject();
        this.pb = this.prview.getProgressBar();
        this.smap = new LinkedHashMap();
        this.tmap = new LinkedHashMap();
        this.xtagsPattern = Pattern.compile("<[/]*x.*?\\d+");
        this.workflow = workflow;
        this.ttx = ttx;
        this.startTagsPattern = Pattern.compile(AppPreferences.startTagRegEx);
        this.endTagsPattern = Pattern.compile(AppPreferences.endTagRegEx);
    }

    public void setCheckStart(int start) {
        this.checkno = start;
        this.tucheck = null;
        this.sourceText = "";
        this.targetText = "";
        this.direction = 0;
        this.pretranslationStarted = false;
    }

    public void cancelCheck() {
        this.tucheck = null;
        this.checkno = -1;
        this.direction = 0;
    }

    public void prepareTUSplit() {
        int fid = this.tucheck.geProjectID();
        TTXUnit tunit = new TTXUnit(fid);
        tunit.setName("Tu");
        tunit.setAttribute("MatchPercent", "100");
        DefaultXMLElement tus = new DefaultXMLElement();
        tus.setName("Tuv");
        DefaultXMLElement tut = new DefaultXMLElement();
        tut.setName("Tuv");
        String id = this.tucheck.getAttribute("id");
        if (id != null) {
            tunit.setAttribute("id", id + "*");
        }
        XMLElement ttus = this.tucheck.getSource();
        XMLElement ttut = this.tucheck.getTarget();
        if (ttus != null) {
            tus.setAttribute("Lang", ttus.getAttribute("Lang"));
        }
        if (ttut != null) {
            tut.setAttribute("Lang", ttut.getAttribute("Lang"));
            tut.setContent(0, "");
        }
        tunit.setSource(tus);
        tunit.setTarget(tut);
        this.tusplit = tunit;
    }

    private boolean makeSplitTU(XMLElement elem, String text) {
        if (this.stags >= 0 || this.ttags >= 0) {
            boolean correct = XMLHelper.parseSegment(elem, this.smap, this.tmap, text, true);
            if (!correct) {
                return false;
            }
        } else {
            List list = elem.getChildren();
            list.clear();
            elem.setContent(0, text);
        }
        return true;
    }

    public void splitTU() {
        if (this.tucheck == null || this.project.filter) {
            return;
        }
        int index = this.tunits.indexOf(this.tucheck) + 1;
        int index2 = -1;
        List tunits2 = null;
        int fileID = this.tucheck.geProjectID();
        TTX t = this.project.getTTX(fileID);
        if (t != null) {
            tunits2 = t.getCurrentFile().getTransUnits();
            index2 = tunits2.indexOf(this.tucheck) + 1;
        }
        XMLElement orgSource = this.tucheck.getSource();
        XMLElement orgTarget = this.tucheck.getTarget();
        if (orgSource != null && orgTarget != null) {
            this.prepareTUSplit();
            String orgSourceString = this.workflow.getSource();
            String orgTargetString = this.workflow.getTarget();
            int scaret = this.topui.getSourcePane().getCaretPosition();
            int tcaret = this.topui.getTargetPane().getCaretPosition();
            if (scaret > 0 && scaret < orgSourceString.length()) {
                boolean ok;
                XMLElement splitSource = this.tusplit.getSource();
                XMLElement splitTarget = this.tusplit.getTarget();
                String newSourceOrg = orgSourceString.substring(0, scaret);
                if (this.firstSourceTag != null) {
                    newSourceOrg = this.firstSourceTag + newSourceOrg;
                }
                String newSplitSourceOrg = orgSourceString.substring(scaret);
                if (this.lastSourceTag != null) {
                    newSplitSourceOrg = newSplitSourceOrg + this.lastSourceTag;
                }
                if (!(ok = this.makeSplitTU(orgSource, newSourceOrg))) {
                    return;
                }
                ok = this.makeSplitTU(splitSource, newSplitSourceOrg);
                if (!ok) {
                    return;
                }
                if (orgTargetString.length() > 0) {
                    String newTargetOrg = orgTargetString.substring(0, tcaret);
                    if (this.firstTargetTag != null) {
                        newTargetOrg = this.firstTargetTag + newTargetOrg;
                    }
                    String newSplitTargetOrg = orgTargetString.substring(tcaret);
                    if (this.lastTargetTag != null) {
                        newSplitTargetOrg = newSplitTargetOrg + this.lastTargetTag;
                    }
                    if (!(ok = this.makeSplitTU(orgTarget, newTargetOrg))) {
                        return;
                    }
                    ok = this.makeSplitTU(splitTarget, newSplitTargetOrg);
                    if (!ok) {
                        return;
                    }
                }
                if (index2 > 0 && tunits2 != null) {
                    tunits2.add(index2, this.tusplit);
                    if (this.project.glue) {
                        this.tunits.add(index, this.tusplit);
                    }
                } else {
                    this.tunits.add(index, this.tusplit);
                }
                this.checkno = this.tunits.indexOf(this.tucheck);
                this.direction = 1;
                this.setNextTU();
            }
        }
    }

    public void joinTU() {
        TTXUnit joinTU;
        if (this.tucheck == null || this.project.filter) {
            return;
        }
        int fileID = this.tucheck.geProjectID();
        int index = this.tunits.indexOf(this.tucheck) + 1;
        if (index < this.tunits.size() && (joinTU = (TTXUnit)this.tunits.get(index)) != null) {
            if (fileID != joinTU.geProjectID()) {
                return;
            }
            XMLElement orgSource = this.tucheck.getSource();
            XMLElement orgTarget = this.tucheck.getTarget();
            XMLElement joinSource = joinTU.getSource();
            XMLElement joinTarget = joinTU.getTarget();
            if (orgSource != null && orgTarget != null && joinSource != null && joinTarget != null) {
                List orgSList = orgSource.getChildren();
                List orgTList = orgTarget.getChildren();
                List joinSList = joinSource.getChildren();
                List joinTList = joinTarget.getChildren();
                if (joinSList.size() > 0) {
                    for (Object object : joinSList) {
                        orgSList.add(object);
                    }
                }
                if (joinTList.size() > 0) {
                    for (Object object : joinTList) {
                        orgTList.add(object);
                    }
                }
                this.tunits.remove(index);
                this.checkno = this.tunits.indexOf(this.tucheck);
                this.direction = 1;
                this.setNextTU();
            }
        }
    }

    private String[] getSourceElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("ut")) {
                    ed = false;
                }
                int tagNo = ++this.stags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                this.smap.put(tname, object);
                fs = fs + stag;
                String[] arr = this.getSourceElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private String[] getTargetElements(List list, boolean edit) {
        String fs = "";
        String es = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean ed = true;
                boolean em = false;
                if (name.equals("ut")) {
                    ed = false;
                }
                int tagNo = ++this.ttags;
                String tname = "x" + tagNo;
                String stag = null;
                String etag = null;
                if (!em) {
                    stag = "<" + tname + ">";
                    etag = "</" + tname + ">";
                } else {
                    stag = "<" + tname + "/>";
                }
                this.tmap.put(tname, object);
                fs = fs + stag;
                String[] arr = this.getTargetElements(li, ed);
                if (arr != null) {
                    fs = fs + arr[0];
                    es = es + arr[1];
                }
                if (etag == null) continue;
                fs = fs + etag;
                continue;
            }
            if (!edit) continue;
            es = es + object.toString();
            fs = fs + object.toString();
        }
        String[] sarr = new String[]{fs, es};
        return sarr;
    }

    private void setNextTU() {
        this.ttx.saved = false;
        this.workflow.setSource("", false);
        this.workflow.setTarget("");
        boolean isQA = this.project.isQAFilterWorkflow();
        while (this.checkno < this.tunits.size()) {
            Object o = this.tunits.get(this.checkno);
            if (o != null && o instanceof TTXUnit) {
                String per;
                this.tucheck = (TTXUnit)o;
                if ((AppPreferences.skipReviewedJump || AppPreferences.skipReviewed) && (per = this.tucheck.getAttribute("MatchPercent")) != null && per.equals("100")) {
                    this.pb.setValue(this.checkno);
                    this.tucheck = null;
                    ++this.checkno;
                    continue;
                }
                AppPreferences.skipReviewedJump = false;
                this.pb.setValue(this.checkno);
                this.sourceText = this.tucheck.getSourceText();
                this.targetText = this.tucheck.getTargetText();
                TTXView view = this.ttx.getView();
                if (AppPreferences.replaceAndEdit) {
                    view.replaceBeforeEdit(this.tucheck);
                }
                view.browseToUnit(this.checkno);
                ++this.checkno;
                break;
            }
            this.tucheck = null;
            ++this.checkno;
        }
        if (this.tucheck != null) {
            XMLElement stuv = this.tucheck.getSource();
            XMLElement ttuv = this.tucheck.getTarget();
            if (stuv != null) {
                List slist = stuv.getChildren();
                List tlist = null;
                if (ttuv != null) {
                    tlist = ttuv.getChildren();
                } else {
                    ttuv = new DefaultXMLElement();
                    ttuv.setName("Tuv");
                    String lang = this.ttx.getTargetLang();
                    if (lang != null) {
                        ttuv.setAttribute("Lang", lang);
                    }
                    this.tucheck.setTarget(ttuv);
                    tlist = ttuv.getChildren();
                }
                this.smap.clear();
                this.stags = 0;
                this.tmap.clear();
                this.ttags = 0;
                this.firstSourceTag = null;
                this.firstTargetTag = null;
                this.lastTargetTag = null;
                this.lastSourceTag = null;
                String[] sarr = this.getSourceElements(slist, true);
                String[] tarr = this.getTargetElements(tlist, true);
                String fsource = sarr[0];
                String ftarget = tarr[0];
                boolean isTargetEmpty = false;
                if (ftarget.length() > 0) {
                    boolean hasString = XMLHelper.hasStringContent(ftarget);
                    if (!hasString) {
                        ftarget = "";
                        isTargetEmpty = true;
                    }
                } else {
                    isTargetEmpty = true;
                }
                if (isTargetEmpty) {
                    int indxs;
                    int exstag;
                    this.tmap.clear();
                    while ((fsource.startsWith("<x") || fsource.startsWith("</x")) && (exstag = this.firstTagsIndex(fsource)) != -1) {
                        this.firstTargetTag = this.firstSourceTag == null && this.firstTargetTag == null ? (this.firstSourceTag = fsource.substring(0, exstag)) : (this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag));
                        fsource = fsource.substring(exstag);
                    }
                    while (fsource.endsWith(">") && (indxs = this.lastTagsIndex(fsource)) != -1) {
                        this.lastTargetTag = this.lastSourceTag == null && this.lastTargetTag == null ? (this.lastSourceTag = fsource.substring(indxs)) : (this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag);
                        fsource = fsource.substring(0, indxs);
                    }
                }
                this.workflow.setTarget(ftarget);
                this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                this.workflow.showfreqWords(fsource, false);
            }
        }
    }

    private void setPrevTU() {
        this.ttx.saved = false;
        this.workflow.setSource("", false);
        this.workflow.setTarget("");
        boolean isQA = this.project.isQAFilterWorkflow();
        while (this.checkno >= 0) {
            Object o = this.tunits.get(this.checkno);
            if (o != null && o instanceof TTXUnit) {
                String per;
                this.tucheck = (TTXUnit)o;
                if (AppPreferences.skipReviewed && (per = this.tucheck.getAttribute("MatchPercent")) != null && per.equals("100")) {
                    this.pb.setValue(this.checkno);
                    this.tucheck = null;
                    --this.checkno;
                    continue;
                }
                this.pb.setValue(this.checkno);
                this.sourceText = this.tucheck.getSourceText();
                this.targetText = this.tucheck.getTargetText();
                TTXView view = this.ttx.getView();
                if (AppPreferences.replaceAndEdit) {
                    view.replaceBeforeEdit(this.tucheck);
                }
                view.browseToUnit(this.checkno);
                --this.checkno;
                break;
            }
            this.tucheck = null;
            --this.checkno;
        }
        if (this.tucheck != null) {
            XMLElement stuv = this.tucheck.getSource();
            XMLElement ttuv = this.tucheck.getTarget();
            if (stuv != null) {
                List slist = stuv.getChildren();
                List tlist = null;
                if (ttuv != null) {
                    tlist = ttuv.getChildren();
                } else {
                    ttuv = new DefaultXMLElement();
                    ttuv.setName("Tuv");
                    String lang = this.ttx.getTargetLang();
                    if (lang != null) {
                        ttuv.setAttribute("Lang", lang);
                    }
                    this.tucheck.setTarget(ttuv);
                    tlist = ttuv.getChildren();
                }
                this.smap.clear();
                this.stags = 0;
                this.tmap.clear();
                this.ttags = 0;
                this.firstSourceTag = null;
                this.firstTargetTag = null;
                this.lastTargetTag = null;
                this.lastSourceTag = null;
                String[] sarr = this.getSourceElements(slist, true);
                String[] tarr = this.getTargetElements(tlist, true);
                String fsource = sarr[0];
                String ftarget = tarr[0];
                boolean isTargetEmpty = false;
                if (ftarget.length() > 0) {
                    boolean hasString = XMLHelper.hasStringContent(ftarget);
                    if (!hasString) {
                        ftarget = "";
                        isTargetEmpty = true;
                    }
                } else {
                    isTargetEmpty = true;
                }
                if (isTargetEmpty) {
                    int indxs;
                    int exstag;
                    this.tmap.clear();
                    while ((fsource.startsWith("<x") || fsource.startsWith("</x")) && (exstag = this.firstTagsIndex(fsource)) != -1) {
                        this.firstTargetTag = this.firstSourceTag == null && this.firstTargetTag == null ? (this.firstSourceTag = fsource.substring(0, exstag)) : (this.firstSourceTag = this.firstSourceTag + fsource.substring(0, exstag));
                        fsource = fsource.substring(exstag);
                    }
                    while (fsource.endsWith(">") && (indxs = this.lastTagsIndex(fsource)) != -1) {
                        this.lastTargetTag = this.lastSourceTag == null && this.lastTargetTag == null ? (this.lastSourceTag = fsource.substring(indxs)) : (this.lastSourceTag = fsource.substring(indxs) + this.lastSourceTag);
                        fsource = fsource.substring(0, indxs);
                    }
                }
                this.workflow.setTarget(ftarget);
                this.workflow.setSource(fsource, AppPreferences.automaticMatching);
                this.workflow.showfreqWords(fsource, false);
            }
        }
    }

    public boolean updateTU() {
        if (this.tucheck != null) {
            TargetView trview;
            int state;
            String target = this.workflow.getTarget();
            String source = this.workflow.getSource();
            if (source.length() > 0 && source.charAt(0) == '?') {
                source = AssembleParser.clearSegmentPattern(source);
                target = AssembleParser.clearSegmentPattern(target);
            } else if (target.length() > 0 && target.charAt(0) == '?') {
                source = AssembleParser.clearSegmentPattern(source);
                target = AssembleParser.clearSegmentPattern(target);
            }
            if (target.length() == 0 && AppPreferences.copysource) {
                target = source;
            }
            if (this.firstSourceTag != null) {
                source = this.firstSourceTag + source;
            }
            if (target.length() > 0 && this.firstTargetTag != null) {
                target = this.firstTargetTag + target;
            }
            if (this.lastSourceTag != null) {
                source = source + this.lastSourceTag;
            }
            if (target.length() > 0 && this.lastTargetTag != null) {
                target = target + this.lastTargetTag;
            }
            XMLElement tarXML = this.tucheck.getTarget();
            if (this.stags > 0 || this.ttags > 0) {
                boolean correct = XMLHelper.parseSegment(tarXML, this.smap, this.tmap, target, true);
                if (!correct) {
                    WorkflowManager man = this.wview.getWorkflowManager();
                    man.stopTimer();
                    man.standByTimer(false);
                    return false;
                }
            } else {
                tarXML.getChildren().clear();
                tarXML.setContent(0, target);
            }
            TranslateEvent event = this.mview.getTranslateEvent();
            if (event != null) {
                boolean storeMatch = false;
                int accuracy = event.getAssembledAccuracy();
                if (accuracy > 100) {
                    int context = event.getContextAccuracy();
                    if (context == 102) {
                        this.tucheck.setMatch(102, 1, storeMatch);
                    } else if (context == 101) {
                        this.tucheck.setMatch(101, 1, storeMatch);
                    } else {
                        this.tucheck.setMatch(100, 1, storeMatch);
                    }
                } else {
                    int fuzzyaccuracy = event.getFuzzyAccuracy();
                    if (fuzzyaccuracy > 0) {
                        this.tucheck.setMatch(fuzzyaccuracy, 2, storeMatch);
                    } else {
                        this.tucheck.setMatch(accuracy, 3, storeMatch);
                    }
                }
            }
            if ((state = (trview = this.topui.getTargetView()).getTUState()) == 1) {
                this.tucheck.setState(1);
            } else if (state == 4) {
                this.tucheck.setState(2);
            }
            String allsource = this.tucheck.getSourceText();
            String alltarget = this.tucheck.getTargetText();
            if (allsource.length() > 0) {
                boolean prop = true;
                if (!AppPreferences.propagate) {
                    prop = false;
                }
                this.ttx.addToMemory(allsource, this.tucheck, prop);
                if (AppPreferences.fragmentAdjustment && alltarget.length() > 0 && event != null) {
                    event.adjustSegmentFragments(allsource, alltarget);
                }
            }
        }
        return true;
    }

    public void checkNextTU() {
        boolean correct;
        Raw currentFile = this.ttx.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        boolean filter = false;
        boolean glue = false;
        this.tunits = this.ttx.getView().getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.ttx.getView().getGluedUnits();
            if (this.tunits == null) {
                this.tunits = currentFile.getTransUnits();
            } else {
                glue = true;
            }
        } else {
            filter = true;
        }
        if (this.tunits.isEmpty()) {
            this.cancelCheck();
            return;
        }
        this.pb.setMinimum(0);
        this.pb.setMaximum(this.tunits.size());
        if (this.direction == -1) {
            this.checkno += 2;
        }
        if (this.checkno == -1) {
            this.setCheckStart(0);
        }
        this.direction = 1;
        if (!this.pretranslationStarted && !this.topui.getResourceLoader().isStartupLoading()) {
            this.pretranslateInMemories();
        }
        if (!(correct = this.updateTU())) {
            return;
        }
        if (this.checkno >= this.tunits.size()) {
            this.pb.setValue(this.pb.getMaximum());
            if (this.tunits.size() > 0) {
                TTXView view = this.ttx.getView();
                view.browseToUnit(this.tunits.size() - 1);
            }
            this.project.cancelReviewMode();
            return;
        }
        if (!filter) {
            this.ttx.setLastID(Integer.toString(this.checkno));
        }
        this.setNextTU();
        if (this.tucheck != null) {
            int currentID;
            int projectID = this.tucheck.geProjectID();
            if ((filter || glue) && (currentID = this.ttx.getID()) != projectID) {
                this.project.setTTX(projectID);
                this.ttx = this.project.getTTX();
                this.ttx.saved = false;
                String p = this.ttx.getPath();
                if (p != null) {
                    this.project.setTitleForFile(p);
                }
            }
        }
    }

    public void checkPreviousTU() {
        boolean correct;
        Raw currentFile = this.ttx.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        boolean filter = false;
        boolean glue = false;
        this.tunits = this.ttx.getView().getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.ttx.getView().getGluedUnits();
            if (this.tunits == null) {
                this.tunits = currentFile.getTransUnits();
            } else {
                glue = true;
            }
        } else {
            filter = true;
        }
        int size = this.tunits.size();
        if (size == 0) {
            this.cancelCheck();
            return;
        }
        this.pb.setMinimum(0);
        this.pb.setMaximum(size);
        if (this.direction == 1) {
            this.checkno -= 2;
        }
        if (this.checkno == -1) {
            if (this.tucheck == null) {
                int no = size - 1;
                this.setCheckStart(no);
            } else {
                boolean correct2 = this.updateTU();
                if (!correct2) {
                    return;
                }
                this.pb.setValue(this.pb.getMinimum());
                this.project.cancelReviewMode();
                return;
            }
        }
        this.direction = -1;
        if (!this.pretranslationStarted && !this.topui.getResourceLoader().isStartupLoading()) {
            this.pretranslateInMemories();
        }
        if (!(correct = this.updateTU())) {
            return;
        }
        if (!filter) {
            this.ttx.setLastID(Integer.toString(this.checkno));
        }
        this.setPrevTU();
        if (this.tucheck != null) {
            int currentID;
            int projectID = this.tucheck.geProjectID();
            if ((filter || glue) && (currentID = this.ttx.getID()) != projectID) {
                this.project.setTTX(projectID);
                this.ttx = this.project.getTTX();
                this.ttx.saved = false;
                String p = this.ttx.getPath();
                if (p != null) {
                    this.project.setTitleForFile(p);
                }
            }
        }
    }

    public TTXUnit getCheckTransUnit() {
        return this.tucheck;
    }

    public int getCheckTUIndex() {
        return this.checkno;
    }

    private int firstTagsIndex(String s) {
        int i = -1;
        Matcher m = this.startTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.end();
        }
        return i;
    }

    private int lastTagsIndex(String s) {
        int i = -1;
        Matcher m = this.endTagsPattern.matcher(s);
        boolean b = m.find();
        if (b) {
            i = m.start();
        }
        return i;
    }

    public void setPretransationStarted(boolean pstart) {
        this.pretranslationStarted = pstart;
    }

    public boolean pretransationStarted() {
        return this.pretranslationStarted;
    }

    public boolean pretranslateInMemories() {
        int from = this.checkno;
        int to = this.tunits.size();
        boolean started = false;
        List mems = this.mview.getLocalMemories();
        if (mems.size() > 0) {
            this.pretranslationStarted = true;
            for (Object object : mems) {
                final Memory m = (Memory)object;
                if (m.isPretranslateOnly() || m.getWorkflowMode() != 1 || m.isPretranslated()) continue;
                String procName = m.getName() + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
                m.initMemoryProgress(from, to, procName);
                SegmentParser cparser = m.getTMX().getParser();
                cparser.clearCache();
                this.mview.clearTMPane(m);
                m.setPretranslated(true);
                m.setActive(true);
                started = true;
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ TTXWorkflow this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        this.this$0.pretranslate(m);
                        return null;
                    }

                    @Override
                    protected void done() {
                        m.removeMemoryProgress();
                        m.update();
                        m.setActive(false);
                    }
                };
                worker.execute();
            }
        }
        return started;
    }

    public void pretranslate(Memory ctm) {
        int from;
        Raw currentFile = this.ttx.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        this.tunits = this.ttx.getView().getFilteredUnits();
        if (this.tunits == null) {
            this.tunits = this.ttx.getView().getGluedUnits();
            if (this.tunits == null) {
                this.tunits = currentFile.getTransUnits();
            }
        }
        if ((from = this.checkno) == -1) {
            from = 0;
        }
        SegmentParser cparser = ctm.getTMX().getParser();
        try {
            TTXUnit[] units = new TTXUnit[this.tunits.size() - from];
            int n = 0;
            ListIterator it = this.tunits.listIterator(from);
            while (it.hasNext()) {
                TTXUnit u;
                units[n] = u = (TTXUnit)it.next();
                ++n;
            }
            for (TTXUnit tu : units) {
                if (!ctm.isClosed()) {
                    String cs;
                    int state = tu.getState();
                    if (state == 1) {
                        ++from;
                        continue;
                    }
                    String source = tu.getSourceText();
                    if (source.length() > 0 && (cs = cparser.cleanSegment(source)).trim().length() > 0) {
                        cparser.translate(source, cs, tu, true);
                        ctm.update();
                    }
                    if (++from % 10 != 0) continue;
                    ctm.updateMemoryProgress(from, ctm.getName(), true);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.topui, ex.getMessage(), "Pretranslation Error in " + ctm.getName(), 0);
        }
    }

    public void analyse(Memory ctm) {
        Raw currentFile = this.ttx.getCurrentFile();
        if (currentFile == null) {
            return;
        }
        List atunits = this.ttx.getView().getFilteredUnits();
        if (atunits == null && (atunits = this.ttx.getView().getGluedUnits()) == null) {
            atunits = currentFile.getTransUnits();
        }
        int from = 0;
        SegmentParser cparser = ctm.getTMX().getParser();
        cparser.setAnalyseMode(true);
        try {
            while (from < atunits.size()) {
                Object o = atunits.get(from);
                if (o != null && o instanceof TTXUnit) {
                    TTXUnit tu = (TTXUnit)o;
                    int state = tu.getState();
                    if (state == 1) {
                        ++from;
                        continue;
                    }
                    String source = tu.getSourceText();
                    if (source.length() > 0) {
                        cparser.analyse(source, tu);
                    }
                }
                if (++from % 10 != 0) continue;
                ctm.updateMemoryProgress(from, ctm.getName(), false);
            }
            cparser.setAnalyseMode(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getTagsXML(String tid, boolean source) {
        Matcher m = this.xtagsPattern.matcher(tid);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            Object ot;
            boolean endTag = false;
            String s = m.group();
            if (s.startsWith("</")) {
                s = s.substring(2);
                endTag = true;
            } else {
                s = s.substring(1);
            }
            if ((ot = source ? this.smap.get(s) : this.tmap.get(s)) == null) continue;
            XMLElement elem = (XMLElement)ot;
            String name = elem.getName();
            if (name.equals("ntr")) {
                sb.append(elem.getContent(0));
                continue;
            }
            sb.append('<');
            if (endTag) {
                sb.append('/');
                sb.append(name);
                sb.append('>');
                continue;
            }
            sb.append(name);
            LinkedHashMap attrMap = elem.getAttributes();
            if (attrMap != null) {
                Set set = attrMap.keySet();
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    sb.append(" ");
                    String s2 = (String)i.next();
                    sb.append(s2);
                    sb.append('=');
                    sb.append('\"');
                    s2 = (String)attrMap.get(s2);
                    sb.append(s2);
                    sb.append('\"');
                }
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

