/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class GridPanel
extends JPanel {
    private TexturePaint texture;
    private Color c = null;
    private Color dc = null;
    private Color bc = null;
    private boolean grid = false;
    private boolean transparent = false;
    private static final double FACTOR = 0.96;

    @Override
    public void setBackground(Color c) {
        this.c = c;
        this.dc = GridPanel.darker(c);
        this.bc = GridPanel.brighter(c);
        super.setBackground(c);
    }

    public void setImage(URL url) throws IOException {
        BufferedImage image = ImageIO.read(url);
        Rectangle rect = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
        this.texture = new TexturePaint(image, rect);
    }

    public void setImage(BufferedImage image) {
        Rectangle rect = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
        this.texture = new TexturePaint(image, rect);
    }

    public BufferedImage getImage() {
        if (this.texture != null) {
            return this.texture.getImage();
        }
        return null;
    }

    public void setGrid(boolean g) {
        this.grid = g;
    }

    public void setTransparent(boolean t) {
        this.transparent = t;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.texture != null) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.texture);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (!this.grid && !this.transparent) {
            super.paintComponent(g);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            if (this.c == null) {
                this.c = super.getBackground();
                this.dc = GridPanel.darker(this.c);
                this.bc = GridPanel.brighter(this.c);
            }
            g2.setPaint(this.c);
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setColor(this.c);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (!this.transparent) {
                int y;
                g2.setColor(this.dc);
                for (y = 8; y < h; y += 16) {
                    g2.drawLine(4, y, w - 4, y);
                }
                g2.setColor(this.bc);
                for (y = 9; y < h; y += 16) {
                    g2.drawLine(4, y, w - 4, y);
                }
            }
        }
    }

    public static Color brighter(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = 24;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.96), 255), Math.min((int)((double)g / 0.96), 255), Math.min((int)((double)b / 0.96), 255));
    }

    public static Color brighter(Color c, double factor) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / factor), 255), Math.min((int)((double)g / factor), 255), Math.min((int)((double)b / factor), 255));
    }

    public static Color darker(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.96), 0), Math.max((int)((double)c.getGreen() * 0.96), 0), Math.max((int)((double)c.getBlue() * 0.96), 0));
    }

    public static Color darker(Color c, double factor) {
        return new Color(Math.max((int)((double)c.getRed() * factor), 0), Math.max((int)((double)c.getGreen() * factor), 0), Math.max((int)((double)c.getBlue() * factor), 0));
    }

    public static Color getContrastColor(Color color) {
        double y = (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
        return y >= 128.0 ? Color.black : Color.white;
    }
}

