/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPopupMenu;

public class GridPopupMenu
extends JPopupMenu {
    private Color c = null;
    private Color dc = null;
    private Color bc = null;
    private boolean grid = true;
    private static final double FACTOR = 0.96;

    @Override
    public void setBackground(Color c) {
        this.c = c;
        this.dc = GridPopupMenu.darker(c);
        this.bc = GridPopupMenu.brighter(c);
        super.setBackground(c);
    }

    public void setGrid(boolean g) {
        this.grid = g;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.grid) {
            super.paintComponent(g);
        } else {
            int y;
            Graphics2D g2 = (Graphics2D)g;
            if (this.c == null) {
                this.c = super.getBackground();
                this.dc = GridPopupMenu.darker(this.c);
                this.bc = GridPopupMenu.brighter(this.c);
            }
            g2.setPaint(this.c);
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setColor(this.c);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(this.dc);
            for (y = 8; y < h; y += 16) {
                g2.drawLine(4, y, w - 4, y);
            }
            g2.setColor(this.bc);
            for (y = 9; y < h; y += 16) {
                g2.drawLine(4, y, w - 4, y);
            }
        }
    }

    public static Color brighter(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = 24;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.96), 255), Math.min((int)((double)g / 0.96), 255), Math.min((int)((double)b / 0.96), 255));
    }

    public static Color darker(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.96), 0), Math.max((int)((double)c.getGreen() * 0.96), 0), Math.max((int)((double)c.getBlue() * 0.96), 0));
    }
}

