/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Optional;
import translator.MainClass;
import translator.ui.DnDTabbedPane;
import translator.ui.GhostGlassPane;

class TabDropTargetListener
implements DropTargetListener {
    private Point prevGlassPt = new Point();

    TabDropTargetListener() {
    }

    private static Optional<GhostGlassPane> getGhostGlassPane(Component component) {
        return Optional.ofNullable(component).filter(c -> c instanceof GhostGlassPane).map(c -> (GhostGlassPane)c);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        TabDropTargetListener.getGhostGlassPane(c).ifPresent(glassPane -> {
            DataFlavor[] f;
            DnDTabbedPane tabbedPane = glassPane.tabbedPane;
            Transferable t = e.getTransferable();
            if (t.isDataFlavorSupported((f = e.getCurrentDataFlavors())[0]) && tabbedPane.dragTabIndex >= 0) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        });
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        TabDropTargetListener.getGhostGlassPane(c).ifPresent(glassPane -> glassPane.setVisible(false));
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        TabDropTargetListener.getGhostGlassPane(c).ifPresent(glassPane -> {
            DnDTabbedPane tabbedPane = glassPane.tabbedPane;
            Point glassPt = e.getLocation();
            if (tabbedPane.getTabPlacement() == 1 || tabbedPane.getTabPlacement() == 3) {
                tabbedPane.initTargetLeftRightLine(tabbedPane.getTargetTabIndex(glassPt));
            } else {
                tabbedPane.initTargetTopBottomLine(tabbedPane.getTargetTabIndex(glassPt));
            }
            if (tabbedPane.hasGhost) {
                glassPane.setPoint(glassPt);
            }
            if (!this.prevGlassPt.equals(glassPt)) {
                glassPane.repaint();
            }
            this.prevGlassPt = glassPt;
            tabbedPane.autoScrollTest(glassPt);
        });
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        TabDropTargetListener.getGhostGlassPane(c).ifPresent(glassPane -> {
            DataFlavor[] f;
            DnDTabbedPane tabbedPane = glassPane.tabbedPane;
            Transferable t = e.getTransferable();
            if (t.isDataFlavorSupported((f = t.getTransferDataFlavors())[0]) && tabbedPane.dragTabIndex >= 0) {
                int target = tabbedPane.getTargetTabIndex(e.getLocation());
                if (target != -1) {
                    tabbedPane.convertTab(tabbedPane.dragTabIndex, target);
                } else {
                    MainClass.getMainView().dropAndDock((GhostGlassPane)glassPane, e.getLocation());
                }
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
            tabbedPane.dragTabIndex = -1;
            glassPane.setVisible(false);
        });
    }
}

