/*
 * Decompiled with CFR 0.152.
 */
package translator.ui.kodo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class KodoBreathingPanel
extends JPanel {
    private float glowAlpha = 0.0f;
    private boolean increasing = true;
    private Color background;
    private Timer timer;

    public KodoBreathingPanel() {
        this.setOpaque(true);
        this.background = new Color(25, 25, 25);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.background);
        g2.fillRect(0, 0, width, height);
        Point2D.Float center = new Point2D.Float(width, height);
        float radius = (float)width * 0.6f;
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{new Color(160, 0, 0, (int)(this.glowAlpha * 255.0f)), new Color(160, 0, 0, 0)};
        RadialGradientPaint paint = new RadialGradientPaint(center, radius, dist, colors);
        g2.setPaint(paint);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, 0.0f, 0.0f));
        g2.dispose();
    }

    public void startBreathing() {
        this.timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KodoBreathingPanel.this.increasing) {
                    KodoBreathingPanel.this.glowAlpha += 0.005f;
                    if (KodoBreathingPanel.this.glowAlpha >= 0.8f) {
                        KodoBreathingPanel.this.glowAlpha = 0.8f;
                        KodoBreathingPanel.this.increasing = false;
                    }
                } else {
                    KodoBreathingPanel.this.glowAlpha -= 0.005f;
                    if (KodoBreathingPanel.this.glowAlpha <= 0.1f) {
                        KodoBreathingPanel.this.glowAlpha = 0.1f;
                        KodoBreathingPanel.this.increasing = true;
                    }
                }
                KodoBreathingPanel.this.repaint();
            }
        });
        this.timer.start();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Exact Kodo Background");
            KodoBreathingPanel panel = new KodoBreathingPanel();
            frame.add(panel);
            frame.setSize(800, 800);
            frame.setDefaultCloseOperation(3);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }
}

