/*
 * Decompiled with CFR 0.152.
 */
package translator.ui.kodo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class KodoPanel
extends JPanel {
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, width, height);
        Point2D.Float center = new Point2D.Float((float)width * 0.95f, (float)height * 0.95f);
        float radius = (float)Math.min(width, height) * 0.6f;
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{new Color(180, 0, 0, 150), new Color(0, 0, 0, 0)};
        RadialGradientPaint redGlow = new RadialGradientPaint(center, radius, dist, colors);
        g2d.setPaint(redGlow);
        g2d.fillRect(0, 0, width, height);
        Path2D.Double curve = new Path2D.Double();
        ((Path2D)curve).moveTo(0.0, (double)height * 0.8);
        ((Path2D)curve).curveTo((double)width * 0.3, (double)height * 0.6, (double)width * 0.7, (double)height * 0.95, width, (double)height * 0.7);
        g2d.setColor(new Color(255, 0, 0, 80));
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(curve);
        g2d.dispose();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("Exact Kodo Background");
            KodoPanel panel = new KodoPanel();
            frame.add(panel);
            frame.setSize(800, 800);
            frame.setDefaultCloseOperation(3);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }
}

