/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.web.WebEngine;
import javafx.stage.FileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import translator.AppPreferences;
import translator.MainView;
import translator.browser.Browser;
import translator.browser.WebPane;
import translator.json.JSONObject;
import translator.web.Proz;
import translator.web.ProzWIWOMessage;
import translator.web.ProzWIWOPost;

public class ProzWIWOSView
extends JFrame {
    private MainView topui;
    private WebPane webPane;
    private Proz proz;
    private ArrayList wiwos;
    private ProzWIWOMessage wiwoMessage;
    private boolean wiwoSent = false;
    private String wordCount;
    private String procentComplete;
    private String sourceLanguageProz = "";
    private String targetLanguageProz = "";
    private static final String CSS = ".triangle-right {\n  position:relative;\n  padding:15px;\n  margin:0em 0 0em;\n  color:#fff;\n  background:#075698; /* default background for browsers without gradient support */\n  /* css3 */\n  background:-webkit-gradient(linear, 0 0, 0 100%, from(#2e88c4), to(#075698));\n  background:-moz-linear-gradient(#2e88c4, #075698);\n  background:-o-linear-gradient(#2e88c4, #075698);\n  background:linear-gradient(#2e88c4, #075698);\n  -webkit-border-radius:10px;\n  -moz-border-radius:10px;\n  border-radius:10px;\n}\n\n/* Variant : for top positioned triangle\n------------------------------------------ */\n\n.triangle-right.top {\n  background:-webkit-gradient(linear, 0 0, 0 100%, from(#075698), to(#2e88c4));\n  background:-moz-linear-gradient(#075698, #2e88c4);\n  background:-o-linear-gradient(#075698, #2e88c4);\n  background:linear-gradient(#075698, #2e88c4);\n}\n\n/* Variant : for left positioned triangle\n------------------------------------------ */\n\n.triangle-right.left {\n  margin-left:40px;\n  background:#075698;\n}\n\n/* Variant : for right positioned triangle\n------------------------------------------ */\n\n.triangle-right.right {\n  margin-right:40px;\n  background:#075698;\n}\n\n/* THE TRIANGLE\n------------------------------------------------------------------------------------------------------------------------------- */\n\n.triangle-right:after {\n  content:\"\";\n  position:absolute;\n  bottom:-20px; /* value = - border-top-width - border-bottom-width */\n  left:50px; /* controls horizontal position */\n  border-width:20px 0 0 20px; /* vary these values to change the angle of the vertex */\n  border-style:solid;\n  border-color:#075698 transparent;\n  /* reduce the damage in FF3.0 */\n  display:block;\n  width:0;\n}\n\n/* Variant : top\n------------------------------------------ */\n\n.triangle-right.top:after {\n  top:-20px; /* value = - border-top-width - border-bottom-width */\n  right:50px; /* controls horizontal position */\n  bottom:auto;\n  left:auto;\n  border-width:20px 20px 0 0; /* vary these values to change the angle of the vertex */\n  border-color:transparent #075698;\n}\n\n/* Variant : left\n------------------------------------------ */\n\n.triangle-right.left:after {\n  top:16px;\n  left:-40px; /* value = - border-left-width - border-right-width */\n  bottom:auto;\n  border-width:15px 40px 0 0; /* vary these values to change the angle of the vertex */\n  border-color:transparent #075698;\n}\n\n/* Variant : right\n------------------------------------------ */\n\n.triangle-right.right:after {\n  top:16px;\n  right:-40px; /* value = - border-left-width - border-right-width */\n  bottom:auto;\n  left:auto;\n  border-width:15px 0 0 40px; /* vary these values to change the angle of the vertex */\n  border-color:transparent #075698 ;\n}\n.pull-right {\n    float: right !important;\n}\n.pull-left {\n    float: left !important;\n}\n\n.list-inline {\n    padding-left: 0;\n    list-style: none;\n}\n.muted {\n    color: #999;\n}\nli {\n    float: left;\n}\n.button {\n-moz-box-shadow:inset 0px 1px 3px 0px #91b8b3;\n\t-webkit-box-shadow:inset 0px 1px 3px 0px #91b8b3;\n\tbox-shadow:inset 0px 1px 3px 0px #91b8b3;\n\tbackground:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, #768d87), color-stop(1, #6c7c7c));\n\tbackground:-moz-linear-gradient(top, #768d87 5%, #6c7c7c 100%);\n\tbackground:-webkit-linear-gradient(top, #768d87 5%, #6c7c7c 100%);\n\tbackground:-o-linear-gradient(top, #768d87 5%, #6c7c7c 100%);\n\tbackground:-ms-linear-gradient(top, #768d87 5%, #6c7c7c 100%);\n\tbackground:linear-gradient(to bottom, #768d87 5%, #6c7c7c 100%);\n\tfilter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#768d87', endColorstr='#6c7c7c',GradientType=0);\n\tbackground-color:#768d87;\n\t-moz-border-radius:5px;\n\t-webkit-border-radius:5px;\n\tborder-radius:5px;\n\tborder:1px solid #566963;\n\tdisplay:inline-block;\n\tcursor:pointer;\n\tcolor:#ffffff;\n\tfont-family:Arial;\n\tfont-size:15px;\n\tfont-weight:bold;\n\tpadding:6px 23px;\n\ttext-decoration:none;\n\ttext-shadow:0px -1px 0px #2b665e;\n}\n.button:hover {\n\tbackground:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, #6c7c7c), color-stop(1, #768d87));\n\tbackground:-moz-linear-gradient(top, #6c7c7c 5%, #768d87 100%);\n\tbackground:-webkit-linear-gradient(top, #6c7c7c 5%, #768d87 100%);\n\tbackground:-o-linear-gradient(top, #6c7c7c 5%, #768d87 100%);\n\tbackground:-ms-linear-gradient(top, #6c7c7c 5%, #768d87 100%);\n\tbackground:linear-gradient(to bottom, #6c7c7c 5%, #768d87 100%);\n\tfilter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#6c7c7c', endColorstr='#768d87',GradientType=0);\n\tbackground-color:#6c7c7c;\n}\n.button:active {\n\tposition:relative;\n\ttop:1px;\n}\n.button2 {\n\t-moz-box-shadow:inset 0px 1px 3px 0px #f7c5c0;\n\t-webkit-box-shadow:inset 0px 1px 3px 0px #f7c5c0;\n\tbox-shadow:inset 0px 1px 3px 0px #f7c5c0;\n\tbackground:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, #fc8d83), color-stop(1, #e4685d));\n\tbackground:-moz-linear-gradient(top, #fc8d83 5%, #e4685d 100%);\n\tbackground:-webkit-linear-gradient(top, #fc8d83 5%, #e4685d 100%);\n\tbackground:-o-linear-gradient(top, #fc8d83 5%, #e4685d 100%);\n\tbackground:-ms-linear-gradient(top, #fc8d83 5%, #e4685d 100%);\n\tbackground:linear-gradient(to bottom, #fc8d83 5%, #e4685d 100%);\n\tfilter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fc8d83', endColorstr='#e4685d',GradientType=0);\n\tbackground-color:#fc8d83;\n\t-moz-border-radius:5px;\n\t-webkit-border-radius:5px;\n\tborder-radius:5px;\n\tborder:1px solid #d83526;\n\tdisplay:inline-block;\n\tcursor:pointer;\n\tcolor:#ffffff;\n\tfont-family:Arial;\n\tfont-size:15px;\n\tfont-weight:bold;\n\tpadding:6px 23px;\n\ttext-decoration:none;\n\ttext-shadow:0px -1px 0px #b23e35;\n}\n.button2:hover {\n\tbackground:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, #e4685d), color-stop(1, #fc8d83));\n\tbackground:-moz-linear-gradient(top, #e4685d 5%, #fc8d83 100%);\n\tbackground:-webkit-linear-gradient(top, #e4685d 5%, #fc8d83 100%);\n\tbackground:-o-linear-gradient(top, #e4685d 5%, #fc8d83 100%);\n\tbackground:-ms-linear-gradient(top, #e4685d 5%, #fc8d83 100%);\n\tbackground:linear-gradient(to bottom, #e4685d 5%, #fc8d83 100%);\n\tfilter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#e4685d', endColorstr='#fc8d83',GradientType=0);\n\tbackground-color:#e4685d;\n}\n.button2:active {\n\tposition:relative;\n\ttop:1px;\n}";

    public ProzWIWOSView(Proz proz, ArrayList wiwos) {
        this.proz = proz;
        this.wiwos = wiwos;
        this.wiwoMessage = proz.makeNewProzWiwoMessage();
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        this.createView();
        this.loadWiwos();
    }

    public void setWiwos(ArrayList wiwos) {
        this.wiwos = wiwos;
        this.loadWiwos();
    }

    private void loadWiwos() {
        String pc;
        String wc;
        Map languageMap = this.proz.getLanguageCodesMap();
        this.wordCount = wc = this.wiwoMessage.getWordCount();
        this.procentComplete = pc = this.wiwoMessage.getProjectComplete();
        String sourceLang = this.wiwoMessage.getSourceLanguage();
        String targetLang = this.wiwoMessage.getTargetLanguage();
        String nextWiwosURL = this.proz.getNextWiwosURL();
        String previousWiwosURL = this.proz.getPreviousWiwosURL();
        boolean wiwoPosted = this.proz.isWiwoPosted();
        String htmlStart = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body bgcolor=\"#e1e1e1\" style=\"font-family: verdana,arial,helvetica,sans-serif;\">";
        String htmlEnd = "</body></html>";
        StringBuilder sb = new StringBuilder();
        if (!wiwoPosted) {
            sb.append("<table bgcolor=\"#f5f5f5\" align=\"center\" cellpadding=\"5\" cellspacing=\"1\" width=\"1000\" style=\"border: 1px outset white; margin-top:20px; font-size:14px\">");
            sb.append("<tr><td align=\"left\" valign=\"center\">");
            sb.append("<p id=\"para_share\" class=\"triangle-right bottom\" class=\"muted\" style=\"margin: 0px 300px 20px 0px;\">Share information about what you are working on to promote the work you do and track your project history over time.</p>");
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td align=\"right\">");
            sb.append("<textarea autofocus name=\"fields[comment]\" style=\"width:100%;height:50px;font-size:16px;\" wrap=\"virtual\" id=\"comment\"></textarea>");
            sb.append("<div style=\"margin: 0px 0px 0px 0px\" align=\"right\" valign=\"center\">");
            sb.append("<ul class=\"list-inline pull-right\" style=\"margin: 2px 0px 0px 10px;\">");
            if (sourceLang.length() > 0 && targetLang.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(sourceLang);
                sb.append(" to ");
                sb.append(targetLang);
                sb.append("</li>");
                String s = (String)languageMap.get(sourceLang);
                String t = (String)languageMap.get(targetLang);
                if (s != null && t != null) {
                    this.sourceLanguageProz = s;
                    this.targetLanguageProz = t;
                } else if (AppPreferences.prozKudozAskQuestionSourceLanguage != null && AppPreferences.prozKudozAskQuestionTargetLanguage != null) {
                    this.sourceLanguageProz = AppPreferences.prozKudozAskQuestionSourceLanguage;
                    this.targetLanguageProz = AppPreferences.prozKudozAskQuestionTargetLanguage;
                }
            }
            if (wc.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(wc);
                sb.append(" ");
                sb.append("words");
                sb.append("</li>");
            }
            if (AppPreferences.dbField != null && AppPreferences.dbField.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(AppPreferences.dbField);
                sb.append("</li>");
            }
            sb.append("</div>");
            sb.append("<div style=\"margin: 20px 0px 0px 0px\" align=\"center\" valign=\"center\">");
            sb.append("<div align=\"center\" style=\"margin: 0px 10px 0px 0px; display: inline-block\">");
            sb.append("<label style=\"display: inline-block\" class=\"muted\" id=\"label_meter_complete\" for=\"meter_complete\">" + this.procentComplete + "% complete</label><br>    <input id=\"procent_complete\" style=\"margin: 2px 0px 0px 0px\" type =\"range\" max=\"100\" min=\"0\" value=\"" + this.procentComplete + "\"        onchange=\"document.getElementById('label_meter_complete').innerHTML = this.value + '% complete';\"    </input>\n");
            sb.append("</div>");
            sb.append("<div align=\"center\" style=\"margin: 0px 5px 0px 0px; display: inline-block\">");
            sb.append("<label style=\"display: inline-block\" class=\"muted\" id=\"label_top_terms\" for=\"top_terms\">Option: Representative terms (comma-separated, 5 max.)</label><br>    <input id=\"top_terms\" name=\"top_terms\" style=\"margin: 2px 0px 0px 0px; font-size:16px;\" type =\"text\"  size=\"65\"    </input>\n");
            sb.append("</div>");
            String wiwoImageHTML = AppPreferences.prozWiwoImage ? "&nbsp;&nbsp;<input type=\"checkbox\" name=\"image_include\" value=\"y\" checked>Include image" : "&nbsp;&nbsp;<input type=\"checkbox\" name=\"image_include\" value=\"y\">Include image";
            sb.append("<button class=\"button\" id=\"wiwo_new\">Post</button>");
            sb.append("</div>");
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("<tr><td width=100 align=\"right\" valign=\"center\">");
            String wiwoPublicHTML = AppPreferences.prozWiwoPublic ? "&nbsp;&nbsp;<input type=\"checkbox\" name=\"public\" value=\"y\" checked>Shared publicly" : "&nbsp;&nbsp;<input type=\"checkbox\" name=\"public\" value=\"y\">Shared publicly";
            if (AppPreferences.prozWiwoAutoPopup) {
                sb.append("<div align=\"left\" class=\"muted pull-left\" style=\"margin: 0px 0px 0px 0px\"><input type=\"checkbox\" name=\"do_not_show\" value=\"y\">Do not pop it up automatically" + wiwoPublicHTML + wiwoImageHTML + "</div>");
            } else {
                sb.append("<div align=\"left\" class=\"muted pull-left\" style=\"margin: 0px 0px 0px 0px\">" + wiwoPublicHTML + wiwoImageHTML + "</div>");
            }
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("</table>");
        }
        sb.append("<table align=\"center\" cellpadding=\"5\" cellspacing=\"1\" width=\"1000\" style=\"border: 0px outset white; margin-top:20px;margin-bottom:0px;font-size:14px\">");
        sb.append("<tr><td width=100 align=\"center\" valign=\"top\">");
        sb.append("<select id=\"filter_wiwos\" align=top style=\"font-size:16px\">\n    <option>Everyone</option>\n    <option>Mine</option>\n</select>\n");
        sb.append("<button class=\"button\" id=\"wiwos_refresh\">Refresh</button>");
        sb.append("<input id=\"search_field\" name=\"search_field\" onkeydown = \"if (event.keyCode == 13)\n                        document.getElementById('wiwos_search').click()\" style=\"margin: 0px 2px 0px 10px; font-size:16px;\" type =\"text\"  size=\"50\"</input> <button class=\"button\" id=\"wiwos_search\">Search</button>\n");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        for (int i = 0; i < this.wiwos.size(); ++i) {
            ProzWIWOPost wiwo = (ProzWIWOPost)this.wiwos.get(i);
            String wiwoID = wiwo.getWiwoID();
            boolean mineWiwo = wiwo.isMine();
            boolean publicWiwo = wiwo.isPublic();
            String profileURL = wiwo.getProfileURL();
            String imageURL = wiwo.getUserImageURL();
            String time = wiwo.getTime();
            String name = wiwo.getName();
            String message = wiwo.getMessage();
            String complete = wiwo.getPercentComplete();
            String[] topTerms = wiwo.getTopTerms();
            char[] chars = message.toCharArray();
            StringBuilder mb = new StringBuilder();
            for (int j = 0; j < chars.length; ++j) {
                char aChar = chars[j];
                if (Character.isHighSurrogate(aChar)) {
                    mb.append("&#x");
                    mb.append(Long.toHexString(message.codePointAt(j)));
                    mb.append(";");
                    ++j;
                    continue;
                }
                mb.append(aChar);
            }
            message = mb.toString();
            String slang = wiwo.getSourceLanguage();
            String tlang = wiwo.getTargetLanguage();
            String d1 = wiwo.getDisciplineGeneral();
            String d2 = wiwo.getDisciplineSpecific();
            String d3 = wiwo.getDisciplineCustom();
            String cat = wiwo.getCATTool();
            String platfrom = wiwo.getPlatform();
            String platfromURL = wiwo.getPlatformURL();
            String wordcount = wiwo.getWordCount();
            String wiwoImageURL = wiwo.getWiwoImageURL();
            ProzWIWOPost[] replies = wiwo.getReplies();
            sb.append("<table bgcolor=\"#f5f5f5\" align=\"center\" cellpadding=\"5\" cellspacing=\"1\" width=\"1000\" style=\"border: 1px outset white; margin-bottom:8px;font-size:14px\">");
            sb.append("<tr><td width=100 align=\"left\" valign=\"top\">");
            sb.append("<a href=\"");
            sb.append(profileURL);
            sb.append("\">");
            sb.append("<img width=\"100\" src=\"");
            if (imageURL.length() > 0) {
                sb.append(imageURL);
            } else {
                sb.append("http://www.proz.com/imgs/wp/default-user-100x100.png");
            }
            sb.append("\" alt=\"...\"></a>");
            sb.append("<div class=\"muted\" style=\"margin-top: 5px;\"><span style=\"display: block; text-align: center;\">");
            sb.append(time);
            sb.append("</span></div>");
            sb.append("</td>");
            sb.append("<td valign=\"top\">");
            sb.append("<div style=\"margin-bottom: 11px; margin-left: 45px;\">");
            if (mineWiwo) {
                sb.append("<strong><span  style=\"color:#B71C1C\">");
            } else {
                sb.append("<strong><span>");
            }
            sb.append(name);
            sb.append("</span></strong>");
            if (publicWiwo) {
                sb.append(" <span class=\"muted\">shared from </span>");
            } else {
                sb.append(" <span class=\"muted\">shared private from </span>");
            }
            if (platfromURL.length() > 0) {
                sb.append("<a href=\"");
                sb.append(platfromURL);
                sb.append("\">");
                sb.append(platfrom);
                sb.append("</a>");
            }
            if (mineWiwo) {
                String wiwoUpdateButtonDHTML = "id=\"update_wiwo_" + wiwoID + "\"";
                String wiwoDeleteButtonDHTML = "id=\"delete_wiwo_" + wiwoID + "\"";
                sb.append("<div align=\"right\" class=\"pull-right\" style=\"margin: 0px 5px 0px 0px; padding: 0;\">");
                sb.append("<button title=\"Edit the comment below and press this button to update.\" ").append(wiwoUpdateButtonDHTML);
                sb.append(">Update</button> ");
                sb.append("<button style=\"color: #B71C1C;\"").append(wiwoDeleteButtonDHTML);
                sb.append(">Delete</button>");
                sb.append("</div>");
            }
            sb.append("</div>");
            String wiwoParaIDHTML = "id=\"para_wiwo_" + wiwoID + "\"";
            if (mineWiwo) {
                sb.append("<p " + wiwoParaIDHTML + " contenteditable=\"true\" class=\"triangle-right left\" style=\"outline: none;\">");
            } else {
                sb.append("<p " + wiwoParaIDHTML + " class=\"triangle-right left\">");
            }
            sb.append(message);
            sb.append("</p>");
            sb.append("<ul class=\"list-inline pull-right\" style=\"margin: 2px 5px 0px 40px;\">");
            if (slang.length() > 0 && tlang.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(slang);
                sb.append(" to ");
                sb.append(tlang);
                sb.append("</li>");
            }
            if (wordcount.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(wordcount);
                sb.append(" ");
                sb.append("words");
                sb.append("</li>");
            }
            if (d1.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(d1);
                sb.append("</li>");
            }
            if (d2.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(d2);
                sb.append("</li>");
            }
            if (d3.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(d3);
                sb.append("</li>");
            }
            if (cat.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(cat);
                sb.append("</li>");
            }
            if (complete.length() > 0) {
                sb.append("<li class=\"muted\" style=\"margin-left: 10px; padding: 0;\">");
                sb.append(complete + "% complete");
                sb.append("</li>");
            }
            sb.append("</ul>");
            if (topTerms != null) {
                sb.append("<div>");
                sb.append("<ul class=\"list-inline pull-left\" style=\"margin: 10px 5px 5px 40px; font-size:18px\">");
                for (int j = 0; j < topTerms.length; ++j) {
                    String tt = topTerms[j];
                    if (tt.length() <= 0) continue;
                    if (j == 0) {
                        sb.append("<li style=\"margin-left: 10px; padding: 0; color: purple\"><b>");
                    } else if (j == 1) {
                        sb.append("<li style=\"margin-left: 10px; padding: 0; color: green\"><b>");
                    } else if (j == 2) {
                        sb.append("<li style=\"margin-left: 10px; padding: 0; color: brown\"><b>");
                    } else if (j == 3) {
                        sb.append("<li style=\"margin-left: 10px; padding: 0; color: blue\"><b>");
                    } else if (j == 4) {
                        sb.append("<li style=\"margin-left: 10px; padding: 0; color: #FF5722\"><b>");
                    }
                    sb.append(tt);
                    sb.append("</b></li>");
                }
                sb.append("</div>");
            }
            if (wiwoImageURL.length() > 0) {
                sb.append("<br>");
                sb.append("<div class=\"pull-left\" style=\"margin-top: 10px; margin-bottom: 10px; margin-left: 45px; width:600px;\">");
                sb.append("<img style=\"max-width:100%; \" src=\"");
                sb.append(wiwoImageURL);
                sb.append("\" alt=\"...\">");
                sb.append("</div>");
            }
            if (replies != null) {
                if (wiwoImageURL.length() > 0) {
                    sb.append("<hr style=\"margin-top: 10px; margin-bottom: 0px; border-style: solid; border-color: #f5f5f5\">");
                } else {
                    sb.append("<hr style=\"margin-top: 20px; margin-bottom: 0px; border-style: solid; border-color: #f5f5f5\">");
                }
                for (int j = 0; j < replies.length; ++j) {
                    ProzWIWOPost reply = replies[j];
                    String profileURLR = reply.getProfileURL();
                    String imageURLR = reply.getUserImageURL();
                    String timeR = reply.getTime();
                    String nameR = reply.getName();
                    String messageR = reply.getMessage();
                    sb.append("<table bgcolor=\"#f5f5f5\" align=\"right\" cellpadding=\"5\" cellspacing=\"1\" style=\"margin-top:0px;font-size:14px;\">");
                    sb.append("<tr>");
                    sb.append("<td valign=\"top\">");
                    sb.append("<div style=\"margin-bottom: 10px;margin-left: 5px;\">");
                    if (mineWiwo) {
                        sb.append("<strong><span  style=\"color:#B71C1C\">");
                    } else {
                        sb.append("<strong><span>");
                    }
                    sb.append(nameR);
                    sb.append("</span></strong>");
                    sb.append(" <span class=\"muted\">replied</span>");
                    sb.append("</div>");
                    sb.append("<p class=\"triangle-right right\">");
                    sb.append(messageR);
                    sb.append("</p>");
                    sb.append("</td>");
                    sb.append("<td width=100 align=\"right\" valign=\"top\">");
                    sb.append("<a href=\"");
                    sb.append(profileURLR);
                    sb.append("\">");
                    sb.append("<img width=\"100\" src=\"");
                    if (imageURLR.length() > 0) {
                        sb.append(imageURLR);
                    } else {
                        sb.append("http://www.proz.com/imgs/wp/default-user-100x100.png");
                    }
                    sb.append("\" alt=\"...\"></a>");
                    sb.append("<div class=\"muted\" style=\"margin-top: 5px;\"><span style=\"display: block; text-align: center;\">");
                    sb.append(timeR);
                    sb.append("</span></div>");
                    sb.append("</td>");
                    sb.append("</tr>");
                    sb.append("</table>");
                }
            }
            sb.append("<div style=\"margin: 40px 0px 0px 40px; float:right; display:block;\">");
            String replyInputIDHTML = "id=\"wiwo_reply_" + wiwoID + "\"";
            String replyButtonIDHTML = "id=\"wiwo_reply_submit_" + wiwoID + "\"";
            sb.append("<input  style=\"font-size:16px;\" size=\"65\" ");
            sb.append(replyInputIDHTML);
            sb.append(" placeholder=\"Reply to ");
            sb.append(name);
            sb.append("\">");
            sb.append(" <button class=\"button\" ");
            sb.append(replyButtonIDHTML);
            sb.append("\">Reply</button>");
            sb.append("</div>");
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("</table>");
        }
        sb.append("<table align=\"center\" cellpadding=\"5\" cellspacing=\"1\" width=\"1000\">");
        sb.append("<tr><td width=100 align=\"right\">");
        if (previousWiwosURL != null) {
            sb.append("<button class=\"button\" id=\"wiwos_previous\">Previous</button>");
        }
        if (nextWiwosURL != null) {
            sb.append("<button class=\"button\" id=\"wiwos_next\">Next</button>");
        }
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        String html = htmlStart + sb.toString() + htmlEnd;
        this.webPane.getBrowser().loadHTML(html);
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createView() {
        this.webPane = new WebPane(new Browser(true));
        this.webPane.getBrowser().getEngine().documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> ov, Document oldValue, Document newValue) {
                if (null != newValue) {
                    ProzWIWOSView.this.setOKAction();
                }
            }
        });
        this.setTitle("ProZ.com - What translators are working on?");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.webPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProzWIWOSView.this.proz.cancelWiwosView();
                        Document doc = ProzWIWOSView.this.webPane.getBrowser().getEngine().getDocument();
                        NodeList els = doc.getElementsByTagName("input");
                        for (int i = 0; i < els.getLength(); ++i) {
                            Element elem = (Element)els.item(i);
                            String s = elem.getAttribute("type");
                            if (s == null || !s.equals("checkbox")) continue;
                            Boolean c = (Boolean)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                            String name = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                            if (!name.equals("do_not_show") || !c.booleanValue()) continue;
                            String v = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                            AppPreferences.prozWiwoAutoPopup = !v.equals("y");
                        }
                    }
                });
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(1080, 800);
        Dimension dlgSize = this.getSize();
        Point loc = this.topui.getLocationOnScreen();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.setVisible(true);
    }

    protected BufferedReader getBufferedReader(URL page, String post) throws IOException {
        String enc;
        URLConnection conn = page.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla 5.0");
        conn.setDoOutput(true);
        if (post != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(post);
            out.close();
        }
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            int response = hconn.getResponseCode();
            boolean bl = redirect = response >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getBufferedReader(page, post);
            }
        }
        if ((enc = conn.getContentEncoding()) == null) {
            enc = "UTF-8";
        }
        InputStream in = conn.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, enc));
        return r;
    }

    private void setOKAction() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Element el;
                EventListener updateWiwoListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        Document doc = ProzWIWOSView.this.webPane.getBrowser().getEngine().getDocument();
                        Element e = (Element)((Object)evt.getTarget());
                        String id = e.getAttribute("id");
                        final String wiwoID = id.substring(id.lastIndexOf(95) + 1);
                        String comment = null;
                        String r = "para_wiwo_" + wiwoID;
                        Element el = doc.getElementById(r);
                        if (el != null) {
                            comment = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('" + r + "').childNodes[0].nodeValue");
                        }
                        if (comment == null || comment.trim().length() == 0) {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Really no reply?", new ButtonType[0]);
                            Optional result = alert.showAndWait();
                            return;
                        }
                        StringBuilder request = new StringBuilder();
                        request.append("{");
                        request.append("\"message\": ");
                        comment = JSONObject.quote(comment);
                        request.append(comment);
                        request.append("}");
                        final String req = request.toString();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                this.this$2.ProzWIWOSView.this.proz.updateWiwoMessageAPI(wiwoID, req);
                            }
                        });
                    }
                };
                EventListener deleteWiwoListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        Document doc = ProzWIWOSView.this.webPane.getBrowser().getEngine().getDocument();
                        Element e = (Element)((Object)evt.getTarget());
                        String id = e.getAttribute("id");
                        final String wiwoID = id.substring(id.lastIndexOf(95) + 1);
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                this.this$2.ProzWIWOSView.this.proz.deleteWIWO(wiwoID);
                            }
                        });
                    }
                };
                EventListener searchListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        String id = "search_field";
                        final String val = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('" + id + "').value");
                        if (val != null && val.length() > 0) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 3 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                @Override
                                public void run() {
                                    this.this$2.ProzWIWOSView.this.proz.showWiwos(null, val);
                                }
                            });
                        }
                    }
                };
                EventListener refreshListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProzWIWOSView.this.proz.showWiwos(null, null);
                            }
                        });
                    }
                };
                EventListener filterListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        String val;
                        Element e = (Element)((Object)evt.getTarget());
                        String id = e.getAttribute("id");
                        AppPreferences.prozWiwoFilter = val = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('" + id + "').value");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProzWIWOSView.this.proz.showWiwos(null, null);
                            }
                        });
                    }
                };
                EventListener nextListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProzWIWOSView.this.proz.showWiwos(ProzWIWOSView.this.proz.getNextWiwosURL(), null);
                            }
                        });
                    }
                };
                EventListener previousListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProzWIWOSView.this.proz.showWiwos(ProzWIWOSView.this.proz.getPreviousWiwosURL(), null);
                            }
                        });
                    }
                };
                EventListener replyListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        Document doc = ProzWIWOSView.this.webPane.getBrowser().getEngine().getDocument();
                        Element e = (Element)((Object)evt.getTarget());
                        String id = e.getAttribute("id");
                        final String wiwoID = id.substring(id.lastIndexOf(95) + 1);
                        String comment = null;
                        String r = "wiwo_reply_" + wiwoID;
                        Element el = doc.getElementById(r);
                        if (el != null) {
                            comment = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('" + r + "').value");
                        }
                        if (comment == null || comment.trim().length() == 0) {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Really no reply?", new ButtonType[0]);
                            Optional result = alert.showAndWait();
                            return;
                        }
                        StringBuilder request = new StringBuilder();
                        request.append("{");
                        request.append("\"message\": ");
                        comment = JSONObject.quote(comment);
                        request.append(comment);
                        request.append("}");
                        final String req = request.toString();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 8 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                this.this$2.ProzWIWOSView.this.proz.replyToWIWOMessage(wiwoID, req);
                            }
                        });
                    }
                };
                EventListener newWiwoListener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        String s;
                        String comment;
                        if (ProzWIWOSView.this.wiwoSent) {
                            return;
                        }
                        String wc = ProzWIWOSView.this.wordCount;
                        String pc = null;
                        String busy = null;
                        boolean visibility = true;
                        boolean withMedia = false;
                        String topTerms = null;
                        Document doc = ProzWIWOSView.this.webPane.getBrowser().getEngine().getDocument();
                        NodeList els = doc.getElementsByTagName("input");
                        for (int i = 0; i < els.getLength(); ++i) {
                            String v;
                            Element elem = (Element)els.item(i);
                            String s2 = elem.getAttribute("type");
                            if (s2 != null && s2.equals("checkbox")) {
                                Boolean v2;
                                String n = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                                if (n.equals("public")) {
                                    v2 = (Boolean)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                                    if (v2.booleanValue()) {
                                        visibility = true;
                                        AppPreferences.prozWiwoPublic = true;
                                        continue;
                                    }
                                    visibility = false;
                                    AppPreferences.prozWiwoPublic = false;
                                    continue;
                                }
                                if (!n.equals("image_include")) continue;
                                v2 = (Boolean)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                                if (v2.booleanValue()) {
                                    withMedia = true;
                                    AppPreferences.prozWiwoImage = true;
                                    continue;
                                }
                                withMedia = false;
                                AppPreferences.prozWiwoImage = false;
                                continue;
                            }
                            if (s2 != null && s2.equals("text")) {
                                v = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                                String n = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                                if (n.equals("fields[comment]")) {
                                    comment = v;
                                    continue;
                                }
                                if (!n.equals("top_terms")) continue;
                                topTerms = v;
                                continue;
                            }
                            if (s2 == null || !s2.equals("range")) continue;
                            v = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                            String id = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].id");
                            if (id.equals("procent_complete")) {
                                pc = v;
                                continue;
                            }
                            if (!id.equals("busy_meter")) continue;
                            busy = v;
                        }
                        comment = (String)ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('comment').value");
                        if (comment.trim().length() == 0) {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Please provide the required information.", new ButtonType[0]);
                            Optional result = alert.showAndWait();
                            return;
                        }
                        StringBuilder request = new StringBuilder();
                        request.append("{");
                        request.append("\"source_language\": ");
                        request.append("\"");
                        request.append(ProzWIWOSView.this.sourceLanguageProz);
                        request.append("\", ");
                        request.append("\"target_language\": ");
                        request.append("\"");
                        request.append(ProzWIWOSView.this.targetLanguageProz);
                        request.append("\", ");
                        request.append("\"public\": ");
                        if (visibility) {
                            request.append("true");
                        } else {
                            request.append("false");
                        }
                        request.append(", ");
                        if (AppPreferences.dbField != null && AppPreferences.dbField.length() > 0) {
                            request.append("\"discipline\": ");
                            s = JSONObject.quote(AppPreferences.dbField);
                            request.append(s);
                            request.append(", ");
                        }
                        if (wc != null && wc.length() > 0) {
                            request.append("\"wordcount\": ");
                            request.append(wc);
                            request.append(", ");
                        }
                        if (pc != null && pc.length() > 0) {
                            request.append("\"percent_complete\": ");
                            request.append(pc);
                            request.append(", ");
                        }
                        if (busy != null && busy.length() > 0) {
                            request.append("\"busy_meter\": ");
                            request.append(busy);
                            request.append(", ");
                        }
                        request.append("\"cat_tool\": ");
                        request.append("\"");
                        request.append("CafeTran Espresso");
                        request.append("\", ");
                        if (topTerms != null && topTerms.length() > 0) {
                            request.append("\"representative_terms\": ");
                            request.append("[");
                            String[] arr = topTerms.split(",");
                            for (int i = 0; i < arr.length; ++i) {
                                String arr1 = arr[i].trim();
                                if (arr1.length() <= 0) continue;
                                String tt = JSONObject.quote(arr1);
                                if (i > 0) {
                                    request.append(",");
                                }
                                request.append(tt);
                                if (i == 4) break;
                            }
                            request.append("], ");
                        }
                        request.append("\"message\": ");
                        comment = JSONObject.quote(comment);
                        request.append(comment);
                        if (!withMedia) {
                            request.append("}");
                        } else {
                            request.append(", ");
                        }
                        s = request.toString();
                        if (withMedia) {
                            FileChooser fileChooser = new FileChooser();
                            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Image files", new String[]{"*.jpg", "*.png", "*.gif"});
                            fileChooser.getExtensionFilters().add((Object)extFilter);
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE IMAGE FILE"));
                            final File file = fileChooser.showOpenDialog(null);
                            if (file != null) {
                                long size = file.length();
                                if (size > 0x200000L) {
                                    Alert alert = new Alert(Alert.AlertType.ERROR, "The maximum file size is 2 MB.", new ButtonType[0]);
                                    Optional result = alert.showAndWait();
                                    return;
                                }
                                ProzWIWOSView.this.wiwoSent = true;
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 9 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        this.this$2.ProzWIWOSView.this.proz.sendWIWOMediaMessage(file, s);
                                    }
                                });
                            }
                        } else {
                            ProzWIWOSView.this.wiwoSent = true;
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 9 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                @Override
                                public void run() {
                                    this.this$2.ProzWIWOSView.this.proz.sendWIWOMessage(s);
                                }
                            });
                        }
                    }
                };
                WebEngine engine = ProzWIWOSView.this.webPane.getBrowser().getEngine();
                Document doc = engine.getDocument();
                Element styleNode = doc.createElement("style");
                Text styleContent = doc.createTextNode(ProzWIWOSView.CSS);
                styleNode.appendChild(styleContent);
                doc.getDocumentElement().getElementsByTagName("head").item(0).appendChild(styleNode);
                if (AppPreferences.prozWiwoFilter.length() > 0) {
                    ProzWIWOSView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('filter_wiwos').value='" + AppPreferences.prozWiwoFilter + "'");
                }
                if ((el = doc.getElementById("filter_wiwos")) != null) {
                    ((EventTarget)((Object)el)).addEventListener("change", filterListener, false);
                }
                NodeList els = doc.getElementsByTagName("button");
                for (int i = 0; i < els.getLength(); ++i) {
                    Element elem = (Element)els.item(i);
                    String s = elem.getAttribute("id");
                    if (s.startsWith("wiwo_reply_submit_")) {
                        ((EventTarget)((Object)elem)).addEventListener("click", replyListener, false);
                        continue;
                    }
                    if (s.equals("wiwo_new")) {
                        ((EventTarget)((Object)elem)).addEventListener("click", newWiwoListener, false);
                        continue;
                    }
                    if (s.equals("wiwos_next")) {
                        ((EventTarget)((Object)elem)).addEventListener("click", nextListener, false);
                        continue;
                    }
                    if (s.equals("wiwos_previous")) {
                        ((EventTarget)((Object)elem)).addEventListener("click", previousListener, false);
                        continue;
                    }
                    if (s.equals("wiwos_refresh")) {
                        ((EventTarget)((Object)elem)).addEventListener("click", refreshListener, false);
                        continue;
                    }
                    if (s.equals("wiwos_search")) {
                        ((EventTarget)((Object)elem)).addEventListener("click", searchListener, false);
                        continue;
                    }
                    if (s.startsWith("update_wiwo")) {
                        ((EventTarget)((Object)elem)).addEventListener("click", updateWiwoListener, false);
                        continue;
                    }
                    if (!s.startsWith("delete_wiwo")) continue;
                    ((EventTarget)((Object)elem)).addEventListener("click", deleteWiwoListener, false);
                }
            }
        });
    }

    private void closeFrame() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

