/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import translator.AppPreferences;
import translator.MainView;
import translator.browser.Browser;
import translator.browser.WebPane;
import translator.json.JSONObject;
import translator.web.Proz;
import translator.web.ProzWIWOMessage;

public class ProzWIWOView
extends JFrame {
    private MainView topui;
    private WebPane webPane;
    private String html;
    private String sourceLang;
    private String targetLang;
    private Map languageCodes;
    private Proz proz;

    public ProzWIWOView(Proz proz, ProzWIWOMessage message) {
        String publicBox;
        this.proz = proz;
        this.languageCodes = proz.getLanguageCodesMap();
        StringBuilder htmlLangs = new StringBuilder();
        Set set = this.languageCodes.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            htmlLangs.append("<option value=\"");
            htmlLangs.append(val);
            htmlLangs.append("\">");
            htmlLangs.append(key);
            htmlLangs.append("</option>");
        }
        StringBuilder htmlGenDisc = new StringBuilder();
        Map gdisc = proz.getGeneralDisciplinesMap();
        Set set3 = gdisc.entrySet();
        for (Map.Entry entry : set3) {
            int key = (Integer)entry.getKey();
            String val = (String)entry.getValue();
            htmlGenDisc.append("<option value=\"");
            htmlGenDisc.append(key);
            htmlGenDisc.append("\">");
            htmlGenDisc.append(val);
            htmlGenDisc.append("</option>");
        }
        StringBuilder htmlSpecDisc = new StringBuilder();
        Map sdisc = proz.getSpecificDisciplinesMap();
        Set set2 = sdisc.entrySet();
        for (Map.Entry entry : set2) {
            int key = (Integer)entry.getKey();
            String val = (String)entry.getValue();
            htmlSpecDisc.append("<option value=\"");
            htmlSpecDisc.append(key);
            htmlSpecDisc.append("\">");
            htmlSpecDisc.append(val);
            htmlSpecDisc.append("</option>");
        }
        StringBuilder htmlTypeOfService = new StringBuilder();
        htmlTypeOfService.append("<option value=\"");
        htmlTypeOfService.append("");
        htmlTypeOfService.append("\">");
        htmlTypeOfService.append("Translation");
        htmlTypeOfService.append("</option>");
        htmlTypeOfService.append("<option value=\"");
        htmlTypeOfService.append("review");
        htmlTypeOfService.append("\">");
        htmlTypeOfService.append("Review");
        htmlTypeOfService.append("</option>");
        if (AppPreferences.prozKudozAskQuestionLevel) {
            publicBox = "<input type=radio name=\"view\" value=\"public\">";
            String privateBox = "<input type=radio name=\"view\" value=\"private\" checked=\"checked\">";
        } else {
            publicBox = "<input type=radio name=\"view\" value=\"public\" checked=\"checked\">";
            String privateBox = "<input type=radio name=\"view\" value=\"private\">";
        }
        String wc = message.getWordCount();
        this.sourceLang = message.getSourceLanguage();
        this.targetLang = message.getTargetLanguage();
        this.html = "<html><head></head><body bgcolor=\"#EEEEEE\"><table align=\"center\" class=\"standard\" id=\"answer_form\" cellpadding=\"5\" cellspacing=\"1\" width=\"98%\"> <tbody><tr> <td width=10% align=\"right\">Message: </td> <td align=\"left\"> <textarea autofocus name=\"fields[comment]\" style=\"width:100%;height:80px;font-size:12pt;\" wrap=\"virtual\" id=\"comment\"></textarea></td></tr>";
        String html2 = " <tr> <td align=\"right\">Number of words</td> <td align=\"left\"><input type=\"text\" name=\"number_of_words\" size=\"10\" maxlength=\"255\" id=\"number_of_words\" value=\"" + wc + "\"></td> </tr><tr><td bgcolor=\"#00BCD4\" align=\"center\" colspan=2> <input type=\"submit\" name=\"send_message\" id=\"send_message\" value=\"Submit message\"> </td> </tr><tr><td align=\"center\"></td><td align=\"right\"><input type=\"checkbox\" name=\"do_not_show\" value=\"y\">Do not show this dialog automatically</td></tr></tbody></table></body></html>";
        this.html = this.html + html2;
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        this.createView();
        this.showAskForm();
    }

    private void showAskForm() {
        this.webPane.getBrowser().loadHTML(this.html);
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createView() {
        this.webPane = new WebPane(new Browser(true));
        this.webPane.getBrowser().getEngine().documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> ov, Document oldValue, Document newValue) {
                if (null != newValue) {
                    ProzWIWOView.this.setOKAction();
                }
            }
        });
        this.setTitle("ProZ.com - What are you working on right now?");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.webPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Document doc = ProzWIWOView.this.webPane.getBrowser().getEngine().getDocument();
                        NodeList els = doc.getElementsByTagName("input");
                        for (int i = 0; i < els.getLength(); ++i) {
                            Element elem = (Element)els.item(i);
                            String s = elem.getAttribute("type");
                            if (!s.equals("checkbox")) continue;
                            Boolean c = (Boolean)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                            String name = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                            if (!name.equals("do_not_show") || !c.booleanValue()) continue;
                            String v = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                            AppPreferences.prozWiwoAutoPopup = !v.equals("y");
                        }
                    }
                });
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(850, 310);
        Dimension dlgSize = this.getSize();
        Point loc = this.topui.getLocationOnScreen();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.setVisible(true);
    }

    protected BufferedReader getBufferedReader(URL page, String post) throws IOException {
        String enc;
        URLConnection conn = page.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla 5.0");
        conn.setDoOutput(true);
        if (post != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(post);
            out.close();
        }
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            int response = hconn.getResponseCode();
            boolean bl = redirect = response >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getBufferedReader(page, post);
            }
        }
        if ((enc = conn.getContentEncoding()) == null) {
            enc = "UTF-8";
        }
        InputStream in = conn.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, enc));
        return r;
    }

    private void setOKAction() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EventListener listener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        String s;
                        Object comment;
                        Object wc = null;
                        boolean visibility = true;
                        Document doc = ProzWIWOView.this.webPane.getBrowser().getEngine().getDocument();
                        NodeList els = doc.getElementsByTagName("select");
                        els = doc.getElementsByTagName("input");
                        for (int i = 0; i < els.getLength(); ++i) {
                            String n;
                            Object v;
                            Element elem = (Element)els.item(i);
                            String s2 = elem.getAttribute("type");
                            if (s2.equals("radio")) {
                                v = (Boolean)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                                if (!((Boolean)v).booleanValue()) continue;
                                n = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                                if (n.equals("public")) {
                                    visibility = true;
                                    continue;
                                }
                                visibility = false;
                                continue;
                            }
                            if (s2.equals("text")) {
                                v = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                                n = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                                if (n.equals("fields[comment]")) {
                                    comment = v;
                                    continue;
                                }
                                if (!n.equals("number_of_words")) continue;
                                wc = v;
                                continue;
                            }
                            if (!s2.equals("checkbox")) continue;
                            Boolean c = (Boolean)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                            String name = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                            if (!name.equals("do_not_show") || !c.booleanValue()) continue;
                            String v2 = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                            AppPreferences.prozWiwoAutoPopup = !v2.equals("y");
                        }
                        comment = (String)ProzWIWOView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('comment').value");
                        if (((String)comment).trim().length() == 0) {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Please provide the required information.", new ButtonType[0]);
                            Optional result = alert.showAndWait();
                            return;
                        }
                        StringBuilder request = new StringBuilder();
                        request.append("{");
                        request.append("\"source_language\": ");
                        request.append("\"");
                        request.append(AppPreferences.prozKudozAskQuestionSourceLanguage);
                        request.append("\", ");
                        request.append("\"target_language\": ");
                        request.append("\"");
                        request.append(AppPreferences.prozKudozAskQuestionTargetLanguage);
                        request.append("\", ");
                        request.append("\"public\": ");
                        request.append("false");
                        request.append(", ");
                        if (AppPreferences.dbField != null && AppPreferences.dbField.length() > 0) {
                            request.append("\"discipline\": ");
                            s = JSONObject.quote(AppPreferences.dbField);
                            request.append(s);
                            request.append(", ");
                        }
                        if (wc != null && ((String)wc).length() > 0) {
                            request.append("\"wordcount\": ");
                            request.append((String)wc);
                            request.append(", ");
                        }
                        request.append("\"cat_tool\": ");
                        request.append("\"");
                        request.append("CafeTran Espresso");
                        request.append("\", ");
                        request.append("\"message\": ");
                        comment = JSONObject.quote((String)comment);
                        request.append((String)comment);
                        request.append("}");
                        s = request.toString();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                this.this$2.ProzWIWOView.this.proz.sendWIWOMessage(s);
                                this.this$2.ProzWIWOView.this.closeFrame();
                            }
                        });
                    }
                };
                Document doc = ProzWIWOView.this.webPane.getBrowser().getEngine().getDocument();
                Element el2 = doc.getElementById("send_message");
                ((EventTarget)((Object)el2)).addEventListener("click", listener, false);
                String sl = (String)ProzWIWOView.this.languageCodes.get(ProzWIWOView.this.sourceLang);
                if (sl == null) {
                    sl = "";
                }
                AppPreferences.prozKudozAskQuestionSourceLanguage = sl;
                String tl = (String)ProzWIWOView.this.languageCodes.get(ProzWIWOView.this.targetLang);
                if (tl == null) {
                    tl = "";
                }
                AppPreferences.prozKudozAskQuestionTargetLanguage = tl;
            }
        });
    }

    private void closeFrame() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

