/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.GlossaryResource;
import translator.LanguageCodes;
import translator.MainView;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.TabView;
import translator.TargetView;
import translator.XMLElementEditor;
import translator.XMLHelper;
import translator.html.CTHTMLEditorKit;
import translator.json.JSONArray;
import translator.json.JSONException;
import translator.json.JSONObject;
import translator.tmx.Memory;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.HTMLFormat;
import translator.ui.UITools;
import translator.web.CafeTranDocument;
import translator.web.CafeTranDocumentsView;
import translator.web.TMTownDocument;
import translator.web.TMTownDocumentsView;

public class TMTown
extends DefaultResource {
    private MainView topui;
    private TabView tview;
    private JPopupMenu pop;
    private GridPanel mainPanel;
    private TMTownDocumentsView documentView;
    private CafeTranDocumentsView localDocumentsView;
    public static boolean TMTownLinking = false;
    private String clientID = "c3f538fb569c6774d76be3e873d80abadd0e706cd4967d6dd8205468f3a8d06f";
    private String clientSecret = "86cda5dcd1b43d378b4fd2da29355cb724e351c56b0456bff482a0fb40a16fda";
    public static String redirectURL = "https://www.cafetran.com/oauth2";
    public static String authorizationRequest = "https://www.tm-town.com/oauth/authorize?redirect_uri=https%3A%2F%2Fwww.cafetran.com%2Foauth2&client_id=c3f538fb569c6774d76be3e873d80abadd0e706cd4967d6dd8205468f3a8d06f&response_type=code&scope=write+public+read_tms+read_terms+read_documents";
    private String signInRequest = "https://www.tm-town.com/translators/sign_in/";
    private String registerRequest = "https://www.tm-town.com/translators/sign_up/";
    private String tokenURL = "https://www.tm-town.com/oauth/token";
    public static String accountURL = "https://www.tm-town.com/wiwos";
    public static String addSegmentURL = "https://www.tm-town.com/api/translation-units";
    private String key = "0e8dbf666cd37267cdb9c11549370d87";
    private String info = "";
    private String sourceLangCodeElement;
    private String targetLangCodeElement;
    private String sourceLangCodeElementMatch;
    private String targetLangCodeElementMatch;
    private String publicTermsURL = "https://www.tm-town.com/api/terms?";
    private String userURL = "https://www.tm-town.com/api/user?";
    private String userTermsURL = "https://www.tm-town.com/api/user-terms?";
    private String userSegmentsURL = "https://www.tm-town.com/api/user-segments?";
    String documentsURL = "https://www.tm-town.com/api/documents";
    private boolean matchLangage = true;
    private JTextPane mtHTMLPane;
    private boolean running;
    private String resourceName;
    private boolean canLook = true;
    private String searchUserTerms = "search_user_terms";
    private String searchUserSegments = "search_user_segments";
    private String userDetails = "user_details";
    private String uploadWork = "upload_work";
    private String userDocuments = "user_documents";
    private String sourceLanguage = "";
    private String targetLanguage = "";
    private String sourceLanguageCode = "";
    private String targetLanguageCode = "";
    private String writeTMName = null;
    private String writeTMToken = null;
    private String writeTMUnitsCount = null;
    private String writeUserUnitsCount = null;
    private HashMap codeLanguageMap;
    StringBuilder userHTML = null;
    ActionListener timerAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TMTown.this.canLook = true;
        }
    };

    public TMTown() {
        this.documentView = new TMTownDocumentsView(this);
        this.localDocumentsView = new CafeTranDocumentsView(this);
        this.codeLanguageMap = new HashMap();
        String[] codes = LanguageCodes.getCodes();
        String[] names = LanguageCodes.getNames();
        for (int i = 0; i < codes.length; ++i) {
            int k;
            String code = codes[i];
            String name = names[i];
            int j = name.indexOf(" (");
            if (j != -1 && (k = (name = name.substring(0, j)).indexOf(45)) != -1) {
                name = name.substring(0, k - 1);
            }
            this.codeLanguageMap.put(code, name);
        }
        this.setLanguageCodesPair(AppPreferences.fileSLang, AppPreferences.fileTLang);
        this.resourceName = "TM-Town";
    }

    public void showLoginFrame() {
        if (AppPreferences.tmTownToken == null) {
            TMTownLinking = true;
            String name = "TM-Town - Authorization";
            this.topui.getResourceLoader().prepareWebResource(authorizationRequest, name, false, true, -1);
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JTextComponent getResourcePane() {
        return this.mtHTMLPane;
    }

    public TMTownDocumentsView getTMTownDocumentsView() {
        return this.documentView;
    }

    public void addDocumentView() {
        Container parent = this.documentView.getParent();
        if (!(parent instanceof JTabbedPane)) {
            if (parent != null && parent == this.mainPanel) {
                return;
            }
            this.mainPanel.add(this.documentView);
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }
    }

    public void addLocalDocumentView() {
        Container parent = this.localDocumentsView.getParent();
        if (parent != null && parent == this.mainPanel) {
            return;
        }
        this.mainPanel.add(this.localDocumentsView);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    public void removeView() {
        int count = this.mainPanel.getComponentCount();
        if (count > 1) {
            this.mainPanel.remove(1);
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }
    }

    public void connectToService() {
        if (AppPreferences.tmTownToken != null) {
            this.getTMTownDocuments();
        } else {
            this.showLinkInMessage();
        }
    }

    public void exchangeAuthorizationForToken(String urlString) {
        int i = urlString.indexOf(61);
        if (i != -1) {
            String code = urlString.substring(i + 1);
            String cSecret = "client_secret=" + this.clientSecret;
            String cID = "client_id=" + this.clientID;
            String grantType = "grant_type=authorization_code";
            String redirURI = "redirect_uri=https%3A%2F%2Fwww.cafetran.com%2Foauth2";
            String authcode = "code=" + code;
            String request = cSecret + "&" + grantType + "&" + redirURI + "&" + authcode + "&" + cID;
            try {
                String eline;
                URL url = new URL(this.tokenURL);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
                out.write(request);
                out.close();
                InputStream ins = conn.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
                StringBuilder sb = new StringBuilder();
                while ((eline = in.readLine()) != null) {
                    sb.append(eline);
                }
                JSONObject jobject = new JSONObject(sb.toString());
                AppPreferences.tmTownToken = jobject.getString("access_token");
                AppPreferences.tmTownRefreshToken = jobject.getString("refresh_token");
            }
            catch (IOException ex) {
                Logger.getLogger(TMTown.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (JSONException ex) {
                Logger.getLogger(TMTown.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (AppPreferences.tmTownToken != null) {
                if (this.topui.getDashboardView() != null) {
                    this.getUser(true);
                } else {
                    this.getUser(false);
                }
            }
        }
    }

    private void resetActiveTM() {
        this.writeTMName = null;
        this.writeTMToken = null;
        this.writeTMUnitsCount = null;
        this.writeUserUnitsCount = null;
    }

    public void addSegmentToWebService(final String source, final String target) {
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Adding a new segment...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TMTown this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                String name = this.this$0.writeTMName;
                String token = this.this$0.writeTMToken;
                if (name == null) {
                    List list = TMTownDocumentsView.getDocuments();
                    for (TMTownDocument next : list) {
                        int t = next.getType();
                        if (t != 1 || !next.getAdd()) continue;
                        name = next.getName();
                        token = next.getToken();
                        this.this$0.writeTMName = name;
                        this.this$0.writeTMToken = token;
                        break;
                    }
                }
                if (name != null && token != null) {
                    this.this$0.addSegment(source, target, name, token);
                }
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
            }
        };
        worker.execute();
    }

    public void addSegment(String source, String target, String name, String token) {
        try {
            source = URLEncoder.encode(source, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        try {
            target = URLEncoder.encode(target, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        try {
            name = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        String accessToken = "access_token=" + AppPreferences.tmTownToken;
        String tmName = "name=" + name;
        String tmToken = "token=" + token;
        String sourceText = "source_text=" + source;
        String sourceLang = "source_language=" + this.sourceLanguageCode;
        String targetText = "target_text=" + target;
        String targetLang = "target_language=" + this.targetLanguageCode;
        String request = accessToken + "&" + tmName + "&" + tmToken + "&" + sourceText + "&" + sourceLang + "&" + targetText + "&" + targetLang;
        try {
            String eline;
            URL url = new URL(addSegmentURL);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(request);
            out.close();
            InputStream ins = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null) {
                sb.append(eline);
            }
            JSONObject jobject = new JSONObject(sb.toString());
            JSONObject jobject2 = jobject.getJSONObject("message");
            int count = jobject2.getInt("translation_units");
            this.writeTMUnitsCount = Integer.toString(count);
            count = jobject2.getInt("user_translation_units_count");
            this.writeUserUnitsCount = Integer.toString(count);
        }
        catch (IOException ex) {
            Logger.getLogger(TMTown.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JSONException ex) {
            Logger.getLogger(TMTown.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void refreshToken() {
        AppPreferences.tmTownToken = null;
        String cSecret = "client_secret=" + this.clientSecret;
        String cID = "client_id=" + this.clientID;
        String grantType = "grant_type=refresh_token";
        String refreshTok = "refresh_token=" + AppPreferences.tmTownRefreshToken;
        String request = cSecret + "&" + grantType + "&" + refreshTok + "&" + cID;
        try {
            String eline;
            URL url = new URL(this.tokenURL);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(request);
            out.close();
            InputStream ins = conn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null) {
                sb.append(eline);
            }
            JSONObject jobject = new JSONObject(sb.toString());
            AppPreferences.tmTownToken = jobject.getString("access_token");
            AppPreferences.tmTownRefreshToken = jobject.getString("refresh_token");
        }
        catch (IOException ex) {
            Logger.getLogger(TMTown.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JSONException ex) {
            Logger.getLogger(TMTown.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (AppPreferences.tmTownToken != null) {
            this.getTMTownDocuments();
        } else {
            this.showLinkInMessage();
            this.showLoginFrame();
        }
    }

    public void setAPIKey(String k) {
        this.key = k;
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.setPopup();
        this.createMTTab();
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JCheckBoxMenuItem checkItemS = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE LANGUAGE SPECIFIED"));
        checkItemS.setSelected(AppPreferences.tmTownSourceLangSpecified);
        checkItemS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.tmTownSourceLangSpecified = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem checkItemT = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET LANGUAGE SPECIFIED"));
        checkItemT.setSelected(AppPreferences.tmTownTargetLangSpecified);
        checkItemT.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.tmTownTargetLangSpecified = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem checkItemM = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EITHER SOURCE OR TARGET MATCH A SPECIFIC LANGUAGE"));
        checkItemM.setSelected(this.matchLangage);
        checkItemM.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TMTown.this.matchLangage = true;
                } else {
                    TMTown.this.matchLangage = false;
                }
            }
        });
        JRadioButtonMenuItem defaultSearchSegments = new JRadioButtonMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEARCH SEGMENTS BY DEFAULT"));
        if (AppPreferences.tmTownDefaultSearch == 1) {
            defaultSearchSegments.setSelected(true);
        }
        defaultSearchSegments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.tmTownDefaultSearch = 1;
                }
            }
        });
        JRadioButtonMenuItem defaultSearchTerms = new JRadioButtonMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEARCH TERMS BY DEFAULT"));
        if (AppPreferences.tmTownDefaultSearch == 2) {
            defaultSearchTerms.setSelected(true);
        }
        defaultSearchTerms.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.tmTownDefaultSearch = 2;
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(defaultSearchSegments);
        group.add(defaultSearchTerms);
        JCheckBoxMenuItem exactMatchItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXACT MATCHING"));
        exactMatchItem.setSelected(AppPreferences.tmTownExactMatching);
        exactMatchItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.tmTownExactMatching = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem autoSearchItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC SEARCH"));
        autoSearchItem.setSelected(AppPreferences.tmTownAutoSearch);
        autoSearchItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.tmTownAutoSearch = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem addSegmentsItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SEGMENTS"));
        addSegmentsItem.setSelected(AppPreferences.tmTownAddSegments);
        addSegmentsItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.tmTownAddSegments = e.getStateChange() == 1;
            }
        });
        JCheckBoxMenuItem termInfoItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW TERM INFORMATION"));
        termInfoItem.setSelected(AppPreferences.tmTownTermInfoDisplay);
        termInfoItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.tmTownTermInfoDisplay = e.getStateChange() == 1;
            }
        });
        this.pop.add(checkItemS);
        this.pop.add(checkItemT);
        this.pop.add(checkItemM);
        this.pop.addSeparator();
        this.pop.add(defaultSearchSegments);
        this.pop.add(defaultSearchTerms);
        this.pop.addSeparator();
        this.pop.add(exactMatchItem);
        this.pop.add(autoSearchItem);
        this.pop.add(addSegmentsItem);
        this.pop.add(termInfoItem);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    public void setLanguageCodesPair(String sourceLangCode, String targetLangCode) {
        if (sourceLangCode != null && targetLangCode != null) {
            int i;
            String source = LanguageCodes.getName(sourceLangCode);
            String target = LanguageCodes.getName(targetLangCode);
            if (source == null) {
                source = sourceLangCode;
            }
            if (target == null) {
                target = targetLangCode;
            }
            if ((i = source.lastIndexOf(40)) != -1) {
                source = source.substring(0, i - 1);
            }
            if ((i = target.lastIndexOf(40)) != -1) {
                target = target.substring(0, i - 1);
            }
            if ((i = source.lastIndexOf(" - ")) != -1) {
                source = source.substring(0, i);
            }
            if ((i = target.lastIndexOf(" - ")) != -1) {
                target = target.substring(0, i);
            }
            int sdash = sourceLangCode.indexOf("-");
            int tdash = targetLangCode.indexOf("-");
            if (sdash != -1) {
                sourceLangCode = sourceLangCode.substring(0, sdash);
            }
            if (tdash != -1) {
                targetLangCode = targetLangCode.substring(0, tdash);
            }
            this.sourceLangCodeElement = "&source_language=" + sourceLangCode;
            this.targetLangCodeElement = "&target_language=" + targetLangCode;
            this.sourceLangCodeElementMatch = "&match_language=" + sourceLangCode;
            this.targetLangCodeElementMatch = "&match_language=" + targetLangCode;
            this.sourceLanguageCode = sourceLangCode;
            this.targetLanguageCode = targetLangCode;
            this.sourceLanguage = source;
            this.targetLanguage = target;
        }
    }

    private void showWriteMemory() {
        if (this.writeTMUnitsCount == null || this.writeUserUnitsCount == null) {
            return;
        }
        this.removeView();
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.styles);
        html.append("<body>");
        html.append(this.getHTMLTooBar(0));
        html.append("<br>");
        html.append("<table align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=2><tr>");
        html.append("<th style=\"color:white; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0D47A1\">");
        html.append("Document Translation Units");
        html.append("</th>");
        html.append("<th style=\"color:white; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0D47A1\">");
        html.append("User Translation Units");
        html.append("</th>");
        html.append("</tr>");
        html.append("<tr>");
        html.append("<td>");
        html.append("<p \"style=font-size:").append(AppPreferences.UIFontSizeHTML).append("\">").append(this.writeTMUnitsCount).append("</p>");
        html.append("</td>");
        html.append("<td>");
        html.append("<p \"style=font-size:").append(AppPreferences.UIFontSizeHTML).append("\">").append(this.writeUserUnitsCount).append("</p>");
        html.append("</td>");
        html.append("</tr>");
        html.append("</table>");
        html.append("</body></html>");
        String r = html.toString();
        this.showMessage(r);
    }

    private void addHTMLNoResultsFoundMessage(StringBuilder html) {
        html.append("<table align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=5><tr>");
        if (AppPreferences.tmTownSourceLangSpecified) {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        } else {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        }
        html.append(this.sourceLanguage);
        html.append(" (" + this.sourceLanguageCode + ")");
        html.append("</th>");
        if (AppPreferences.tmTownTargetLangSpecified) {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        } else {
            html.append("<th style=\"color:#FFFFFF; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#0074CC\">");
        }
        html.append(this.targetLanguage);
        html.append(" (" + this.targetLanguageCode + ")");
        html.append("</th>");
        html.append("</tr>");
        html.append("<tr>");
        html.append("<td nowrap colspan=\"2\">");
        html.append("<p \"style=font-size:").append(AppPreferences.UIFontSizeHTML).append("\">No results have been found.</p>");
        html.append("</td>");
        html.append("</tr>");
        html.append("</table>");
    }

    private String getHTMLTooBar(int context) {
        String webButtonStyle = "\"style=color:#FFFFFF;font-size:" + Integer.toString(AppPreferences.fontsize) + "\"";
        String button = "<td style=\"color:#FFFFFF; background-color:" + Colors.colorProZ + ";border-style:solid;border-width: 0px;\" align=center>";
        StringBuilder sb = new StringBuilder();
        sb.append("<table width=100% align=center CELLSPACING=2 CELLPADDING=8 style=\"margin:0px 0px 0px 0px;\"><tr>");
        if (context == 5) {
            sb.append(button);
            sb.append("<a href=\"" + this.userDocuments + "\" " + webButtonStyle + "><u>Documents</u>");
        } else {
            sb.append(button);
            sb.append("<a href=\"" + this.userDocuments + "\" " + webButtonStyle + ">Documents");
        }
        sb.append("</td>");
        if (context == 7) {
            sb.append(button);
            sb.append("<a href=\"" + this.uploadWork + "\" " + webButtonStyle + "><u>Upload document</u>");
        } else {
            sb.append(button);
            sb.append("<a href=\"" + this.uploadWork + "\" " + webButtonStyle + ">Upload document");
        }
        sb.append("</td>");
        if (context == 3) {
            sb.append(button);
            sb.append("<a href=\"" + this.searchUserSegments + "\" " + webButtonStyle + "><u>Search segments</u>");
        } else {
            sb.append(button);
            sb.append("<a href=\"" + this.searchUserSegments + "\" " + webButtonStyle + ">Search segments");
        }
        sb.append("</td>");
        if (context == 4) {
            sb.append(button);
            sb.append("<a href=\"" + this.searchUserTerms + "\" " + webButtonStyle + "><u>Search terms</u>");
        } else {
            sb.append(button);
            sb.append("<a href=\"" + this.searchUserTerms + "\" " + webButtonStyle + ">Search terms");
        }
        sb.append("</td>");
        if (context == 1) {
            sb.append(button);
            sb.append("<a href=\"" + this.userDetails + "\" " + webButtonStyle + "><u>Your TM-Town details</u>");
        } else {
            sb.append(button);
            sb.append("<a href=\"" + this.userDetails + "\" " + webButtonStyle + ">Your TM-Town details");
        }
        sb.append("</td>");
        sb.append(button);
        sb.append("<a href=\"" + this.signInRequest + "\" " + webButtonStyle + ">Your TM-Town account");
        sb.append("</td>");
        sb.append("</tr>");
        if (this.writeTMName != null) {
            sb.append("<tr>");
            sb.append(button);
            sb.append("<a href=\"writeTM\" " + webButtonStyle + ">" + this.writeTMName + "</p>");
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table><br>");
        return sb.toString();
    }

    public void showLinkInMessage() {
        this.removeView();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.styles);
        sb.append("<body>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<table align=center WIDTH=33% CELLSPACING=8 CELLPADDING=2 style=\"color:white; background-color:3A3A3A; border-style:ridge; border-width: 1px;\"><tr>");
        sb.append("<th>");
        sb.append("<a href=\"").append(authorizationRequest).append("\" \"style=color:white;font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><u>Link CafeTran to your TM-Town account</u>");
        sb.append("</th>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</body></html>");
        this.info = sb.toString();
        this.showMessage(this.info);
    }

    public void translate(String source) {
        this.search(source, null);
    }

    public void getUser(final boolean showMessageDialog) {
        if (!this.canLook) {
            return;
        }
        this.removeView();
        this.showMessage("<body></body>");
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Connecting to TM-Town...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TMTown this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.showUser(showMessageDialog);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                if (showMessageDialog && this.this$0.userHTML != null) {
                    JOptionPane.showMessageDialog(this.this$0.topui, this.this$0.userHTML.toString());
                }
            }
        };
        worker.execute();
    }

    public void getTMTownDocuments() {
        if (!this.canLook) {
            return;
        }
        this.showMessage("<body></body>");
        this.removeView();
        this.resetActiveTM();
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Connecting to TM-Town...");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TMTown this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.userDocuments();
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                this.this$0.addDocumentView();
            }
        };
        worker.execute();
    }

    public void getCafeTranDocuments() {
        if (!this.canLook) {
            return;
        }
        this.showMessage("<body></body>");
        this.removeView();
        this.resetActiveTM();
        SwingWorker worker = new SwingWorker(){

            public String doInBackground() {
                TMTown.this.localDocuments();
                return null;
            }

            @Override
            protected void done() {
                TMTown.this.addLocalDocumentView();
            }
        };
        worker.execute();
    }

    private String getTMTokens() {
        StringBuilder sb = new StringBuilder();
        TMTown tMTown = this;
        List docs = tMTown.documentView.getDocuments();
        boolean first = true;
        for (TMTownDocument doc : docs) {
            String type = doc.getFileType();
            if (!type.equals("Translation Memory") || !doc.getSearch()) continue;
            if (!first) {
                sb.append(',');
            }
            sb.append(doc.getToken());
            first = false;
        }
        return sb.toString();
    }

    private String getTerminologyTokens() {
        StringBuilder sb = new StringBuilder();
        TMTown tMTown = this;
        List docs = tMTown.documentView.getDocuments();
        boolean first = true;
        for (TMTownDocument doc : docs) {
            String type = doc.getFileType();
            if (!type.equals("Terminology") || !doc.getSearch()) continue;
            if (!first) {
                sb.append(',');
            }
            sb.append(doc.getToken());
            first = false;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userDocuments() {
        this.canLook = false;
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.styles);
        html.append("<body>");
        html.append(this.getHTMLTooBar(5));
        BufferedReader in = null;
        try {
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.documentsURL).append('?');
            sq.append("access_token=");
            sq.append(AppPreferences.tmTownToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                if (AppPreferences.tmTownRefreshToken != null) {
                    this.refreshToken();
                    StringBuilder sb = new StringBuilder();
                    sb.append("TM-Town.com connection error: " + responseCode);
                    this.showErrorMessage(sb.toString());
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            TMTown tMTown = this;
            List documents = tMTown.documentView.getDocuments();
            documents.clear();
            JSONArray nameArray = new JSONArray(sb.toString());
            boolean found = false;
            for (int i = 0; i < nameArray.length(); ++i) {
                int count;
                long size;
                TMTownDocument doc = new TMTownDocument();
                JSONObject jo = nameArray.getJSONObject(i);
                String p = jo.getString("name");
                if (p != null) {
                    doc.setName(p);
                }
                if ((p = jo.getString("file_type")) != null) {
                    doc.setFileType(p);
                }
                if ((p = jo.getString("token")) != null) {
                    doc.setToken(p);
                }
                if ((size = jo.getLong("size")) != -1L) {
                    String dsize = TMTown.readableFileSize(size);
                    doc.setSize(dsize);
                }
                if (jo.has("tu_count")) {
                    int count2 = jo.getInt("tu_count");
                    doc.setTUCount(Integer.toString(count2));
                } else if (jo.has("term_count") && (count = jo.getInt("term_count")) != -1) {
                    doc.setTUCount(Integer.toString(count));
                }
                if (jo.has("word_count")) {
                    count = jo.getInt("word_count");
                    int type = doc.getType();
                    if (type == 3 || type == 4) {
                        doc.setWords(Integer.toString(count));
                    }
                }
                JSONArray arr = jo.getJSONArray("fields_of_expertise");
                StringBuilder b = new StringBuilder();
                for (int j = 0; j < arr.length(); ++j) {
                    if (j > 0) {
                        b.append(", ");
                    }
                    b.append(arr.getString(j));
                }
                doc.setFieldsOfExpertise(b.toString());
                doc.setSearch(true);
                documents.add(doc);
                found = true;
            }
            if (!found) {
                this.addHTMLNoResultsFoundMessage(html);
            }
            html.append("</body></html>");
            String r = html.toString();
            this.showMessage(r);
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("TM-Town web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        catch (JSONException er) {
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    private void localDocuments() {
        String name;
        CafeTranDocument doc;
        File rfile;
        String path;
        int k;
        List documents = CafeTranDocumentsView.getDocuments();
        documents.clear();
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.styles);
        html.append("<body>");
        html.append(this.getHTMLTooBar(7));
        boolean found = false;
        List slist = this.topui.getMemoryView().getLocalMemories();
        for (k = 0; k < slist.size(); ++k) {
            Memory m = (Memory)slist.get(k);
            path = m.getPath();
            if (path == null || path.length() <= 0 || !(rfile = new File(path)).exists()) continue;
            doc = new CafeTranDocument();
            name = rfile.getName();
            doc.setName(name);
            doc.setPath(path);
            doc.setType("Translation Memory");
            documents.add(doc);
            found = true;
        }
        slist = this.topui.getResourceView().getGlossaries();
        if (slist != null) {
            for (k = 0; k < slist.size(); ++k) {
                GlossaryResource glossary = (GlossaryResource)slist.get(k);
                path = glossary.getResourcePath();
                if (path == null || path.length() <= 0 || !(rfile = new File(path)).exists()) continue;
                doc = new CafeTranDocument();
                name = rfile.getName();
                doc.setName(name);
                doc.setPath(path);
                doc.setType("Glossary");
                documents.add(doc);
                found = true;
            }
        }
        if (found) {
            this.localDocumentsView.getTable().setRowSelectionInterval(0, 0);
        }
        html.append("</body></html>");
        String r = html.toString();
        this.showMessage(r);
    }

    public void searchUserTerms(String term) {
        if (!this.canLook) {
            return;
        }
        this.showMessage("<body></body>");
        if (term == null) {
            term = this.getRequestedTerm();
        }
        final String myTerm = term = term.replaceAll("\\s+", " ");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TMTown this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.userTerms(myTerm);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.removeView();
            }
        };
        worker.execute();
    }

    public void searchUserSegments(String term) {
        if (!this.canLook) {
            return;
        }
        this.showMessage("<body></body>");
        if (term == null) {
            term = this.getRequestedTerm();
        }
        final String myTerm = term = term.replaceAll("\\s+", " ");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TMTown this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.userSegments(myTerm);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.removeView();
            }
        };
        worker.execute();
    }

    private String getRequestedTerm() {
        JTextPane pane = this.topui.getSourcePane();
        String query = pane.getSelectedText();
        if (query == null) {
            query = this.topui.getResourceView().getLookUpText();
        }
        query = query != null && query.length() > 0 ? XMLHelper.parseTags(query) : "";
        return query;
    }

    @Override
    public void search(String term, String rep) {
        if (AppPreferences.tmTownToken != null) {
            if (AppPreferences.tmTownDefaultSearch == 1) {
                this.searchUserSegments(term);
            } else if (AppPreferences.tmTownDefaultSearch == 2) {
                this.searchUserTerms(term);
            }
        } else {
            this.showLinkInMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userSegments(String request) {
        String tokens = this.getTMTokens();
        if (tokens.length() == 0) {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append(HTMLFormat.styles);
            html.append("<body>");
            html.append(this.getHTMLTooBar(3));
            this.addHTMLNoResultsFoundMessage(html);
            html.append("</body></html>");
            String r = html.toString();
            this.showMessage(r);
            return;
        }
        String query = request;
        try {
            request = URLEncoder.encode(request, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        this.canLook = false;
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.styles);
        html.append("<body>");
        html.append(this.getHTMLTooBar(3));
        html.append("<table WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=2>");
        BufferedReader in = null;
        try {
            String eline;
            URL url;
            HttpURLConnection conn;
            int responseCode;
            StringBuilder sq = new StringBuilder();
            sq.append(this.userSegmentsURL);
            sq.append("access_token=");
            sq.append(AppPreferences.tmTownToken);
            sq.append("&query=");
            sq.append(request);
            sq.append("&tokens=");
            sq.append(tokens);
            if (this.matchLangage) {
                if (AppPreferences.tmTownSourceLangSpecified) {
                    sq.append(this.sourceLangCodeElementMatch);
                } else if (AppPreferences.tmTownTargetLangSpecified) {
                    sq.append(this.targetLangCodeElementMatch);
                }
            } else {
                if (AppPreferences.tmTownSourceLangSpecified) {
                    sq.append(this.sourceLangCodeElement);
                }
                if (AppPreferences.tmTownTargetLangSpecified) {
                    sq.append(this.targetLangCodeElement);
                }
            }
            if (AppPreferences.tmTownExactMatching) {
                sq.append("&exact_match=true");
            }
            if ((responseCode = (conn = (HttpURLConnection)(url = new URL(sq.toString())).openConnection()).getResponseCode()) != 200) {
                if (AppPreferences.tmTownRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            Pattern pattern = Pattern.compile(query, 82);
            JSONArray jarray1 = new JSONArray(sb.toString());
            if (jarray1.length() > 0) {
                html.append("<tr>");
                if (AppPreferences.tmTownTermInfoDisplay) {
                    html.append("<td colspan=3 style=\"color:#FFFFFF; background-color:#0074CC\" align=center>");
                } else {
                    html.append("<td colspan=2 style=\"color:#FFFFFF; background-color:#0074CC\" align=center>");
                }
                html.append("Results: ");
                html.append(jarray1.length());
                html.append("</td>");
                html.append("</tr>");
            }
            boolean colorRow = false;
            boolean found = false;
            for (int i = 0; i < jarray1.length(); ++i) {
                Object o = jarray1.get(i);
                html.append("<tr>");
                colorRow = !colorRow;
                String documentName = null;
                StringBuilder langPair = new StringBuilder();
                StringBuilder contents = new StringBuilder();
                if (o instanceof JSONArray) {
                    JSONArray jarray2 = (JSONArray)o;
                    for (int j = 0; j < jarray2.length(); ++j) {
                        Object o2 = jarray2.get(j);
                        if (!(o2 instanceof JSONObject)) continue;
                        JSONObject jo = (JSONObject)o2;
                        String text = null;
                        Iterator iterator = jo.keys();
                        while (iterator.hasNext()) {
                            String name;
                            Object next = iterator.next();
                            if (!(next instanceof String)) continue;
                            String s = next.toString();
                            if (s.equals("text")) {
                                text = jo.getString(s);
                                continue;
                            }
                            if (s.equals("document_name")) {
                                documentName = jo.getString(s);
                                continue;
                            }
                            if (!s.equals("language")) continue;
                            String lan = jo.getString(s);
                            if (langPair.length() > 0) {
                                langPair.append(" - ");
                            }
                            if ((name = (String)this.codeLanguageMap.get(lan)) != null) {
                                lan = name;
                            }
                            langPair.append(lan);
                        }
                        if (!colorRow) {
                            contents.append(HTMLFormat.defaultRowLeftAlign2);
                        } else {
                            contents.append(HTMLFormat.defaultRowLeftAlign2);
                        }
                        if (text != null) {
                            contents.append("<p>");
                            text = this.highlightMatch(text, pattern);
                            contents.append(text);
                            contents.append("</p>");
                            found = true;
                        }
                        contents.append("</td>");
                    }
                }
                if (AppPreferences.tmTownTermInfoDisplay) {
                    html.append("<td width=25% style=\"color:#FFFFFF; background-color:#0074CC\" align=left valign=top>");
                    if (langPair.length() > 0) {
                        html.append("<p><u>");
                        html.append((CharSequence)langPair);
                        html.append("</u></p>");
                    }
                    if (documentName != null) {
                        html.append("<p>");
                        html.append(documentName);
                        html.append("</p>");
                    }
                    html.append("</td>");
                }
                html.append((CharSequence)contents);
                html.append("</tr>");
            }
            html.append("</table>");
            if (!found) {
                this.addHTMLNoResultsFoundMessage(html);
            }
            html.append("</body></html>");
            String r = html.toString();
            this.showMessage(r);
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("TM-Town web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        catch (JSONException er) {
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userTerms(String request) {
        String tokens = this.getTerminologyTokens();
        if (tokens.length() == 0) {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append(HTMLFormat.styles);
            html.append("<body>");
            html.append(this.getHTMLTooBar(4));
            this.addHTMLNoResultsFoundMessage(html);
            html.append("</body></html>");
            String r = html.toString();
            this.showMessage(r);
            return;
        }
        String query = request;
        try {
            request = URLEncoder.encode(request, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        this.canLook = false;
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.styles);
        html.append("<body>");
        html.append(this.getHTMLTooBar(4));
        html.append("<table WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=2>");
        BufferedReader in = null;
        try {
            String eline;
            URL url;
            HttpURLConnection conn;
            int responseCode;
            StringBuilder sq = new StringBuilder();
            sq.append(this.userTermsURL);
            sq.append("access_token=");
            sq.append(AppPreferences.tmTownToken);
            sq.append("&query=");
            sq.append(request);
            sq.append("&tokens=");
            sq.append(tokens);
            if (this.matchLangage) {
                if (AppPreferences.tmTownSourceLangSpecified) {
                    sq.append(this.sourceLangCodeElementMatch);
                } else if (AppPreferences.tmTownTargetLangSpecified) {
                    sq.append(this.targetLangCodeElementMatch);
                }
            } else {
                if (AppPreferences.tmTownSourceLangSpecified) {
                    sq.append(this.sourceLangCodeElement);
                }
                if (AppPreferences.tmTownTargetLangSpecified) {
                    sq.append(this.targetLangCodeElement);
                }
            }
            if (AppPreferences.tmTownExactMatching) {
                sq.append("&exact_match=true");
            }
            if ((responseCode = (conn = (HttpURLConnection)(url = new URL(sq.toString())).openConnection()).getResponseCode()) != 200) {
                if (AppPreferences.tmTownRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            Pattern pattern = Pattern.compile(query, 82);
            JSONArray jarray1 = new JSONArray(sb.toString());
            boolean colorRow = false;
            boolean found = false;
            if (jarray1.length() > 0) {
                html.append("<tr>");
                if (AppPreferences.tmTownTermInfoDisplay) {
                    html.append("<td colspan=3 style=\"color:#FFFFFF; background-color:#0074CC\" align=center>");
                } else {
                    html.append("<td colspan=2 style=\"color:#FFFFFF; background-color:#0074CC\" align=center>");
                }
                html.append("Results: ");
                html.append(jarray1.length());
                html.append("</td>");
                html.append("</tr>");
            }
            for (int i = 0; i < jarray1.length(); ++i) {
                Object o = jarray1.get(i);
                if (!(o instanceof JSONArray)) continue;
                html.append("<tr>");
                colorRow = !colorRow;
                String documentName = null;
                StringBuilder contents = new StringBuilder();
                StringBuilder langPair = new StringBuilder();
                JSONArray jarray2 = (JSONArray)o;
                for (int j = 0; j < jarray2.length(); ++j) {
                    Object o2 = jarray2.get(j);
                    if (!(o2 instanceof JSONObject)) continue;
                    JSONObject jo = (JSONObject)o2;
                    String term = null;
                    Iterator iterator = jo.keys();
                    while (iterator.hasNext()) {
                        Object next = iterator.next();
                        if (!(next instanceof String)) continue;
                        String s = next.toString();
                        if (s.equals("language")) {
                            String name;
                            String lan = jo.getString(s);
                            if (langPair.length() > 0) {
                                langPair.append(" - ");
                            }
                            if ((name = (String)this.codeLanguageMap.get(lan)) != null) {
                                lan = name;
                            }
                            langPair.append(lan);
                            continue;
                        }
                        if (s.equals("term")) {
                            term = jo.getString(s);
                            continue;
                        }
                        if (!s.equals("document_name")) continue;
                        documentName = jo.getString(s);
                    }
                    if (term == null) continue;
                    if (!colorRow) {
                        contents.append(HTMLFormat.defaultRowLeftAlign2);
                    } else {
                        contents.append(HTMLFormat.defaultRowLeftAlign2);
                    }
                    contents.append("<p>");
                    term = this.highlightMatch(term, pattern);
                    contents.append(term);
                    contents.append("</p>");
                    contents.append("</td>");
                    found = true;
                }
                if (AppPreferences.tmTownTermInfoDisplay) {
                    html.append("<td width=25% style=\"color:#FFFFFF; background-color:#0074CC\" align=left valign=top>");
                    if (langPair.length() > 0) {
                        html.append("<p><u>");
                        html.append(langPair.toString().trim());
                        html.append("</u></p>");
                    }
                    if (documentName != null) {
                        html.append("<p>");
                        html.append(documentName);
                        html.append("</p>");
                    }
                    html.append("</td>");
                }
                html.append((CharSequence)contents);
                html.append("</tr>");
            }
            html.append("</table>");
            if (!found) {
                this.addHTMLNoResultsFoundMessage(html);
            }
            html.append("</body></html>");
            String r = html.toString();
            this.showMessage(r);
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("TM-Town web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        catch (JSONException er) {
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showUser(boolean messageDialog) {
        this.canLook = false;
        this.userHTML = new StringBuilder();
        this.userHTML.append("<html>");
        this.userHTML.append(HTMLFormat.styles);
        this.userHTML.append("<body>");
        if (!messageDialog) {
            this.userHTML.append("<table align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=8>");
        } else {
            this.userHTML.append("<table width=100% align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=4 BGCOLOR=" + HTMLFormat.barBackgroundHitsColor + ">");
        }
        this.userHTML.append("<thead>");
        this.userHTML.append("</thead>");
        BufferedReader in = null;
        try {
            String s;
            Object o;
            String s2;
            String eline;
            StringBuilder sq = new StringBuilder();
            sq.append(this.userURL);
            sq.append("access_token=");
            sq.append(AppPreferences.tmTownToken);
            URL url = new URL(sq.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                if (AppPreferences.tmTownRefreshToken != null) {
                    this.refreshToken();
                } else {
                    this.showLinkInMessage();
                }
                return;
            }
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            StringBuilder sb = new StringBuilder();
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            this.userHTML.append("<tr>");
            this.userHTML.append("<td style=\"color:white; background-color:black\" align=center colspan=2>");
            this.userHTML.append("<a href=\"").append("https://www.tm-town.com").append("\" \"style=color:yellow; font-size:").append(AppPreferences.UIFontSizeHTML).append("\"><b><u>").append("TM-Town.com User").append("</b></u>");
            this.userHTML.append("</td>");
            this.userHTML.append("</tr>");
            JSONObject myjson = new JSONObject(sb.toString());
            String userName = null;
            String name = null;
            String preferredName = null;
            String country = null;
            String gender = null;
            String about = null;
            int tus = -1;
            int termConcepts = -1;
            int karma = -1;
            int rank = -1;
            JSONArray jarray1 = null;
            JSONArray jarray2 = null;
            JSONArray jarray3 = null;
            JSONArray jarray4 = null;
            Iterator iterator = myjson.keys();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof String)) continue;
                s2 = next.toString();
                if (s2.equals("username")) {
                    userName = myjson.getString(s2);
                    continue;
                }
                if (s2.equals("name")) {
                    name = myjson.getString(s2);
                    continue;
                }
                if (s2.equals("preferred_name")) {
                    preferredName = myjson.getString(s2);
                    continue;
                }
                if (s2.equals("country")) {
                    country = myjson.getString(s2);
                    continue;
                }
                if (s2.equals("gender")) {
                    gender = myjson.getString(s2);
                    continue;
                }
                if (s2.equals("about")) {
                    about = myjson.getString(s2);
                    continue;
                }
                if (s2.equals("translation_units")) {
                    tus = myjson.getInt(s2);
                    continue;
                }
                if (s2.equals("term_concepts")) {
                    termConcepts = myjson.getInt(s2);
                    continue;
                }
                if (s2.equals("karma")) {
                    karma = myjson.getInt(s2);
                    continue;
                }
                if (s2.equals("rank")) {
                    rank = myjson.getInt(s2);
                    continue;
                }
                if (s2.equals("fields_of_expertise")) {
                    jarray1 = myjson.getJSONArray(s2);
                    continue;
                }
                if (s2.equals("language_pairs")) {
                    jarray2 = myjson.getJSONArray(s2);
                    continue;
                }
                if (s2.equals("software")) {
                    jarray3 = myjson.getJSONArray(s2);
                    continue;
                }
                if (!s2.equals("term_repositories")) continue;
                jarray4 = myjson.getJSONArray(s2);
            }
            if (userName != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("User name:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(userName);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (name != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Name:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(name);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (preferredName != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Preferred name:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(preferredName);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (country != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Country:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(country);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (gender != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Gender:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(gender);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (jarray1 != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Fields of expertise:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                for (int i = 0; i < jarray1.length(); ++i) {
                    o = jarray1.get(i);
                    s2 = o.toString();
                    this.userHTML.append(s2);
                    this.userHTML.append("<br>");
                }
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (jarray2 != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Language pairs:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                for (int i = 0; i < jarray2.length(); ++i) {
                    JSONArray arr;
                    o = jarray2.get(i);
                    if (!(o instanceof JSONArray) || (arr = (JSONArray)o).length() <= 1) continue;
                    s = arr.getString(0);
                    String s22 = arr.getString(1);
                    this.userHTML.append(s);
                    this.userHTML.append("-");
                    this.userHTML.append(s22);
                    this.userHTML.append("<br>");
                }
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (tus != -1) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Translation units:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(tus);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (termConcepts != -1) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Term concepts:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(termConcepts);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (karma != -1) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Karma:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(karma);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (rank != -1) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Rank:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(rank);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (jarray3 != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("Software:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                for (int i = 0; i < jarray3.length(); ++i) {
                    o = jarray3.get(i);
                    s2 = o.toString();
                    this.userHTML.append(s2);
                    this.userHTML.append("<br>");
                }
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            if (about != null) {
                this.userHTML.append("<tr>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append("<b>");
                this.userHTML.append("About:");
                this.userHTML.append("</b>");
                this.userHTML.append("</td>");
                this.userHTML.append(HTMLFormat.defaultRowLeftAlign2);
                this.userHTML.append(about);
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
            }
            this.userHTML.append("</table>");
            if (jarray4 != null) {
                this.userHTML.append("<table align=center BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=2>");
                this.userHTML.append("<thead>");
                this.userHTML.append("<tr>");
                this.userHTML.append("<td colspan=\"5\" style=\"color:white; font-size:").append(AppPreferences.UIFontSizeHTML).append("; background-color:#B71C1C\" align=center><b>");
                this.userHTML.append("My TM-Town Terminology Repositories");
                this.userHTML.append("</b></td>");
                this.userHTML.append("</tr>");
                this.userHTML.append("</thead>");
                this.userHTML.append("<tr>");
                this.userHTML.append("<td style=\"color:white; background-color:#01579B\">");
                this.userHTML.append("Name");
                this.userHTML.append("</td>");
                this.userHTML.append("<td style=\"color:white; background-color:#01579B\">");
                this.userHTML.append("Term concepts");
                this.userHTML.append("</td>");
                this.userHTML.append("<td style=\"color:white; background-color:#01579B\">");
                this.userHTML.append("Terms");
                this.userHTML.append("</td>");
                this.userHTML.append("<td style=\"color:white; background-color:#01579B\">");
                this.userHTML.append("Downloads");
                this.userHTML.append("</td>");
                this.userHTML.append("<td style=\"color:white; background-color:#01579B\">");
                this.userHTML.append("License type");
                this.userHTML.append("</td>");
                this.userHTML.append("</tr>");
                for (int i = 0; i < jarray4.length(); ++i) {
                    this.userHTML.append("<tr>");
                    o = jarray4.get(i);
                    if (o instanceof JSONObject) {
                        this.userHTML.append("<td style=\"color:black; background-color:#EEEEEE\">");
                        JSONObject jo = (JSONObject)o;
                        s = jo.getString("name");
                        if (s != null) {
                            this.userHTML.append(s);
                        }
                        this.userHTML.append("</td>");
                        this.userHTML.append("<td style=\"color:black; background-color:#EEEEEE\">");
                        jo = (JSONObject)o;
                        int k = jo.getInt("term_concepts");
                        this.userHTML.append(k);
                        this.userHTML.append("</td>");
                        this.userHTML.append("<td style=\"color:black; background-color:#EEEEEE\">");
                        jo = (JSONObject)o;
                        k = jo.getInt("terms");
                        this.userHTML.append(k);
                        this.userHTML.append("</td>");
                        this.userHTML.append("<td style=\"color:black; background-color:#EEEEEE\">");
                        jo = (JSONObject)o;
                        k = jo.getInt("downloads");
                        this.userHTML.append(k);
                        this.userHTML.append("</td>");
                        this.userHTML.append("<td style=\"color:black; background-color:#EEEEEE\">");
                        jo = (JSONObject)o;
                        s = jo.getString("license_type");
                        if (s != null) {
                            this.userHTML.append(s);
                        }
                        this.userHTML.append("</td>");
                    }
                    this.userHTML.append("</tr>");
                }
                this.userHTML.append("</table>");
            }
            this.userHTML.append("</body></html>");
            StringBuilder s3 = new StringBuilder(this.userHTML);
            s3.insert(this.userHTML.indexOf("<body>") + 6, this.getHTMLTooBar(1));
            this.showMessage(s3.toString());
            this.canLook = true;
            this.closeConnection(in);
        }
        catch (IOException er) {
            StringBuilder sb = new StringBuilder();
            sb.append("TM-Town web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        catch (JSONException er) {
            this.showErrorMessage(er.toString());
        }
        finally {
            this.canLook = true;
            this.closeConnection(in);
        }
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TMTown.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void stopSearch() {
        this.running = false;
    }

    public void createMTTab() {
        File file;
        this.mtHTMLPane = new JTextPane();
        this.mtHTMLPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.mtHTMLPane.putClientProperty("type", "memory");
        this.mtHTMLPane.addHyperlinkListener(new TMTownHyperactive());
        this.mtHTMLPane.setContentType("text/html");
        Graphics g = this.mtHTMLPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            Color foreground = new Color(AppPreferences.foreground);
            background = new Color(AppPreferences.background);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.mtHTMLPane.setCaretColor(foreground);
            this.mtHTMLPane.setBackground(background);
            this.mtHTMLPane.setForeground(foreground);
            this.mtHTMLPane.setSelectionColor(selection);
            this.mtHTMLPane.setSelectedTextColor(foreground);
        }
        this.mtHTMLPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        this.mtHTMLPane.setMargin(new Insets(0, 0, 0, 0));
        this.mtHTMLPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TMTown.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.mtHTMLPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TMTown.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean ctrl = UITools.isShortcutDown(evt);
                if (!ctrl && evt.getButton() == 1) {
                    String sel;
                    int cc = evt.getClickCount();
                    if (cc < 2 && (sel = TMTown.this.mtHTMLPane.getSelectedText()) != null && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                        try {
                            int spos = Utilities.getWordStart(TMTown.this.mtHTMLPane, TMTown.this.mtHTMLPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(TMTown.this.mtHTMLPane, TMTown.this.mtHTMLPane.getSelectionEnd() - 1);
                            TMTown.this.mtHTMLPane.setSelectionStart(spos);
                            TMTown.this.mtHTMLPane.setSelectionEnd(epos);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((sel = TMTown.this.mtHTMLPane.getSelectedText()) != null) {
                        TargetView pview = TMTown.this.topui.getTargetView();
                        pview.grabSelection(sel);
                    }
                }
                if (evt.isPopupTrigger()) {
                    TMTown.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.mtHTMLPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.mtHTMLPane.setBackground(new Color(0, 0, 0, 0));
            this.mtHTMLPane.setOpaque(false);
        }
        jScrollPane.getViewport().add((Component)this.mtHTMLPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.mtHTMLPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.mtHTMLPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.mainPanel = new GridPanel();
        this.mainPanel.setBorder(new EmptyBorder(4, 0, 0, 0));
        this.mainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TMTown.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TMTown.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.documentView.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TMTown.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TMTown.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.add(jScrollPane);
        this.tview.addTab(this, this.resourceName, this.mainPanel);
    }

    public void showMessage(String mes) {
        if (this.mtHTMLPane != null) {
            HTMLDocument doc = (HTMLDocument)this.mtHTMLPane.getDocument();
            try {
                doc.setInnerHTML(doc.getDefaultRootElement(), mes);
                JViewport vp = (JViewport)this.mtHTMLPane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMTown this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showErrorMessage(String error) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.styles);
        sb.append("<body>");
        sb.append(this.getHTMLTooBar(1));
        sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=8 CELLPADDING=8><tr>");
        sb.append("<td style=\"color:white; background-color:black\">");
        sb.append(error);
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</body></html>");
        this.info = sb.toString();
        this.showMessage(this.info);
    }

    @Override
    public void closeResource() {
        this.running = false;
        this.topui.getResourceView().setTMTownService("");
        this.tview.removeTab(this.resourceName);
    }

    void downloadGlossary(String url, String name) {
        if (name == null) {
            name = "TM-Town_Glossary";
        }
        final ResourceInfo ri = new ResourceInfo();
        ri.setEntry("Path", url);
        ri.setEntry("Name", name);
        ri.setEntry("Encoding", "UTF-8");
        ri.setEntry("Entry word separator", "\t");
        ri.setEntry("Priority", "2");
        ri.setEntry("Connection URL", url);
        ri.setEntry("Read only", "yes");
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Downloading " + name + "...");
        SwingWorker worker = new SwingWorker(this){
            GlossaryResource g;
            final /* synthetic */ TMTown this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.g = new GlossaryResource(ri);
                return null;
            }

            @Override
            protected void done() {
                if (this.g != null) {
                    this.g.setMainView(this.this$0.topui);
                    this.this$0.topui.getResourceView().addGlossary(this.g);
                    this.g.checkTrialVersionLimit(false);
                }
                this.this$0.topui.removePretranslateProgressBar(bar);
            }
        };
        worker.execute();
    }

    private String highlightMatch(String html, Pattern p) {
        StringBuffer sbHTML = new StringBuffer();
        Matcher ma = p.matcher(html);
        while (ma.find()) {
            String m = ma.group();
            String h = HTMLFormat.matchColorHTML + m + "</span>";
            ma.appendReplacement(sbHTML, h);
        }
        ma.appendTail(sbHTML);
        return sbHTML.toString();
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    class TMTownHyperactive
    implements HyperlinkListener {
        TMTownHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String s = e.getDescription();
                if (s.equals(authorizationRequest)) {
                    TMTownLinking = true;
                    String name = "TM-Town - Authorization";
                    TMTown.this.topui.getResourceLoader().prepareWebResource(s, name, false, false, -1);
                } else if (s.equals(TMTown.this.signInRequest)) {
                    String name = "TM-Town - Account";
                    TMTown.this.topui.getResourceLoader().prepareWebResource(s, name, true, false, -1);
                } else if (s.equals(TMTown.this.searchUserSegments)) {
                    TMTown.this.searchUserSegments(null);
                } else if (s.equals(TMTown.this.searchUserTerms)) {
                    TMTown.this.searchUserTerms(null);
                } else if (s.equals(TMTown.this.userDetails)) {
                    TMTown.this.getUser(false);
                } else if (s.equals(TMTown.this.userDocuments)) {
                    TMTown.this.getTMTownDocuments();
                } else if (s.equals(TMTown.this.uploadWork)) {
                    TMTown.this.getCafeTranDocuments();
                } else if (s.equals("writeTM")) {
                    TMTown.this.showWriteMemory();
                } else if (s.startsWith("http")) {
                    try {
                        URI uri = new URI(s);
                        TMTown.this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    static class DefaultTrustManager
    implements X509TrustManager {
        DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

