/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.xliff.XLIFFUnit;

public class BinaryUnit
extends DefaultXMLElement {
    private DefaultXMLElement bsource;
    private DefaultXMLElement btarget;
    private List tunits = new ArrayList();

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("trans-unit")) {
                XLIFFUnit elem = (XLIFFUnit)xml;
                this.addTransUnit(elem);
            } else if (name.equals("bin-target")) {
                DefaultXMLElement elem = (DefaultXMLElement)xml;
                this.setBinaryTarget(elem);
            } else if (name.equals("bin-source")) {
                DefaultXMLElement elem = (DefaultXMLElement)xml;
                this.setBinarySource(elem);
            } else {
                super.addChild(xml);
            }
        }
    }

    public List getNotes() {
        return this.getChildren("note");
    }

    public List getContextGroups() {
        return this.getChildren("context-group");
    }

    public List getCountGroups() {
        return this.getChildren("count-group");
    }

    public void setBinarySource(DefaultXMLElement bsource) {
        this.bsource = bsource;
    }

    public void setBinaryTarget(DefaultXMLElement btarget) {
        this.btarget = btarget;
    }

    public DefaultXMLElement getBinarySource() {
        return this.bsource;
    }

    public DefaultXMLElement getBinaryTarget() {
        return this.btarget;
    }

    public void addTransUnit(XLIFFUnit tunit) {
        this.tunits.add(tunit);
    }

    public void addTransUnit(int i, XLIFFUnit tunit) {
        this.tunits.add(i, tunit);
    }

    public void removeTransUnit(XLIFFUnit tunit) {
        this.tunits.remove(tunit);
    }

    public XLIFFUnit getTransUnit(int id) {
        return (XLIFFUnit)this.tunits.get(id);
    }

    public List getTransUnits() {
        return this.tunits;
    }

    int getTUCount() {
        return this.tunits.size();
    }

    @Override
    public String getXMLFormat() {
        String s;
        String s2;
        StringBuffer sb = new StringBuffer();
        String name = this.getName();
        sb.append("<");
        sb.append(name);
        LinkedHashMap attrMap = this.getAttributes();
        if (attrMap != null) {
            Set set = attrMap.keySet();
            Iterator<Object> i = set.iterator();
            while (i.hasNext()) {
                sb.append(" ");
                String s3 = (String)i.next();
                sb.append(s3);
                sb.append('=');
                sb.append('\"');
                sb.append((String)attrMap.get(s3));
                sb.append('\"');
            }
        }
        sb.append(">");
        if (this.bsource != null) {
            s2 = this.bsource.getXMLFormat();
            sb.append(s2);
        }
        if (this.btarget != null) {
            s2 = this.btarget.getXMLFormat();
            sb.append(s2);
        }
        if (this.tunits != null) {
            List val = this.tunits;
            for (XLIFFUnit tunit : val) {
                s = tunit.getXMLFormat();
                sb.append(s);
            }
        }
        List elems = this.getChildren();
        for (DefaultXMLElement elem : elems) {
            s = elem.getXMLFormat();
            sb.append(s);
        }
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }
}

