/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.util.ArrayList;
import java.util.List;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.xliff.BinaryUnit;
import translator.xliff.XLIFFUnit;

public class Group
extends DefaultXMLElement {
    private List tunits = new ArrayList();
    private List bunits = new ArrayList();

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("trans-unit")) {
                XLIFFUnit elem = (XLIFFUnit)xml;
                this.addTransUnit(elem);
            } else if (name.equals("bin-unit")) {
                BinaryUnit elem = (BinaryUnit)xml;
                this.addBinaryUnit(elem);
            } else {
                super.addChild(xml);
            }
        }
    }

    public List getGroups() {
        return this.getChildren("group");
    }

    public List getNotes() {
        return this.getChildren("note");
    }

    public void addTransUnit(XLIFFUnit tunit) {
        super.addChild(tunit);
        this.tunits.add(tunit);
    }

    public void addTransUnit(int i, XLIFFUnit tunit) {
        super.getChildren().add(i, tunit);
        this.tunits.add(i, tunit);
    }

    public void removeTransUnit(XLIFFUnit tunit) {
        super.removeChild(tunit);
        this.tunits.remove(tunit);
    }

    public void removeBinaryUnit(BinaryUnit bu) {
        super.removeChild(bu);
        this.bunits.remove(bu);
    }

    int getTUCount() {
        return this.tunits.size();
    }

    int getBUCount() {
        return this.bunits.size();
    }

    public void addBinaryUnit(BinaryUnit bunit) {
        super.addChild(bunit);
        this.bunits.add(bunit);
    }

    public List getBinaryUnits() {
        return this.bunits;
    }

    public List getTransUnits() {
        return this.tunits;
    }

    public List getContextGroups() {
        return this.getChildren("context-group");
    }

    public List getCountGroups() {
        return this.getChildren("count-group");
    }
}

