/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.ResourceView;
import translator.XMLElement;
import translator.translatables.ZipDocument;
import translator.xliff.Billing;

public class InvoiceEditor
extends JDialog
implements ActionListener {
    private MainView parent;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel0;
    private JTextPane jtextArea1;
    private JTextPane jtextArea2;
    private JTextField totalfield;
    private JTextField subtotalfield;
    private JTextField taxfield;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private DefaultXMLElement elem;
    private LinkedHashMap attr;
    public boolean cancelled = false;
    XMLElement client;
    XMLElement company;

    public InvoiceEditor(JDialog owner, final MainView parent, Billing bill, DefaultXMLElement elem, String title) {
        super(owner, title, true);
        this.parent = parent;
        this.setResizable(false);
        this.elem = elem;
        this.jPanel0 = new JPanel();
        this.jPanel0.setLayout(new GridLayout(0, 2, 0, 0));
        this.jPanel1 = new JPanel();
        this.jPanel1.setLayout(new GridLayout(0, 4, 10, 5));
        Color background = new Color(AppPreferences.background);
        Color foreground = new Color(AppPreferences.foreground);
        JPanel con = (JPanel)this.getContentPane();
        con.setBorder(new EmptyBorder(new Insets(10, 10, 5, 10)));
        con.add((Component)this.jPanel1, "North");
        String cli = null;
        String comp = null;
        List list = elem.getChildren();
        for (Object o : list) {
            if (!(o instanceof XMLElement)) continue;
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("bill:client")) {
                this.client = xml;
                cli = xml.getContent(0).toString();
                continue;
            }
            if (!name.equals("bill:company")) continue;
            this.company = xml;
            comp = xml.getContent(0).toString();
        }
        this.jtextArea1 = new JTextPane();
        if (comp != null && comp.length() > 0) {
            this.jtextArea1.setText(comp);
        } else {
            this.jtextArea1.setText(AppPreferences.company);
        }
        this.jtextArea1.setCaretPosition(0);
        this.jtextArea1.setFont(new Font(AppPreferences.fontname, 1, AppPreferences.fontsize));
        if (AppPreferences.background != 0) {
            this.jtextArea1.setCaretColor(foreground);
            this.jtextArea1.setBackground(background);
            this.jtextArea1.setForeground(foreground);
        }
        this.jtextArea1.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane = new JScrollPane(this.jtextArea1);
        this.jPanel2 = new JPanel();
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(400, 175));
        this.jPanel2.setLayout(new GridLayout(0, 1, 7, 3));
        this.jPanel2.setBorder(new CompoundBorder(new EmptyBorder(new Insets(10, 0, 0, 0)), new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COMPANY"))));
        this.jPanel2.add(jScrollPane);
        this.jPanel0.add(this.jPanel2);
        this.jtextArea2 = new JTextPane();
        if (cli != null && cli.length() > 0) {
            this.jtextArea2.setText(cli);
        } else {
            String clie;
            DefaultXMLElement order = bill.getOrder();
            if (order != null && (clie = order.getContent(0).toString()) != null && clie.length() > 0) {
                this.jtextArea2.setText(clie);
            }
        }
        this.jtextArea2.setCaretPosition(0);
        this.jtextArea2.setFont(new Font(AppPreferences.fontname, 1, AppPreferences.fontsize));
        if (AppPreferences.background != 0) {
            this.jtextArea2.setCaretColor(foreground);
            this.jtextArea2.setBackground(background);
            this.jtextArea2.setForeground(foreground);
        }
        this.jtextArea2.setMargin(new Insets(3, 3, 3, 3));
        jScrollPane = new JScrollPane(this.jtextArea2);
        this.jPanel2 = new JPanel();
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(400, 175));
        this.jPanel2.setLayout(new GridLayout(0, 1, 7, 3));
        this.jPanel2.setBorder(new CompoundBorder(new EmptyBorder(new Insets(10, 0, 0, 0)), new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLIENT"))));
        this.jPanel2.add(jScrollPane);
        this.jPanel0.add(this.jPanel2);
        this.attr = elem.getAttributes();
        if (this.attr != null) {
            Set keys = this.attr.keySet();
            for (String name : keys) {
                JTextField field;
                String value = (String)this.attr.get(name);
                if (name.equals("layout")) {
                    field = new JTextField(value);
                    field.setCaretPosition(0);
                    field.setMargin(new Insets(0, 2, 0, 0));
                    field.setFont(field.getFont().deriveFont(1));
                    JButton jb = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE TEMPLATE") + "...");
                    jb.setName(name);
                    jb.setHorizontalAlignment(2);
                    jb.addActionListener(new ActionListener(){
                        final /* synthetic */ InvoiceEditor this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (AppPreferences.isJavaFXReady()) {
                                Platform.runLater((Runnable)new Runnable(){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            File file;
                                            FileChooser fileChooser = new FileChooser();
                                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE INVOICE TEMPLATE"));
                                            File f = new File(AppPreferences.packagePath + "layouts/invoice");
                                            if (f.isDirectory() && f.canRead()) {
                                                fileChooser.setInitialDirectory(f);
                                            }
                                            if ((file = fileChooser.showOpenDialog(null)) != null) {
                                                SwingUtilities.invokeLater(new Runnable(){
                                                    final /* synthetic */ 1 this$2;
                                                    {
                                                        this.this$2 = this$2;
                                                    }

                                                    @Override
                                                    public void run() {
                                                        field.setText(file.getName());
                                                    }
                                                });
                                            }
                                        }
                                        catch (Exception ex) {
                                            final String s = ex.getMessage();
                                            SwingUtilities.invokeLater(new Runnable(){
                                                final /* synthetic */ 1 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                }

                                                @Override
                                                public void run() {
                                                    JOptionPane.showMessageDialog(parent, s);
                                                }
                                            });
                                        }
                                    }
                                });
                            } else {
                                JFileChooser jch = new JFileChooser(AppPreferences.packagePath + "layouts/invoice");
                                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE INVOICE TEMPLATE"));
                                if (0 == jch.showOpenDialog(parent)) {
                                    File file = jch.getSelectedFile();
                                    field.setText(file.getName());
                                }
                            }
                        }
                    });
                    this.jPanel1.add(jb);
                    this.jPanel1.add(field);
                    continue;
                }
                field = new JTextField(value);
                field.setCaretPosition(0);
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setFont(field.getFont().deriveFont(1));
                field.setPreferredSize(new Dimension(200, 23));
                if (name.equals("tax")) {
                    this.taxfield = field;
                }
                if (name.equals("total")) {
                    this.jButton4 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TOTAL:"));
                    this.jButton4.setName(name);
                    this.jButton4.setHorizontalAlignment(2);
                    this.jButton4.addActionListener(this);
                    this.jPanel1.add(this.jButton4);
                    this.totalfield = field;
                } else if (name.equals("sub-total")) {
                    this.jButton5 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SUB-TOTAL:"));
                    this.jButton5.setName(name);
                    this.jButton5.setHorizontalAlignment(2);
                    this.jButton5.addActionListener(this);
                    this.jPanel1.add(this.jButton5);
                    this.subtotalfield = field;
                } else {
                    String display = name.equals("number") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE NUMBER:") : (name.equals("price-per-unit") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRICE PER UNIT:") : (name.equals("date") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE DATE:") : (name.equals("currency") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CURRENCY:") : (name.equals("time") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE TIME:") : (name.equals("service") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TYPE OF SERVICE:") : (name.equals("tax") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAX:") : (name.equals("job") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOB DESCRIPTION:") : (name.equals("source-language") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE LANGUAGE:") : (name.equals("payment") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PAYMENT METHOD:") : (name.equals("target-language") ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET LANGUAGE:") : name.substring(0, 1).toUpperCase() + name.substring(1) + ":"))))))))));
                    JLabel label = new JLabel(display);
                    label.setHorizontalAlignment(4);
                    label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
                    label.setName(name);
                    if (name.equals("number") && value.length() == 0) {
                        label.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LAST INVOICE NUMBER:") + " " + AppPreferences.billingNumber);
                    }
                    this.jPanel1.add(label);
                }
                this.jPanel1.add(field);
            }
        }
        this.jPanel3 = new JPanel();
        this.jPanel3.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        this.jPanel3.setLayout(new GridLayout(0, 2, 10, 0));
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRINT INVOICE"));
        this.jButton3.setMnemonic(80);
        this.jButton3.addActionListener(this);
        this.jPanel3.add(this.jButton2);
        this.jPanel3.add(this.jButton3);
        con.add((Component)this.jPanel0, "Center");
        con.add((Component)this.jPanel3, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvoiceEditor.this.jButton3.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvoiceEditor.this.jButton2.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                InvoiceEditor.this.cancelled = true;
                InvoiceEditor.this.closeDialog();
            }
        });
        this.pack();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void save() {
        Component[] comps = this.jPanel1.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            String content;
            JComponent lab;
            String type = null;
            String value = null;
            if (comps[i] instanceof JLabel) {
                lab = (JLabel)comps[i];
                type = lab.getName();
                ++i;
            } else if (comps[i] instanceof JButton) {
                lab = (JButton)comps[i];
                type = lab.getName();
                ++i;
            }
            if (comps[i] instanceof JTextField) {
                JTextField field = (JTextField)comps[i];
                value = field.getText();
            }
            if (type != null && value != null) {
                this.elem.setAttribute(type, value);
                if (type.equals("layout")) {
                    AppPreferences.billingLayout = value;
                } else if (type.equals("tax")) {
                    AppPreferences.billingTax = value;
                } else if (type.equals("number")) {
                    AppPreferences.billingNumber = value;
                } else if (type.equals("service")) {
                    AppPreferences.billingService = value;
                } else if (type.equals("price-per-unit")) {
                    AppPreferences.billingPrice = value;
                } else if (type.equals("payment")) {
                    AppPreferences.billingPayment = value;
                } else if (type.equals("currency")) {
                    AppPreferences.billingCurrency = value;
                }
            }
            if ((content = this.jtextArea2.getText()) != null) {
                this.client.setContent(0, content);
            }
            if ((content = this.jtextArea1.getText()) == null) continue;
            this.company.setContent(0, content);
            AppPreferences.company = content;
        }
    }

    String replaceTemplate(String bill, String ext) {
        String number = (String)this.attr.get("number");
        String date = (String)this.attr.get("date");
        String time = (String)this.attr.get("time");
        String cli = this.client.getContent(0).toString();
        String comp = this.company.getContent(0).toString();
        String service = (String)this.attr.get("service");
        String job = (String)this.attr.get("job");
        String price = (String)this.attr.get("price-per-unit");
        String slang = (String)this.attr.get("source-language");
        String tlang = (String)this.attr.get("target-language");
        String payment = (String)this.attr.get("payment");
        String currency = (String)this.attr.get("currency");
        String subtotal = (String)this.attr.get("sub-total");
        String tax = (String)this.attr.get("tax");
        String total = (String)this.attr.get("total");
        if (number != null) {
            bill = bill.replaceFirst("setNumber", number);
        }
        if (date != null) {
            bill = bill.replaceFirst("setDate", date);
        }
        if (time != null) {
            bill = bill.replaceFirst("setTime", time);
        }
        if (AppPreferences.company != null) {
            if (ext.equals(".odt")) {
                comp = comp.replaceAll("\n", "</text:p><text:p  text:style-name='P2'>");
            } else if (ext.equals(".docx") || ext.equals(".xml")) {
                comp = comp.replaceAll("\n", "</w:t></w:r></w:p><w:p><w:pPr><w:pStyle w:val='P2'/></w:pPr><w:r><w:t>");
            }
            bill = bill.replaceFirst("setCompany", comp);
        }
        if (this.client != null) {
            if (ext.equals(".odt")) {
                cli = cli.replaceAll("\n", "</text:p><text:p  text:style-name='P2'>");
            } else if (ext.equals(".docx") || ext.equals(".xml")) {
                cli = cli.replaceAll("\n", "</w:t></w:r></w:p><w:p><w:pPr><w:pStyle w:val='P2'/></w:pPr><w:r><w:t>");
            }
            bill = bill.replaceFirst("setClient", cli);
        }
        if (service != null) {
            bill = bill.replaceFirst("setService", service);
        }
        if (job != null) {
            bill = bill.replaceFirst("setJob", job);
        }
        if (price != null) {
            bill = bill.replaceFirst("setPrice", price);
        }
        if (slang != null) {
            bill = bill.replaceFirst("setSourceLanguage", slang);
        }
        if (tlang != null) {
            bill = bill.replaceFirst("setTargetLanguage", tlang);
        }
        if (payment != null) {
            bill = bill.replaceFirst("setPayment", payment);
        }
        if (currency != null) {
            bill = bill.replaceAll("setCurrency", currency);
        }
        if (subtotal != null) {
            bill = bill.replaceAll("setSubtotal", subtotal);
        }
        if (tax != null) {
            bill = bill.replaceAll("setTax", tax);
        }
        if (total != null) {
            bill = bill.replaceAll("setTotal", total);
        }
        return bill;
    }

    void view() {
        File file;
        String layout = null;
        String lpath = AppPreferences.packagePath + "layouts/invoice/";
        String name = (String)this.attr.get("layout");
        if (name != null && name.length() > 0) {
            file = new File(lpath + name);
            if (!file.exists()) {
                name = "english.odt";
                file = new File(lpath + name);
            }
        } else {
            name = "english.odt";
            file = new File(lpath + name);
        }
        ZipDocument tr = new ZipDocument();
        if (name.endsWith(".docx") || name.endsWith(".odt")) {
            try {
                String doc = null;
                String ext = name.substring(name.indexOf(46));
                if (ext.equals(".docx")) {
                    doc = "word/document.xml";
                } else if (ext.equals(".odt")) {
                    doc = "content.xml";
                } else {
                    return;
                }
                ZipFile zfile = new ZipFile(file);
                layout = tr.loadZipFile(zfile, doc, "UTF-8");
                String bill = this.replaceTemplate(layout, ext);
                File temp = File.createTempFile(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE"), ext);
                temp.deleteOnExit();
                zfile = new ZipFile(file);
                String[] names = new String[]{doc};
                String[] texts = new String[]{bill};
                tr.storeZipFile(temp, zfile, names, texts);
                ResourceView rv = this.parent.getResourceView();
                rv.viewFile(temp);
            }
            catch (ZipException ex) {
                Logger.getLogger(InvoiceEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(InvoiceEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (name.endsWith(".xml")) {
            try {
                String ext = name.substring(name.indexOf(46));
                layout = tr.loadTextFile(file, "UTF-8");
                String bill = this.replaceTemplate(layout, ext);
                File temp = File.createTempFile(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE"), ext);
                temp.deleteOnExit();
                tr.storeFile(temp, bill, "UTF-8");
                ResourceView rv = this.parent.getResourceView();
                rv.viewFile(temp);
            }
            catch (IOException ex) {
                Logger.getLogger(InvoiceEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private float round(float val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (float)factor);
        return (float)tmp / (float)factor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton3) {
            this.save();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InvoiceEditor.this.view();
                }
            });
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            this.cancelled = true;
            this.closeDialog();
        } else if (e.getSource() == this.jButton4) {
            String tax = this.taxfield.getText().trim();
            String subtotal = this.subtotalfield.getText().trim();
            try {
                float ftax = Float.parseFloat(tax);
                float fsubtotal = Float.parseFloat(subtotal);
                ftax = ftax / 100.0f + 1.0f;
                float ftotal = ftax * fsubtotal;
                ftotal = this.round(ftotal, 2);
                this.totalfield.setText(Float.toString(ftotal));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET SUB-TOTAL AND TAX VALUES."));
            }
        } else if (e.getSource() == this.jButton5) {
            String tax = this.taxfield.getText().trim();
            String total = this.totalfield.getText().trim();
            try {
                float ftax = Float.parseFloat(tax);
                float ftotal = Float.parseFloat(total);
                ftax = ftax / 100.0f + 1.0f;
                float fsubtotal = ftotal / ftax;
                fsubtotal = this.round(fsubtotal, 2);
                this.subtotalfield.setText(Float.toString(fsubtotal));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET TOTAL AND TAX VALUES."));
            }
        }
    }
}

