/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import translator.Abbreviations;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.FormatChooser;
import translator.LanguageCodes;
import translator.MT;
import translator.NumbersHelper;
import translator.Placeables;
import translator.Project;
import translator.Prompter;
import translator.StopWords;
import translator.XMLElement;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.web.Proz;
import translator.web.TMTown;
import translator.xliff.AltTrans;
import translator.xliff.BinaryUnit;
import translator.xliff.ContextGroup;
import translator.xliff.FileBody;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;
import translator.xliff.XliffMenu;
import translator.xliff.XliffView;
import translator.xliff.XliffWorkflow;

public class XLIFF
extends DefaultXMLElement {
    private int version = 1;
    private XliffFile currentFile;
    private Locale locale;
    private Locale srclocale;
    private HashMap projectFiles;
    private LinkedHashMap segmentAttributes;
    private XliffView xliffview;
    private static XliffWorkflow xworkflow;
    public boolean isUncleaned = false;
    public boolean isDocumentBilingual = false;
    public boolean isSubtitles = false;
    public boolean isExternalToolXLIFF = false;
    public boolean isStudioXLIFF = false;
    public boolean isCafeTranXLIFF = false;
    public boolean isMQXLIFF = false;
    public boolean isTXML = false;
    public boolean isMXLIFF = false;
    public boolean isTXLIFF = false;
    public boolean isPO = false;
    public boolean isUnknownXLIFF = false;
    public boolean emptyTargetSegments = false;
    public static int unitCounter;
    public static int fileCounter;
    private int currentFileID = -1;
    private int id = -1;
    private String path;
    private String zipPath;
    public boolean saved = true;
    private String lastTUID;
    private List ctnotes;
    private boolean noSpaceAfterPeriodSourceLanguage;
    private boolean noSpaceAfterPeriodTargetLanguage;
    public static Map sdlCommentsMap;
    private Map trackedElementInfos;
    private Pattern tags = Pattern.compile(AppPreferences.segmentSeparator);
    int n = -1;

    public XLIFF() {
        super(0, 2);
        this.projectFiles = new HashMap();
        this.segmentAttributes = new LinkedHashMap(4);
        this.trackedElementInfos = new HashMap();
    }

    public void removeTrackedElementInfo(XMLElement xml) {
        String id;
        XMLElement ixml;
        XMLElement refDefs;
        List list3;
        XMLElement docInfo;
        List list2;
        List list = this.getChildren("doc-info");
        if (!(list.isEmpty() || (list2 = (docInfo = (XMLElement)list.get(0)).getChildren("rev-defs")).isEmpty() || (list3 = (refDefs = (XMLElement)list2.get(0)).getChildren("rev-def")).isEmpty() || (ixml = (XMLElement)this.trackedElementInfos.get(id = xml.getAttribute("sdl:revid"))) == null)) {
            refDefs.removeChild(ixml);
            this.trackedElementInfos.remove(id);
        }
    }

    public void addTrackedElementInfo(XMLElement xml) {
        String id = xml.getAttribute("id");
        if (id != null) {
            this.trackedElementInfos.put(id, xml);
        }
    }

    public String[] getTrackedElementInfo(XMLElement xml) {
        XMLElement e;
        String[] info = new String[2];
        String id = xml.getAttribute("sdl:revid");
        if (id != null && (e = (XMLElement)this.trackedElementInfos.get(id)) != null) {
            String author = e.getAttribute("author");
            String date = e.getAttribute("date");
            if (author != null) {
                info[0] = author;
            }
            if (date != null) {
                info[1] = date;
            }
        }
        return info;
    }

    private XMLElement createTrackedElementCTE(String tag) {
        String type = tag.endsWith(" track=\"add\">") ? "x-added" : "x-deleted";
        String author = AppPreferences.userid.length() > 0 ? AppPreferences.userid : "CT";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sdf.format(cal.getTime()).toString();
        DefaultXMLElement newElement = new DefaultXMLElement();
        newElement.setName("mrk");
        newElement.setAttribute("mtype", type);
        newElement.setAttribute("ct:author", author);
        newElement.setAttribute("ct:date", date);
        return newElement;
    }

    private XMLElement createTrackedElementSDL(String tag) {
        String revType;
        String type;
        DefaultXMLElement revDefs;
        XMLElement docInfo;
        List list = this.getChildren("doc-info");
        if (list.isEmpty()) {
            docInfo = new DefaultXMLElement();
            docInfo.setName("doc-info");
            String attr = this.getAttribute("xmlns:sdl");
            if (attr == null) {
                attr = "http://sdl.com/FileTypes/SdlXliff/1.0";
            }
            docInfo.setAttribute("xmlns", attr);
            List elems = this.getChildren();
            elems.add(0, docInfo);
        } else {
            docInfo = (XMLElement)list.get(0);
        }
        List list2 = docInfo.getChildren("rev-defs");
        if (list2.isEmpty()) {
            revDefs = new DefaultXMLElement();
            revDefs.setName("rev-defs");
            docInfo.addChild(revDefs);
        } else {
            revDefs = (DefaultXMLElement)list2.get(0);
        }
        if (tag.endsWith(" track=\"add\">")) {
            type = "x-sdl-added";
            revType = null;
        } else {
            type = "x-sdl-deleted";
            revType = "Delete";
        }
        String uuid = UUID.randomUUID().toString();
        String author = AppPreferences.userid.length() > 0 ? AppPreferences.userid : "Reviewer";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        String date = sdf.format(cal.getTime()).toString();
        DefaultXMLElement revDef = new DefaultXMLElement();
        revDef.setName("rev-def");
        revDef.setAttribute("id", uuid);
        if (revType != null) {
            revDef.setAttribute("type", revType);
        }
        revDef.setAttribute("author", author);
        revDef.setAttribute("date", date);
        revDefs.addChild(revDef);
        this.addTrackedElementInfo(revDef);
        DefaultXMLElement newElement = new DefaultXMLElement();
        newElement.setName("mrk");
        newElement.setAttribute("mtype", type);
        newElement.setAttribute("sdl:revid", uuid);
        return newElement;
    }

    public XMLElement createTrackedElement(String tag) {
        if (this.isCafeTranXLIFF) {
            return this.createTrackedElementCTE(tag);
        }
        if (this.isStudioXLIFF) {
            return this.createTrackedElementSDL(tag);
        }
        return null;
    }

    public void setEmptyTargetSegments(boolean ets) {
        this.emptyTargetSegments = ets;
    }

    public Map getFilesMap() {
        return this.projectFiles;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int v) {
        this.version = v;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setZipPath(String zpath) {
        this.zipPath = zpath;
    }

    public void setStatus(XLIFFUnit tu, int status) {
        if (status == 1) {
            XMLElement tarXML;
            if (this.isCafeTranXLIFF) {
                XMLElement tarXML2 = tu.getTarget();
                if (tarXML2 != null) {
                    tarXML2.setAttribute("state", "signed-off");
                }
            } else if (this.isMXLIFF) {
                tu.setAttribute("m:confirmed", "1");
            } else if (this.isMQXLIFF) {
                tu.setAttribute("mq:status", "ManuallyConfirmed");
            } else if (this.isStudioXLIFF) {
                tu.setSDLStatus("Translated");
            } else if (this.isExternalToolXLIFF && (tarXML = tu.getTarget()) != null) {
                tarXML.setAttribute("state", "signed-off");
            }
            tu.setState(1);
        } else if (status == 2) {
            if (this.isCafeTranXLIFF) {
                tu.setAttribute("approved", "yes");
            } else if (this.isMQXLIFF) {
                tu.setAttribute("mq:status", "Reviewer1Confirmed");
            } else if (this.isStudioXLIFF) {
                tu.setSDLStatus("ApprovedTranslation");
            } else if (this.isExternalToolXLIFF) {
                tu.setAttribute("approved", "yes");
            }
            tu.setState(2);
        } else if (status == 3) {
            if (this.isCafeTranXLIFF) {
                tu.setAttribute("approved", "no");
            } else if (this.isMQXLIFF) {
                tu.setAttribute("mq:status", "Rejected");
            } else if (this.isStudioXLIFF) {
                tu.setSDLStatus("RejectedTranslation");
            } else if (this.isExternalToolXLIFF) {
                tu.setAttribute("approved", "no");
            }
            tu.setState(3);
        } else if (status == 4) {
            tu.setLock(true, this.isCafeTranXLIFF);
        }
    }

    @Override
    public void setAttribute(String type, String value) {
        super.setAttribute(type, value);
        if (type.startsWith("property:")) {
            this.segmentAttributes.put(type.substring(9), value);
        }
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("file")) {
                XliffFile fxml = (XliffFile)xml;
                fxml.setFileID(fileCounter);
                this.projectFiles.put(fileCounter, fxml);
                ++fileCounter;
                this.setCurrentFile(fxml);
                this.setWorkflow(null);
            }
            super.addChild(xml);
        }
    }

    public void removeFile(XliffFile file) {
        this.removeChild(file);
        int cid = file.getFileID();
        if (cid != -1) {
            this.projectFiles.remove(cid);
        }
    }

    public List getFiles() {
        if (this.isTXML) {
            ArrayList<XliffFile> list = new ArrayList<XliffFile>(1);
            list.add(this.currentFile);
            return list;
        }
        return this.getChildren("file");
    }

    public List getContentsFiles() {
        List allFile = this.getFiles();
        ArrayList<XliffFile> cFiles = new ArrayList<XliffFile>(allFile.size());
        for (XliffFile next : allFile) {
            if (!next.hasTranslationUnits()) continue;
            cFiles.add(next);
        }
        return cFiles;
    }

    public XliffFile getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(XliffFile file) {
        XLIFFUnit tu;
        int count;
        if (file == null) {
            this.currentFile = null;
            return;
        }
        if (this.currentFile != null && this.currentFile.equals(file)) {
            return;
        }
        FileBody body = file.getBody();
        if (body != null && (count = body.getTUCount()) > 0 && (tu = (XLIFFUnit)body.getTransUnits().get(count - 1)) != null) {
            body.setCurrentTU(tu);
        }
        this.currentFile = file;
        if (this.version == 2) {
            String src = this.getAttribute("srcLang");
            String trg = this.getAttribute("trgLang");
            if (trg == null || LanguageCodes.getName(trg) == null) {
                this.xliffview.getMenu().showXLIFF(this);
            } else if (src != null && trg != null) {
                this.setLangEnvironment(src, trg);
                this.setFormat();
            }
            return;
        }
        String trglang = this.currentFile.getAttribute("target-language");
        if (trglang == null && AppPreferences.fileSDLTargetLang != null) {
            trglang = AppPreferences.fileSDLTargetLang;
            this.currentFile.setAttribute("target-language", trglang);
        }
        String srclang = this.currentFile.getAttribute("source-language");
        if (trglang == null || srclang == null) {
            if (srclang == null) {
                this.currentFile.setAttribute("source-language", "");
            }
            if (trglang == null) {
                this.currentFile.setAttribute("target-language", "");
            }
            if (this.isUnknownXLIFF) {
                if (fileCounter == 1) {
                    boolean cancel = this.xliffview.getMenu().showXLIFFFile(this.currentFile, 0, false);
                    if (!cancel) {
                        String tlang = this.currentFile.getAttribute("target-language");
                        String slang = this.currentFile.getAttribute("source-language");
                        this.setLangEnvironment(slang, tlang);
                        this.setFormat();
                    }
                } else {
                    XliffFile firstFile = this.getFile(0);
                    if (firstFile != null) {
                        String tlang = firstFile.getAttribute("target-language");
                        String slang = firstFile.getAttribute("source-language");
                        if (tlang != null) {
                            this.currentFile.setAttribute("target-language", tlang);
                        }
                        if (slang != null) {
                            this.currentFile.setAttribute("source-language", slang);
                        }
                    }
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (XLIFF.this.isExternalToolXLIFF) {
                            String trglang = XLIFF.this.currentFile.getAttribute("target-language");
                            String srclang = XLIFF.this.currentFile.getAttribute("source-language");
                            if (trglang == null || trglang.length() == 0) {
                                trglang = AppPreferences.fileTLang;
                            }
                            if (srclang == null || srclang.length() == 0) {
                                srclang = AppPreferences.fileSLang;
                            }
                            XLIFF.this.setLangEnvironment(srclang, trglang);
                            XLIFF.this.setFormat();
                        } else {
                            boolean cancel = XLIFF.this.xliffview.getMenu().showXLIFFFile(XLIFF.this.currentFile, 0, false);
                            String trglang = XLIFF.this.currentFile.getAttribute("target-language");
                            String srclang = XLIFF.this.currentFile.getAttribute("source-language");
                            XLIFF.this.setLangEnvironment(srclang, trglang);
                            XLIFF.this.setFormat();
                        }
                    }
                });
            }
        } else {
            this.setLangEnvironment(srclang, trglang);
            this.setFormat();
        }
    }

    public boolean setCurrentFile(int id) {
        Object o;
        boolean change = false;
        int cid = this.currentFile.getFileID();
        if (cid != id && (o = this.projectFiles.get(id)) != null && o instanceof XliffFile) {
            XliffFile file = (XliffFile)o;
            this.setCurrentFile(file);
            change = true;
        }
        return change;
    }

    public boolean isCurrentFile(int id) {
        boolean current = false;
        int cid = this.currentFile.getFileID();
        if (cid == id) {
            current = true;
        }
        return current;
    }

    public XliffFile getFile(int id) {
        XliffFile xfile = null;
        Object o = this.projectFiles.get(id);
        if (o != null && o instanceof XliffFile) {
            xfile = (XliffFile)o;
        }
        return xfile;
    }

    public void setLangEnvironment(String srclang, String trglang) {
        String two;
        int i;
        Proz ws2;
        TMTown ws;
        MT mt8;
        MT mt7;
        MT mt6;
        MT mt5;
        MT mt3;
        MT mt2;
        MT mt;
        if (trglang != null && trglang.length() > 0) {
            trglang = this.setLocale(trglang);
        }
        if (srclang != null && srclang.length() > 0) {
            srclang = this.setSrcLocale(srclang);
        }
        if ((mt = this.xliffview.topui.getResourceView().getMT()) != null) {
            mt.setLanguageCodesPair(srclang, trglang);
        }
        if ((mt2 = this.xliffview.topui.getResourceView().getMT2()) != null) {
            mt2.setLanguageCodesPair(srclang, trglang);
        }
        if ((mt3 = this.xliffview.topui.getResourceView().getMT3()) != null) {
            mt3.setLanguageCodesPair(srclang, trglang);
        }
        if ((mt5 = this.xliffview.topui.getResourceView().getMT5()) != null) {
            mt5.setLanguageCodesPair(srclang, trglang);
        }
        if ((mt6 = this.xliffview.topui.getResourceView().getMT6()) != null) {
            mt6.setLanguageCodesPair(srclang, trglang);
        }
        if ((mt7 = this.xliffview.topui.getResourceView().getMT7()) != null) {
            mt7.setLanguageCodesPair(srclang, trglang);
        }
        if ((mt8 = this.xliffview.topui.getResourceView().getMT8()) != null) {
            mt8.setLanguageCodesPair(srclang, trglang);
        }
        if ((ws = this.xliffview.topui.getResourceView().getTMTownService()) != null) {
            ws.setLanguageCodesPair(srclang, trglang);
        }
        if ((ws2 = this.xliffview.topui.getResourceView().getProzService()) != null) {
            ws2.setLanguageCodesPair(srclang, trglang);
        }
        String[] langs = new String[2];
        if (srclang != null) {
            AppPreferences.fileSLang = srclang;
            langs[0] = LanguageCodes.getName(srclang);
        }
        if (trglang != null) {
            AppPreferences.fileTLang = trglang;
            langs[1] = LanguageCodes.getName(trglang);
        }
        LanguageCodes.updateCurrentLangNames(langs);
        LanguageCodes.setSourceLanguage();
        LanguageCodes.setTargetLanguage();
        String one = LanguageCodes.getName(AppPreferences.fileSLang);
        if (one == null) {
            one = AppPreferences.fileSLang;
        }
        if ((i = one.indexOf(40)) != -1) {
            one = one.substring(0, i - 1);
        }
        if ((two = LanguageCodes.getName(AppPreferences.fileTLang)) == null) {
            two = AppPreferences.fileTLang;
        }
        if ((i = two.indexOf(40)) != -1) {
            two = two.substring(0, i - 1);
        }
        this.xliffview.topui.getLanguagePairLabel().setText(one + ":" + two);
    }

    private void setSpellChecker(String lang) {
        HunSpellChecker spell = this.xliffview.topui.getSpellChecker();
        if (spell != null) {
            spell.setTargetLanguageDictionary(lang);
            spell.setBreakIterator(this.locale);
        }
    }

    private void setAbbreviations(String lang) {
        Abbreviations.loadAbbreviations(lang);
    }

    public void setFormat() {
        String attr;
        String dtype = this.currentFile.getAttribute("datatype");
        if (dtype != null && dtype.length() > 0 && !dtype.equals("x-auto")) {
            String format;
            if (dtype.startsWith("x-subtitles")) {
                this.isSubtitles = true;
            }
            if ((format = FormatChooser.getFormatType(dtype)) != null) {
                AppPreferences.format = format;
                this.isUncleaned = format.indexOf("Uncleaned") != -1;
            }
        }
        this.isDocumentBilingual = (attr = this.currentFile.getAttribute("filter:ImportTargetColumn")) != null && attr.length() > 0;
    }

    public String getFormat() {
        String dtype = this.currentFile.getAttribute("datatype");
        if (dtype != null && dtype.length() > 0) {
            String format = FormatChooser.getFormatType(dtype);
            return format;
        }
        return AppPreferences.format;
    }

    private String setLocale(String lang) {
        String ccode;
        String lcode;
        int v = lang.indexOf(45);
        if (v == -1) {
            v = lang.indexOf(95);
        }
        if (v != -1) {
            lcode = lang.substring(0, v).toLowerCase();
            ccode = lang.substring(v + 1).toUpperCase();
        } else {
            lcode = lang.toLowerCase();
            ccode = LanguageCodes.getCountryCodeforLanguage(lcode);
            if (ccode == null) {
                ccode = lang.toUpperCase();
            }
        }
        lang = lcode + "-" + ccode;
        this.locale = new Locale(lcode, ccode);
        if (lcode.equals("ja") || lcode.equals("zh") || lcode.equals("th")) {
            AppPreferences.noWordSeparatorTargetLanguage = true;
            this.noSpaceAfterPeriodTargetLanguage = true;
            Prompter.imputMethodsOverlapping = lcode.equals("ja");
        } else {
            AppPreferences.noWordSeparatorTargetLanguage = false;
            this.noSpaceAfterPeriodTargetLanguage = false;
            Prompter.imputMethodsOverlapping = false;
        }
        this.setSpellChecker(lcode + "_" + ccode);
        this.xliffview.topui.getTargetView().setTextComponentOrientation(this.locale);
        this.xliffview.topui.getResourceView().getTextShortcuts().setDefaultShortcuts(this.locale);
        NumbersHelper.setTargetLocale(this.locale);
        return lang;
    }

    private String setSrcLocale(String lang) {
        String ccode;
        String lcode;
        int v = lang.indexOf(45);
        if (v == -1) {
            v = lang.indexOf(95);
        }
        if (v != -1) {
            lcode = lang.substring(0, v).toLowerCase();
            ccode = lang.substring(v + 1).toUpperCase();
        } else {
            lcode = lang.toLowerCase();
            ccode = LanguageCodes.getCountryCodeforLanguage(lcode);
            if (ccode == null) {
                ccode = lang.toUpperCase();
            }
        }
        lang = lcode + "-" + ccode;
        this.srclocale = new Locale(lcode, ccode);
        if (this.srclocale.getLanguage().equals("ja") || this.srclocale.getLanguage().equals("zh")) {
            this.noSpaceAfterPeriodSourceLanguage = true;
            AppPreferences.noWordSeparatorSourceLanguage = true;
            AppPreferences.userBreakIteratorTokenizer = false;
        } else if (this.srclocale.getLanguage().equals("th")) {
            this.noSpaceAfterPeriodSourceLanguage = false;
            AppPreferences.noWordSeparatorSourceLanguage = true;
            AppPreferences.userBreakIteratorTokenizer = true;
        } else {
            this.noSpaceAfterPeriodSourceLanguage = false;
            AppPreferences.noWordSeparatorSourceLanguage = false;
            AppPreferences.userBreakIteratorTokenizer = false;
        }
        this.setAbbreviations(lcode + "_" + ccode);
        StopWords.setStopWords(lcode);
        this.xliffview.topui.getSourceView().setTextComponentOrientation(this.srclocale);
        NumbersHelper.setSourceLocale(this.srclocale);
        return lang;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getSrcLocale() {
        return this.srclocale;
    }

    public void setView(XliffView view) {
        this.xliffview = view;
    }

    public XliffView getView() {
        return this.xliffview;
    }

    public XliffMenu getMenu() {
        return this.xliffview.getMenu();
    }

    public void setWorkflow(XliffWorkflow flow) {
        xworkflow = flow;
    }

    public XliffWorkflow getWorkflow() {
        return xworkflow;
    }

    public void edit(String s) {
        if (s.startsWith("#")) {
            String tuid = s.substring(1);
            int j = tuid.indexOf(95);
            if (j != -1) {
                String tuid2 = tuid.substring(0, j);
                char c = tuid.charAt(j + 1);
                if (c == 'N') {
                    String nid = tuid.substring(j + 2);
                    List tus = this.xliffview.getViewUnits();
                    XLIFFUnit tu = (XLIFFUnit)tus.get(Integer.parseInt(tuid2));
                    if (tu != null) {
                        List notes = tu.getNotes();
                        DefaultXMLElement elem = (DefaultXMLElement)notes.get(Integer.parseInt(nid));
                        int k = this.xliffview.getMenu().showXMLElement(elem);
                        if (k == 0) {
                            if (this.isExternalToolXLIFF) {
                                List list = this.getChildren("doc-info");
                                if (!list.isEmpty()) {
                                    XMLElement docInfo = (XMLElement)list.get(0);
                                    tu.removeMrkTagComment(docInfo);
                                    tu.removeNote(elem);
                                    int current = this.xliffview.getCurrentTUIndex();
                                    if (current >= 0) {
                                        xworkflow.setCheckStart(current);
                                    }
                                    xworkflow.checkNextTU();
                                } else {
                                    tu.removeNote(elem);
                                    int current = this.xliffview.getCurrentTUIndex();
                                    this.xliffview.browseToUnit(current);
                                }
                            } else {
                                tu.removeNote(elem);
                                int current = this.xliffview.getCurrentTUIndex();
                                this.xliffview.browseToUnit(current);
                            }
                        }
                    }
                } else if (c == 'A') {
                    String nid = tuid.substring(j + 2);
                    List tus = this.xliffview.getViewUnits();
                    XLIFFUnit tu = (XLIFFUnit)tus.get(Integer.parseInt(tuid2));
                    if (tu != null) {
                        int k;
                        AltTrans alt;
                        XMLElement atut;
                        List atrans = tu.getAltTrans();
                        int na = Integer.parseInt(nid);
                        if (na < atrans.size() && (atut = (alt = (AltTrans)atrans.get(na)).getTarget()) != null && (k = this.xliffview.getMenu().showXMLElement(atut)) == 0) {
                            tu.removeChild(alt);
                            int current = this.xliffview.getCurrentTUIndex();
                            this.xliffview.browseToUnit(current);
                        }
                    }
                }
            } else {
                int i = Integer.parseInt(tuid);
                if (i == -1) {
                    xworkflow.checkNextTU();
                } else if (i == -2) {
                    xworkflow.checkPreviousTU();
                } else if (i == -3) {
                    xworkflow.joinTU();
                } else if (i == -4) {
                    int current = this.xliffview.getCurrentTUIndex();
                    this.xliffview.browseToUnit(current);
                } else {
                    XLIFFUnit tu;
                    String t;
                    if (xworkflow.isTargetSegmentEmpty() && (t = this.xliffview.topui.getWorkflowView().getWorkflowManager().getWorkflow().getTarget()) != null && t.length() > 0 && (tu = xworkflow.getCheckTransUnit()) != null) {
                        tu.setSegmentUnconfirmed(t);
                    }
                    if (i >= 0) {
                        xworkflow.setCheckStart(i);
                    }
                    xworkflow.checkNextTU();
                }
            }
        }
    }

    public void prepareTransUnit() {
        FileBody body = this.currentFile.getBody();
        int fid = this.currentFile.getFileID();
        XLIFFUnit temp = body.getCurrentTU();
        XLIFFUnit tunit = new XLIFFUnit(this.id, fid, -1, 0);
        if (fid != this.currentFileID) {
            tunit.first = true;
            this.currentFileID = fid;
        }
        tunit.setName("trans-unit");
        DefaultXMLElement tus = new DefaultXMLElement();
        tus.setName("source");
        DefaultXMLElement tut = new DefaultXMLElement();
        tut.setName("target");
        tut.setAttribute("state", "new");
        if (temp == null) {
            tus.setAttribute("xml:lang", this.currentFile.getAttribute("source-language"));
            tut.setAttribute("xml:lang", this.currentFile.getAttribute("target-language"));
        } else {
            List contexts = temp.getContextGroups();
            if (contexts != null) {
                for (ContextGroup cg : contexts) {
                    tunit.addChild(cg);
                }
            }
            XMLElement ttus = temp.getSource();
            XMLElement ttut = temp.getTarget();
            if (ttus != null) {
                tus.setAttribute("xml:lang", ttus.getAttribute("xml:lang"));
            }
            if (ttut != null) {
                tut.setAttribute("xml:lang", ttut.getAttribute("xml:lang"));
            }
        }
        int no = body.getTUCount() + 1;
        tunit.setAttribute("id", String.valueOf(no));
        tunit.setSource(tus);
        tunit.setTarget(tut);
        this.currentFile.getBody().setCurrentTU(tunit);
    }

    public void setSegmentSeparator(String sep) {
        this.tags = Pattern.compile(sep);
    }

    public void createTransUnit(String source, String target, String segBreak, int position, int length, int tustate, String note) {
        FileBody body;
        XLIFFUnit tunit;
        if (source != null && (tunit = (body = this.currentFile.getBody()).getCurrentTU()) != null) {
            XMLElement tut;
            XMLElement tus = tunit.getSource();
            if (tus != null) {
                Matcher ma = this.tags.matcher(source);
                int st = 0;
                while (ma.find()) {
                    String id;
                    int b = ma.start();
                    int e = ma.end();
                    String group = ma.group();
                    String cont = source.substring(st, b);
                    DefaultXMLElement x = new DefaultXMLElement();
                    x.setName("x");
                    int idIndex = group.indexOf("id=\"");
                    if (idIndex != -1) {
                        id = group.substring(idIndex + 4, group.indexOf("\"", idIndex + 4));
                        x.setAttribute("id", id);
                    }
                    if ((idIndex = group.indexOf("ctype=\"")) != -1) {
                        id = group.substring(idIndex + 7, group.indexOf("\"", idIndex + 7));
                        x.setAttribute("ctype", id);
                    }
                    if ((idIndex = group.indexOf("equiv-text=\"")) != -1) {
                        id = group.substring(idIndex + 12, group.indexOf("\"", idIndex + 12));
                        x.setAttribute("equiv-text", id);
                    }
                    if ((idIndex = group.indexOf("entity=\"")) != -1) {
                        id = group.substring(idIndex + 8, group.indexOf("\"", idIndex + 8));
                        x.setAttribute("text:entity", id);
                    }
                    if (b > 0) {
                        tus.addChild(cont);
                    }
                    tus.addChild(x);
                    st = e;
                }
                int le = source.length();
                if (st <= le) {
                    tus.addChild(source.substring(st, le));
                } else if (st == 0) {
                    tus.addChild(source);
                }
                if (segBreak != null) {
                    tus.setAttribute("text:break", segBreak);
                }
                tus.setAttribute("text:position", String.valueOf(position));
                tus.setAttribute("text:length", String.valueOf(length));
            }
            if ((tut = tunit.getTarget()) != null) {
                Matcher ma = this.tags.matcher(target);
                int st = 0;
                while (ma.find()) {
                    String id;
                    int b = ma.start();
                    int e = ma.end();
                    String group = ma.group();
                    String cont = target.substring(st, b);
                    DefaultXMLElement x = new DefaultXMLElement();
                    x.setName("x");
                    int idIndex = group.indexOf("id=\"");
                    if (idIndex != -1) {
                        id = group.substring(idIndex + 4, group.indexOf("\"", idIndex + 4));
                        x.setAttribute("id", id);
                    }
                    if ((idIndex = group.indexOf("ctype=\"")) != -1) {
                        id = group.substring(idIndex + 7, group.indexOf("\"", idIndex + 7));
                        x.setAttribute("ctype", id);
                    }
                    if ((idIndex = group.indexOf("equiv-text=\"")) != -1) {
                        id = group.substring(idIndex + 12, group.indexOf("\"", idIndex + 12));
                        x.setAttribute("equiv-text", id);
                    }
                    if ((idIndex = group.indexOf("entity=\"")) != -1) {
                        id = group.substring(idIndex + 8, group.indexOf("\"", idIndex + 8));
                        x.setAttribute("text:entity", id);
                    }
                    if (b > 0) {
                        tut.addChild(cont);
                    }
                    tut.addChild(x);
                    st = e;
                }
                int le = target.length();
                if (st <= le) {
                    tut.addChild(target.substring(st, le));
                } else if (st == 0) {
                    tut.addChild(target);
                }
                if (tustate == 1) {
                    tut.setAttribute("state", "signed-off");
                    tunit.setState(1);
                } else if (tustate == 4) {
                    tunit.setState(2);
                    tunit.setAttribute("approved", "yes");
                } else {
                    tut.setAttribute("state", "new");
                }
            }
            if (note != null) {
                DefaultXMLElement xnote = new DefaultXMLElement();
                note = XMLHelper.resolveXMLEntities(note);
                xnote.setContent(0, note);
                xnote.setName("note");
                tunit.addChild(xnote);
            }
            body.addTransUnit(tunit);
            if (source.length() > 0) {
                String con = tunit.getSourceText();
                boolean prop = true;
                if (this.isUncleaned || !AppPreferences.propagate) {
                    prop = false;
                }
                this.addToMemory(con, tunit, prop, false);
            }
        }
    }

    public void setTargetPosition(int position, int length, String segBreak) {
        FileBody body = this.currentFile.getBody();
        XLIFFUnit tunit = body.getCurrentTU();
        if (tunit != null) {
            XMLElement tut = tunit.getTarget();
            tut.setAttribute("text:position", String.valueOf(position));
            tut.setAttribute("text:length", String.valueOf(length));
            if (segBreak != null) {
                tut.setAttribute("text:break", segBreak);
            }
        }
    }

    public void createTUNote() {
        XLIFFUnit tunit = null;
        XliffWorkflow flow = this.getWorkflow();
        if (flow != null) {
            tunit = flow.getCheckTransUnit();
        }
        if (tunit == null) {
            FileBody body = this.currentFile.getBody();
            tunit = body.getCurrentTU();
        }
        if (tunit != null) {
            this.getView().getMenu().createNote(tunit);
        }
    }

    public void toggleBookmark() {
        XLIFFUnit tunit = null;
        XliffWorkflow flow = this.getWorkflow();
        if (flow != null) {
            tunit = flow.getCheckTransUnit();
        }
        if (tunit == null) {
            FileBody body = this.currentFile.getBody();
            tunit = body.getCurrentTU();
        }
        if (tunit != null) {
            this.getView().getMenu().toggleBookmark(tunit);
        }
    }

    public void createAltTrans() {
        XLIFFUnit tunit = null;
        XliffWorkflow flow = this.getWorkflow();
        if (flow != null) {
            tunit = flow.getCheckTransUnit();
        }
        if (tunit == null) {
            FileBody body = this.currentFile.getBody();
            tunit = body.getCurrentTU();
        }
        if (tunit != null) {
            this.getView().getMenu().createAltTrans(tunit);
        }
    }

    public void makeBinaryUnit(String url) {
        DefaultXMLElement bsource;
        FileBody body = this.currentFile.getBody();
        BinaryUnit bunit = body.getCurrentBU();
        if (bunit != null && (bsource = bunit.getBinarySource()) != null) {
            List list = bsource.getChildren();
            for (Object o : list) {
                DefaultXMLElement exFile;
                String furl;
                XMLElement xml;
                if (!(o instanceof XMLElement) || !(xml = (XMLElement)o).getName().equals("external-file") || (furl = (exFile = (DefaultXMLElement)xml).getAttribute("href")) == null || !url.equals(furl)) continue;
                return;
            }
        }
        DefaultXMLElement exFile = new DefaultXMLElement();
        exFile.setName("external-file");
        exFile.setAttribute("href", url);
        DefaultXMLElement bsource2 = new DefaultXMLElement();
        bsource2.setName("bin-source");
        bsource2.addChild(exFile);
        bunit = new BinaryUnit();
        bunit.setName("bin-unit");
        bunit.setBinarySource(bsource2);
        int bno = body.getBUCount() + 1;
        String s = bno + "";
        bunit.setAttribute("id", s);
        int dot = url.lastIndexOf(".");
        if (dot != -1) {
            String ext = url.substring(dot + 1, url.length());
            bunit.setAttribute("mime-type", "image/" + ext);
        }
        this.currentFile.getBody().addBinaryUnit(bunit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addToMemory(String source, XLIFFUnit tu, boolean propagate, boolean isLoaded) {
        HashMap projectMemory;
        Object ob;
        List patterns;
        if (NumbersHelper.isExtendedNumber(source)) {
            int[] pos = tu.getSourceTagsPositions();
            int p = pos[0];
            if (p == 0) {
                tu.number = true;
            } else {
                tu.numberTagged = true;
            }
        }
        if (!isLoaded) {
            Placeables.clearCurrentPlaceables();
            Set set = Placeables.getPlaceablesSet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Pattern p;
                String place = it.next().toString();
                if (place.charAt(0) != '|') {
                    int start = source.indexOf(place);
                    if (start == -1) continue;
                    p = Placeables.getPlaceablePattern(place);
                    if (p == null) {
                        String sp = AppPreferences.noWordSeparatorSourceLanguage ? "\\Q" + place + "\\E" : "\\b\\Q" + place + "\\E\\b";
                        p = Pattern.compile(sp);
                        Placeables.putPlaceablePattern(place, p);
                    }
                    Placeables.addCurrentPlaceablePattern(p);
                    continue;
                }
                String place2 = place.substring(1);
                p = Placeables.getPlaceablePattern(place);
                if (p == null) {
                    p = Pattern.compile(place2);
                    Placeables.putPlaceablePattern(place, p);
                }
                Placeables.addCurrentPlaceablePattern(p);
            }
        }
        if (tu.locked && !AppPreferences.propagateFromLockedSegments) {
            return;
        }
        boolean hasTransferable = false;
        String fullSource = source;
        ArrayList<String> slist = null;
        if (AppPreferences.propagateNumbers && !AppPreferences.propagateNontranslatables) {
            Pattern np = NumbersHelper.getNumberPattern();
            Matcher m = np.matcher(source);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                if (slist == null) {
                    slist = new ArrayList<String>();
                }
                hasTransferable = true;
                m.appendReplacement(sb, "");
                String s = m.group();
                if (AppPreferences.formatnumbers) {
                    String t = NumbersHelper.formatLocaleNumber(s);
                    if (!s.equals(t)) {
                        slist.add(t);
                        continue;
                    }
                    slist.add(s);
                    continue;
                }
                slist.add(s);
            }
            m.appendTail(sb);
            source = sb.toString();
        }
        if (AppPreferences.propagateNontranslatables && (patterns = Placeables.getCurrentPlaceablePatterns()) != null) {
            for (Pattern next : patterns) {
                Matcher m = next.matcher(source);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    if (slist == null) {
                        slist = new ArrayList();
                    }
                    hasTransferable = true;
                    m.appendReplacement(sb, "");
                    slist.add(m.group());
                    if (isLoaded) continue;
                    tu.addPlaceablePattern(next);
                }
                m.appendTail(sb);
                source = sb.toString();
            }
        }
        if (source.trim().length() == 0) {
            hasTransferable = false;
            source = fullSource;
        }
        if (hasTransferable) {
            List patterns2;
            XLIFFUnit.placeableTargetReplacementList = new ArrayList();
            String target = tu.getTargetText();
            if (AppPreferences.propagateNumbers && !AppPreferences.propagateNontranslatables) {
                Pattern np = NumbersHelper.getNumberPattern();
                Matcher mt = np.matcher(target);
                while (mt.find()) {
                    int j = slist.indexOf(mt.group());
                    XLIFFUnit.placeableTargetReplacementList.add(j);
                }
            }
            if (AppPreferences.propagateNontranslatables && (patterns2 = Placeables.getCurrentPlaceablePatterns()) != null) {
                for (Pattern next : patterns2) {
                    Matcher mt = next.matcher(target);
                    while (mt.find()) {
                        int n = slist.indexOf(mt.group());
                        XLIFFUnit.placeableTargetReplacementList.add(n);
                    }
                }
            }
        }
        if ((ob = (projectMemory = Project.getProjectMemory()).get(source)) != null) {
            Stack<XLIFFUnit> deck = null;
            if (ob instanceof XLIFFUnit) {
                XLIFFUnit tuu = (XLIFFUnit)ob;
                if (tu.equals(tuu)) return;
                tuu.repetitionFirst = true;
                deck = new Stack<XLIFFUnit>();
                deck.addElement(tuu);
                projectMemory.put(source, deck);
            } else {
                deck = (Stack<XLIFFUnit>)ob;
            }
            if (propagate) {
                String targetNew = null;
                for (Object e : deck) {
                    int state;
                    XLIFFUnit tuu = (XLIFFUnit)e;
                    if (tuu.locked || !AppPreferences.propagateAcrossDocuments && (tu.getProjectID() != tuu.getProjectID() || tu.getFileID() != tuu.getFileID()) || AppPreferences.propagateForwardOnly && tuu.getUnitID() < tu.getUnitID()) continue;
                    if (tu.propagate != tuu.propagate) {
                        tuu.setPropagation(tu.propagate, this.isCafeTranXLIFF);
                    }
                    if (tu.equals(tuu) || !tuu.propagate) continue;
                    String target = tuu.getTargetTextForPropagation();
                    if (targetNew == null) {
                        targetNew = tu.getTargetTextForPropagation();
                    }
                    if (target.length() > 0 && (tuu.number || tuu.numberTagged)) {
                        if (!AppPreferences.propagateStatus || (state = tu.getState()) <= 0) continue;
                        this.setStatus(tuu, state);
                        continue;
                    }
                    if (targetNew.length() > 0 && !target.equals(targetNew)) {
                        int pid;
                        int state2;
                        boolean auto;
                        XMLElement tuss = tuu.getSource();
                        XMLElement tutt = tuu.getTarget();
                        if (tuss == null || tutt == null) continue;
                        boolean tansferPlaceable = false;
                        String fullSource2 = tuu.getSourceText();
                        if (hasTransferable && !tu.numberTagged) {
                            if (!fullSource.equals(fullSource2)) {
                                tansferPlaceable = true;
                            }
                        } else if (!fullSource.equals(fullSource2)) continue;
                        if (this.isCafeTranXLIFF) {
                            auto = tuu.propagate(fullSource2, targetNew, tu.getTargetTagsPositions(), tansferPlaceable);
                            if (!auto) continue;
                            if (AppPreferences.propagateStatus && (state2 = tu.getState()) > 0) {
                                this.setStatus(tuu, state2);
                            }
                            tuu.autopropagated = true;
                            pid = tuu.getProjectID();
                            if (pid != this.id && this.xliffview != null) {
                                this.xliffview.saveFlagProjectFile(pid);
                            }
                            this.saved = false;
                            boolean noteSet = false;
                            List notes = tuu.getNotes();
                            for (int j = 0; j < notes.size(); ++j) {
                                XMLElement note = (XMLElement)notes.get(j);
                                String nc = note.getContent(0).toString();
                                if (nc == null || !nc.startsWith("propagated")) continue;
                                noteSet = true;
                                break;
                            }
                            if (noteSet) continue;
                            DefaultXMLElement note = new DefaultXMLElement();
                            String text = "propagated";
                            note.setContent(0, text);
                            note.setName("note");
                            tuu.addChild(note);
                            continue;
                        }
                        auto = tuu.propagateSDL(fullSource2, targetNew, tu.getTargetTagsPositions(), tansferPlaceable);
                        if (!auto) continue;
                        if (AppPreferences.propagateStatus && (state2 = tu.getState()) > 0) {
                            this.setStatus(tuu, state2);
                        }
                        tuu.autopropagated = true;
                        pid = tuu.getProjectID();
                        if (pid != this.id && this.xliffview != null) {
                            this.xliffview.saveFlagProjectFile(pid);
                        }
                        this.saved = false;
                        continue;
                    }
                    if (targetNew.length() <= 0 || !AppPreferences.propagateStatus || (state = tu.getState()) <= 0) continue;
                    this.setStatus(tuu, state);
                    tuu.autopropagated = true;
                    int pid = tuu.getProjectID();
                    if (pid != this.id && this.xliffview != null) {
                        this.xliffview.saveFlagProjectFile(pid);
                    }
                    this.saved = false;
                }
            }
            tu.repetition = true;
            deck.remove(tu);
            deck.add(0, tu);
            return;
        } else {
            projectMemory.put(source, tu);
            if (fullSource == null) return;
            projectMemory.put(fullSource, tu);
        }
    }

    public String getFromMemory(String source, String[] tags) {
        Object o = Project.getProjectMemory().get(source);
        if (o != null) {
            XLIFFUnit tu2 = null;
            if (o instanceof XLIFFUnit) {
                tu2 = (XLIFFUnit)o;
                String t = tu2.getTargetTextForPropagation();
                if (t.length() > 0) {
                    if (tags != null) {
                        int[] pos = tu2.getTargetTagsPositions();
                        t = this.setTargetTags(t, tags, pos);
                    }
                    return t;
                }
                return null;
            }
            Stack deck = (Stack)o;
            String t = null;
            for (XLIFFUnit tu2 : deck) {
                t = tu2.getTargetTextForPropagation();
                if (t.length() <= 0) continue;
                if (tags == null) break;
                int[] pos = tu2.getTargetTagsPositions();
                t = this.setTargetTags(t, tags, pos);
                break;
            }
            return t;
        }
        return null;
    }

    private String setTargetTags(String target, String[] tags, int[] pos) {
        int off = 0;
        StringBuffer sb = new StringBuffer(target);
        for (int i = 0; i < pos.length; ++i) {
            int j = pos[i];
            String tag = tags[i];
            if (j <= 0 || tag == null) break;
            if (sb.length() <= j + off) continue;
            sb = sb.insert(j + off, tag);
            off += tag.length();
        }
        return sb.toString();
    }

    public StringBuffer toAutoCompletion() {
        StringBuffer sb = new StringBuffer();
        List pfiles = this.getFiles();
        if (pfiles != null) {
            for (XliffFile file : pfiles) {
                FileBody body = file.getBody();
                if (body == null) continue;
                List tus = body.getTransUnits();
                this.takeTUContent(tus, sb);
            }
        }
        return sb;
    }

    private void takeTUContent(Collection tus, StringBuffer sb) {
        for (XLIFFUnit tunit : tus) {
            String content = tunit.getTargetText();
            if (content.length() <= 0) continue;
            sb.append(content);
            sb.append(" ");
        }
    }

    public int getLastSourcePosition() {
        XMLElement source;
        int pos = -1;
        FileBody body = this.currentFile.getBody();
        XLIFFUnit tu = body.getCurrentTU();
        if (tu != null && (source = tu.getSource()) != null && pos == -1) {
            String spos = source.getAttribute("text:position");
            String slen = source.getAttribute("text:length");
            if (spos != null) {
                pos = new Integer(spos) + new Integer(slen);
            }
        }
        return pos;
    }

    public int getLastTargetPosition() {
        XMLElement target;
        XLIFFUnit tu;
        int pos = -1;
        FileBody body = this.currentFile.getBody();
        List list = body.getTransUnits();
        if (list != null && list.size() > 0 && (tu = (XLIFFUnit)list.get(list.size() - 1)) != null && (target = tu.getTarget()) != null && pos == -1) {
            String spos = target.getAttribute("text:position");
            String slen = target.getAttribute("text:length");
            if (spos != null) {
                pos = new Integer(spos) + new Integer(slen);
            }
        }
        return pos;
    }

    public void searchFile(String s, String r, int mode) {
        this.xliffview.search(s, r, mode);
    }

    public void viewRange(int from, int to) {
        this.xliffview.viewRange(from, to);
    }

    public void sort() {
        this.xliffview.sort();
    }

    public void sortByLength(boolean longToShort) {
        this.xliffview.sortByLength(longToShort);
    }

    public String previewUnclean(Document sdoc) {
        int tuno = 0;
        FileBody body = this.currentFile.getBody();
        body.setCurrentTU(null);
        String targetString = null;
        List units = body.getTransUnits();
        int size = units.size();
        ProgressMonitor pm = new ProgressMonitor(this.xliffview.topui, "Exporting translation...", null, 0, size);
        int length = sdoc.getLength();
        if (length > 0 && body.getCurrentBU() == null) {
            StringBuffer sbuffer = new StringBuffer(length);
            for (XLIFFUnit tu : units) {
                XMLElement tus = tu.getSource();
                XMLElement tut = tu.getTarget();
                if (tus != null && tut != null) {
                    String con;
                    String id;
                    String name;
                    XMLElement el;
                    List li = tus.getChildren();
                    for (Object object : li) {
                        if (object instanceof XMLElement) {
                            el = (XMLElement)object;
                            name = el.getName();
                            if (!name.equals("x") || (id = el.getAttribute("id")) == null) continue;
                            id = XMLHelper.resolveEntitiesXML(id);
                            sbuffer.append(id);
                            continue;
                        }
                        con = object.toString();
                        sbuffer.append(con);
                    }
                    li = tut.getChildren();
                    for (Object object : li) {
                        if (object instanceof XMLElement) {
                            el = (XMLElement)object;
                            name = el.getName();
                            if (!name.equals("x") || (id = el.getAttribute("id")) == null) continue;
                            id = XMLHelper.resolveEntitiesXML(id);
                            sbuffer.append(id);
                            continue;
                        }
                        con = object.toString();
                        sbuffer.append(con);
                    }
                }
                pm.setProgress(++tuno);
            }
            targetString = sbuffer.toString();
        }
        return targetString;
    }

    public String translateUnclean(Document sdoc) {
        int tuno = 0;
        FileBody body = this.currentFile.getBody();
        body.setCurrentTU(null);
        int length = sdoc.getLength();
        StringBuffer sbuffer = new StringBuffer(length);
        try {
            List units = body.getTransUnits();
            int size = units.size();
            ProgressMonitor pm = new ProgressMonitor(this.xliffview.topui, "Exporting translation...", null, 0, size);
            if (length > 0 && body.getCurrentBU() == null) {
                for (XLIFFUnit tu : units) {
                    XMLElement tus = tu.getSource();
                    XMLElement tut = tu.getTarget();
                    if (tus != null && tut != null) {
                        String con;
                        String id;
                        String name;
                        XMLElement el;
                        List li = tus.getChildren();
                        for (Object object : li) {
                            if (object instanceof XMLElement) {
                                el = (XMLElement)object;
                                name = el.getName();
                                if (!name.equals("x") || (id = el.getAttribute("id")) == null) continue;
                                id = XMLHelper.resolveEntitiesXML(id);
                                sbuffer.append(id);
                                continue;
                            }
                            con = object.toString();
                            sbuffer.append(con);
                        }
                        li = tut.getChildren();
                        for (Object object : li) {
                            if (object instanceof XMLElement) {
                                el = (XMLElement)object;
                                name = el.getName();
                                if (!name.equals("x") || (id = el.getAttribute("id")) == null) continue;
                                id = XMLHelper.resolveEntitiesXML(id);
                                sbuffer.append(id);
                                continue;
                            }
                            con = object.toString();
                            sbuffer.append(con);
                        }
                        tut.setAttribute("state", "translated");
                    }
                    pm.setProgress(++tuno);
                }
                sdoc.remove(0, length);
                sdoc.insertString(0, sbuffer.toString(), null);
                this.currentFile.setCurrentPhase("End");
                String tlang = this.currentFile.getAttribute("target-language");
                if (tlang != null) {
                    sdoc.putProperty("target-lang", tlang);
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        return sbuffer.toString();
    }

    public int translateToHTMLClipboard(Document sdoc) {
        int tuno = 0;
        FileBody body = this.currentFile.getBody();
        body.setCurrentTU(null);
        try {
            List units = body.getTransUnits();
            int length = sdoc.getLength();
            if (length > 0) {
                StringBuilder sbuffer = new StringBuilder(length);
                int pos = 0;
                int head = 0;
                String allSource = sdoc.getText(0, length);
                ListIterator i = units.listIterator();
                while (i.hasNext()) {
                    XLIFFUnit tu = (XLIFFUnit)i.next();
                    XMLElement tus = tu.getSource();
                    XMLElement tut = tu.getTarget();
                    if (tus != null && tut != null) {
                        String attr = tut.getAttribute("state");
                        if (attr != null && attr.equals("translated")) continue;
                        StringBuilder ft = new StringBuilder();
                        int start = 0;
                        String tt = tu.getTargetText();
                        String t = tt.length() == 0 ? tu.getSourceXMLText() : tu.getTargetXMLText();
                        int len = t.length();
                        if (start < len) {
                            ft.append(t.substring(start));
                        }
                        tut.setAttribute("state", "translated");
                        t = ft.toString();
                        String spos = tus.getAttribute("text:position");
                        String slen = tus.getAttribute("text:length");
                        if (spos != null && slen != null) {
                            pos = new Integer(spos);
                            int ilen = new Integer(slen);
                            if (pos >= head && pos < allSource.length()) {
                                String border = allSource.substring(head, pos);
                                if (t.length() > 0) {
                                    sbuffer.append(border);
                                }
                                sbuffer.append(t);
                                head = pos + ilen;
                            } else {
                                sbuffer.append(t);
                                head = pos + ilen;
                            }
                        }
                    }
                    ++tuno;
                }
                if (head >= 0 && head < allSource.length()) {
                    sbuffer.append(allSource.substring(head, allSource.length()));
                }
                String trans = sbuffer.toString();
                trans = trans.replaceAll("\r*\n", "<br>");
                sdoc.remove(0, length);
                sdoc.insertString(0, trans.trim(), null);
            } else {
                StringBuilder sb = new StringBuilder();
                ListIterator i = units.listIterator();
                while (i.hasNext()) {
                    XLIFFUnit tu = (XLIFFUnit)i.next();
                    XMLElement tut = tu.getTarget();
                    if (tut == null) continue;
                    String tt = tu.getTargetXMLText();
                    sb.append(tt);
                    sb.append("<br>");
                }
                sdoc.insertString(0, sb.toString(), null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
        return tuno;
    }

    public int translateToClipboard(Document sdoc) {
        int tuno = 0;
        FileBody body = this.currentFile.getBody();
        body.setCurrentTU(null);
        try {
            List units = body.getTransUnits();
            int length = sdoc.getLength();
            if (length > 0) {
                StringBuilder sbuffer = new StringBuilder(length);
                int pos = 0;
                int head = 0;
                String allSource = sdoc.getText(0, length);
                ListIterator i = units.listIterator();
                while (i.hasNext()) {
                    XLIFFUnit tu = (XLIFFUnit)i.next();
                    XMLElement tus = tu.getSource();
                    XMLElement tut = tu.getTarget();
                    if (tus != null && tut != null) {
                        String attr = tut.getAttribute("state");
                        if (attr != null && attr.equals("translated")) continue;
                        StringBuilder ft = new StringBuilder();
                        int start = 0;
                        String tt = tu.getTargetText();
                        String t = tt.length() == 0 ? tu.getSourceString() : tu.getTargetString();
                        int len = t.length();
                        if (start < len) {
                            ft.append(t.substring(start));
                        }
                        tut.setAttribute("state", "translated");
                        t = ft.toString();
                        String spos = tus.getAttribute("text:position");
                        String slen = tus.getAttribute("text:length");
                        if (spos != null && slen != null) {
                            pos = new Integer(spos);
                            int ilen = new Integer(slen);
                            if (pos >= head && pos < allSource.length()) {
                                String border = allSource.substring(head, pos);
                                if (t.length() > 0) {
                                    sbuffer.append(border);
                                }
                                sbuffer.append(t);
                                head = pos + ilen;
                            } else {
                                sbuffer.append(t);
                                head = pos + ilen;
                            }
                        }
                    }
                    ++tuno;
                }
                if (head >= 0 && head < allSource.length()) {
                    sbuffer.append(allSource.substring(head, allSource.length()));
                }
                sdoc.remove(0, length);
                sdoc.insertString(0, sbuffer.toString().trim(), null);
            } else {
                StringBuilder sb = new StringBuilder();
                ListIterator i = units.listIterator();
                while (i.hasNext()) {
                    XLIFFUnit tu = (XLIFFUnit)i.next();
                    XMLElement tut = tu.getTarget();
                    if (tut == null) continue;
                    String tt = tu.getTargetText();
                    sb.append(tt);
                    sb.append("\n");
                }
                sdoc.insertString(0, sb.toString(), null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
        return tuno;
    }

    public String translate(Document sdoc) {
        String format = this.currentFile.getAttribute("datatype");
        if (format != null && (format.equals("x-clipboard") || format.equals("x-image"))) {
            if (!AppPreferences.clipboardHTMLExport) {
                this.translateToClipboard(sdoc);
            } else {
                this.translateToHTMLClipboard(sdoc);
            }
            return null;
        }
        int tuno = 0;
        FileBody body = this.currentFile.getBody();
        body.setCurrentTU(null);
        int length = sdoc.getLength();
        StringBuffer sbuffer = new StringBuffer(length);
        try {
            List units = body.getTransUnits();
            int size = units.size();
            ProgressMonitor pm = new ProgressMonitor(this.xliffview.topui, "Exporting translation...", null, 0, size);
            if (length > 0 && body.getCurrentBU() == null) {
                String tsegFormat = "(<x id=[^>]*>)+?";
                Pattern segtags = Pattern.compile(tsegFormat);
                String s = null;
                String t = null;
                int pos = 0;
                int head = 0;
                String allSource = sdoc.getText(0, length);
                for (XLIFFUnit tu : units) {
                    XMLElement tus = tu.getSource();
                    XMLElement tut = tu.getTarget();
                    if (tus != null && tut != null) {
                        StringBuilder ft = new StringBuilder();
                        s = tu.getSourceString();
                        String tt = tu.getTargetText();
                        t = tt.length() == 0 ? s : tu.getTargetString();
                        if (this.noSpaceAfterPeriodSourceLanguage && !this.noSpaceAfterPeriodTargetLanguage && s.length() > 0 && t.length() > 0) {
                            char c1 = s.charAt(s.length() - 1);
                            char c2 = t.charAt(t.length() - 1);
                            if (!(c1 != '\u3002' && c1 != '\uff1f' && c1 != '\uff01' && c1 != '\uff1a' && c1 != '\uff1b' || c2 != '.' && c2 != '?' && c2 != '!' && c2 != ':' && c2 != ';' && c2 != '>')) {
                                t = t + " ";
                            }
                        }
                        Matcher sma = segtags.matcher(s);
                        Matcher tma = segtags.matcher(t);
                        int len = t.length();
                        int start = 0;
                        while (sma.find()) {
                            String stag = sma.group();
                            if (tma.find()) {
                                int sstart = tma.start();
                                int end = tma.end();
                                String ttag = tma.group();
                                if (ttag.equals(stag)) {
                                    ft.append(t.substring(start, end));
                                } else {
                                    ft.append(t.substring(start, sstart));
                                    ft.append(stag);
                                }
                                start = end;
                                continue;
                            }
                            ft.append(stag);
                        }
                        while (tma.find()) {
                            start = tma.end();
                        }
                        if (start < len) {
                            ft.append(t.substring(start));
                        }
                        tut.setAttribute("state", "translated");
                        t = ft.toString();
                        String spos = tus.getAttribute("text:position");
                        String slen = tus.getAttribute("text:length");
                        if (spos != null && slen != null) {
                            pos = new Integer(spos);
                            int ilen = new Integer(slen);
                            if (pos >= head) {
                                String border = allSource.substring(head, pos);
                                if (t.length() > 0) {
                                    sbuffer.append(border);
                                }
                                sbuffer.append(t);
                                head = pos + ilen;
                            } else {
                                sbuffer.append(t);
                                head = pos + ilen;
                            }
                            int tarPos = sbuffer.length();
                            int tarLen = t.length();
                            tut.setAttribute("text:position", String.valueOf(tarPos));
                            tut.setAttribute("text:length", String.valueOf(tarLen));
                        }
                    }
                    pm.setProgress(++tuno);
                }
                if (head >= 0 && head < allSource.length()) {
                    sbuffer.append(allSource.substring(head, allSource.length()));
                }
                this.currentFile.setCurrentPhase("End");
                String tlang = this.currentFile.getAttribute("target-language");
                if (tlang != null) {
                    sdoc.putProperty("target-lang", tlang);
                }
            } else {
                String t = null;
                sbuffer = new StringBuffer();
                for (XLIFFUnit tu : units) {
                    XMLElement tut = tu.getTarget();
                    if (tut != null) {
                        tut.setAttribute("state", "translated");
                        t = tu.getTargetText();
                        if (t != null && t.length() > 0) {
                            sbuffer.append(t);
                            sbuffer.append("\n");
                        }
                    }
                    pm.setProgress(++tuno);
                }
                sdoc.insertString(0, sbuffer.toString(), null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        return sbuffer.toString();
    }

    public String preview2(Document sdoc) {
        String allSource = "";
        try {
            FileBody body = this.currentFile.getBody();
            List units = body.getTransUnits();
            allSource = sdoc.getText(0, sdoc.getLength());
            for (XLIFFUnit tu : units) {
                XMLElement tus = tu.getSource();
                XMLElement tut = tu.getTarget();
                if (tus == null || tut == null) continue;
                String s = tu.getSourceString();
                String t = tu.getTargetText();
                if (t.length() == 0) continue;
                t = tu.getTargetString();
                Pattern pattern = Pattern.compile(s, 16);
                Matcher matcher = pattern.matcher(allSource);
                StringBuffer sb = new StringBuffer();
                if (matcher.find()) {
                    matcher.appendReplacement(sb, t);
                    matcher.appendTail(sb);
                    allSource = sb.toString();
                    continue;
                }
                if (!s.startsWith("<x id") || !t.startsWith("<x id")) continue;
                s = s.substring(s.indexOf(">") + 1);
                t = t.substring(t.indexOf(">") + 1);
                if (s.length() <= 0 || t.length() <= 0) continue;
                StringBuffer sb2 = new StringBuffer();
                Pattern pattern2 = Pattern.compile(s, 16);
                Matcher matcher2 = pattern2.matcher(allSource);
                if (!matcher2.find()) continue;
                matcher2.appendReplacement(sb2, t);
                matcher2.appendTail(sb2);
                allSource = sb2.toString();
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(XLIFF.class.getName()).log(Level.SEVERE, null, ex);
        }
        return allSource;
    }

    public String preview(Document sdoc) {
        int tuno = 0;
        String targetString = null;
        FileBody body = this.currentFile.getBody();
        try {
            List units = body.getTransUnits();
            int size = units.size();
            ProgressMonitor pm = new ProgressMonitor(this.xliffview.topui, "Exporting translation...", null, 0, size);
            int length = sdoc.getLength();
            if (length > 0 && body.getCurrentBU() == null) {
                String tsegFormat = "(<x id=[^>]*>)";
                Pattern segtags = Pattern.compile(tsegFormat);
                String s = null;
                String t = null;
                StringBuffer sbuffer = new StringBuffer(length);
                int pos = 0;
                int head = 0;
                String allSource = sdoc.getText(0, length);
                for (XLIFFUnit tu : units) {
                    XMLElement tus = tu.getSource();
                    XMLElement tut = tu.getTarget();
                    if (tus != null && tut != null) {
                        StringBuffer ft = new StringBuffer();
                        s = tu.getSourceString();
                        String tt = tu.getTargetText();
                        t = tt.length() == 0 ? (!this.emptyTargetSegments ? s : tt) : tu.getTargetString();
                        if (this.noSpaceAfterPeriodSourceLanguage && !this.noSpaceAfterPeriodTargetLanguage && s.length() > 0 && t.length() > 0) {
                            char c1 = s.charAt(s.length() - 1);
                            char c2 = t.charAt(t.length() - 1);
                            if (!(c1 != '\u3002' && c1 != '\uff1f' && c1 != '\uff01' && c1 != '\uff1a' && c1 != '\uff1b' || c2 != '.' && c2 != '?' && c2 != '!' && c2 != ':' && c2 != ';' && c2 != '>')) {
                                t = t + " ";
                            }
                        }
                        Matcher sma = segtags.matcher(s);
                        Matcher tma = segtags.matcher(t);
                        int len = t.length();
                        int start = 0;
                        while (sma.find()) {
                            String stag = sma.group();
                            if (tma.find()) {
                                int sstart = tma.start();
                                int end = tma.end();
                                String ttag = tma.group();
                                if (ttag.equals(stag)) {
                                    ft.append(t.substring(start, end));
                                } else {
                                    ft.append(t.substring(start, sstart));
                                    ft.append(stag);
                                }
                                start = end;
                                continue;
                            }
                            ft.append(stag);
                        }
                        while (tma.find()) {
                            start = tma.end();
                        }
                        if (start < len) {
                            ft.append(t.substring(start));
                        }
                        t = ft.toString();
                        String spos = tus.getAttribute("text:position");
                        String slen = tus.getAttribute("text:length");
                        if (spos != null && slen != null) {
                            pos = new Integer(spos);
                            int ilen = new Integer(slen);
                            if (pos >= head) {
                                String border = allSource.substring(head, pos);
                                if (t.length() > 0) {
                                    sbuffer.append(border);
                                }
                                sbuffer.append(t);
                                head = pos + ilen;
                            } else {
                                sbuffer.append(t);
                                head = pos + ilen;
                            }
                        }
                    }
                    pm.setProgress(++tuno);
                }
                if (head >= 0 && head < allSource.length()) {
                    int k;
                    String tail = allSource.substring(head, allSource.length());
                    String e = tail.trim();
                    if (!e.startsWith("<x id=") && e.endsWith("/>") && (k = tail.lastIndexOf("<x id=")) != -1) {
                        tail = tail.substring(k);
                    }
                    sbuffer.append(tail);
                }
                targetString = sbuffer.toString();
            } else {
                String t = null;
                StringBuffer sbuffer = new StringBuffer();
                for (XLIFFUnit tu : units) {
                    XMLElement tut = tu.getTarget();
                    if (tut != null && (t = tu.getTargetText()) != null && t.length() > 0) {
                        sbuffer.append(t);
                        sbuffer.append("\n");
                    }
                    pm.setProgress(++tuno);
                }
                targetString = sbuffer.toString();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        return targetString;
    }

    public List getCTNotes() {
        return this.ctnotes;
    }

    public String previewWithNotes(Document sdoc) {
        int tuno = 0;
        String targetString = null;
        FileBody body = this.currentFile.getBody();
        this.ctnotes = new ArrayList();
        try {
            List units = body.getTransUnits();
            int size = units.size();
            ProgressMonitor pm = new ProgressMonitor(this.xliffview.topui, "Exporting translation...", null, 0, size);
            int length = sdoc.getLength();
            if (length > 0 && body.getCurrentBU() == null) {
                String tsegFormat = "(<x id=[^>]*>)";
                Pattern segtags = Pattern.compile(tsegFormat);
                StringBuilder sbuffer = new StringBuilder(length);
                int head = 0;
                String allSource = sdoc.getText(0, length);
                for (XLIFFUnit tu : units) {
                    XMLElement tus = tu.getSource();
                    XMLElement tut = tu.getTarget();
                    if (tus != null && tut != null) {
                        StringBuilder ft = new StringBuilder();
                        String s = tu.getSourceString();
                        String tt = tu.getTargetText();
                        String t = tt.length() == 0 ? (!this.emptyTargetSegments ? s : tt) : tu.getTargetString();
                        if (this.noSpaceAfterPeriodSourceLanguage && !this.noSpaceAfterPeriodTargetLanguage && s.length() > 0 && t.length() > 0) {
                            char c1 = s.charAt(s.length() - 1);
                            char c2 = t.charAt(t.length() - 1);
                            if (!(c1 != '\u3002' && c1 != '\uff1f' && c1 != '\uff01' && c1 != '\uff1a' && c1 != '\uff1b' || c2 != '.' && c2 != '?' && c2 != '!' && c2 != ':' && c2 != ';' && c2 != '>')) {
                                t = t + " ";
                            }
                        }
                        List notes = tu.getNotes();
                        StringBuilder sbNotes = new StringBuilder();
                        if (notes != null && notes.size() > 0) {
                            for (DefaultXMLElement c : notes) {
                                String con;
                                Object o = c.getContent(0);
                                if (o == null || (con = o.toString()).length() <= 0 || con.equals("propagated")) continue;
                                sbNotes.append(con);
                            }
                            if (sbNotes.length() > 0) {
                                if (AppPreferences.includeSourceinNotes) {
                                    String ss = tu.getSourceText();
                                    sbNotes.append("-seg-");
                                    sbNotes.append(ss);
                                }
                                StringBuilder buf = new StringBuilder(t);
                                int ns = 0;
                                if (t.startsWith("<x id")) {
                                    ns = t.indexOf(">") + 1;
                                }
                                buf.insert(ns, "<ctnote>");
                                if (t.endsWith("/>")) {
                                    int ne = buf.lastIndexOf("<x id");
                                    buf.insert(ne, "</ctnote>");
                                } else {
                                    buf.append("</ctnote>");
                                }
                                String sn = sbNotes.toString();
                                sn = XMLHelper.resolveXMLEntities(sn);
                                this.ctnotes.add(sn);
                                t = buf.toString();
                            }
                        }
                        Matcher sma = segtags.matcher(s);
                        Matcher tma = segtags.matcher(t);
                        int len = t.length();
                        int start = 0;
                        while (sma.find()) {
                            String stag = sma.group();
                            if (tma.find()) {
                                int sstart = tma.start();
                                int end = tma.end();
                                String ttag = tma.group();
                                if (ttag.equals(stag)) {
                                    ft.append(t.substring(start, end));
                                } else {
                                    ft.append(t.substring(start, sstart));
                                    ft.append(stag);
                                }
                                start = end;
                                continue;
                            }
                            ft.append(stag);
                        }
                        while (tma.find()) {
                            start = tma.end();
                        }
                        if (start < len) {
                            ft.append(t.substring(start));
                        }
                        t = ft.toString();
                        String spos = tus.getAttribute("text:position");
                        String slen = tus.getAttribute("text:length");
                        if (spos != null && slen != null) {
                            int pos = new Integer(spos);
                            int ilen = new Integer(slen);
                            if (pos >= head) {
                                String border = allSource.substring(head, pos);
                                if (t.length() > 0) {
                                    sbuffer.append(border);
                                }
                                sbuffer.append(t);
                                head = pos + ilen;
                            } else {
                                sbuffer.append(t);
                                head = pos + ilen;
                            }
                        }
                    }
                    pm.setProgress(++tuno);
                }
                if (head >= 0 && head < allSource.length()) {
                    sbuffer.append(allSource.substring(head, allSource.length()));
                }
                targetString = sbuffer.toString();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        return targetString;
    }

    public boolean importBilingualFromWord(String skeleton) {
        int size;
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<String> notes = new ArrayList<String>();
        ArrayList<String> statues = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<w:tr[> ].+?</w:tr>", 32);
        Pattern pattern2 = Pattern.compile("<w:tc[> ].+?</w:tc>", 32);
        Pattern pattern3 = Pattern.compile("<w:t[> ].+?</w:t>");
        Pattern pattern4 = Pattern.compile("|", 16);
        Matcher matcher1 = pattern.matcher(skeleton);
        boolean header = false;
        while (matcher1.find()) {
            if (!header) {
                header = true;
                continue;
            }
            String group1 = matcher1.group();
            Matcher matcher2 = pattern2.matcher(group1);
            int i = 0;
            while (matcher2.find()) {
                if (i == 2 || i == 3 || i == 4) {
                    String group2 = matcher2.group();
                    Matcher matcher3 = pattern3.matcher(group2);
                    StringBuilder sb = new StringBuilder();
                    int end = 0;
                    while (matcher3.find()) {
                        int k;
                        int start = matcher3.start();
                        String newline = null;
                        if (end > 0) {
                            newline = group2.substring(end, start);
                        }
                        String group3 = matcher3.group();
                        end = matcher3.end();
                        int j = group3.indexOf(62);
                        String s = group3.substring(j + 1, k = group3.indexOf(60, j));
                        if (s.length() <= 0) continue;
                        if (i == 2 && newline != null && (newline.indexOf("<w:br/>") != -1 || newline.indexOf("</w:p><w:p") != -1)) {
                            sb.append("\n");
                        }
                        s = XMLHelper.resolveEntitiesXML(s);
                        sb.append(s);
                    }
                    if (i == 2) {
                        targets.add(sb.toString());
                    } else if (i == 3) {
                        notes.add(sb.toString());
                    } else if (i == 4) {
                        statues.add(sb.toString());
                    }
                }
                ++i;
            }
        }
        List units = this.getView().getFilteredUnits();
        if (units == null) {
            units = this.getView().getGluedUnits();
            if (units == null) {
                FileBody body = this.currentFile.getBody();
                units = body.getTransUnits();
            }
        } else {
            int i = JOptionPane.showConfirmDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TO FILTER?"), "", 2);
            if (i != 0) {
                return false;
            }
        }
        if ((size = units.size()) == targets.size()) {
            int ind = 0;
            Iterator it = targets.iterator();
            while (it.hasNext()) {
                String t;
                XMLElement tut;
                String s = it.next().toString();
                XLIFFUnit tu = (XLIFFUnit)units.get(ind);
                if (tu.locked) {
                    ++ind;
                    continue;
                }
                if (s.length() > 0 && (tut = tu.getTarget()) != null && !s.equals(t = tu.getReviewTargetString())) {
                    DefaultXMLElement aatarget = new DefaultXMLElement();
                    aatarget.setName("target");
                    List targetElements = tut.getChildren();
                    for (Object next : targetElements) {
                        aatarget.addChild(next);
                    }
                    AltTrans alt = new AltTrans();
                    alt.setName("alt-trans");
                    alt.addChild(aatarget);
                    tu.addChild(alt);
                    Matcher m = pattern4.matcher(s);
                    ArrayList<String> elements = new ArrayList<String>();
                    int end = 0;
                    while (m.find()) {
                        int start = m.start();
                        if (start == 0) {
                            elements.add("");
                        } else {
                            String content = s.substring(end, start);
                            elements.add(content);
                        }
                        elements.add(m.group());
                        end = m.end();
                    }
                    if (end < s.length()) {
                        String content = s.substring(end);
                        elements.add(content);
                    }
                    if (elements.size() > 0) {
                        tu.setReviewTargetString(elements);
                    }
                }
                if (notes.size() > 0) {
                    String note;
                    List onotes = tu.getNotes();
                    if (onotes != null && onotes.size() > 0) {
                        for (DefaultXMLElement c : onotes) {
                            Object o = c.getContent(0);
                            if (o != null) {
                                String con = o.toString();
                                if (con.length() <= 0 || con.equals("propagated")) continue;
                                tu.removeChild(c);
                                continue;
                            }
                            tu.removeChild(c);
                        }
                    }
                    if ((note = (String)notes.get(ind)) != null && note.length() > 0) {
                        DefaultXMLElement xn = new DefaultXMLElement();
                        xn.setName("note");
                        xn.addChild(note);
                        tu.addChild(xn);
                    }
                }
                if (statues.size() > 0 && !AppPreferences.ignoreSegmentStatusAtImport) {
                    String status = (String)statues.get(ind);
                    if (status != null && status.equalsIgnoreCase("C")) {
                        tu.setState(1);
                    } else if (status != null && status.equalsIgnoreCase("A")) {
                        tu.setState(2);
                    } else if (status != null && status.equalsIgnoreCase("R")) {
                        tu.setState(3);
                    } else {
                        tu.setState(0);
                    }
                }
                ++ind;
            }
        }
        return true;
    }

    public String exportBilingualToWord(String name, boolean withNotes) {
        String sl = "";
        String tl = "";
        String nl = "";
        if (this.currentFile != null) {
            sl = this.currentFile.getAttribute("source-language");
            if (sl != null && sl.indexOf(45) != -1) {
                sl = "<w:rPr><w:lang w:val=\"" + sl + "\"/></w:rPr>";
            }
            if ((tl = this.currentFile.getAttribute("target-language")) != null && tl.indexOf(45) != -1) {
                nl = "<w:lang w:val=\"" + tl + "\"/>";
                tl = "<w:rPr><w:lang w:val=\"" + tl + "\"/></w:rPr>";
            }
        }
        String startTable = "<w:tblGrid><w:gridCol w:w=\"600\"/><w:gridCol w:w=\"4606\"/><w:gridCol w:w=\"4606\"/></w:tblGrid>";
        String startTable2 = "<w:tblGrid><w:gridCol w:w=\"600\"/><w:gridCol w:w=\"3500\"/><w:gridCol w:w=\"3500\"/><w:gridCol w:w=\"2212\"/><w:gridCol w:w=\"300\"/></w:tblGrid>";
        String startRow = "<w:tr>";
        String endRow = "</w:tr>";
        String colorPipe = "</w:t></w:r><w:r><w:rPr><w:b/><w:color w:val=\"FF0000\"/></w:rPr><w:t>|</w:t></w:r><w:r>" + sl + "<w:t xml:space=\"preserve\">";
        String noColorPipe = "</w:t></w:r><w:r><w:t>|</w:t></w:r><w:r>" + tl + "<w:t xml:space=\"preserve\">";
        String idHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"600\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String langHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"7000\"/><w:gridSpan w:val=\"2\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String noteHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"2212\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String statusHeaderColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"300\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"595959\"/>\n          </w:tcPr>\n          <w:p><w:pPr><w:jc w:val=\"center\"/></w:pPr>\n            <w:r><w:rPr><w:b/><w:color w:val=\"FFFFFF\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String statusColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"300\"/><w:shd w:val=\"clear\" w:color=\"auto\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>\n              <w:t xml:space=\"preserve\">";
        String statusColumn2 = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"300\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>\n              <w:t xml:space=\"preserve\">";
        String idColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"600\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r><w:rPr><w:sz w:val=\"18\"/></w:rPr>\n              <w:t xml:space=\"preserve\">";
        String startColumnSource = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnSourceChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnSourceNotes = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnSourceNotesChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + sl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTarget = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTargetChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"4606\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTargetNotes = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String startColumnTargetNotesChecked = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"3500\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r>" + tl + "\n              <w:t xml:space=\"preserve\">";
        String noteColumn = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"2212\"/><w:shd w:val=\"clear\" w:color=\"auto\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r><w:rPr><w:i/>" + nl + "</w:rPr>\n              <w:t xml:space=\"preserve\">";
        String noteColumnR = "<w:tc>\n          <w:tcPr>\n            <w:tcW w:type=\"dxa\" w:w=\"2212\"/><w:shd w:val=\"clear\" w:color=\"auto\" w:fill=\"D6E3BC\"/>\n          </w:tcPr>\n          <w:p>\n            <w:r><w:rPr><w:i/>" + nl + "</w:rPr>\n              <w:t xml:space=\"preserve\">";
        String endColumn = "</w:t>\n            </w:r>\n          </w:p>\n        </w:tc>";
        String wBreak = "</w:t></w:r><w:br/><w:r><w:t xml:space=\"preserve\">";
        int tuno = 0;
        String targetString = null;
        List units = this.getView().getFilteredUnits();
        if (units == null) {
            units = this.getView().getGluedUnits();
            if (units == null) {
                FileBody body = this.currentFile.getBody();
                units = body.getTransUnits();
            }
        } else {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT FROM FILTER TO BILINGUAL DOCUMENT. RETURN IMPORT ONLY INTO EXACTLY THE SAME FILTER."));
        }
        int size = units.size();
        ProgressMonitor pm = new ProgressMonitor(this.xliffview.topui, "Exporting translation...", null, 0, size);
        StringBuilder sbuffer = new StringBuilder();
        if (!withNotes) {
            sbuffer.append(startTable);
        } else {
            sbuffer.append(startTable2);
        }
        sbuffer.append(startRow);
        sbuffer.append(idHeaderColumn);
        sbuffer.append("ID");
        sbuffer.append(endColumn);
        sbuffer.append(langHeaderColumn);
        int k = name.indexOf(46);
        if (k != -1) {
            name = name.substring(0, k);
        }
        name = XMLHelper.resolveXMLEntities(name);
        sbuffer.append(name);
        sbuffer.append(endColumn);
        if (withNotes) {
            sbuffer.append(noteHeaderColumn);
            sbuffer.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTES"));
            sbuffer.append(endColumn);
            sbuffer.append(statusHeaderColumn);
            sbuffer.append("*");
            sbuffer.append(endColumn);
        }
        sbuffer.append(endRow);
        boolean odd = false;
        for (XLIFFUnit tu : units) {
            String t;
            String s;
            XMLElement tus = tu.getSource();
            XMLElement tut = tu.getTarget();
            if (tus == null || tut == null) continue;
            int state = tu.getState();
            if (this.isCafeTranXLIFF) {
                s = tu.getReviewSourceString();
                s = XMLHelper.resolveXMLEntities(s);
                s = s.replace("|", colorPipe);
            } else {
                XMLElement e = tu.getSource();
                if (e != null) {
                    s = tu.getElements(e.getChildren(), true);
                    if (s.length() > 0 && s.endsWith("|")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    s = XMLHelper.resolveXMLEntities(s);
                    s = s.replace("|", colorPipe);
                } else {
                    s = "";
                }
            }
            if (this.isCafeTranXLIFF) {
                t = tu.getReviewTargetString();
                t = XMLHelper.resolveXMLEntities(t);
                t = t.replace("|", noColorPipe);
            } else {
                XMLElement e = tu.getTarget();
                if (e != null) {
                    t = tu.getElements(e.getChildren(), true);
                    if (t.length() > 0 && t.endsWith("|")) {
                        t = t.substring(0, t.length() - 1);
                    }
                    t = XMLHelper.resolveXMLEntities(t);
                    t = t.replace("|", colorPipe);
                } else {
                    t = "";
                }
            }
            sbuffer.append(startRow);
            int indexCol = tuno + 1;
            sbuffer.append(idColumn);
            sbuffer.append(Integer.toString(indexCol));
            sbuffer.append(endColumn);
            if (!withNotes) {
                if (state == 1) {
                    sbuffer.append(startColumnSourceChecked);
                } else {
                    sbuffer.append(startColumnSource);
                }
                sbuffer.append(s);
                sbuffer.append(endColumn);
                if (state == 1) {
                    sbuffer.append(startColumnTargetChecked);
                } else {
                    sbuffer.append(startColumnTarget);
                }
                sbuffer.append(t);
                sbuffer.append(endColumn);
            } else {
                if (state == 1) {
                    sbuffer.append(startColumnSourceNotesChecked);
                } else {
                    sbuffer.append(startColumnSourceNotes);
                }
                sbuffer.append(s);
                sbuffer.append(endColumn);
                if (state == 1) {
                    sbuffer.append(startColumnTargetNotesChecked);
                } else {
                    sbuffer.append(startColumnTargetNotes);
                }
                sbuffer.append(t);
                sbuffer.append(endColumn);
                StringBuilder sbNotes = new StringBuilder();
                List notes = tu.getNotes();
                if (notes != null && notes.size() > 0) {
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0 || con.equals("propagated")) continue;
                        sbNotes.append(con);
                    }
                }
                if (state == 1) {
                    sbuffer.append(noteColumnR);
                } else {
                    sbuffer.append(noteColumn);
                }
                String sn = sbNotes.toString();
                if (sn.length() > 0) {
                    sn = XMLHelper.resolveXMLEntities(sn);
                    sn = sn.replace("\n", wBreak);
                    sbuffer.append(sn);
                }
                sbuffer.append(endColumn);
                if (state == 1) {
                    sbuffer.append(statusColumn2);
                    sbuffer.append("C");
                } else if (state == 2) {
                    sbuffer.append(statusColumn2);
                    sbuffer.append("A");
                } else if (state == 3) {
                    sbuffer.append(statusColumn2);
                    sbuffer.append("R");
                } else {
                    sbuffer.append(statusColumn);
                }
                sbuffer.append(endColumn);
            }
            sbuffer.append(endRow);
            odd = !odd;
            pm.setProgress(++tuno);
        }
        targetString = sbuffer.toString();
        return targetString;
    }

    public LinkedHashMap getSegmentAttributes() {
        return this.segmentAttributes;
    }

    public void setGlueMode(String mode) {
        this.setAttribute("text:glue", mode);
    }

    public String getGlueMode() {
        return this.getAttribute("text:glue");
    }

    public void setDuration(String duration) {
        this.setAttribute("bill:duration", duration);
    }

    public String getDuration() {
        return this.getAttribute("bill:duration");
    }

    public void setLastID(String id) {
        if (this.isExternalToolXLIFF || this.isTXML) {
            this.lastTUID = id;
            return;
        }
        if (this.n == -1 && this.currentFile != null) {
            String val = this.currentFile.getAttribute("tool-id");
            this.n = val != null && val.startsWith("CafeTran") ? 1 : 0;
        }
        if (this.n == 1) {
            this.setAttribute("text:segment", id);
        }
    }

    public String getLastID() {
        if (this.isExternalToolXLIFF || this.isTXML) {
            return this.lastTUID;
        }
        String s = this.getAttribute("text:segment");
        return s;
    }

    public void removeLastID() {
        LinkedHashMap map = this.getAttributes();
        map.remove("text:segment");
    }

    public void setTranslatedStatus() {
        List files = this.getFiles();
        for (int j = 0; j < files.size(); ++j) {
            List tunits;
            XliffFile file = (XliffFile)files.get(j);
            FileBody body = file.getBody();
            if (body == null || (tunits = body.getTransUnits()) == null) continue;
            this.setTranslatedStatus(tunits);
        }
    }

    public void setTranslatedStatus(List tunits) {
        for (int j = 0; j < tunits.size(); ++j) {
            XMLElement tut;
            String stateAttr;
            XLIFFUnit tuParent;
            Object object = tunits.get(j);
            if (!(object instanceof XLIFFUnit)) continue;
            XLIFFUnit tu = (XLIFFUnit)object;
            if (tu.locked) continue;
            tu.setState(1);
            if (this.isMXLIFF) {
                tuParent = tu.getParentTU();
                if (tuParent != null) {
                    tu = tuParent;
                }
                if ((stateAttr = tu.getAttribute("m:confirmed")) != null && stateAttr.equals("1")) continue;
                tu.setAttribute("m:confirmed", "1");
                continue;
            }
            if (this.isMQXLIFF) {
                tuParent = tu.getParentTU();
                if (tuParent != null) {
                    tu = tuParent;
                }
                if ((stateAttr = tu.getAttribute("mq:status")) != null && stateAttr.equals("ManuallyConfirmed")) continue;
                tu.setAttribute("mq:status", "ManuallyConfirmed");
                continue;
            }
            if (this.isStudioXLIFF) {
                tu.setSDLStatus("Translated");
                continue;
            }
            if (this.isTXML || (tut = tu.getTarget()) == null || (stateAttr = tut.getAttribute("state")) != null && stateAttr.equals("translated")) continue;
            tut.setAttribute("state", "translated");
        }
    }

    public void updateLockedIDs() {
        List files = this.getFiles();
        for (XliffFile next : files) {
            FileBody body = next.getBody();
            if (body == null) continue;
            body.updateLockedIDs();
        }
    }

    public void writeXMLFormat(BufferedWriter awriter) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getXMLFormat());
        awriter.write(sb.toString());
        sb.setLength(0);
    }

    public void writeXMLFormat() throws IOException {
        if (this.zipPath != null) {
            this.writeXMLZipFormat();
            return;
        }
        File projectFile = new File(this.path);
        File tempFile = File.createTempFile("old", null, projectFile.getParentFile());
        FileOutputStream fout = new FileOutputStream(tempFile);
        String enc = AppPreferences.en;
        if (!enc.startsWith("UTF")) {
            enc = "UTF-8";
        }
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, enc));
        if (!this.path.toLowerCase().endsWith(".sdlxliff")) {
            awriter.write("<?xml version=\"1.0\"?>");
        } else {
            awriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getXMLFormat());
        awriter.write(sb.toString());
        sb.setLength(0);
        awriter.close();
        fout.close();
        if (projectFile.exists()) {
            projectFile.delete();
        }
        if (!tempFile.renameTo(projectFile)) {
            throw new IOException();
        }
        this.saved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXMLZipFormat() {
        FileOutputStream fos = null;
        File file = new File(this.path);
        try {
            fos = new FileOutputStream(file);
            ZipOutputStream zos = new ZipOutputStream(fos);
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            sb.append(this.getXMLFormat());
            String text = sb.toString();
            sb.setLength(0);
            byte[] buf = text.getBytes("UTF-8");
            ZipEntry entry = new ZipEntry(this.zipPath);
            zos.putNextEntry(entry);
            zos.write(buf, 0, buf.length);
            zos.finish();
            zos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(XLIFF.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(XLIFF.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        unitCounter = 0;
        fileCounter = 0;
        sdlCommentsMap = new HashMap();
    }
}

