/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.NumbersHelper;
import translator.Placeables;
import translator.Project;
import translator.Tag;
import translator.Workflow;
import translator.XMLElement;
import translator.XMLHelper;
import translator.qa.Fixable;
import translator.qa.Issue;
import translator.ui.Colors;
import translator.xliff.CDATA;

public class XLIFFUnit
extends DefaultXMLElement
implements Comparable,
Fixable {
    public boolean repetitionFirst = false;
    public boolean repetition = false;
    public boolean number = false;
    public boolean numberTagged = false;
    public boolean bookmark = false;
    public boolean locked = false;
    public boolean edited = false;
    public boolean translate = true;
    public boolean propagate = true;
    public boolean autopropagated = false;
    private int unitID;
    private int unitNumber;
    private int fileID;
    private int projectID;
    public String percent = null;
    public String segmentUnconfirmed;
    private int match = -1;
    private int state = 0;
    private int matchType = -1;
    private int fileType = 0;
    private XLIFFUnit parentTU;
    private String SDLsegmentID;
    private String context;
    private List comments;
    XLIFFUnit previousTU;
    XLIFFUnit nextTU;
    public boolean current;
    public boolean first;
    public static Map lockedTUs = new HashMap();
    private ArrayList placeables;
    public static ArrayList placeableTargetReplacementList;
    private XMLElement SDLSegment;
    private XMLElement SDLComment;
    private boolean join;
    private int sourceLength;
    int mrkID;
    private int markSeg = -1;
    private boolean addSpace;
    private List spaceInsertPositions;
    private StringBuilder endFormatTag = new StringBuilder();
    private StringBuilder startFormatTag = new StringBuilder();
    private StringBuilder endFormatTagSource = new StringBuilder();
    private StringBuilder startFormatTagSource = new StringBuilder();
    private StringBuilder endFormatTagTarget = new StringBuilder();
    private StringBuilder startFormatTagTarget = new StringBuilder();
    private int tagCount = 0;
    private int hiddenStartTag = 0;
    private int tagPosition;
    private int tagIndex;
    private List issues;

    public XLIFFUnit(int projectID, int fileID, int unitID, int fileType) {
        this.projectID = projectID;
        this.fileID = fileID;
        this.unitID = unitID;
        this.fileType = fileType;
    }

    public boolean isTracked(XMLElement e) {
        List childern = e.getChildren();
        for (int k = 0; k < childern.size(); ++k) {
            String a;
            Object get = childern.get(k);
            if (!(get instanceof XMLElement)) continue;
            e = (XMLElement)get;
            String name = e.getName();
            if (name.equals("mrk") && (a = e.getAttribute("mtype")) != null && (a.endsWith("-added") || a.endsWith("-deleted"))) {
                return true;
            }
            if (!this.isTracked(e)) continue;
            return true;
        }
        return false;
    }

    public void join(boolean j) {
        this.join = j;
    }

    public boolean isJoined() {
        return this.join;
    }

    public void setParentTU(XLIFFUnit tu) {
        this.parentTU = tu;
    }

    public XLIFFUnit getParentTU() {
        return this.parentTU;
    }

    public void setSDLComment(XMLElement comment) {
        this.SDLComment = comment;
    }

    public void setSDLSegment(XMLElement SDLSegment) {
        this.SDLSegment = SDLSegment;
    }

    public void setSDLSegmentID(String id) {
        this.SDLsegmentID = id;
    }

    public XLIFFUnit getPreviousTranslationUnit() {
        return this.previousTU;
    }

    public XLIFFUnit getNextTranslationUnit() {
        return this.nextTU;
    }

    public void setSegmentUnconfirmed(String text) {
        this.segmentUnconfirmed = text;
    }

    public String getSegmentUnconfirmed() {
        return this.segmentUnconfirmed;
    }

    public void setMatch(int i, int t, boolean store) {
        if (this.match == -1) {
            XMLElement target;
            this.match = i;
            this.matchType = t;
            if (store && (target = this.getTarget()) != null) {
                if (t == 1) {
                    String s = "x-exact-match-" + Integer.toString(this.match);
                    target.setAttribute("state-qualifier", s);
                } else if (t == 2) {
                    String s = "x-fuzzy-match-" + Integer.toString(this.match);
                    target.setAttribute("state-qualifier", s);
                } else if (t == 3) {
                    String s = "x-machine-translation-ct";
                    target.setAttribute("state-qualifier", s);
                } else if (t == 4) {
                    String s = "x-machine-translation";
                    target.setAttribute("state-qualifier", s);
                } else if (t == 5) {
                    String s = "x-human-translation";
                    target.setAttribute("state-qualifier", s);
                } else if (t == 0) {
                    String s = "x-ai-translation";
                    target.setAttribute("state-qualifier", s);
                }
            }
        }
    }

    public int getMatch() {
        return this.match;
    }

    public int getMatchType() {
        return this.matchType;
    }

    public void setState(int i) {
        this.state = i;
    }

    public int getState() {
        return this.state;
    }

    public void setLock(boolean lock, boolean store) {
        if (store && this.locked != lock) {
            this.setAttribute("ct:locked", Boolean.toString(lock));
        }
        this.locked = lock;
    }

    public void setPropagation(boolean p, boolean store) {
        if (store && this.propagate != p) {
            this.setAttribute("ct:propagate", Boolean.toString(p));
        }
        this.propagate = p;
    }

    public void changeSDLMTOrigin() {
        String or;
        if (this.SDLSegment != null && (or = this.SDLSegment.getAttribute("origin")) != null && (or.equals("mt") || or.equals("nmt") || or.equals("amt"))) {
            List list;
            List prevOrg = this.SDLSegment.getChildren("sdl:prev-origin");
            if (!prevOrg.isEmpty()) {
                return;
            }
            this.SDLSegment.setAttribute("origin", "interactive");
            String system = this.SDLSegment.getAttribute("origin-system");
            if (system != null) {
                this.SDLSegment.getAttributes().remove("origin-system");
            }
            DefaultXMLElement segElement = new DefaultXMLElement();
            segElement.setName("sdl:prev-origin");
            segElement.setAttribute("origin", or);
            if (system != null) {
                segElement.setAttribute("origin-system", system);
            }
            if (!(list = this.SDLSegment.getChildren("sdl:value")).isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Object o;
                    XMLElement get = (XMLElement)list.get(i);
                    String key = get.getAttribute("key");
                    if (key == null || !key.equals("SegmentIdentityHash") || (o = get.getContent(0)) == null) continue;
                    String hash = o.toString();
                    DefaultXMLElement segElement2 = new DefaultXMLElement();
                    segElement2.setName("sdl:value");
                    segElement2.setAttribute("key", "SegmentIdentityHash");
                    segElement2.setContent(0, hash);
                    segElement.addChild(segElement2);
                    break;
                }
            }
            this.SDLSegment.addChild(segElement);
        }
    }

    public void setSDLStatus(String status) {
        if (this.SDLSegment != null) {
            this.SDLSegment.setAttribute("conf", status);
        }
    }

    public String getSDLStatus() {
        String stat = null;
        List sdlsegsdefs = this.getChildren("sdl:seg-defs");
        if (sdlsegsdefs != null) {
            for (int k = 0; k < sdlsegsdefs.size(); ++k) {
                XMLElement xmle;
                List sdlsegs;
                Object object1 = sdlsegsdefs.get(k);
                if (!(object1 instanceof XMLElement) || (sdlsegs = (xmle = (XMLElement)object1).getChildren("sdl:seg")) == null) continue;
                for (int l = 0; l < sdlsegs.size(); ++l) {
                    Object object2 = sdlsegs.get(l);
                    if (!(object2 instanceof XMLElement)) continue;
                    XMLElement xmle2 = (XMLElement)object2;
                    stat = xmle2.getAttribute("conf");
                }
            }
        }
        return stat;
    }

    public void removeMatch(boolean store) {
        this.matchType = -1;
        if (this.match != -1) {
            LinkedHashMap map;
            XMLElement target;
            this.match = -1;
            if (store && (target = this.getTarget()) != null && (map = target.getAttributes()) != null) {
                map.remove("state-qualifier");
            }
        }
    }

    private void updateMrkTagComment() {
        if (this.SDLComment != null) {
            List contents;
            XMLElement mrk;
            String mtype;
            XMLElement target = this.getTarget();
            List mrks = target.getChildren("mrk");
            if (!mrks.isEmpty() && (mtype = (mrk = (XMLElement)mrks.get(0)).getAttribute("mtype")) != null && mtype.equals("seg") && (contents = mrk.getChildren()) != null) {
                for (Object next : contents) {
                    this.SDLComment.addChild(next);
                }
                contents.clear();
                mrk.addChild(this.SDLComment);
            }
            this.SDLComment = null;
        }
    }

    public void removeMrkTagComment(XMLElement docInfo) {
        List contents;
        XMLElement mrk;
        String mtype;
        XMLElement target = this.getTarget();
        List mrks = target.getChildren("mrk");
        if (!mrks.isEmpty() && (mtype = (mrk = (XMLElement)mrks.get(0)).getAttribute("mtype")) != null && mtype.equals("seg") && (contents = mrk.getChildren("mrk")) != null) {
            boolean removed = false;
            for (Object next : contents) {
                List list;
                String uuid;
                XMLElement mrk2;
                String attr;
                if (!(next instanceof XMLElement) || (attr = (mrk2 = (XMLElement)next).getAttribute("mtype")) == null || !attr.equals("x-sdl-comment")) continue;
                removed = true;
                mrk.removeChild(next);
                List contents2 = mrk2.getChildren();
                if (contents2 != null) {
                    for (Object next2 : contents2) {
                        mrk.addChild(next2);
                    }
                }
                if ((uuid = mrk2.getAttribute("sdl:cid")) == null || (list = docInfo.getChildren("cmt-defs")) == null || list.isEmpty()) continue;
                DefaultXMLElement cmtDefs = (DefaultXMLElement)list.get(0);
                List list2 = cmtDefs.getChildren();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    XMLElement cmtDef;
                    String id;
                    Object next2 = iterator2.next();
                    if (!(next2 instanceof XMLElement) || (id = (cmtDef = (XMLElement)next2).getAttribute("id")) == null || !id.equals(uuid)) continue;
                    iterator2.remove();
                    break;
                }
                if (!list2.isEmpty()) continue;
                docInfo.removeChild(cmtDefs);
            }
            if (removed) {
                this.updateParentTargetSegment();
                this.comments = null;
            }
        }
    }

    private boolean updateMrkTagContent(XMLElement parent) {
        boolean updated = false;
        List list = parent.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (!(object instanceof XMLElement)) continue;
            XMLElement xml = (XMLElement)object;
            if (xml.getName().equals("mrk")) {
                String pID;
                String a = xml.getAttribute("mtype");
                if (a == null || !a.equals("seg") || (pID = xml.getAttribute("mid")) == null || !pID.equals(this.SDLsegmentID)) continue;
                List marks = this.getTarget().getChildren("mrk");
                for (XMLElement next : marks) {
                    String nID = next.getAttribute("mid");
                    if (nID == null || !nID.equals(this.SDLsegmentID)) continue;
                    parent.setContent(i, next);
                    updated = true;
                    return updated;
                }
                continue;
            }
            updated = this.updateMrkTagContent(xml);
            if (updated) break;
        }
        return updated;
    }

    public void updateParentTargetSegment() {
        XMLElement target;
        if (this.parentTU != null && (target = this.parentTU.getTarget()) != null) {
            this.mrkID = 0;
            this.updateMrkTagComment();
            this.updateMrkTagContent(target);
        }
    }

    public int compareTo(Object compareObject) {
        XLIFFUnit tu = (XLIFFUnit)compareObject;
        String s1 = this.getSourceText().trim();
        String s2 = tu.getSourceText().trim();
        int i = s1.compareToIgnoreCase(s2);
        return i;
    }

    public void setUnitID(int id) {
        this.unitID = id;
    }

    public int getUnitID() {
        return this.unitID;
    }

    public void setUnitNumber(int no) {
        this.unitNumber = no;
    }

    public int getUnitNumber() {
        return this.unitNumber;
    }

    public void setFileID(int id) {
        this.fileID = id;
    }

    public int getFileID() {
        return this.fileID;
    }

    public int getProjectID() {
        return this.projectID;
    }

    public void setProjectID(int id) {
        this.projectID = id;
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            super.addChild(o);
        }
    }

    public void setSource(XMLElement elem) {
        List children = this.getChildren("source");
        if (children != null && children.size() > 0) {
            children.set(0, elem);
        } else {
            this.addChild(elem);
        }
    }

    public void setTarget(XMLElement elem) {
        List children = this.getChildren("target");
        if (children != null && children.size() > 0) {
            children.set(0, elem);
        } else {
            this.addChild(elem);
        }
    }

    public XMLElement getSource() {
        XMLElement elem = null;
        List children = this.getChildren("seg-source");
        if (children.isEmpty()) {
            children = this.getChildren("source");
        }
        if (children.size() > 0) {
            elem = (XMLElement)children.get(0);
        }
        return elem;
    }

    public XMLElement getTarget() {
        XMLElement elem = null;
        List children = this.getChildren("target");
        if (children.size() > 0) {
            elem = (XMLElement)children.get(0);
        }
        return elem;
    }

    public String getElements(List list, boolean edit) {
        String segTags = "";
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof XMLElement) {
                String s;
                XMLElement xml = (XMLElement)object;
                String name = xml.getName();
                List li = xml.getChildren();
                boolean editable = true;
                boolean empty = false;
                if (this.fileType == 3) {
                    if (name.equals("cp") || name.equals("ph") || name.equals("sc") || name.equals("ec") || name.equals("sm") || name.equals("em")) {
                        editable = false;
                        empty = true;
                    }
                } else {
                    if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                        editable = false;
                    }
                    if (name.equals("x") || name.equals("bx") || name.equals("ex")) {
                        empty = true;
                    }
                }
                String stag = null;
                String etag = null;
                if (!empty) {
                    stag = "|";
                    etag = "|";
                } else {
                    stag = "|";
                }
                if (!segTags.endsWith("|") && segTags.length() > 0) {
                    segTags = segTags + stag;
                }
                if ((s = this.getElements(li, editable)) != null) {
                    segTags = segTags + s;
                }
                if (etag == null || segTags.endsWith("|")) continue;
                segTags = segTags + etag;
                continue;
            }
            if (!edit) continue;
            String e = object.toString();
            segTags = segTags + e;
        }
        return segTags;
    }

    public String getReviewSourceString() {
        List list;
        XMLElement elem = this.getSource();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getReviewStringContent(list, sb);
        }
        while (sb.indexOf("|", sb.length() - 1) != -1) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getReviewTargetString() {
        List list;
        XMLElement elem = this.getTarget();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getReviewStringContent(list, sb);
        }
        while (sb.indexOf("|", sb.length() - 1) != -1) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void getReviewStringContent(List children, StringBuilder sb) {
        for (Object object : children) {
            if (object instanceof String) {
                String s = object.toString();
                s = XMLHelper.resolveEntitiesXML(s);
                sb.append(s);
                continue;
            }
            XMLElement elem = (XMLElement)object;
            if (elem.getName().equals("x")) {
                if (sb.length() <= 0) continue;
                sb.append("|");
                String xn = elem.getAttribute("equiv-text");
                if (xn == null || !xn.equals(" ")) continue;
                sb.append(xn);
                continue;
            }
            List list = elem.getChildren();
            if (list.size() <= 0) continue;
            this.getStringContent(list, sb);
        }
    }

    public String getSourceXMLText() {
        List list;
        XMLElement elem = this.getSource();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getXMLTextContent(list, sb);
        }
        return sb.toString();
    }

    public String getTargetXMLText() {
        List list;
        XMLElement elem = this.getTarget();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getXMLTextContent(list, sb);
        }
        return sb.toString();
    }

    public String getCurrentSourceXMLText() {
        String id;
        XMLElement e;
        String name;
        Object o;
        List children;
        XMLElement source;
        List list;
        XMLElement elem = this.getSource();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            if (this.endFormatTag.length() > 0) {
                this.endFormatTag.setLength(0);
            }
            if (this.startFormatTag.length() > 0) {
                this.startFormatTag.setLength(0);
            }
            this.tagCount = 0;
            this.getCurrentXMLTextContent(list, sb, true, false);
            this.startFormatTagSource = this.startFormatTag;
            this.endFormatTagSource = this.endFormatTag;
        }
        if (this.parentTU != null && (source = this.parentTU.getSource()) != null && !(children = source.getChildren()).isEmpty() && (o = children.get(0)) instanceof XMLElement && (name = (e = (XMLElement)o).getName()).equals("g") && (id = e.getAttribute("id")) != null && this.SDLsegmentID != null) {
            Tag tag;
            String id2;
            XMLElement e2;
            String name2;
            Object o2;
            boolean format = false;
            List children2 = e.getChildren();
            if (!children2.isEmpty() && (o2 = children2.get(0)) instanceof XMLElement && (name2 = (e2 = (XMLElement)o2).getName()).equals("mrk") && (id2 = e2.getAttribute("mid")) != null && id2.equals(this.SDLsegmentID)) {
                format = true;
            }
            if (format && (tag = Project.getTag(id)) != null) {
                String c;
                if (tag.isBold()) {
                    sb.insert(0, "<b>");
                    sb.append("</b>");
                }
                if (tag.isItalic()) {
                    sb.insert(0, "<i>");
                    sb.append("</i>");
                }
                if (tag.isUnderline()) {
                    sb.insert(0, "<u>");
                    sb.append("</u>");
                }
                if (!AppPreferences.replaceDocumentColors && (c = tag.getColor()) != null) {
                    StringBuilder sbuilder = new StringBuilder();
                    sbuilder.append("<span style=color:");
                    sbuilder.append(c);
                    sbuilder.append(">");
                    sb.insert(0, sbuilder);
                    sb.append("</span>");
                }
            }
        }
        this.sourceLength = sb.length();
        return sb.toString();
    }

    public String getCurrentTargetXMLText() {
        Object o;
        List children;
        XMLElement target;
        List list;
        XMLElement elem = this.getTarget();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            if (this.endFormatTag.length() > 0) {
                this.endFormatTag.setLength(0);
            }
            if (this.startFormatTag.length() > 0) {
                this.startFormatTag.setLength(0);
            }
            this.tagCount = 0;
            this.hiddenStartTag = 0;
            this.getCurrentXMLTextContent(list, sb, false, false);
            this.startFormatTagTarget = this.startFormatTag;
            this.endFormatTagTarget = this.endFormatTag;
        }
        if (this.parentTU != null && (target = this.parentTU.getTarget()) != null && !(children = target.getChildren()).isEmpty() && (o = children.get(0)) instanceof XMLElement) {
            String type;
            XMLElement e = (XMLElement)o;
            String name = e.getName();
            if (name.equals("g")) {
                String id = e.getAttribute("id");
                if (id != null && this.SDLsegmentID != null) {
                    Tag tag;
                    String id2;
                    XMLElement e2;
                    String name2;
                    Object o2;
                    boolean format = false;
                    List children2 = e.getChildren();
                    if (!children2.isEmpty() && (o2 = children2.get(0)) instanceof XMLElement && (name2 = (e2 = (XMLElement)o2).getName()).equals("mrk") && (id2 = e2.getAttribute("mid")) != null && id2.equals(this.SDLsegmentID)) {
                        format = true;
                    }
                    if (format && (tag = Project.getTag(id)) != null) {
                        String c;
                        if (tag.isBold()) {
                            sb.insert(0, "<b>");
                            sb.append("</b>");
                        }
                        if (tag.isItalic()) {
                            sb.insert(0, "<i>");
                            sb.append("</i>");
                        }
                        if (tag.isUnderline()) {
                            sb.insert(0, "<u>");
                            sb.append("</u>");
                        }
                        if (!AppPreferences.replaceDocumentColors && (c = tag.getColor()) != null) {
                            StringBuilder sbuilder = new StringBuilder();
                            sbuilder.append("<span style=color:");
                            sbuilder.append(c);
                            sbuilder.append(">");
                            sb.insert(0, sbuilder);
                            sb.append("</span>");
                        }
                    }
                }
            } else if (name.equals("mrk") && (type = e.getAttribute("mtype")) != null) {
                if (type.equals("x-sdl-added")) {
                    sb.insert(0, "<u>");
                    sb.append("</u>");
                } else if (type.equals("x-sdl-deleted")) {
                    sb.insert(0, "<s>");
                    sb.append("</s>");
                }
            }
        }
        return sb.toString();
    }

    public String getSourceText() {
        List list;
        this.markSeg = -1;
        this.spaceInsertPositions = null;
        XMLElement elem = this.getSource();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getTextContent(list, sb, false);
        }
        return sb.toString();
    }

    public int getSourceTextLength() {
        return this.sourceLength;
    }

    public String getTargetText() {
        List list;
        this.markSeg = -1;
        this.spaceInsertPositions = null;
        XMLElement elem = this.getTarget();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getTextContent(list, sb, false);
        }
        return sb.toString();
    }

    public List getSpaceInsertPositions() {
        return this.spaceInsertPositions;
    }

    public String getTargetTextForPropagation() {
        List list;
        this.markSeg = -1;
        XMLElement elem = this.getTarget();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getTextContent(list, sb, true);
        }
        return sb.toString();
    }

    public String getTargetString() {
        List list;
        XMLElement elem = this.getTarget();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getStringContent(list, sb);
        }
        return sb.toString();
    }

    public String getSourceString() {
        List list;
        XMLElement elem = this.getSource();
        StringBuilder sb = new StringBuilder();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.getStringContent(list, sb);
        }
        return sb.toString();
    }

    private void getStringContent(List children, StringBuilder sb) {
        for (Object object : children) {
            List list;
            String a;
            if (object instanceof String) {
                String s = object.toString();
                s = XMLHelper.resolveEntitiesXML(s);
                sb.append(s);
                continue;
            }
            XMLElement elem = (XMLElement)object;
            String ename = elem.getName();
            if (ename.equals("x")) {
                LinkedHashMap map = elem.getAttributes();
                if (map == null) continue;
                sb.append("<x");
                Set set = map.keySet();
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    sb.append(" ");
                    String s = (String)i.next();
                    sb.append(s);
                    sb.append('=');
                    sb.append('\"');
                    s = (String)map.get(s);
                    sb.append(s);
                    sb.append('\"');
                }
                sb.append("/>");
                continue;
            }
            if (ename.equals("mrk") && (a = elem.getAttribute("mtype")) != null && a.equals("x-deleted") || (list = elem.getChildren()).size() <= 0) continue;
            this.getStringContent(list, sb);
        }
    }

    private void getTextContent(List children, StringBuilder sb, boolean propagation) {
        for (Object object : children) {
            List list;
            String s;
            String attr;
            if (object instanceof String) {
                if (this.markSeg == 1) continue;
                String s2 = object.toString();
                s2 = XMLHelper.resolveEntitiesXML(s2);
                if (this.addSpace) {
                    if (s2.length() > 0 && s2.charAt(0) != ' ' && sb.length() > 0) {
                        if (this.spaceInsertPositions == null) {
                            this.spaceInsertPositions = new ArrayList();
                        }
                        this.spaceInsertPositions.add(sb.length());
                    }
                    this.addSpace = false;
                }
                sb.append(s2);
                continue;
            }
            XMLElement elem = (XMLElement)object;
            String name = elem.getName();
            boolean mark = false;
            if (name != null && name.equals("mrk") && (attr = elem.getAttribute("mtype")) != null && attr.equals("seg")) {
                mark = true;
                this.markSeg = 0;
            }
            if (sb.length() > 0 && (s = elem.getAttribute("equiv-text")) != null) {
                sb.append(s);
            }
            if (this.fileType > 0) {
                if (name.equals("g")) {
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ' && !propagation) {
                        this.addSpace = true;
                    }
                    if ((list = elem.getChildren()).size() > 0) {
                        this.getTextContent(list, sb, propagation);
                    }
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ' || propagation) continue;
                    this.addSpace = true;
                    continue;
                }
                if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                    if (!name.equals("x") && !name.equals("bpt") && !name.equals("ph") || sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ' || propagation) continue;
                    this.addSpace = true;
                    continue;
                }
            }
            if ((list = elem.getChildren()).size() > 0) {
                this.getTextContent(list, sb, propagation);
            }
            if (!mark || this.markSeg != 0) continue;
            this.markSeg = 1;
        }
    }

    private void getXMLTextContent(List children, StringBuilder sb) {
        for (Object object : children) {
            List list;
            String name;
            String s;
            if (object instanceof String) {
                String s2 = object.toString();
                s2 = XMLHelper.resolveXMLEntities2(s2);
                sb.append(s2);
                continue;
            }
            XMLElement elem = (XMLElement)object;
            if (sb.length() > 0 && (s = elem.getAttribute("equiv-text")) != null) {
                sb.append(s);
            }
            if (this.fileType > 0 && ((name = elem.getName()).equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) || (list = elem.getChildren()).size() <= 0) continue;
            this.getXMLTextContent(list, sb);
        }
    }

    public StringBuilder getStartFormatTag(boolean sourceSegment) {
        if (sourceSegment) {
            return this.startFormatTagSource;
        }
        return this.startFormatTagTarget;
    }

    public StringBuilder getEndFormatTag(boolean sourceSegment) {
        if (sourceSegment) {
            return this.endFormatTagSource;
        }
        return this.endFormatTagTarget;
    }

    private void getCurrentXMLTextContent(List children, StringBuilder sb, boolean sourceSegment, boolean tracking) {
        if (this.current && sourceSegment) {
            Workflow.formatMap.clear();
        }
        for (Object object : children) {
            List list;
            String c;
            StringBuilder sbuilder;
            String name;
            if (object instanceof String) {
                StringBuilder formatTag;
                StringBuilder formatTag2;
                if (this.startFormatTag.length() > 0) {
                    sb.append((CharSequence)this.startFormatTag);
                    if (this.current && sourceSegment && AppPreferences.sourceSegmentFormatting && this.fileType == 0) {
                        Workflow.formatMap.put(this.tagCount - this.hiddenStartTag, this.startFormatTag.toString());
                    }
                    if (this.fileType > 0 || tracking) {
                        this.startFormatTag.setLength(0);
                    }
                } else if (this.tagCount == 0 && this.previousTU != null && this.fileType == 0 && (formatTag2 = this.previousTU.getStartFormatTag(sourceSegment)).length() > 0) {
                    sb.append((CharSequence)formatTag2);
                    if (this.startFormatTag.length() == 0) {
                        this.startFormatTag.append((CharSequence)formatTag2);
                    }
                    if (this.current && sourceSegment && AppPreferences.sourceSegmentFormatting && this.fileType == 0) {
                        Workflow.formatMap.put(this.tagCount - this.hiddenStartTag, formatTag2.toString());
                    }
                }
                String s = object.toString();
                s = XMLHelper.resolveXMLEntities2(s);
                sb.append(s);
                if (this.endFormatTag.length() > 0) {
                    sb.append((CharSequence)this.endFormatTag);
                    if (this.fileType <= 0 && !tracking) continue;
                    this.endFormatTag.setLength(0);
                    continue;
                }
                if (this.tagCount != 0 || this.previousTU == null || this.fileType != 0 || (formatTag = this.previousTU.getEndFormatTag(sourceSegment)).length() <= 0) continue;
                sb.append((CharSequence)formatTag);
                if (this.endFormatTag.length() != 0) continue;
                this.endFormatTag.append((CharSequence)formatTag);
                continue;
            }
            this.startFormatTag.setLength(0);
            this.endFormatTag.setLength(0);
            ++this.tagCount;
            boolean track = false;
            XMLElement elem = (XMLElement)object;
            if (sb.length() > 0) {
                String s = elem.getAttribute("equiv-text");
                if (s != null) {
                    sb.append(s);
                }
            } else if (AppPreferences.hideBoundaryTags || this.first) {
                this.hiddenStartTag = 1;
            }
            if (this.fileType == 0) {
                String type;
                name = elem.getName();
                String s = elem.getAttribute("ctype");
                if (s != null) {
                    int color;
                    if (sb.length() > 0 && (s.indexOf("x-break") != -1 || s.indexOf("x-page") != -1)) {
                        sb.append("<br>");
                    }
                    if (s.indexOf("bold") != -1) {
                        this.startFormatTag.append("<b>");
                        this.endFormatTag.append("</b>");
                    }
                    if (s.indexOf("italic") != -1) {
                        this.startFormatTag.append("<i>");
                        this.endFormatTag.append("</i>");
                    }
                    if (s.indexOf("underline") != -1) {
                        this.startFormatTag.append("<u>");
                        this.endFormatTag.append("</u>");
                    }
                    if (s.indexOf("subscript") != -1) {
                        this.startFormatTag.append("<sub>");
                        this.endFormatTag.append("</sub>");
                    }
                    if (s.indexOf("superscript") != -1) {
                        this.startFormatTag.append("<sup>");
                        this.endFormatTag.append("</sup>");
                    }
                    if (s.indexOf("strikethrough") != -1) {
                        this.startFormatTag.append("<s>");
                        this.endFormatTag.append("</s>");
                    }
                    if (!AppPreferences.replaceDocumentColors && (color = s.indexOf("color:")) != -1) {
                        sbuilder = new StringBuilder();
                        sbuilder.append("<span style=");
                        char ch = s.charAt(color - 1);
                        if (ch == 'f') {
                            sbuilder.append("color:");
                        } else {
                            sbuilder.append("background:");
                        }
                        int j = s.indexOf(59, color + 6);
                        if (j == -1) {
                            j = s.length();
                        }
                        sbuilder.append(s.substring(color + 6, j));
                        if (j != -1 && (color = s.indexOf("color:", j)) != -1) {
                            ch = s.charAt(color - 1);
                            if (ch == 'f') {
                                sbuilder.append(";color:");
                            } else {
                                sbuilder.append(";background:");
                            }
                            j = s.indexOf(59, color + 6);
                            if (j == -1) {
                                j = s.length();
                            }
                            sbuilder.append(s.substring(color + 6, j));
                        }
                        sbuilder.append(">");
                        this.startFormatTag.insert(0, sbuilder);
                        this.endFormatTag.append("</span>");
                    }
                } else if (name.equals("mrk") && (type = elem.getAttribute("mtype")) != null) {
                    if (type.equals("x-added")) {
                        track = true;
                        this.startFormatTag.append("<u>");
                        this.endFormatTag.append("</u>");
                        c = Colors.trackingAddColorHTML;
                        StringBuilder sbuilder2 = new StringBuilder();
                        sbuilder2.append("<span style=color:");
                        sbuilder2.append(c);
                        sbuilder2.append(">");
                        this.startFormatTag.insert(0, sbuilder2);
                        this.endFormatTag.append("</span>");
                    } else if (type.equals("x-deleted")) {
                        track = true;
                        this.startFormatTag.append("<s>");
                        this.endFormatTag.append("</s>");
                        c = Colors.trackingDeleteColorHTML;
                        StringBuilder sbuilder3 = new StringBuilder();
                        sbuilder3.append("<span style=color:");
                        sbuilder3.append(c);
                        sbuilder3.append(">");
                        this.startFormatTag.insert(0, sbuilder3);
                        this.endFormatTag.append("</span>");
                    }
                }
            } else {
                String type;
                name = elem.getName();
                if (name.equals("bpt") || name.equals("ept") || name.equals("it") || name.equals("ph") || name.equals("bx") || name.equals("ex") || name.equals("x") || name.equals("ut")) {
                    String lockContent;
                    XLIFFUnit lockTU;
                    String lockID;
                    if (!name.equals("x") || (lockID = elem.getAttribute("xid")) == null || !lockID.startsWith("lockTU") || (lockTU = (XLIFFUnit)lockedTUs.get(lockID)) == null || (lockContent = lockTU.getCurrentSourceXMLText()).length() <= 0) continue;
                    sb.append("<span color=\"red\">");
                    sb.append(lockContent);
                    sb.append("</span>");
                    continue;
                }
                if (name.equals("g")) {
                    Tag tag;
                    String id = elem.getAttribute("id");
                    if (id != null && (tag = Project.getTag(id)) != null) {
                        if (tag.isBold()) {
                            this.startFormatTag.append("<b>");
                            this.endFormatTag.append("</b>");
                        }
                        if (tag.isItalic()) {
                            this.startFormatTag.append("<i>");
                            this.endFormatTag.append("</i>");
                        }
                        if (tag.isUnderline()) {
                            this.startFormatTag.append("<u>");
                            this.endFormatTag.append("</u>");
                        }
                        if (!AppPreferences.replaceDocumentColors && (c = tag.getColor()) != null) {
                            StringBuilder sbuilder4 = new StringBuilder();
                            sbuilder4.append("<span style=color:");
                            sbuilder4.append(c);
                            sbuilder4.append(">");
                            this.startFormatTag.insert(0, sbuilder4);
                            this.endFormatTag.append("</span>");
                        }
                    }
                } else if (name.equals("mrk") && (type = elem.getAttribute("mtype")) != null) {
                    if (type.equals("x-sdl-added")) {
                        this.startFormatTag.append("<u>");
                        this.endFormatTag.append("</u>");
                        String c2 = Colors.trackingAddColorHTML;
                        sbuilder = new StringBuilder();
                        sbuilder.append("<span style=color:");
                        sbuilder.append(c2);
                        sbuilder.append(">");
                        this.startFormatTag.insert(0, sbuilder);
                        this.endFormatTag.append("</span>");
                    } else if (type.equals("x-sdl-deleted")) {
                        this.startFormatTag.append("<s>");
                        this.endFormatTag.append("</s>");
                        String c3 = Colors.trackingDeleteColorHTML;
                        sbuilder = new StringBuilder();
                        sbuilder.append("<span style=color:");
                        sbuilder.append(c3);
                        sbuilder.append(">");
                        this.startFormatTag.insert(0, sbuilder);
                        this.endFormatTag.append("</span>");
                    }
                }
            }
            if ((list = elem.getChildren()).size() <= 0) continue;
            this.getCurrentXMLTextContent(list, sb, sourceSegment, track);
        }
    }

    public int[] getTargetTagsPositions() {
        List list;
        int[] pos = new int[20];
        XMLElement elem = this.getTarget();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.tagPosition = 0;
            this.tagIndex = 0;
            this.getTagsPositions(list, pos);
        }
        return pos;
    }

    public int[] getSourceTagsPositions() {
        List list;
        int[] pos = new int[20];
        XMLElement elem = this.getSource();
        if (elem != null && (list = elem.getChildren()).size() > 0) {
            this.tagPosition = 0;
            this.tagIndex = 0;
            this.getTagsPositions(list, pos);
        }
        return pos;
    }

    private int getTagsPositions(List children, int[] pos) {
        int len = 0;
        for (Object object : children) {
            int k;
            if (object instanceof String) {
                String s = object.toString();
                s = XMLHelper.resolveEntitiesXML(s);
                this.tagPosition += s.length();
                len += s.length();
                continue;
            }
            if (this.tagPosition > 0 && this.tagIndex < 20) {
                pos[this.tagIndex] = this.tagPosition;
                ++this.tagIndex;
            }
            XMLElement elem = (XMLElement)object;
            String name = elem.getName();
            List list = elem.getChildren();
            if (list.size() <= 0 || (k = !name.equals("bpt") && !name.equals("ept") && !name.equals("it") && !name.equals("ph") ? this.getTagsPositions(list, pos) : 1) <= 0 || this.tagPosition <= 0 || this.tagIndex >= 20) continue;
            pos[this.tagIndex] = this.tagPosition;
            ++this.tagIndex;
        }
        return len;
    }

    public void setReviewTargetString(List elements) {
        List list;
        ArrayList newElements = new ArrayList();
        ArrayList sourceTags = new ArrayList();
        XMLElement selem = this.getSource();
        if (selem != null && (list = selem.getChildren()).size() > 0) {
            boolean startTag = false;
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                if (object instanceof XMLElement) {
                    if (!startTag) {
                        newElements.add(object);
                        continue;
                    }
                    sourceTags.add(object);
                    continue;
                }
                startTag = true;
            }
            int j = 0;
            boolean space = false;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                String string = it.next().toString();
                if (string.equals("|")) {
                    if (j >= sourceTags.size()) continue;
                    Object object = sourceTags.get(j);
                    XMLElement elem = (XMLElement)object;
                    String xn = elem.getAttribute("equiv-text");
                    if (xn != null && xn.equals(" ")) {
                        space = true;
                    }
                    newElements.add(object);
                    ++j;
                    continue;
                }
                if (space) {
                    if (string.startsWith(" ")) {
                        string = string.substring(1);
                    }
                    space = false;
                }
                newElements.add(string);
            }
            while (j < sourceTags.size()) {
                Object object = sourceTags.get(j);
                newElements.add(object);
                ++j;
            }
        }
        if (newElements.size() > 0) {
            XMLElement telem = this.getTarget();
            List list2 = telem.getChildren();
            list2.clear();
            Iterator it = newElements.iterator();
            while (it.hasNext()) {
                list2.add(it.next());
            }
        }
    }

    public boolean propagate(String source, String newTarget, int[] tagpos, boolean transferPlaceable) {
        List list;
        int j;
        if (transferPlaceable && placeableTargetReplacementList != null && (newTarget = this.replacePlaceablesInTarget(source, newTarget)) == null) {
            return false;
        }
        ArrayList<String> subStrings = new ArrayList<String>();
        ArrayList<Object> elems = new ArrayList<Object>();
        int k = 0;
        boolean prop = false;
        int len = newTarget.length();
        for (int i = 0; i < tagpos.length && (j = tagpos[i]) != 0 && j <= len; ++i) {
            String sub = newTarget.substring(k, j);
            if (sub.length() > 0) {
                subStrings.add(sub);
            }
            k = j;
        }
        if (k < newTarget.length()) {
            String sub = newTarget.substring(k);
            subStrings.add(sub);
        }
        int n = 0;
        XMLElement selem = this.getSource();
        if (selem != null && (list = selem.getChildren()).size() > 0) {
            for (Object object : list) {
                String empty;
                if (object instanceof XMLElement) {
                    XMLElement e = (XMLElement)object;
                    elems.add(e);
                    continue;
                }
                if (n >= subStrings.size() || (empty = object.toString()).length() <= 0) continue;
                String sub = subStrings.get(n).toString();
                elems.add(sub);
                ++n;
            }
            while (n < subStrings.size()) {
                String sub = subStrings.get(n).toString();
                elems.add(sub);
                ++n;
            }
        }
        if (elems.size() > 0) {
            XMLElement telem = this.getTarget();
            List list2 = telem.getChildren();
            list2.clear();
            Iterator it = elems.iterator();
            while (it.hasNext()) {
                list2.add(it.next());
            }
            prop = true;
        }
        return prop;
    }

    private int copySDLSourceToTarget(XMLElement source, XMLElement target, List strings, int index, boolean fromSource) {
        int n = index;
        List sourceElements = source.getChildren();
        for (int i = 0; i < sourceElements.size(); ++i) {
            Object object = sourceElements.get(i);
            if (object instanceof XMLElement) {
                String id;
                String tagname;
                XMLElement sx = (XMLElement)object;
                if (fromSource && (tagname = sx.getName()).equals("x") && (id = sx.getAttribute("id")) != null && id.startsWith("locked")) {
                    n = -1;
                    break;
                }
                String sxName = sx.getName();
                DefaultXMLElement tx = sxName.equals("!CDATA") ? new CDATA() : new DefaultXMLElement();
                tx.setName(sxName);
                LinkedHashMap amap = sx.getAttributes();
                if (amap != null) {
                    Set keys = amap.keySet();
                    for (String key : keys) {
                        String value = (String)amap.get(key);
                        tx.setAttribute(key, value);
                    }
                }
                target.addChild(tx);
                n = this.copySDLSourceToTarget(sx, tx, strings, n, fromSource);
                if (n != -1) continue;
                break;
            }
            if (object.toString().length() <= 0) continue;
            String xname = target.getName();
            if (xname != null && (xname.equals("bpt") || xname.equals("ept") || xname.equals("it") || xname.equals("ph") || xname.equals("bx") || xname.equals("ex") || xname.equals("x") || xname.equals("ut"))) {
                target.addChild(object);
                continue;
            }
            if (n >= strings.size()) continue;
            target.addChild(strings.get(n));
            ++n;
        }
        return n;
    }

    public boolean propagateSDL(String source, String newTarget, int[] tagpos, boolean transferPlaceable) {
        int j;
        if (transferPlaceable && placeableTargetReplacementList != null && (newTarget = this.replacePlaceablesInTarget(source, newTarget)) == null) {
            return false;
        }
        ArrayList<String> subStrings = new ArrayList<String>();
        int k = 0;
        boolean prop = false;
        int len = newTarget.length();
        for (int i = 0; i < tagpos.length && (j = tagpos[i]) != 0 && j <= len; ++i) {
            String sub = newTarget.substring(k, j);
            if (sub.length() > 0) {
                subStrings.add(sub);
            }
            k = j;
        }
        if (k < newTarget.length()) {
            subStrings.add(newTarget.substring(k));
        }
        int n = 0;
        if (this.getTargetText().trim().length() == 0) {
            XMLElement selem = this.getSource();
            XMLElement telem = this.getTarget();
            DefaultXMLElement tx = new DefaultXMLElement();
            int nn = this.copySDLSourceToTarget(selem, tx, subStrings, n, true);
            if (nn == subStrings.size()) {
                telem.getChildren().clear();
                List nlist = tx.getChildren();
                telem.getChildren().addAll(nlist);
                prop = true;
            }
        } else {
            DefaultXMLElement tx;
            XMLElement telem = this.getTarget();
            int nn = this.copySDLSourceToTarget(telem, tx = new DefaultXMLElement(), subStrings, n, false);
            if (nn == subStrings.size()) {
                telem.getChildren().clear();
                List nlist = tx.getChildren();
                telem.getChildren().addAll(nlist);
                prop = true;
            }
        }
        if (prop) {
            this.updateParentTargetSegment();
        }
        return prop;
    }

    public List getNotes() {
        if (this.fileType > 0) {
            if (this.comments != null) {
                return this.comments;
            }
            return this.getChildren("note");
        }
        return this.getChildren("note");
    }

    public void setNotes(List list) {
        this.comments = list;
    }

    public void removeNote(XMLElement note) {
        String name = note.getName();
        if (name.equals("mq:comment")) {
            List mqcomments = this.getChildren("mq:comments");
            if (!mqcomments.isEmpty()) {
                List commentElement;
                XMLElement commentsElement = (XMLElement)mqcomments.get(0);
                commentsElement.removeChild(note);
                if (this.comments != null) {
                    this.comments.remove(note);
                }
                if ((commentElement = commentsElement.getChildren("mq:comment")).isEmpty()) {
                    this.removeChild(commentsElement);
                }
            }
        } else if (name.equals("comment")) {
            List comments = this.getChildren("comments");
            if (!comments.isEmpty()) {
                List commentElement;
                XMLElement commentsElement = (XMLElement)comments.get(0);
                commentsElement.removeChild(note);
                if (comments != null) {
                    comments.remove(note);
                }
                if ((commentElement = commentsElement.getChildren("comment")).isEmpty()) {
                    this.removeChild(commentsElement);
                }
            }
        } else {
            this.removeChild(note);
        }
    }

    public List getContextGroups() {
        return this.getChildren("context-group");
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String s) {
        this.context = s;
    }

    public List getCountGroups() {
        return this.getChildren("count-group");
    }

    public List getAltTrans() {
        return this.getChildren("alt-trans");
    }

    @Override
    public void addIssue(Issue issue) {
        this.issues.add(issue);
    }

    @Override
    public List getIssues() {
        return this.issues;
    }

    @Override
    public void setIssues() {
        this.issues = new ArrayList(2);
    }

    public String replacePlaceablesInTarget(String source, String target) {
        List patterns;
        ArrayList<String> slist = new ArrayList<String>();
        Pattern np = NumbersHelper.getNumberPattern();
        if (AppPreferences.propagateNumbers && !AppPreferences.propagateNontranslatables) {
            Matcher ms = np.matcher(source);
            while (ms.find()) {
                String s = ms.group();
                if (AppPreferences.formatnumbers) {
                    String t = NumbersHelper.formatLocaleNumber(s);
                    if (!s.equals(t)) {
                        slist.add(t);
                        continue;
                    }
                    slist.add(s);
                    continue;
                }
                slist.add(s);
            }
        }
        if (AppPreferences.propagateNontranslatables && this.placeables != null && this.placeables != null) {
            for (Pattern next : this.placeables) {
                Matcher ms = next.matcher(source);
                while (ms.find()) {
                    slist.add(ms.group());
                }
            }
        }
        int k = 0;
        int i = 0;
        if (AppPreferences.propagateNumbers && !AppPreferences.propagateNontranslatables) {
            Matcher mt = np.matcher(target);
            StringBuffer sb = new StringBuffer();
            while (mt.find()) {
                if (placeableTargetReplacementList.size() > i) {
                    int j = (Integer)placeableTargetReplacementList.get(i);
                    if (j != -1 && j < slist.size()) {
                        String s = (String)slist.get(j);
                        mt.appendReplacement(sb, s);
                        ++k;
                    } else {
                        mt.appendReplacement(sb, mt.group());
                    }
                } else {
                    mt.appendReplacement(sb, mt.group());
                }
                ++i;
            }
            mt.appendTail(sb);
            target = sb.toString();
        }
        if (AppPreferences.propagateNontranslatables && (patterns = Placeables.getCurrentPlaceablePatterns()) != null) {
            for (Pattern next : patterns) {
                Matcher mt = next.matcher(target);
                StringBuffer sb = new StringBuffer();
                while (mt.find()) {
                    if (placeableTargetReplacementList.size() > i) {
                        int j = (Integer)placeableTargetReplacementList.get(i);
                        if (j != -1 && j < slist.size()) {
                            String s = (String)slist.get(j);
                            mt.appendReplacement(sb, s);
                            ++k;
                        } else {
                            mt.appendReplacement(sb, mt.group());
                        }
                    } else {
                        mt.appendReplacement(sb, mt.group());
                    }
                    ++i;
                }
                mt.appendTail(sb);
                target = sb.toString();
            }
        }
        if (k == 0 || k != placeableTargetReplacementList.size()) {
            return null;
        }
        return target;
    }

    public void addPlaceablePattern(Pattern p) {
        if (this.placeables == null) {
            this.placeables = new ArrayList(4);
        }
        this.placeables.add(p);
    }
}

