/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.xliff.FileBody;
import translator.xliff.FileHeader;
import translator.xliff.Glossary;
import translator.xliff.PhaseGroup;
import translator.xliff.Reference;
import translator.xliff.XLIFFUnit;

public class XliffFile
extends DefaultXMLElement {
    private FileHeader header;
    private FileBody body;
    private int fileID;
    public static String fileReplacementDir;
    private Date date;

    public XliffFile() {
        super(0, 2);
    }

    public boolean hasTranslationUnits() {
        return this.body != null && this.body.getTUCount() > 0;
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("header")) {
                FileHeader head = (FileHeader)xml;
                this.setHeader(head);
            } else if (name.equals("body")) {
                FileBody bod = (FileBody)xml;
                this.setBody(bod);
            } else {
                super.addChild(o);
            }
        }
    }

    public String getReference(String ruid) {
        List refs = this.getHeader().getReferences();
        if (refs != null) {
            for (Reference r : refs) {
                XMLElement ext = r.getExternalFile();
                if (ext == null) continue;
                String href = ext.getAttribute("href");
                String uid = ext.getAttribute("uid");
                if (href == null || uid == null || !ruid.equals(uid)) continue;
                return href;
            }
        }
        return null;
    }

    public void addReference(String rhref, String ruid) {
        List refs = this.getHeader().getReferences();
        if (refs != null) {
            for (Reference r : refs) {
                XMLElement ext = r.getExternalFile();
                if (ext == null) continue;
                String href = ext.getAttribute("href");
                String uid = ext.getAttribute("uid");
                if (href == null || !rhref.equals(href)) continue;
                if (ruid != null && uid != null) {
                    if (!ruid.equals(uid)) continue;
                    return;
                }
                return;
            }
        }
        Reference reference = new Reference();
        reference.setName("reference");
        DefaultXMLElement ext = new DefaultXMLElement();
        ext.setName("external-file");
        ext.setAttribute("href", rhref);
        if (ruid != null) {
            ext.setAttribute("uid", ruid);
        }
        reference.setExternalFile(ext);
        FileHeader head = this.getHeader();
        head.addChild(reference);
    }

    public void removeReference(String ref) {
        List refs = this.getHeader().getReferences();
        if (refs != null) {
            for (Reference r : refs) {
                String href;
                XMLElement ext = r.getExternalFile();
                if (ext == null || (href = ext.getAttribute("href")) == null || !href.equals(ref)) continue;
                this.getHeader().removeChild(r);
                break;
            }
        }
    }

    public void removeLibreOfficeReference() {
        List refs = this.getHeader().getReferences();
        if (refs != null) {
            for (Reference r : refs) {
                String uid;
                XMLElement ext = r.getExternalFile();
                if (ext == null || (uid = ext.getAttribute("uid")) == null || !uid.equals("LibreOffice")) continue;
                this.getHeader().removeChild(r);
                break;
            }
        }
    }

    public void addGlossary(String rhref, String ruid) {
        List glossaries = this.getHeader().getGlossaries();
        if (glossaries != null) {
            for (Glossary glossary : glossaries) {
                XMLElement ext = glossary.getExternalFile();
                if (ext == null) continue;
                String href = ext.getAttribute("href");
                String uid = ext.getAttribute("uid");
                if (href == null || !rhref.equals(href)) continue;
                if (ruid != null && uid != null) {
                    if (!ruid.equals(uid)) continue;
                    return;
                }
                return;
            }
        }
        Glossary gloss = new Glossary();
        gloss.setName("glossary");
        DefaultXMLElement ext = new DefaultXMLElement();
        ext.setName("external-file");
        ext.setAttribute("href", rhref);
        if (ruid != null) {
            ext.setAttribute("uid", ruid);
        }
        gloss.setExternalFile(ext);
        FileHeader head = this.getHeader();
        head.addChild(gloss);
    }

    public void removeGlossary(String ref) {
        List glossaries = this.getHeader().getGlossaries();
        if (glossaries != null) {
            for (Glossary glossary : glossaries) {
                String href;
                XMLElement ext = glossary.getExternalFile();
                if (ext == null || (href = ext.getAttribute("href")) == null || !href.equals(ref)) continue;
                this.getHeader().removeChild(glossary);
                break;
            }
        }
    }

    public FileBody getBody() {
        return this.body;
    }

    public void setBody(FileBody body) {
        this.body = body;
        super.addChild(body);
    }

    public void setVirtualBody(FileBody body) {
        this.body = body;
    }

    public void setHeader(FileHeader header) {
        this.header = header;
        super.addChild(header);
    }

    public FileHeader getHeader() {
        return this.header;
    }

    public void setHeaderNote(String note) {
        if (this.header != null) {
            List notes = this.header.getChildren("note");
            if (notes != null && notes.size() > 0) {
                XMLElement xnote = (XMLElement)notes.get(0);
                xnote.setContent(0, note);
            } else {
                DefaultXMLElement xnote = new DefaultXMLElement();
                xnote.setName("note");
                xnote.setContent(0, note);
                this.header.addChild(xnote);
            }
        }
    }

    public String getHeaderNote() {
        List notes;
        String note = null;
        if (this.header != null && (notes = this.header.getChildren("note")) != null && notes.size() > 0) {
            XMLElement xnote = (XMLElement)notes.get(0);
            note = (String)xnote.getContent(0);
        }
        return note;
    }

    public void setCurrentPhase(String processName) {
        List phases;
        PhaseGroup phgroup;
        if (this.header != null && (phgroup = this.header.getPhaseGroup()) != null && (phases = phgroup.getPhases()) != null) {
            for (XMLElement elem : phases) {
                String phname = elem.getAttribute("phase-name");
                if (!phname.equalsIgnoreCase("Default")) continue;
                elem.setAttribute("process-name", processName);
                break;
            }
        }
    }

    public String getCurrentPhase() {
        List phases;
        PhaseGroup phgroup;
        String processName = null;
        if (this.header != null && (phgroup = this.header.getPhaseGroup()) != null && (phases = phgroup.getPhases()) != null) {
            for (XMLElement elem : phases) {
                String name = elem.getAttribute("process-name");
                String phname = elem.getAttribute("phase-name");
                if (!phname.equalsIgnoreCase("Default")) continue;
                processName = name;
                break;
            }
        }
        return processName;
    }

    public Date getDate() {
        String d;
        if (this.date == null && (d = this.getAttribute("date")) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            try {
                this.date = sdf.parse(d);
            }
            catch (ParseException ex) {
                Logger.getLogger(XliffFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.date;
    }

    public void setLastID(String id) {
        this.setAttribute("text:segment", id);
    }

    public String getLastID() {
        String s = this.getAttribute("text:segment");
        return s;
    }

    public void setFileID(int id) {
        this.fileID = id;
    }

    public int getFileID() {
        return this.fileID;
    }

    public int getFirstTUID() {
        List list = this.body.getTransUnits();
        if (list != null && list.size() > 0) {
            XLIFFUnit tu = (XLIFFUnit)list.get(0);
            return tu.getUnitID();
        }
        return -1;
    }

    public String getShortName() {
        String name = this.getAttribute("original");
        if (name != null) {
            int fs = name.lastIndexOf(AppPreferences.fs);
            if (fs == -1 && (fs = name.lastIndexOf("/")) == -1) {
                fs = name.lastIndexOf("\\");
            }
            if (fs != -1) {
                name = name.substring(fs + 1);
            }
        }
        return name;
    }

    public String getTranslatablePath() {
        String path = this.getAttribute("original");
        return path;
    }
}

