/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.FileFilters;
import translator.FormatChooser;
import translator.LanguageCodes;
import translator.MainView;
import translator.Project;
import translator.Segmentation;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.translatables.AutoCadDocument;
import translator.ui.GridPanel;
import translator.ui.UITools;
import translator.ui.kodo.KodoButton;
import translator.ui.kodo.KodoTabbedPaneUI;
import translator.xliff.FileHeader;
import translator.xliff.Reference;
import translator.xliff.XLIFF;
import translator.xliff.XliffFile;

public class XliffFileEditor
extends JDialog
implements ActionListener {
    private JPanel propsPanel;
    private JPanel filterPanel;
    private JPanel jPanel1;
    private JPanel orgPanel;
    private JButton jButton1;
    private JButton jButton2;
    private JTextField ofield;
    private JTextField ofield2;
    private JTextField fieldProjectName;
    private JComboBox projectLocationBox;
    private JComboBox combo1;
    private JComboBox combo2;
    private JComboBox combo8;
    private JComboBox combo9;
    private XliffFile projectFile;
    public boolean cancelled = false;
    private MainView topui;
    private LinkedHashMap segAttrs;
    private boolean segAttrsSet = true;
    private boolean isNewFile;
    private boolean withLibreOffce;
    private int mode;
    private int rows = 0;
    private JCheckBox folderBox;
    private JLabel filterLabel;
    private JTextField documentsFilterField;
    private Memory projectTM;
    private JCheckBox newMemBox;
    private JCheckBox newGlossaryBox;
    private Project project;

    public XliffFileEditor(final MainView topui, XliffFile projFile, int mode, boolean isNew, String title) {
        super(topui, title, true);
        File file;
        String projectPath;
        this.setResizable(false);
        this.projectFile = projFile;
        this.topui = topui;
        this.isNewFile = isNew;
        this.withLibreOffce = topui.getResourceView().isLibreOfficeAvailable();
        String projectName = null;
        String projectLocation = null;
        this.project = topui.getProjectView().getProject();
        if (this.project != null && (projectPath = this.project.getProjectPath()) != null && (file = new File(projectPath)).exists() && (file = file.getParentFile()).exists()) {
            projectName = file.getName();
            if ((file = file.getParentFile()).exists()) {
                projectLocation = file.getPath();
            }
        }
        FileHeader header = this.projectFile.getHeader();
        Reference ref = null;
        if (header != null && (ref = header.getReference("Aligned document")) != null) {
            mode = 4;
        }
        this.mode = mode;
        JTabbedPane jTab = new JTabbedPane(1, 1);
        if (!AppPreferences.laf.equals("Nimbus")) {
            KodoTabbedPaneUI ui = new KodoTabbedPaneUI();
            jTab.setUI(ui);
        }
        this.jPanel1 = new JPanel();
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridLayout(0, 2, 10, 10));
        this.orgPanel = new JPanel();
        this.orgPanel.setOpaque(false);
        this.orgPanel.setLayout(new SpringLayout());
        this.orgPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.projectLocationBox = new JComboBox();
        this.projectLocationBox.setPreferredSize(new Dimension(600, 32));
        this.projectLocationBox.setMaximumSize(new Dimension(600, 32));
        if (AppPreferences.projectLocations.length() > 0 && isNew) {
            String[] arr = AppPreferences.projectLocations.split(";");
            for (int i = 0; i < arr.length; ++i) {
                File f;
                String string = arr[i];
                if (string.length() <= 0 || !(f = new File(string)).exists()) continue;
                this.projectLocationBox.addItem(string);
            }
        }
        this.projectLocationBox.setEditable(true);
        if (projectLocation != null && projectLocation.length() > 0) {
            this.projectLocationBox.setSelectedItem(projectLocation);
        } else if (AppPreferences.projectLocationDir.length() > 0) {
            this.projectLocationBox.setSelectedItem(AppPreferences.projectLocationDir);
        } else {
            String wloc;
            File f;
            String loc = System.getProperty("user.home") + AppPreferences.fs + "Projects";
            if (AppPreferences.operatingSystem == 0 && (f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists()) {
                loc = wloc + AppPreferences.fs + "Projects";
            }
            this.projectLocationBox.setSelectedItem(loc);
        }
        String plocation = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT LOCATION") + "...";
        KodoButton projectLocationButton = new KodoButton(plocation);
        projectLocationButton.setName("ProjectLocation");
        ((JComponent)projectLocationButton).setBackground(topui.getMainPanelBackgroundColor());
        projectLocationButton.setForeground(new Color(AppPreferences.toolBarsForeground));
        projectLocationButton.setHorizontalAlignment(2);
        projectLocationButton.addActionListener(new ActionListener(){
            final /* synthetic */ XliffFileEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            try {
                                File file;
                                DirectoryChooser fileChooser = new DirectoryChooser();
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT LOCATION"));
                                File f = new File(AppPreferences.projectLocationDir);
                                if (f.isDirectory() && f.canRead()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showDialog(null)) != null) {
                                    final String path = file.getPath();
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            this.this$2.this$1.this$0.projectLocationBox.setSelectedItem(path);
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(topui, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    File file;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT LOCATION"));
                    jFileChooser.setSelectedFile(new File(""));
                    File f = new File(AppPreferences.projectLocationDir);
                    if (f.isDirectory()) {
                        jFileChooser.setCurrentDirectory(f);
                    }
                    if (0 == jFileChooser.showOpenDialog(topui) && (file = jFileChooser.getSelectedFile()) != null) {
                        final String path = file.getPath();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                this.this$1.this$0.projectLocationBox.setSelectedItem(path);
                            }
                        });
                    }
                }
            }
        });
        this.fieldProjectName = new JTextField();
        if (projectName != null) {
            this.fieldProjectName.setText(projectName);
        }
        this.fieldProjectName.setName("ProjectName");
        this.fieldProjectName.setEnabled(isNew);
        this.fieldProjectName.setCaretPosition(0);
        this.fieldProjectName.setMargin(new Insets(0, 2, 0, 0));
        this.fieldProjectName.setFont(this.fieldProjectName.getFont().deriveFont(1));
        this.fieldProjectName.setPreferredSize(new Dimension(600, this.fieldProjectName.getPreferredSize().height));
        if (AppPreferences.linuxGTK) {
            this.fieldProjectName.setCaretColor(this.fieldProjectName.getForeground());
        }
        String pname = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT NAME:");
        JLabel label = new JLabel(pname);
        label.setName("ProjectName");
        label.setHorizontalAlignment(4);
        this.orgPanel.add(label);
        this.orgPanel.add(this.fieldProjectName);
        ++this.rows;
        this.orgPanel.add(projectLocationButton);
        this.orgPanel.add(this.projectLocationBox);
        ++this.rows;
        LinkedHashMap attr = this.projectFile.getAttributes();
        if (attr != null) {
            Set keys = attr.keySet();
            for (String name : keys) {
                String display;
                if (name.startsWith("text:") || name.equals("date")) continue;
                String value = (String)attr.get(name);
                if (name.equals("original")) {
                    String sref;
                    if (mode == 0 || mode == 4 || mode == 5) {
                        this.ofield = new JTextField(value);
                        this.ofield.setCaretPosition(0);
                        this.ofield.setMargin(new Insets(0, 2, 0, 0));
                        this.ofield.setPreferredSize(new Dimension(600, 32));
                        this.ofield.setName(name);
                        display = mode == 0 || mode == 5 ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT") + "..." : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT 1") + "...";
                        KodoButton jb = new KodoButton(display);
                        ((JComponent)jb).setBackground(topui.getMainPanelBackgroundColor());
                        jb.setForeground(new Color(AppPreferences.toolBarsForeground));
                        jb.setName(name);
                        jb.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET FILE PATH"));
                        jb.setHorizontalAlignment(2);
                        jb.addActionListener(new ActionListener(){
                            final /* synthetic */ XliffFileEditor this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String sel = (String)this.this$0.combo9.getSelectedItem();
                                if (this.this$0.folderBox != null && this.this$0.folderBox.isSelected() && !sel.equals("LibreOffice Document")) {
                                    this.this$0.chooseFolder();
                                    return;
                                }
                                if (AppPreferences.isJavaFXReady()) {
                                    Platform.runLater((Runnable)new Runnable(){
                                        final /* synthetic */ 2 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        @Override
                                        public void run() {
                                            try {
                                                File file;
                                                FileChooser fileChooser = new FileChooser();
                                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE DOCUMENT"));
                                                File f = new File(AppPreferences.sourceFilesDirectory);
                                                if (f.isDirectory() && f.canRead()) {
                                                    fileChooser.setInitialDirectory(f);
                                                }
                                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                                    SwingUtilities.invokeLater(new Runnable(){
                                                        final /* synthetic */ 1 this$2;
                                                        {
                                                            this.this$2 = this$2;
                                                        }

                                                        @Override
                                                        public void run() {
                                                            String desc = this.this$2.this$1.this$0.combo9.getSelectedItem().toString();
                                                            this.this$2.this$1.this$0.selectSourceFile(file, desc);
                                                        }
                                                    });
                                                }
                                            }
                                            catch (Exception ex) {
                                                final String s = ex.getMessage();
                                                SwingUtilities.invokeLater(new Runnable(){
                                                    final /* synthetic */ 1 this$2;
                                                    {
                                                        this.this$2 = this$2;
                                                    }

                                                    @Override
                                                    public void run() {
                                                        JOptionPane.showMessageDialog(topui, s);
                                                    }
                                                });
                                            }
                                        }
                                    });
                                } else {
                                    FileFilters filters = new FileFilters();
                                    String filterName = this.this$0.combo9.getSelectedItem().toString();
                                    JFileChooser jFileChooser = new JFileChooser();
                                    jFileChooser.setFileSelectionMode(0);
                                    filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
                                    jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE DOCUMENT"));
                                    File f = new File(AppPreferences.sourceFilesDirectory);
                                    if (f.isDirectory()) {
                                        jFileChooser.setCurrentDirectory(f);
                                    }
                                    if (0 == jFileChooser.showOpenDialog(topui)) {
                                        FileFilter filter = jFileChooser.getFileFilter();
                                        String desc = filter.getDescription();
                                        if (desc.equals("All Files")) {
                                            desc = "Text";
                                        }
                                        File file = jFileChooser.getSelectedFile();
                                        this.this$0.selectSourceFile(file, desc);
                                    }
                                }
                            }
                        });
                        this.orgPanel.add(jb);
                        this.orgPanel.add(this.ofield);
                        ++this.rows;
                        if (mode == 0 && this.isNewFile) {
                            this.folderBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE FOLDER WITH DOCUMENTS"));
                            this.folderBox.addItemListener(new ItemListener(){

                                @Override
                                public void itemStateChanged(ItemEvent e) {
                                    if (e.getStateChange() == 1) {
                                        XliffFileEditor.this.documentsFilterField.setEnabled(true);
                                        XliffFileEditor.this.documentsFilterField.setVisible(true);
                                        XliffFileEditor.this.filterLabel.setVisible(true);
                                    } else {
                                        XliffFileEditor.this.documentsFilterField.setEnabled(false);
                                        XliffFileEditor.this.documentsFilterField.setVisible(false);
                                        XliffFileEditor.this.filterLabel.setVisible(false);
                                    }
                                }
                            });
                            this.folderBox.setName("TranslateFolder");
                            this.orgPanel.add(new JLabel());
                            this.orgPanel.add(this.folderBox);
                            ++this.rows;
                            this.filterLabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILTER FILES (E.G. DOCX|XLSX):"));
                            this.orgPanel.add(this.filterLabel);
                            this.documentsFilterField = new JTextField();
                            this.documentsFilterField.setName("TextFieldFilterFiles");
                            if (!this.folderBox.isSelected()) {
                                this.documentsFilterField.setEnabled(false);
                                this.documentsFilterField.setVisible(false);
                                this.filterLabel.setVisible(false);
                            }
                            this.orgPanel.add(this.documentsFilterField);
                            ++this.rows;
                        }
                    }
                    if (mode != 4) continue;
                    this.ofield2 = new JTextField();
                    if (ref != null && (sref = ref.getExternalFile().getAttribute("href")) != null) {
                        this.ofield2.setText(sref);
                    }
                    this.ofield2.setCaretPosition(0);
                    this.ofield2.setMargin(new Insets(0, 2, 0, 0));
                    this.ofield2.setPreferredSize(new Dimension(600, 32));
                    KodoButton jb = new KodoButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT 2") + "...");
                    jb.setName(name);
                    jb.setHorizontalAlignment(2);
                    ((JComponent)jb).setBackground(topui.getMainPanelBackgroundColor());
                    jb.setForeground(new Color(AppPreferences.toolBarsForeground));
                    jb.addActionListener(new ActionListener(){
                        final /* synthetic */ XliffFileEditor this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (AppPreferences.isJavaFXReady()) {
                                Platform.runLater((Runnable)new Runnable(){
                                    final /* synthetic */ 4 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            File file;
                                            FileChooser fileChooser = new FileChooser();
                                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A TARGET DOCUMENT"));
                                            File f = new File(AppPreferences.sourceFilesDirectory);
                                            if (f.isDirectory() && f.canRead()) {
                                                fileChooser.setInitialDirectory(f);
                                            }
                                            if ((file = fileChooser.showOpenDialog(null)) != null) {
                                                final String path = file.getPath();
                                                SwingUtilities.invokeLater(new Runnable(){
                                                    final /* synthetic */ 1 this$2;
                                                    {
                                                        this.this$2 = this$2;
                                                    }

                                                    @Override
                                                    public void run() {
                                                        this.this$2.this$1.this$0.ofield2.setText(path);
                                                    }
                                                });
                                            }
                                        }
                                        catch (Exception ex) {
                                            final String s = ex.getMessage();
                                            SwingUtilities.invokeLater(new Runnable(){
                                                final /* synthetic */ 1 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                }

                                                @Override
                                                public void run() {
                                                    JOptionPane.showMessageDialog(topui, s);
                                                }
                                            });
                                        }
                                    }
                                });
                            } else {
                                FileFilters filters = new FileFilters();
                                String filterName = this.this$0.combo9.getSelectedItem().toString();
                                JFileChooser jFileChooser = new JFileChooser();
                                jFileChooser.setFileSelectionMode(0);
                                filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
                                jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A TARGET DOCUMENT"));
                                jFileChooser.setSelectedFile(new File(""));
                                File f = new File(AppPreferences.sourceFilesDirectory);
                                if (f.isDirectory()) {
                                    jFileChooser.setCurrentDirectory(f);
                                }
                                if (0 == jFileChooser.showOpenDialog(topui)) {
                                    File file;
                                    FileFilter filter = jFileChooser.getFileFilter();
                                    String desc = filter.getDescription();
                                    if (desc.equals("All Files")) {
                                        desc = "Text";
                                    }
                                    if ((file = jFileChooser.getSelectedFile()).isFile()) {
                                        String name = file.getName();
                                        String path = file.getPath();
                                        this.this$0.ofield2.setText(path);
                                    }
                                }
                            }
                        }
                    });
                    this.orgPanel.add(jb);
                    this.orgPanel.add(this.ofield2);
                    ++this.rows;
                    continue;
                }
                if (name.equals("tool-id")) continue;
                if (name.equals("source-language")) {
                    String val;
                    display = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE-LANGUAGE:");
                    label = new JLabel(display);
                    label.setHorizontalAlignment(4);
                    label.setName(name);
                    label.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SWITCH LANGUAGES"));
                    label.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            String src = (String)XliffFileEditor.this.combo1.getSelectedItem();
                            String trg = (String)XliffFileEditor.this.combo2.getSelectedItem();
                            if (src != null && trg != null) {
                                XliffFileEditor.this.combo1.setSelectedItem(trg);
                                XliffFileEditor.this.combo2.setSelectedItem(src);
                            }
                        }
                    });
                    label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.blue));
                    label.setFont(label.getFont().deriveFont(1));
                    String[] langs = LanguageCodes.getNames();
                    this.combo1 = new JComboBox<String>(langs);
                    this.combo1.setEditable(true);
                    Font cfont = this.combo1.getFont();
                    float fsize = cfont.getSize2D();
                    if ((double)fsize < 12.0) {
                        this.combo1.setFont(cfont.deriveFont(12.0f));
                    }
                    if ((val = LanguageCodes.getName(value)) != null) {
                        this.combo1.setSelectedItem(val);
                    } else {
                        this.combo1.setSelectedItem(value);
                    }
                    if (!isNew && value.length() > 0 && this.project.mode != 3) {
                        this.combo1.setEnabled(false);
                    }
                    this.jPanel1.add(label);
                    this.jPanel1.add(this.combo1);
                    continue;
                }
                if (name.equals("target-language")) {
                    String val;
                    display = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET-LANGUAGE:");
                    label = new JLabel(display);
                    label.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Color.red));
                    label.setHorizontalAlignment(4);
                    label.setName(name);
                    label.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SWITCH LANGUAGES"));
                    label.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            String src = (String)XliffFileEditor.this.combo1.getSelectedItem();
                            String trg = (String)XliffFileEditor.this.combo2.getSelectedItem();
                            if (src != null && trg != null) {
                                XliffFileEditor.this.combo1.setSelectedItem(trg);
                                XliffFileEditor.this.combo2.setSelectedItem(src);
                            }
                        }
                    });
                    label.setFont(label.getFont().deriveFont(1));
                    String[] langs = LanguageCodes.getNames();
                    this.combo2 = new JComboBox<String>(langs);
                    this.combo2.setEditable(true);
                    Font cfont = this.combo2.getFont();
                    float fsize = cfont.getSize2D();
                    if ((double)fsize < 12.0) {
                        this.combo2.setFont(cfont.deriveFont(12.0f));
                    }
                    if ((val = LanguageCodes.getName(value)) != null) {
                        this.combo2.setSelectedItem(val);
                    } else {
                        this.combo2.setSelectedItem(value);
                    }
                    if (!isNew && value.length() > 0 && this.project.mode != 3) {
                        this.combo2.setEnabled(false);
                    }
                    this.jPanel1.add(label);
                    this.jPanel1.add(this.combo2);
                    continue;
                }
                if (name.equals("datatype")) {
                    label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE-TYPE:"));
                    label.setHorizontalAlignment(4);
                    label.setName(name);
                    label.setFont(label.getFont().deriveFont(1));
                    this.combo9 = new JComboBox();
                    this.combo9.setMaximumRowCount(12);
                    this.combo9.setEditable(false);
                    Font cfont = this.combo9.getFont();
                    float fsize = cfont.getSize2D();
                    if ((double)fsize < 12.0) {
                        this.combo9.setFont(cfont.deriveFont(12.0f));
                    }
                    for (int j = 0; j < FormatChooser.formatType.length; ++j) {
                        String string = FormatChooser.formatType[j];
                        this.combo9.addItem(string);
                    }
                    if (this.withLibreOffce && mode != 4 && mode != 3) {
                        this.combo9.addItem("LibreOffice Document");
                        if (value != null && value.equals("x-auto")) {
                            mode = 5;
                        }
                    }
                    boolean definedType = true;
                    if (mode == 2) {
                        int k = FormatChooser.formatType.length - 1;
                        String v = FormatChooser.formatType[k];
                        this.combo9.setSelectedItem(v);
                    } else if (mode == 3) {
                        definedType = false;
                    } else if (mode == 5) {
                        this.combo9.setSelectedItem("LibreOffice Document");
                    } else if (value == null || value.length() == 0 || value.equals("x-auto")) {
                        String val = AppPreferences.format;
                        this.combo9.setSelectedItem(val);
                    } else {
                        String val = FormatChooser.getFormatType(value);
                        int count = this.combo9.getItemCount();
                        boolean foundType = false;
                        for (int j = 0; j < count; ++j) {
                            String s = (String)this.combo9.getItemAt(j);
                            if (!s.equals(val)) continue;
                            foundType = true;
                            break;
                        }
                        definedType = foundType;
                        this.combo9.setSelectedItem(val);
                    }
                    if (!definedType) continue;
                    this.jPanel1.add(label);
                    this.jPanel1.add(this.combo9);
                    continue;
                }
                if (name.startsWith("filter:")) continue;
                label = new JLabel();
                label.setHorizontalAlignment(4);
                label.setText(name);
                label.setName(name);
                label.setFont(label.getFont().deriveFont(1));
                JTextField field = new JTextField(value);
                field.setCaretPosition(0);
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setFont(field.getFont().deriveFont(1));
                field.setPreferredSize(new Dimension(210, 24));
                this.jPanel1.add(label);
                this.jPanel1.add(field);
            }
            if (isNew && mode == 4 || mode == 5) {
                String display = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTATION") + ":";
                label = new JLabel(display);
                label.setHorizontalAlignment(4);
                label.setFont(label.getFont().deriveFont(1));
                String[] types = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROGRESSIVE SEGMENTATION"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTO-SEGMENTATION")};
                this.combo8 = new JComboBox<String>(types);
                this.combo8.setEditable(false);
                Font cfont = this.combo8.getFont();
                float fsize = cfont.getSize2D();
                if ((double)fsize < 12.0) {
                    this.combo8.setFont(cfont.deriveFont(12.0f));
                }
                this.combo8.setSelectedIndex(1);
                this.jPanel1.add(label);
                this.jPanel1.add(this.combo8);
            }
        }
        JPanel jPanelFilter = new JPanel();
        jPanelFilter.setOpaque(false);
        jPanelFilter.setBorder(new EmptyBorder(new Insets(10, 0, 5, 0)));
        this.filterPanel = new JPanel();
        this.filterPanel.setOpaque(false);
        this.filterPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanelFilter.add(this.filterPanel);
        JPanel jPanel0 = new JPanel();
        jPanel0.setOpaque(false);
        jPanel0.setBorder(new EmptyBorder(new Insets(10, 0, 5, 0)));
        this.propsPanel = new JPanel();
        this.propsPanel.setName("ProjectProperties");
        this.propsPanel.setOpaque(false);
        this.propsPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel0.add(this.propsPanel);
        this.segAttrs = topui.getProjectView().getProject().getSegmentAttributes();
        if (this.segAttrs == null || this.segAttrs.size() == 0) {
            this.segAttrsSet = false;
            this.segAttrs = new LinkedHashMap(4);
            String[] at = AppPreferences.segmentAttributes.split(";");
            if (at != null) {
                for (int i = 0; i < at.length; ++i) {
                    String string = at[i];
                    if (string.length() <= 0) continue;
                    if (string.indexOf(32) != -1) {
                        string = string.replace(" ", "");
                    }
                    if (string.indexOf(58) != -1) {
                        string = string.replace(":", "");
                    }
                    this.segAttrs.put(string, "");
                }
            }
            if (this.segAttrs.size() < 1) {
                this.segAttrs.put("Project", "");
            }
            if (this.segAttrs.size() < 2 && AppPreferences.dbFieldCol.length() > 0) {
                this.segAttrs.put(AppPreferences.dbFieldCol, "");
            }
            if (this.segAttrs.size() < 3) {
                this.segAttrs.put("Client", "");
            }
            if (this.segAttrs.size() < 4) {
                this.segAttrs.put("Property", "");
            }
        }
        for (String n : this.segAttrs.keySet()) {
            String s;
            int i;
            Object[] o;
            String v = (String)this.segAttrs.get(n);
            JComboBox<Object> box = null;
            JTextField field = null;
            if (n.equalsIgnoreCase(AppPreferences.dbFieldCol)) {
                List subjects = Project.getSubjectList();
                if (subjects != null && subjects.size() > 0) {
                    o = subjects.toArray();
                    box = new JComboBox<Object>(o);
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                    box.setPreferredSize(new Dimension(250, box.getPreferredSize().height));
                    for (i = 0; i < o.length; ++i) {
                        s = o[i].toString();
                        if (!s.equalsIgnoreCase(v)) continue;
                        box.setSelectedItem(v);
                        break;
                    }
                } else {
                    box = new JComboBox();
                    box.setEditable(true);
                    box.setSelectedItem(v);
                }
            } else if (n.equalsIgnoreCase(AppPreferences.dbClientCol)) {
                List cilents = Project.getClientList();
                if (cilents != null && cilents.size() > 0) {
                    o = cilents.toArray();
                    box = new JComboBox<Object>(o);
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                    box.setPreferredSize(new Dimension(250, box.getPreferredSize().height));
                    for (i = 0; i < o.length; ++i) {
                        s = o[i].toString();
                        if (!s.equalsIgnoreCase(v)) continue;
                        box.setSelectedItem(v);
                        break;
                    }
                } else {
                    box = new JComboBox();
                    box.setEditable(true);
                    box.setSelectedItem(v);
                }
            } else {
                field = new JTextField(v);
                field.setCaretPosition(0);
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setFont(field.getFont().deriveFont(1));
                field.setPreferredSize(new Dimension(250, field.getPreferredSize().height));
            }
            JButton jb = new JButton();
            jb.setPreferredSize(new Dimension(250, jb.getPreferredSize().height));
            String display = n.substring(0, 1).toUpperCase() + n.substring(1);
            jb.setText(display);
            jb.setName(n);
            jb.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SET A PROPERTY NAME"));
            jb.setHorizontalAlignment(2);
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    String org = button.getName();
                    String n = JOptionPane.showInputDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A PROPERTY NAME:"), (Object)org);
                    if (n != null && n.length() > 0) {
                        String display = n.substring(0, 1).toUpperCase() + n.substring(1);
                        button.setText(display);
                        button.setName(n);
                    }
                }
            });
            this.propsPanel.add(jb);
            if (field != null) {
                this.propsPanel.add(field);
                continue;
            }
            this.propsPanel.add(box);
        }
        JPanel resPanel = new JPanel();
        resPanel.setOpaque(false);
        resPanel.setLayout(new SpringLayout());
        resPanel.setBorder(new EmptyBorder(new Insets(10, 10, 0, 0)));
        this.projectTM = topui.getMemoryView().newProjectMemory();
        JButton memPRButton = new JButton("");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SETTINGS, (int)(memPRButton.getFont().getSize() + 4), (Color)memPRButton.getForeground());
        memPRButton.setIcon((Icon)ficon);
        memPRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XliffFileEditor.this.projectTM.showStartDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW PROJECT MEMORY"));
                AppPreferences.forSegmentsMemoryPR = XliffFileEditor.this.projectTM.getSegmentsMode();
                AppPreferences.forTermsMemoryPR = XliffFileEditor.this.projectTM.getTermsMode();
                AppPreferences.termsCheckMemoryPR = XliffFileEditor.this.projectTM.getTermsCheck();
                AppPreferences.duplicatesMemoryPR = XliffFileEditor.this.projectTM.getDuplicatesMode();
                AppPreferences.priorityMemoryPR = XliffFileEditor.this.projectTM.getPriority();
                AppPreferences.matchCaseMemoryPR = XliffFileEditor.this.projectTM.getCaseMatch();
                AppPreferences.exactGreedyMatchMemoryPR = XliffFileEditor.this.projectTM.isGreedyMatching();
            }
        });
        this.newMemBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT MEMORY"));
        if (isNew) {
            this.newMemBox.setSelected(AppPreferences.projectTMX);
        }
        this.newMemBox.setOpaque(false);
        resPanel.add(this.newMemBox);
        resPanel.add(memPRButton);
        this.newGlossaryBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT GLOSSARY"));
        if (isNew) {
            this.newGlossaryBox.setSelected(AppPreferences.projectGlossary);
        }
        resPanel.add(this.newGlossaryBox);
        JLabel lab = new JLabel("");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PENCIL, (int)(lab.getFont().getSize() + 4), (Color)lab.getForeground());
        lab.setIcon((Icon)ficon);
        resPanel.add(lab);
        this.jButton1 = new KodoButton();
        if (isNew) {
            this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINISH"));
        } else {
            this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        }
        this.jButton1.setBackground(topui.getMainPanelBackgroundColor());
        this.jButton1.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.jButton1.setPreferredSize(new Dimension(100, 28));
        this.jButton1.addActionListener(this);
        this.jButton2 = new KodoButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.setBackground(topui.getMainPanelBackgroundColor());
        this.jButton2.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.jButton2.setPreferredSize(new Dimension(100, 28));
        this.jButton2.addActionListener(this);
        JPanel docPanel = new JPanel();
        docPanel.setOpaque(false);
        docPanel.setLayout(new FlowLayout(1));
        docPanel.setBorder(new EmptyBorder(new Insets(10, 0, 90, 0)));
        docPanel.add(this.jPanel1);
        jTab.add(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT SETTING"), docPanel);
        jTab.add(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY AND GLOSSARY"), resPanel);
        jTab.add(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT PROPERTIES"), jPanel0);
        jTab.add(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILTER OPTIONS"), jPanelFilter);
        jTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane pane;
                int i;
                if (e.getSource() instanceof JTabbedPane && (i = (pane = (JTabbedPane)e.getSource()).getSelectedIndex()) == 3) {
                    Map options;
                    if (XliffFileEditor.this.filterPanel.getComponentCount() > 0) {
                        XliffFileEditor.this.filterPanel.removeAll();
                    }
                    if (XliffFileEditor.this.isNewFile) {
                        String s = XliffFileEditor.this.combo9.getSelectedItem().toString();
                        options = FormatChooser.getFilterOptions(s);
                    } else {
                        options = XliffFileEditor.this.projectFile.getAttributes();
                    }
                    if (options != null && !options.isEmpty()) {
                        for (Map.Entry entry : options.entrySet()) {
                            String labelText;
                            String key = entry.getKey().toString();
                            if (!key.startsWith("filter:")) continue;
                            boolean autocad = false;
                            boolean checkbox = false;
                            if (key.equals("filter:ImportSourceColumn")) {
                                labelText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT SOURCE COLUMN") + ":";
                            } else if (key.equals("filter:ExportColumn")) {
                                labelText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COLUMN") + ":";
                            } else if (key.equals("filter:ImportTargetColumn")) {
                                labelText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TARGET COLUMN") + ":";
                            } else if (key.equals("filter:ImportNotesColumn")) {
                                labelText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT NOTES COLUMN") + ":";
                            } else if (key.equals("filter:NoSegmentation")) {
                                labelText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO SEGMENATION IN CELLS");
                                checkbox = true;
                            } else if (key.equals("filter:Layers")) {
                                labelText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILTER LAYERS") + "...";
                                autocad = true;
                            } else {
                                labelText = key;
                            }
                            if (checkbox) {
                                boolean val = (Boolean)entry.getValue();
                                JCheckBox jbox = new JCheckBox(labelText, val);
                                JLabel label = new JLabel();
                                label.setName(key);
                                XliffFileEditor.this.filterPanel.add(label);
                                XliffFileEditor.this.filterPanel.add(jbox);
                                continue;
                            }
                            String val = entry.getValue().toString();
                            if (autocad) {
                                JButton button = new JButton(labelText);
                                button.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        String p = XliffFileEditor.this.ofield.getText();
                                        File file = new File(p);
                                        if (file.exists() && file.isFile()) {
                                            AutoCadDocument doc = new AutoCadDocument();
                                            doc.filterLayers(file);
                                            String layers = doc.getFilteredLayers();
                                            if (layers != null && layers.length() > 0) {
                                                JTextField field = (JTextField)XliffFileEditor.this.filterPanel.getComponent(1);
                                                field.setText(layers);
                                            }
                                        }
                                    }
                                });
                                button.setName(key);
                                XliffFileEditor.this.filterPanel.add(button);
                            } else {
                                JLabel label = new JLabel(labelText);
                                label.setName(key);
                                label.setHorizontalAlignment(4);
                                XliffFileEditor.this.filterPanel.add(label);
                            }
                            JTextField field = new JTextField(val);
                            field.setCaretPosition(0);
                            field.setMargin(new Insets(0, 2, 0, 0));
                            field.setFont(field.getFont().deriveFont(1));
                            field.setPreferredSize(new Dimension(250, 32));
                            XliffFileEditor.this.filterPanel.add(field);
                        }
                    }
                    XliffFileEditor.this.filterPanel.revalidate();
                    XliffFileEditor.this.filterPanel.repaint();
                }
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.setBorder(new EmptyBorder(new Insets(0, 0, 5, 0)));
        buttonsPanel.add(this.jButton2);
        buttonsPanel.add(this.jButton1);
        GridPanel con = new GridPanel();
        con.setLayout(new BorderLayout());
        this.setContentPane(con);
        con.setBorder(new EmptyBorder(new Insets(10, 10, 0, 10)));
        if (mode == 4) {
            UITools.makeCompactGrid(this.orgPanel, this.rows, 2, 0, 0, 10, 10);
        } else {
            UITools.makeCompactGrid(this.orgPanel, this.rows, 2, 0, 0, 10, 10);
        }
        UITools.makeCompactGrid(resPanel, 2, 2, 0, 0, 5, 5);
        con.add((Component)this.orgPanel, "North");
        con.add((Component)jTab, "Center");
        con.add((Component)buttonsPanel, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XliffFileEditor.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XliffFileEditor.this.cancelled = true;
                XliffFileEditor.this.closeDialog();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                XliffFileEditor.this.cancelled = true;
                XliffFileEditor.this.closeDialog();
            }
        });
        this.pack();
        this.fieldProjectName.requestFocusInWindow();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            XLIFF xliff;
            Segmentation seg;
            String val;
            String proName = this.fieldProjectName.getText();
            Object item = this.projectLocationBox.getSelectedItem();
            if (proName.trim().length() == 0) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO PROJECT NAME!"));
                return;
            }
            if (item == null) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO PROJECT LOCATION!"));
                return;
            }
            String proLocation = item.toString().trim();
            if (proLocation.length() == 0) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO PROJECT LOCATION!"));
                return;
            }
            if (this.isNewFile) {
                String invalidChars = "\\/:*?\"<>|";
                char[] chars = proName.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (invalidChars.indexOf(chars[i]) < 0 && chars[i] >= ' ' && (chars[i] <= '~' || chars[i] >= '\u00a0')) continue;
                    JOptionPane.showMessageDialog(this.topui, "Invalid character in the Project name: " + chars[i]);
                    return;
                }
                if (this.mode == 0 || this.mode == 4 || this.mode == 5) {
                    String org = this.ofield.getText().toLowerCase();
                    if (org.endsWith(".doc")) {
                        JOptionPane.showMessageDialog(this.topui, "Please save this MS Word .doc file in the new MS Word .docx format and create the project again.");
                        return;
                    }
                    if (org.endsWith(".ppt")) {
                        JOptionPane.showMessageDialog(this.topui, "Please save this MS PowerPoint .ppt file in the new MS PowerPoint .pptx format and create the project again.");
                        return;
                    }
                    if (org.endsWith(".xls")) {
                        JOptionPane.showMessageDialog(this.topui, "Please save this MS Excel .xls file in the new MS Excel .xlsx format and create the project again.");
                        return;
                    }
                    this.projectFile.setAttribute("original", this.ofield.getText());
                } else {
                    this.projectFile.setAttribute("original", this.fieldProjectName.getText());
                }
                File f = new File(proLocation);
                if (f.exists()) {
                    AppPreferences.projectLocationDir = proLocation;
                    if (AppPreferences.projectLocations.length() == 0) {
                        AppPreferences.projectLocations = proLocation;
                    } else {
                        boolean b = false;
                        String[] arr = AppPreferences.projectLocations.split(";");
                        for (int i = 0; i < arr.length; ++i) {
                            String string = arr[i];
                            if (!string.equalsIgnoreCase(proLocation)) continue;
                            b = true;
                            break;
                        }
                        if (!b) {
                            if (arr.length < 6) {
                                AppPreferences.projectLocations = proLocation + ";" + AppPreferences.projectLocations;
                            } else {
                                int fi = AppPreferences.projectLocations.lastIndexOf(59);
                                if (fi != -1) {
                                    AppPreferences.projectLocations = AppPreferences.projectLocations.substring(0, fi);
                                    AppPreferences.projectLocations = proLocation + ";" + AppPreferences.projectLocations;
                                }
                            }
                        }
                    }
                }
                if (!proLocation.endsWith(AppPreferences.fs)) {
                    proLocation = proLocation + AppPreferences.fs;
                }
                AppPreferences.projectDirectory = proLocation + this.fieldProjectName.getText();
            }
            boolean image = false;
            Component[] comps = this.jPanel1.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                String val2;
                JComponent field;
                String type = null;
                String value = null;
                if (comps[i] instanceof JLabel) {
                    JLabel lab = (JLabel)comps[i];
                    type = lab.getName();
                    ++i;
                } else if (comps[i] instanceof JButton) {
                    JButton but = (JButton)comps[i];
                    type = but.getName();
                    ++i;
                }
                int selection = -1;
                if (comps[i] instanceof JTextField) {
                    field = (JTextField)comps[i];
                    if (field.isEnabled()) {
                        value = ((JTextComponent)field).getText();
                    }
                } else if (comps[i] instanceof JComboBox && (field = (JComboBox)comps[i]).isEnabled()) {
                    value = (String)((JComboBox)field).getSelectedItem();
                    selection = ((JComboBox)field).getSelectedIndex();
                }
                if (type == null || value == null) continue;
                if (type.equals("datatype")) {
                    if (value.equals("LibreOffice Document")) {
                        value = "x-openoffice";
                        this.mode = 5;
                    } else {
                        if (value.startsWith("Image")) {
                            image = true;
                        }
                        AppPreferences.format = value;
                        if ((value = FormatChooser.getDataType(value)).equals("x-po")) {
                            this.project.poFile = true;
                            XLIFF xlf = this.project.getXLIFF();
                            xlf.isPO = true;
                            XMLHelper.showCustomTags();
                        }
                    }
                    this.projectFile.setAttribute(type, value);
                    continue;
                }
                if (type.equals("source-language")) {
                    val2 = LanguageCodes.getCode(value);
                    if (val2 != null) {
                        this.projectFile.setAttribute(type, val2);
                        continue;
                    }
                    this.projectFile.setAttribute(type, value);
                    continue;
                }
                if (type.equals("target-language")) {
                    val2 = LanguageCodes.getCode(value);
                    if (val2 != null) {
                        this.projectFile.setAttribute(type, val2);
                        continue;
                    }
                    this.projectFile.setAttribute(type, value);
                    continue;
                }
                this.projectFile.setAttribute(type, value);
            }
            if (this.isNewFile) {
                this.projectFile.setCurrentPhase("Review");
                if (this.mode == 5) {
                    this.project.setLibreOfficeMode(1);
                    this.projectFile.setAttribute("tool-id", "CafeTran-LibreOffice");
                } else {
                    this.projectFile.setAttribute("tool-id", "CafeTran");
                }
                if (this.mode == 3) {
                    this.projectFile.setAttribute("datatype", "plaintext");
                }
            }
            if ((val = this.projectFile.getAttribute("original")).length() == 0) {
                if (this.folderBox != null && this.folderBox.isSelected()) {
                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE SOURCE DOCUMENTS FOLDER"));
                } else {
                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE DOCUMENT"));
                }
                return;
            }
            val = this.projectFile.getAttribute("source-language");
            if (val.length() == 0) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A SOURCE LANGUAGE"));
                return;
            }
            if (!val.equals(AppPreferences.fileSLang)) {
                AppPreferences.fileSLang = val;
            }
            if ((seg = this.topui.getSegmentation()) != null) {
                String name;
                boolean loaded = false;
                if (seg.segmenationChanged() && (name = seg.getName()) != null) {
                    loaded = seg.load(name);
                }
                if (loaded) {
                    seg.setLanguagePattern(val);
                } else {
                    String l = seg.getLanguageCode();
                    if (l != null && !l.equals(val)) {
                        seg.setLanguagePattern(val);
                    }
                }
            }
            if ((val = this.projectFile.getAttribute("datatype")).length() == 0) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A DATATYPE"));
                return;
            }
            val = this.projectFile.getAttribute("target-language");
            if (val != null && val.length() > 0) {
                AppPreferences.fileTLang = val;
            } else {
                XLIFF xlf = this.project.getXLIFF();
                if (xlf.isUnknownXLIFF) {
                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT A TARGET LANGUAGE"));
                    return;
                }
            }
            val = this.projectFile.getAttribute("tool-id");
            if (val != null && val.length() > 0) {
                AppPreferences.tool = val;
            }
            Project project = this.topui.getProjectView().getProject();
            if (this.isNewFile) {
                String s;
                if (this.mode == 0 || this.mode == 4 || this.mode == 5) {
                    if (image) {
                        project.mode = 2;
                    } else {
                        String aref;
                        if (this.combo8 != null) {
                            int i = this.combo8.getSelectedIndex();
                            if (i == 0) {
                                project.mode = 0;
                            } else if (i == 1) {
                                project.mode = 1;
                            }
                        } else {
                            project.mode = 1;
                        }
                        if (this.mode == 4 && (aref = this.ofield2.getText()).length() > 0) {
                            project.align = true;
                            AppPreferences.alignedFile = aref;
                        }
                    }
                } else if (this.mode == 2) {
                    project.mode = 2;
                } else if (this.mode == 3) {
                    project.mode = 3;
                    this.projectFile.setAttribute("datatype", "x-clipboard");
                }
                if (this.folderBox != null && this.folderBox.isSelected() && this.documentsFilterField != null && (s = this.documentsFilterField.getText()).length() > 0) {
                    project.createFilesFilter(s);
                }
                this.setDocumentFilter();
                AppPreferences.projectTMX = this.newMemBox.isSelected();
                AppPreferences.projectGlossary = this.newGlossaryBox.isSelected();
            } else if (project.mode == 3 && (xliff = project.getXLIFF()) != null) {
                xliff.setLangEnvironment(this.projectFile.getAttribute("source-language"), this.projectFile.getAttribute("target-language"));
            }
            this.setVisible(false);
            this.setSegmentAttributes();
            this.setProjectTM();
            this.setProjectGlossary();
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            this.cancelled = true;
            this.closeDialog();
        }
    }

    private void chooseFolder() {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        File file;
                        DirectoryChooser fileChooser = new DirectoryChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE SOURCE DOCUMENTS FOLDER"));
                        File f = new File(AppPreferences.sourceFilesDirectory);
                        if (f.isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if ((file = fileChooser.showDialog(null)) != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 13 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    String desc = this.this$1.XliffFileEditor.this.combo9.getSelectedItem().toString();
                                    this.this$1.XliffFileEditor.this.selectSourceFile(file, desc);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 13 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.XliffFileEditor.this.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            FileFilters filters = new FileFilters();
            String filterName = this.combo9.getSelectedItem().toString();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE A SOURCE DOCUMENT"));
            jFileChooser.setCurrentDirectory(new File(AppPreferences.sourceFilesDirectory));
            if (0 == jFileChooser.showOpenDialog(this.topui)) {
                FileFilter filter = jFileChooser.getFileFilter();
                String desc = filter.getDescription();
                if (desc.equals("All Files")) {
                    desc = "Text";
                }
                File file = jFileChooser.getSelectedFile();
                this.selectSourceFile(file, desc);
            }
        }
    }

    public void selectSourceFile(File file, String filter) {
        AppPreferences.format = filter;
        AppPreferences.sourceFilesDirectory = file.getParent();
        String name = file.getName().toLowerCase();
        String path = file.getPath();
        if (name.endsWith(".xlf") || name.endsWith(".ttx") || name.endsWith(".tmx") || name.endsWith(".xliff") || name.endsWith(".sdlxliff") || name.endsWith(".mxliff") || name.endsWith(".mqxliff") || name.endsWith(".txml") || name.endsWith(".txlf")) {
            this.cancelled = true;
            this.closeDialog();
            AppPreferences.projectDirectory = file.getParent();
            this.topui.getProjectView().prepareProject(path);
        } else {
            if (this.ofield != null) {
                this.ofield.setText(path);
            }
            if (file.isDirectory() && !this.folderBox.isSelected()) {
                this.folderBox.setSelected(true);
            }
            this.combo9.setSelectedItem(AppPreferences.format);
            String pname = this.fieldProjectName.getText();
            if (pname == null || pname.length() == 0) {
                pname = file.getName();
                int dot = pname.lastIndexOf(46);
                if (dot != -1) {
                    pname = pname.substring(0, dot);
                }
                this.fieldProjectName.requestFocusInWindow();
                this.fieldProjectName.setText(pname);
                this.fieldProjectName.setCaretPosition(0);
                this.fieldProjectName.moveCaretPosition(pname.length());
            }
        }
    }

    private void setSegmentAttributes() {
        Project pro = this.topui.getProjectView().getProject();
        Component[] comps = this.propsPanel.getComponents();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < comps.length; ++i) {
            JButton but;
            Component component = comps[i];
            String name = null;
            String value = null;
            if (!(component instanceof JButton) || (name = (but = (JButton)component).getName()) == null) continue;
            name = name.trim();
            component = comps[i + 1];
            ++i;
            if (name.length() > 0) {
                if (name.indexOf(32) != -1) {
                    name = name.replace(" ", "_");
                }
                if (name.indexOf(58) != -1) {
                    name = name.replace(":", "");
                }
                if (name.indexOf(59) != -1) {
                    name = name.replace(";", "");
                }
                if (name.indexOf(61) != -1) {
                    name = name.replace("=", "");
                }
                if (name.indexOf(34) != -1) {
                    name = name.replace("\"", "");
                }
                sb.append(name);
                sb.append(';');
            }
            if (component instanceof JTextField) {
                JTextField field = (JTextField)component;
                value = field.getText().trim();
                pro.setSegmentAttribute("property:" + name, value);
                continue;
            }
            if (!(component instanceof JComboBox)) continue;
            JComboBox box = (JComboBox)component;
            value = box.getSelectedItem().toString();
            pro.setSegmentAttribute("property:" + name, value);
        }
        if (!this.segAttrsSet && sb.length() > 0) {
            AppPreferences.segmentAttributes = sb.toString();
        }
    }

    private void setDocumentFilter() {
        Component[] comps = this.filterPanel.getComponents();
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Segmentation seg;
            JComponent box;
            String name;
            Component component = comps[i];
            if (!(component instanceof JLabel) && !(component instanceof JButton) || (name = component.getName()) == null) continue;
            name = name.trim();
            component = comps[i + 1];
            ++i;
            if (component instanceof JTextField) {
                JTextField field = (JTextField)component;
                String value = field.getText().trim();
                if (value.length() <= 0 || this.project == null) continue;
                this.project.addDocumentFilter(name, value);
                continue;
            }
            if (component instanceof JComboBox) {
                box = (JComboBox)component;
                String value = ((JComboBox)box).getSelectedItem().toString();
                if (value.length() <= 0 || this.project == null) continue;
                this.project.addDocumentFilter(name, value);
                continue;
            }
            if (!(component instanceof JCheckBox)) continue;
            box = (JCheckBox)component;
            boolean value = ((AbstractButton)box).isSelected();
            if (!name.equals("filter:NoSegmentation") || !value || (seg = this.topui.getSegmentation()) == null) continue;
            seg.setFilterSegmenation("\\z");
        }
    }

    private void setProjectTM() {
        if (this.newMemBox.isSelected()) {
            boolean loaded = false;
            MemoryView mv = this.topui.getMemoryView();
            List mems = mv.getLocalMemories();
            for (Memory m : mems) {
                String mname = m.getName();
                if (mname == null || !mname.equals("ProjectTM")) continue;
                loaded = true;
                break;
            }
            if (!loaded) {
                mv.setProjectMemory(this.projectTM);
            }
        }
    }

    private void setProjectGlossary() {
        AppPreferences.projectGlossary = this.newGlossaryBox.isSelected();
    }
}

