/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.Frequencer;
import translator.MainView;
import translator.Placeables;
import translator.Project;
import translator.ProjectView;
import translator.Statistics;
import translator.WordCount;
import translator.XMLElement;
import translator.XMLHelper;
import translator.qa.Issue;
import translator.ui.Colors;
import translator.ui.HTMLFormat;
import translator.xliff.AltTrans;
import translator.xliff.BinaryUnit;
import translator.xliff.FileBody;
import translator.xliff.Group;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;
import translator.xliff.XliffMenu;

public class XliffView {
    MainView topui;
    ProjectView prview;
    private int fromIndex;
    private XLIFF xliff;
    private XliffMenu xliffmenu;
    private static List tunitsFilter;
    private static List tunitsNestedFilter;
    private List tunitsGlued;
    private static List tunitsSGlued;
    private static boolean qafilter;
    private String query;
    private int queryType;
    private boolean resetView = false;
    private int currentTUIndex = -1;
    public int currentTUSize = -1;
    private int newSegment = 0;
    private Set<String> extractedResults;
    private static Pattern latinPattern;
    private static Pattern greekPattern;
    private static Pattern cyrillicPattern;
    private static Pattern searchPattern;
    private static String replaceString;
    private static boolean replaceInSource;
    private boolean lastTU;
    Pattern urlPattern = Pattern.compile("(((https?|file)://+|www\\.)[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)");

    public XliffView(MainView topui, XLIFF xliff) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.xliff = xliff;
        tunitsSGlued = null;
    }

    public XLIFFUnit getUnitInView(String id) {
        int i = Integer.parseInt(id);
        List tus = this.getViewUnits();
        if (tus != null) {
            XLIFFUnit tu = (XLIFFUnit)tus.get(i);
            return tu;
        }
        return null;
    }

    void setLastTU(boolean last) {
        this.lastTU = last;
    }

    void saveFlagProjectFile(int id) {
        List list = this.prview.getProject().getProjects();
        if (list != null) {
            for (Object object : list) {
                XLIFF xlf;
                int xid;
                if (!(object instanceof XLIFF) || (xid = (xlf = (XLIFF)object).getID()) != id) continue;
                xlf.saved = false;
                break;
            }
        }
    }

    public void viewTypeChanged() {
        this.resetView = true;
    }

    public int getCurrentUnitsSize() {
        if (tunitsFilter != null) {
            return tunitsFilter.size();
        }
        if (tunitsSGlued != null) {
            return tunitsSGlued.size();
        }
        if (this.tunitsGlued != null) {
            return this.tunitsGlued.size();
        }
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            FileBody body = file.getBody();
            return body.getTransUnits().size();
        }
        return 0;
    }

    public List getViewUnits() {
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            List tunits;
            if (tunitsFilter != null) {
                tunits = tunitsFilter;
            } else if (tunitsSGlued != null) {
                tunits = tunitsSGlued;
            } else if (this.tunitsGlued != null) {
                tunits = this.tunitsGlued;
            } else {
                FileBody body = file.getBody();
                tunits = body.getTransUnits();
            }
            return tunits;
        }
        return null;
    }

    public List getFilteredUnits() {
        return tunitsFilter;
    }

    public static void setQAFilteredUnits(List list) {
        qafilter = true;
        tunitsFilter = list;
    }

    public static boolean hasQAFilter() {
        return qafilter;
    }

    public static void setFilteredWorkflow(boolean flag) {
        if (flag) {
            if (AppPreferences.searchMultiFilter) {
                if (tunitsFilter == null) {
                    tunitsFilter = new ArrayList();
                }
            } else {
                tunitsFilter = new ArrayList();
            }
        } else {
            qafilter = false;
            tunitsFilter = null;
            AppPreferences.searchMultiFilter = false;
            AppPreferences.replaceAndEdit = false;
            searchPattern = null;
            replaceInSource = false;
            replaceString = null;
        }
    }

    public List getGluedUnits() {
        if (tunitsSGlued != null) {
            return tunitsSGlued;
        }
        return this.tunitsGlued;
    }

    public void cancelGluedWorkflows() {
        if (this.tunitsGlued != null) {
            this.tunitsGlued.clear();
            this.tunitsGlued = null;
        }
        if (tunitsSGlued != null) {
            tunitsSGlued.clear();
            tunitsSGlued = null;
        }
    }

    public void setSuperGluedWorkflow(boolean flag) {
        if (flag) {
            tunitsSGlued = new ArrayList();
            this.fillSuperGluedArray(tunitsSGlued);
        } else {
            tunitsSGlued = null;
            this.resetGluedWorkflow();
        }
    }

    private void resetGluedWorkflow() {
        List list = this.prview.getProject().getProjects();
        if (list != null) {
            for (Object object : list) {
                if (!(object instanceof XLIFF)) continue;
                XLIFF xlf = (XLIFF)object;
                xlf.getView().setGluedWorkflow(true);
            }
        }
    }

    private void fillSuperGluedArray(List superlist) {
        List list = this.prview.getProject().getProjects();
        if (list != null) {
            for (Object object : list) {
                if (!(object instanceof XLIFF)) continue;
                XLIFF xlf = (XLIFF)object;
                xlf.getView().setGluedWorkflow(false);
                this.fillGluedArray(xlf, superlist);
            }
        }
    }

    public void setGluedWorkflow(boolean flag) {
        if (flag) {
            if (this.tunitsGlued == null) {
                this.tunitsGlued = new ArrayList();
                this.fillGluedArray(this.xliff, this.tunitsGlued);
            }
        } else {
            this.tunitsGlued = null;
        }
    }

    private void fillGluedArray(XLIFF xliff, List list) {
        List files = xliff.getFiles();
        if (files.size() > 0) {
            for (XliffFile file : files) {
                FileBody body = file.getBody();
                if (body.getCurrentBU() == null) {
                    List units = body.getTransUnits();
                    for (XLIFFUnit tu : units) {
                        if (!tu.translate) continue;
                        list.add(tu);
                    }
                    continue;
                }
                Group currentGroup = body.getCurrentGroup();
                List bunits = currentGroup != null ? currentGroup.getBinaryUnits() : body.getBinaryUnits();
                for (BinaryUnit bu : bunits) {
                    List tunits = bu.getTransUnits();
                    for (XLIFFUnit tu : tunits) {
                        if (!tu.translate) continue;
                        list.add(tu);
                    }
                }
            }
        }
    }

    private void fillSortedArray() {
        if (tunitsSGlued != null) {
            tunitsFilter = new ArrayList(tunitsSGlued);
            return;
        }
        if (this.tunitsGlued != null) {
            tunitsFilter = new ArrayList(this.tunitsGlued);
            return;
        }
        XliffFile file = this.xliff.getCurrentFile();
        FileBody body = file.getBody();
        if (body.getCurrentBU() == null) {
            List units = body.getTransUnits();
            for (XLIFFUnit tu : units) {
                if (!tu.translate) continue;
                tunitsFilter.add(tu);
            }
        } else {
            Group currentGroup = body.getCurrentGroup();
            List bunits = currentGroup != null ? currentGroup.getBinaryUnits() : body.getBinaryUnits();
            for (BinaryUnit bu : bunits) {
                List tunits = bu.getTransUnits();
                for (XLIFFUnit tu : tunits) {
                    if (!tu.translate) continue;
                    tunitsFilter.add(tu);
                }
            }
        }
    }

    void viewContent(final XLIFFUnit tu) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ XliffView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JTextPane sourceTextArea = this.this$0.topui.getSourcePane();
                JTextPane targetTextArea = this.this$0.topui.getTargetPane();
                if (sourceTextArea.getClientProperty("content") == null) {
                    sourceTextArea.putClientProperty("content", sourceTextArea.getText());
                }
                if (targetTextArea.getClientProperty("content") == null) {
                    targetTextArea.putClientProperty("content", targetTextArea.getText());
                }
                String word = this.this$0.topui.getResourceView().getLookUpText();
                String source = tu.getSourceText();
                if (source.length() > 0) {
                    try {
                        Document doc = sourceTextArea.getDocument();
                        int length = doc.getLength();
                        doc.remove(0, length);
                        doc.insertString(0, source, null);
                        sourceTextArea.setCaretPosition(0);
                        if (word != null && word.length() > 0) {
                            this.this$0.topui.getSourceView().highlightWord(word);
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(XliffView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    sourceTextArea.setText("");
                }
                String target = tu.getTargetText();
                if (target.length() > 0) {
                    try {
                        Document doc = targetTextArea.getDocument();
                        int length = doc.getLength();
                        doc.remove(0, length);
                        doc.insertString(0, target, null);
                        targetTextArea.setCaretPosition(0);
                        if (word != null && word.length() > 0) {
                            this.this$0.topui.getTargetView().highlightWord(word);
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(XliffView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    targetTextArea.setText("");
                }
            }
        });
    }

    public XliffMenu getMenu() {
        if (this.xliffmenu == null) {
            this.xliffmenu = new XliffMenu(this.topui, this.prview.getProject());
        }
        return this.xliffmenu;
    }

    public void createFile(boolean add) {
        XliffMenu fview = this.getMenu();
        fview.createFile(add);
    }

    public void replaceFile(XliffFile file) {
        XliffMenu fview = this.getMenu();
        fview.replaceFile(file);
    }

    public void editFile() {
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            XliffMenu fview = this.getMenu();
            boolean bl = fview.showXLIFFFile(file, 0, false);
        }
    }

    public void showPopUp(Component comp, int x, int y, Object o) {
        XliffMenu fmenu = this.getMenu();
        fmenu.showPopUp(comp, x, y, o);
    }

    public Statistics getStatistics(boolean singeDoc) {
        ArrayList<XliffFile> files;
        Statistics stats = new Statistics();
        List pr = this.prview.getProject().getProjects();
        if (!singeDoc && pr != null && tunitsSGlued != null) {
            files = new ArrayList();
            for (Object object : pr) {
                if (!(object instanceof XLIFF)) continue;
                XLIFF x = (XLIFF)object;
                files.addAll(x.getFiles());
            }
        } else if (!singeDoc) {
            files = this.xliff.getFiles();
        } else {
            files = new ArrayList<XliffFile>();
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null) {
                files.add(file);
            }
        }
        if (files.size() > 0) {
            WordCount wordCountAllSource = new WordCount();
            WordCount wordCountAllTarget = new WordCount();
            WordCount wordCountUntranslated = new WordCount();
            WordCount wordCountChecked = new WordCount();
            WordCount wordCountApproved = new WordCount();
            WordCount wordCountRejected = new WordCount();
            WordCount wordCountRepetions = new WordCount();
            HashSet<String> set = new HashSet<String>();
            for (XliffFile file : files) {
                FileBody body = file.getBody();
                if (body.getCurrentBU() == null) {
                    List units = tunitsFilter != null && !singeDoc ? tunitsFilter : body.getTransUnits();
                    for (XLIFFUnit tu : units) {
                        String t;
                        if (tu.locked || !tu.translate) continue;
                        ++stats.allSegments;
                        int status = tu.getState();
                        if (status == 1) {
                            ++stats.checkedSegments;
                        } else if (status == 2) {
                            ++stats.approvedSegments;
                        } else if (status == 3) {
                            ++stats.rejectedSegments;
                        }
                        String s = tu.getSourceText();
                        if (s.length() > 0) {
                            boolean adds = set.add(s);
                            if (!adds) {
                                if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                    wordCountRepetions.doWordCount(s);
                                } else {
                                    wordCountRepetions.doCJKVWordCount(s);
                                }
                                stats.repeatedChars += (float)s.length();
                                ++stats.repeatedSegments;
                            }
                            if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                wordCountAllSource.doWordCount(s);
                            } else {
                                wordCountAllSource.doCJKVWordCount(s);
                            }
                            if (status == 1) {
                                if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                    wordCountChecked.doWordCount(s);
                                } else {
                                    wordCountChecked.doCJKVWordCount(s);
                                }
                            } else if (status == 2) {
                                if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                    wordCountApproved.doWordCount(s);
                                } else {
                                    wordCountApproved.doCJKVWordCount(s);
                                }
                            } else if (status == 3) {
                                if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                    wordCountRejected.doWordCount(s);
                                } else {
                                    wordCountRejected.doCJKVWordCount(s);
                                }
                            }
                        }
                        if ((t = tu.getTargetText()) != null && t.length() > 0) {
                            if (!AppPreferences.noWordSeparatorTargetLanguage) {
                                wordCountAllTarget.doWordCount(t);
                            } else {
                                wordCountAllTarget.doCJKVWordCount(t);
                            }
                        }
                        if (t == null || t.trim().length() == 0) {
                            ++stats.untranslatedSegments;
                            if (!AppPreferences.noWordSeparatorSourceLanguage) {
                                wordCountUntranslated.doWordCount(s);
                                continue;
                            }
                            wordCountUntranslated.doCJKVWordCount(s);
                            continue;
                        }
                        ++stats.translatedSegments;
                    }
                } else {
                    Group currentGroup = body.getCurrentGroup();
                    List bunits = currentGroup != null ? currentGroup.getBinaryUnits() : body.getBinaryUnits();
                    int nbu = 0;
                    for (BinaryUnit bu : bunits) {
                        ++nbu;
                        List tunits = bu.getTransUnits();
                        for (XLIFFUnit tu : tunits) {
                            if (tu.locked || !tu.translate) continue;
                            ++stats.allSegments;
                            int status = tu.getState();
                            if (status == 1) {
                                ++stats.checkedSegments;
                            } else if (status == 2) {
                                ++stats.approvedSegments;
                            } else if (status == 3) {
                                ++stats.rejectedSegments;
                            }
                            String t = tu.getTargetText();
                            if (t != null && t.length() > 0) {
                                if (!AppPreferences.noWordSeparatorTargetLanguage) {
                                    wordCountAllTarget.doWordCount(t);
                                } else {
                                    wordCountAllTarget.doCJKVWordCount(t);
                                }
                                if (status == 1) {
                                    if (!AppPreferences.noWordSeparatorTargetLanguage) {
                                        wordCountChecked.doWordCount(t);
                                    } else {
                                        wordCountChecked.doCJKVWordCount(t);
                                    }
                                } else if (status == 2) {
                                    if (!AppPreferences.noWordSeparatorTargetLanguage) {
                                        wordCountApproved.doWordCount(t);
                                    } else {
                                        wordCountApproved.doCJKVWordCount(t);
                                    }
                                } else if (status == 3) {
                                    if (!AppPreferences.noWordSeparatorTargetLanguage) {
                                        wordCountRejected.doWordCount(t);
                                    } else {
                                        wordCountRejected.doCJKVWordCount(t);
                                    }
                                }
                            }
                            if (t == null || t.trim().length() == 0) {
                                ++stats.untranslatedSegments;
                                continue;
                            }
                            ++stats.translatedSegments;
                        }
                    }
                }
                if (tunitsFilter == null || singeDoc) continue;
                break;
            }
            if (stats.allSegments == 0) {
                return null;
            }
            stats.allSourceWords = wordCountAllSource.getWordCount();
            stats.allSourceChars = wordCountAllSource.getAllCharsCount();
            stats.allSourceCharsNoWhites = wordCountAllSource.getCharsCount();
            stats.allTargetWords = wordCountAllTarget.getWordCount();
            stats.allTargetChars = wordCountAllTarget.getAllCharsCount();
            stats.allTargetCharsNoWhites = wordCountAllTarget.getCharsCount();
            stats.untranslatedWords = wordCountUntranslated.getWordCount();
            stats.untranslatedChars = wordCountUntranslated.getAllCharsCount();
            stats.untranslatedCharsNoWhites = wordCountUntranslated.getCharsCount();
            stats.translatedWords = stats.allSourceWords - stats.untranslatedWords;
            stats.translatedChars = stats.allSourceChars - stats.untranslatedChars;
            stats.translatedCharsNoWhites = stats.allSourceCharsNoWhites - stats.untranslatedCharsNoWhites;
            stats.checkedWords = wordCountChecked.getWordCount();
            stats.checkedChars = wordCountChecked.getAllCharsCount();
            stats.checkedCharsNoWhites = wordCountChecked.getCharsCount();
            stats.approvedWords = wordCountApproved.getWordCount();
            stats.approvedChars = wordCountApproved.getAllCharsCount();
            stats.approvedCharsNoWhites = wordCountApproved.getCharsCount();
            stats.rejectedWords = wordCountRejected.getWordCount();
            stats.rejectedChars = wordCountRejected.getAllCharsCount();
            stats.rejectedCharsNoWhites = wordCountRejected.getCharsCount();
            stats.uncheckedSegments = stats.allSegments - stats.checkedSegments;
            stats.uncheckedWords = stats.allSourceWords - stats.checkedWords;
            stats.uncheckedChars = stats.allSourceChars - stats.checkedChars;
            stats.uncheckedCharsNoWhites = stats.allSourceCharsNoWhites - stats.checkedCharsNoWhites;
            stats.repeatedWords = wordCountRepetions.getWordCount();
            stats.repeatedChars = wordCountRepetions.getAllCharsCount();
            stats.repeatedCharsNoWhites = wordCountRepetions.getCharsCount();
            if (!AppPreferences.updateProjectStatistics) {
                Frequencer freq = this.topui.getFrequencer();
                if (freq == null) {
                    this.topui.setFrequencer();
                    freq = this.topui.getFrequencer();
                }
                freq.findProjectHFWords();
                int[] freqWords = freq.getRepetitions2();
                stats.repeatedInternalWords = freqWords[0];
                stats.repeatedInternalCharsNoWhites = freqWords[1];
                stats.repeatedInternalChars = freqWords[2];
                stats.allSourceInteralChars = freqWords[3];
            }
            stats.setSourceBillingMessage(wordCountAllSource.getCountMessage());
            stats.setTargetBillingMessage(wordCountAllTarget.getCountMessage());
            return stats;
        }
        return null;
    }

    public void browseToUnit(int i) {
        this.currentTUIndex = i;
        this.fromIndex = i;
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchQAGridContent(-2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchQAGridSplitContent(-2);
                this.goToSplitContent(arr, i);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(true, -2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchContentSplit(true, -2);
                this.goToSplitContent(arr, i);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchGridContent(-2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchGridSplitContent(-2);
                this.goToSplitContent(arr, i);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(false, -2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchContentSplit(false, -2);
                this.goToSplitContent(arr, i);
            }
        }
    }

    public void browseToNextUnit(int i) {
        if (i < this.fromIndex || i > this.fromIndex + AppPreferences.pagesize) {
            this.fromIndex = i - (AppPreferences.pagesize + 1);
            this.nextTUS();
        }
    }

    public void browseToPrevUnit(int i) {
        if (i <= this.fromIndex || i > this.fromIndex + AppPreferences.pagesize) {
            this.fromIndex = i;
            this.previousTUS();
        }
    }

    public void browseToLastUnit() {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchQAGridContent(0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchQAGridSplitContent(0);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(true, 0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(true, 0);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchGridContent(0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchGridSplitContent(0);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(false, 0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(false, 0);
                this.showSplitContent(arr, true);
            }
        }
    }

    public int getCurrentTUIndex() {
        return this.currentTUIndex;
    }

    public void sort() {
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.fillSortedArray();
            }
            Collections.sort(tunitsFilter);
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        }
    }

    void sortByLength(boolean longToShort) {
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.fillSortedArray();
            }
            if (!longToShort) {
                Collections.sort(tunitsFilter, new Comparator<XLIFFUnit>(){

                    @Override
                    public int compare(XLIFFUnit tu1, XLIFFUnit tu2) {
                        String s1 = tu1.getSourceText();
                        String s2 = tu2.getSourceText();
                        int len1 = s1.length();
                        int len2 = s2.length();
                        return len1 - len2;
                    }
                });
            } else {
                Collections.sort(tunitsFilter, new Comparator<XLIFFUnit>(){

                    @Override
                    public int compare(XLIFFUnit tu1, XLIFFUnit tu2) {
                        String s1 = tu1.getSourceText();
                        String s2 = tu2.getSourceText();
                        int len1 = s1.length();
                        int len2 = s2.length();
                        return len2 - len1;
                    }
                });
            }
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        }
    }

    public void viewRange(int from, int to) {
        List tunits;
        if (!tunitsNestedFilter.isEmpty()) {
            tunitsNestedFilter.clear();
        }
        if (tunitsFilter != null) {
            if (AppPreferences.searchMultiFilter) {
                tunitsNestedFilter.addAll(tunitsFilter);
            }
            tunitsFilter.clear();
        }
        if (--from > to) {
            return;
        }
        if (AppPreferences.searchMultiFilter && !tunitsNestedFilter.isEmpty()) {
            tunits = tunitsNestedFilter;
        } else if (tunitsSGlued != null) {
            tunits = tunitsSGlued;
        } else if (this.tunitsGlued != null) {
            tunits = this.tunitsGlued;
        } else {
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null) {
                tunits = file.getBody().getTransUnits();
            } else {
                return;
            }
        }
        while (from < tunits.size()) {
            Object o = tunits.get(from);
            if (o != null && o instanceof XLIFFUnit) {
                XLIFFUnit tu = (XLIFFUnit)o;
                tunitsFilter.add(tu);
            }
            if (++from != to) continue;
            break;
        }
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        } else {
            this.showContent("", true);
        }
    }

    public void search(String s, String r, int mode) {
        List files;
        qafilter = false;
        String content = this.fetchSearchGridContent(s, r, mode);
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        } else {
            this.showContent(content, true);
        }
        if (r != null && (files = this.prview.getProject().getProjects()) != null && tunitsSGlued != null) {
            for (XLIFF t : files) {
                t.saved = false;
            }
        }
        if (AppPreferences.searchExtractRegExp && AppPreferences.searchType == 0) {
            String name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REG. EXP. RESULTS");
            this.topui.getResourceView().showExtractedSearchResults(this.extractedResults, name);
        }
        this.resetView = true;
    }

    private String fetchSearchGridContent(String s, String r, int mode) {
        this.query = s;
        this.queryType = mode;
        if (!tunitsNestedFilter.isEmpty()) {
            tunitsNestedFilter.clear();
        }
        if (tunitsFilter != null) {
            if (mode == 4 || mode == 5) {
                AppPreferences.searchMultiFilter = true;
            }
            if (AppPreferences.searchMultiFilter) {
                tunitsNestedFilter.addAll(tunitsFilter);
            }
            tunitsFilter.clear();
        }
        if (mode == 37) {
            boolean multi = false;
            List list = this.prview.getProject().getProjects();
            if (list != null && list.size() > 1) {
                multi = true;
            } else {
                int nf = this.xliff.getFiles().size();
                if (nf > 1) {
                    multi = true;
                }
            }
            HashMap map = Project.getProjectMemory();
            Object o = map.get(s);
            if (o != null) {
                if (o instanceof Stack) {
                    Stack deck = (Stack)o;
                    ArrayList<XLIFFUnit> sortedList = new ArrayList<XLIFFUnit>(deck.size());
                    for (XLIFFUnit tuu : deck) {
                        sortedList.add(tuu);
                    }
                    Collections.sort(sortedList, new Comparator<XLIFFUnit>(){

                        @Override
                        public int compare(XLIFFUnit tu1, XLIFFUnit tu2) {
                            Integer i1 = tu1.getUnitID();
                            Integer i2 = tu2.getUnitID();
                            return i1.compareTo(i2);
                        }
                    });
                    for (XLIFFUnit tuu : sortedList) {
                        int fileID;
                        if (tunitsFilter == null) continue;
                        boolean add = true;
                        if (multi && this.tunitsGlued == null && tunitsSGlued == null && !this.xliff.isCurrentFile(fileID = tuu.getFileID())) {
                            add = false;
                        }
                        if (!add) continue;
                        tunitsFilter.add(tuu);
                    }
                } else {
                    XLIFFUnit tu = (XLIFFUnit)o;
                    if (tunitsFilter != null) {
                        int fileID;
                        boolean add = true;
                        if (multi && this.tunitsGlued == null && tunitsSGlued == null && !this.xliff.isCurrentFile(fileID = tu.getFileID())) {
                            add = false;
                        }
                        if (add) {
                            tunitsFilter.add(tu);
                        }
                    }
                }
            }
            return "";
        }
        if (mode == 14 || mode == 30) {
            boolean multi = false;
            List list = this.prview.getProject().getProjects();
            if (list != null && list.size() > 1) {
                multi = true;
            } else {
                int nf = this.xliff.getFiles().size();
                if (nf > 1) {
                    multi = true;
                }
            }
            boolean firstOnly = false;
            if (mode == 30) {
                firstOnly = true;
            }
            HashMap map = Project.getProjectMemory();
            Collection values = map.values();
            block2: for (Object object : values) {
                if (!(object instanceof Stack)) continue;
                Stack deck = (Stack)object;
                ArrayList<XLIFFUnit> sortedList = new ArrayList<XLIFFUnit>(deck.size());
                for (XLIFFUnit tuu : deck) {
                    sortedList.add(tuu);
                }
                Collections.sort(sortedList, new Comparator<XLIFFUnit>(){

                    @Override
                    public int compare(XLIFFUnit tu1, XLIFFUnit tu2) {
                        Integer i1 = tu1.getUnitID();
                        Integer i2 = tu2.getUnitID();
                        return i1.compareTo(i2);
                    }
                });
                for (XLIFFUnit tuu : sortedList) {
                    int fileID;
                    if (tunitsFilter == null) continue;
                    boolean add = true;
                    if (multi && this.tunitsGlued == null && tunitsSGlued == null && !this.xliff.isCurrentFile(fileID = tuu.getFileID())) {
                        add = false;
                    }
                    if (add) {
                        tunitsFilter.add(tuu);
                    }
                    if (!firstOnly) continue;
                    continue block2;
                }
            }
            return "";
        }
        Pattern p = AppPreferences.searchCase ? Pattern.compile(s) : Pattern.compile(s, 66);
        if (AppPreferences.replaceAndEdit) {
            searchPattern = p;
            replaceString = r;
            this.query = r;
            r = null;
            replaceInSource = mode == 4;
        }
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.projectStyles);
        html.append(HTMLFormat.startBody);
        boolean glued = false;
        boolean nested = false;
        List tunits = null;
        if (AppPreferences.searchMultiFilter && !tunitsNestedFilter.isEmpty()) {
            tunits = tunitsNestedFilter;
            nested = true;
        } else if (tunitsSGlued != null) {
            tunits = tunitsSGlued;
            glued = true;
        } else if (this.tunitsGlued != null) {
            tunits = this.tunitsGlued;
            glued = true;
        } else {
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null) {
                FileBody body = file.getBody();
                tunits = body.getTransUnits();
            }
        }
        if (tunits != null) {
            int i = 0;
            XMLElement tus = null;
            XMLElement tut = null;
            String content = null;
            int j = 0;
            boolean found = false;
            if (AppPreferences.searchExtractRegExp && AppPreferences.searchType == 0) {
                this.extractedResults = new TreeSet<String>();
            }
            boolean header = false;
            block5: for (XLIFFUnit tu : tunits) {
                Matcher m;
                Pattern p2;
                Matcher ma;
                if (!tu.translate) continue;
                if (mode == 38) {
                    XMLElement e = tu.getTarget();
                    if (!tu.isTracked(e) || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 25) {
                    if (tu.locked || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (tu.locked && AppPreferences.skipLocked) {
                    ++i;
                    continue;
                }
                if (mode == 23) {
                    String sxml = tu.getCurrentSourceXMLText();
                    if (sxml.indexOf("style=color") == -1 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 24) {
                    String sxml = tu.getCurrentSourceXMLText();
                    if (sxml.indexOf("style=background") == -1 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 22) {
                    List ats = tu.getAltTrans();
                    if (ats == null || ats.size() <= 0) continue;
                    for (AltTrans alt : ats) {
                        String con;
                        XMLElement atut;
                        if (alt == null || (atut = alt.getTarget()) == null || (con = alt.getTargetText()).length() <= 0) continue;
                        ma = p.matcher(con);
                        while (ma.find()) {
                            if (tunitsFilter == null) continue;
                            tunitsFilter.add(tu);
                            continue block5;
                        }
                    }
                    continue;
                }
                if (mode == 8) {
                    List notes = tu.getNotes();
                    if (notes == null || notes.size() <= 0) continue;
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0 || con.equals("propagated")) continue;
                        ma = p.matcher(con);
                        while (ma.find()) {
                            if (tunitsFilter == null) continue;
                            tunitsFilter.add(tu);
                            continue block5;
                        }
                    }
                    continue;
                }
                if (mode == 9) {
                    int state;
                    tut = tu.getTarget();
                    if (tut == null || (state = tu.getState()) != 1 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 10) {
                    int state;
                    tut = tu.getTarget();
                    if (tut == null || (state = tu.getState()) == 1 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 11) {
                    if (!tu.bookmark || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 31) {
                    if (tu.bookmark || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 12) {
                    String targetContent = tu.getTargetText();
                    if (targetContent != null && targetContent.trim().length() != 0 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 13) {
                    String targetContent = tu.getTargetText();
                    if (targetContent == null || targetContent.trim().length() <= 0 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 36) {
                    int m2 = tu.getMatch();
                    int t = tu.getMatchType();
                    if (t != 2 && (tu.percent == null || m2 >= 100) || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 15) {
                    int m3 = tu.getMatch();
                    int t = tu.getMatchType();
                    if (m3 <= 99 || t != 1 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 16) {
                    int m4 = tu.getMatch();
                    if (m4 <= 100 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 17) {
                    int m5 = tu.getMatch();
                    if (m5 <= 101 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 18) {
                    int m6 = tu.getMatch();
                    if (m6 >= 102 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 19) {
                    int m7 = tu.getMatch();
                    if (m7 >= 101 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 20) {
                    int m8 = tu.getMatch();
                    int t = tu.getMatchType();
                    if (m8 > 99 && t != 1) {
                        m8 = 99;
                    }
                    if (m8 >= 100 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 26) {
                    String sourceContent = tu.getSourceText();
                    if (sourceContent == null || sourceContent.trim().length() <= 0) continue;
                    Set set = Placeables.getPlaceablesSet();
                    Iterator it2 = set.iterator();
                    while (it2.hasNext()) {
                        String place = it2.next().toString();
                        if (place.charAt(0) != '|') {
                            if (!sourceContent.equals(place) || tunitsFilter == null) continue;
                            tunitsFilter.add(tu);
                            continue;
                        }
                        String place2 = place.substring(1);
                        p2 = Placeables.getPlaceablePattern(place);
                        if (p2 == null) {
                            p2 = Pattern.compile(place2);
                        }
                        if (!(m = p2.matcher(sourceContent)).matches() || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                    }
                    continue;
                }
                if (mode == 27) {
                    String sourceContent = tu.getSourceText();
                    if (sourceContent == null || sourceContent.trim().length() <= 0) continue;
                    Set set = Placeables.getPlaceablesSet();
                    Iterator it2 = set.iterator();
                    while (it2.hasNext()) {
                        String place = it2.next().toString();
                        if (place.charAt(0) != '|') {
                            if (sourceContent.indexOf(place) == -1 || tunitsFilter == null) continue;
                            tunitsFilter.add(tu);
                            continue;
                        }
                        String place2 = place.substring(1);
                        p2 = Placeables.getPlaceablePattern(place);
                        if (p2 == null) {
                            p2 = Pattern.compile(place2);
                        }
                        if (!(m = p2.matcher(sourceContent)).find() || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                    }
                    continue;
                }
                if (mode == 28) {
                    if (tu.getState() != 2 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 32) {
                    if (tu.getState() != 3 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 29) {
                    if (tu.getState() == 2 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 33) {
                    if (!tu.edited || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 34) {
                    if (tu.getMatchType() != 5 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 35) {
                    int t = tu.getMatchType();
                    if (t != 3 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 43) {
                    int t = tu.getMatchType();
                    if (t != 4 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 44) {
                    int t = tu.getMatchType();
                    if (t != 0 || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                if (mode == 39) {
                    String sourceContent = tu.getSourceText();
                    if (sourceContent == null || sourceContent.trim().length() <= 0) continue;
                    char[] chars = sourceContent.toCharArray();
                    for (int k = 0; k < chars.length; ++k) {
                        char aChar = chars[k];
                        boolean b = Character.isIdeographic(aChar);
                        if (!b) continue;
                        if (tunitsFilter == null) continue block5;
                        tunitsFilter.add(tu);
                        continue block5;
                    }
                    continue;
                }
                if (mode == 40) {
                    Matcher m9;
                    String sourceContent = tu.getSourceText();
                    if (sourceContent == null || sourceContent.trim().length() <= 0 || !(m9 = latinPattern.matcher(sourceContent)).find()) continue;
                    if (tunitsFilter == null) break;
                    tunitsFilter.add(tu);
                    break;
                }
                if (mode == 41) {
                    Matcher m10;
                    String sourceContent = tu.getSourceText();
                    if (sourceContent == null || sourceContent.trim().length() <= 0 || !(m10 = cyrillicPattern.matcher(sourceContent)).find()) continue;
                    if (tunitsFilter == null) break;
                    tunitsFilter.add(tu);
                    break;
                }
                if (mode == 42) {
                    Matcher m11;
                    String sourceContent = tu.getSourceText();
                    if (sourceContent == null || sourceContent.trim().length() <= 0 || !(m11 = greekPattern.matcher(sourceContent)).find()) continue;
                    if (tunitsFilter == null) break;
                    tunitsFilter.add(tu);
                    break;
                }
                if (!header) {
                    header = true;
                    html.append(HTMLFormat.startGrid);
                    html.append(HTMLFormat.sRow);
                    html.append("<TD COLSPAN=3 ALIGN=RIGHT VALIGN=TOP>");
                    html.append("<p>");
                    html.append("<A HREF=filter_mode_").append(mode).append("><b><u>").append("FILTER</b></u></A>&nbsp;&nbsp;&nbsp;");
                    html.append("<A HREF=#").append("-4").append("><b><u>").append("GO TO CURRENT SEGMENT</b></u></A>");
                    html.append("</p>");
                    html.append("</TD>");
                    html.append(HTMLFormat.eRow);
                }
                StringBuffer sbHTML = new StringBuffer();
                if (mode == 4) {
                    content = tu.getSourceText();
                } else if (mode == 5) {
                    content = tu.getTargetText();
                }
                if (content != null) {
                    Matcher ma2 = p.matcher(content);
                    boolean tuAdded = false;
                    while (ma2.find()) {
                        if (tunitsFilter != null && !tuAdded) {
                            tunitsFilter.add(tu);
                            tuAdded = true;
                        }
                        found = true;
                        if (r != null && !tu.locked) {
                            if (AppPreferences.preserveCaseWithReplacement) {
                                String h;
                                String key = ma2.group();
                                String f = XMLHelper.adaptCase(key, r);
                                if (!f.equals(r)) {
                                    h = HTMLFormat.matchColorHTML + f + "</span>";
                                    ma2.appendReplacement(sbHTML, h);
                                    continue;
                                }
                                h = HTMLFormat.matchColorHTML + r + "</span>";
                                ma2.appendReplacement(sbHTML, h);
                                continue;
                            }
                            String h = HTMLFormat.matchColorHTML + r + "</span>";
                            ma2.appendReplacement(sbHTML, h);
                            continue;
                        }
                        String m12 = ma2.group();
                        if (m12.indexOf(36) != -1) {
                            m12 = m12.replace("$", "\\$");
                        }
                        String h = HTMLFormat.matchColorHTML + m12 + "</span>";
                        ma2.appendReplacement(sbHTML, h);
                        if (!AppPreferences.searchExtractRegExp || AppPreferences.searchType != 0) continue;
                        this.extractedResults.add(m12);
                    }
                    if (r != null && !tu.locked) {
                        this.xliff.saved = false;
                        if (mode == 4) {
                            tus = tu.getSource();
                            if (tus != null) {
                                boolean replaced = XMLHelper.replaceInXML(tus, p, r);
                                if (this.xliff.isExternalToolXLIFF && replaced) {
                                    tu.updateParentTargetSegment();
                                }
                            }
                        } else if (mode == 5 && (tut = tu.getTarget()) != null) {
                            boolean replaced = XMLHelper.replaceInXML(tut, p, r);
                            if (this.xliff.isExternalToolXLIFF && replaced) {
                                tu.updateParentTargetSegment();
                            }
                        }
                    }
                    if (sbHTML.length() > 0) {
                        List notes;
                        ma2.appendTail(sbHTML);
                        String result = XMLHelper.resolveXMLEntitiesBetweenSpanTags(sbHTML.toString());
                        result = result.replace("\n", "<br>");
                        int k = i + 1;
                        if (mode == 4) {
                            html.append(HTMLFormat.sRow);
                            html.append(HTMLFormat.TUContentRightColumn);
                            html.append("<p id=").append(i).append(">");
                            html.append(result);
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.TUContentRightColumn);
                            html.append("<p id=").append(i).append(">");
                            String target = tu.getTargetXMLText();
                            html.append(target);
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.TUStatusColumn);
                            html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.eRow);
                        } else if (mode == 5) {
                            html.append(HTMLFormat.sRow);
                            html.append(HTMLFormat.TUContentRightColumn);
                            html.append("<p id=").append(i).append(">");
                            String source = tu.getSourceXMLText();
                            html.append(source);
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.TUContentRightColumn);
                            html.append("<p id=").append(i).append(">");
                            html.append(result);
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.TUStatusColumn);
                            html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.eRow);
                        }
                        ++j;
                        String ctx = tu.getContext();
                        if (ctx != null) {
                            html.append(HTMLFormat.sRow);
                            html.append(HTMLFormat.TUNotesColumn);
                            html.append("<p>");
                            html.append(ctx);
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.TUStatusColumn);
                            html.append("<p style=\"color:red;font:bold;font-size:9px\">C</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.eRow);
                        }
                        if ((notes = tu.getNotes()) != null && notes.size() > 0) {
                            for (DefaultXMLElement c : notes) {
                                String con;
                                Object o = c.getContent(0);
                                if (o == null || (con = o.toString()).length() <= 0) continue;
                                html.append(HTMLFormat.sRow);
                                html.append(HTMLFormat.TUNotesColumn);
                                html.append("<p>");
                                html.append("<i>");
                                con = this.findURLLink(con);
                                con = con.replace("\n", "<br>");
                                html.append(con);
                                html.append("</i>");
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.TUStatusColumn);
                                html.append("<p style=\"color:red;font:bold;font-size:9px\">N</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                            }
                        }
                    }
                }
                ++i;
            }
            html.append(HTMLFormat.endTable);
            if (mode == 5 && r != null) {
                this.topui.getTargetView().replaceText(p, r);
            }
        }
        html.append(HTMLFormat.endHTML);
        return html.toString();
    }

    public String fetchTextSegments() {
        if (tunitsFilter != null) {
            return this.fetchTextCurrentSegments(tunitsFilter);
        }
        if (tunitsSGlued != null) {
            return this.fetchTextCurrentSegments(tunitsSGlued);
        }
        StringBuilder sb = new StringBuilder();
        List files = this.xliff.getFiles();
        for (int ii = 0; ii < files.size(); ++ii) {
            if (ii > 0) {
                sb.append("\n\n\n");
            }
            XliffFile xfile = (XliffFile)files.get(ii);
            FileBody body = xfile.getBody();
            List tunits = body.getTransUnits();
            ListIterator i = tunits.listIterator();
            while (i.hasNext()) {
                String tt;
                XMLElement tut;
                XLIFFUnit tu = (XLIFFUnit)i.next();
                if (!tu.translate || (tut = tu.getTarget()) == null || (tt = tu.getTargetText()).length() <= 0) continue;
                sb.append(tt);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String fetchTextSegments(int from) {
        StringBuilder sb = new StringBuilder();
        XliffFile xfile = this.xliff.getCurrentFile();
        if (xfile == null) {
            return null;
        }
        FileBody body = xfile.getBody();
        List tunits = body.getTransUnits();
        while (from < tunits.size()) {
            String tt;
            XLIFFUnit tu;
            XMLElement tut;
            Object o = tunits.get(from);
            if (o != null && o instanceof XLIFFUnit && (tut = (tu = (XLIFFUnit)o).getTarget()) != null && (tt = tu.getTargetText()).length() > 0) {
                sb.append(tt);
                sb.append("\n");
            }
            ++from;
        }
        return sb.toString();
    }

    private String fetchTextCurrentSegments(List tunits) {
        StringBuilder sb = new StringBuilder();
        ListIterator i = tunits.listIterator();
        while (i.hasNext()) {
            XLIFFUnit tu = (XLIFFUnit)i.next();
            if (!tu.translate) continue;
            if (AppPreferences.projectView == 2) {
                XMLElement tus = tu.getSource();
                if (tus == null) continue;
                String ss = tu.getSourceText();
                sb.append(ss);
                sb.append("\n");
                continue;
            }
            XMLElement tut = tu.getTarget();
            if (tut == null) continue;
            String tt = tu.getTargetText();
            sb.append(tt);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String fetchHTMLContent() {
        if (qafilter) {
            return this.fetchQAGridContent(2);
        }
        if (tunitsFilter != null) {
            return this.fetchHTMLCurrentContent(tunitsFilter);
        }
        if (tunitsSGlued != null) {
            return this.fetchHTMLCurrentContent(tunitsSGlued);
        }
        String starthtml = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body style=\"font-family:verdana;font-size:14px;\">";
        String endhtml = "</body></html>";
        String endTable = "</TABLE>";
        String startTable = "<TABLE WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLPADDING=2 CELLSPACING=2>";
        String sRow = "<TR>";
        String noNotesCol = "<TD BORDER=0 VALIGN=TOP ALIGN=LEFT>";
        String notesColumn = "<TD WIDTH=50% BORDER=0 COLOR=BLACK VALIGN=TOP ALIGN=LEFT>";
        String sIDCol = "<TD WIDTH=2% style=\"font-family:verdana;font-size:12px;\" BGCOLOR=#E5D9B7 BORDER=0 VALIGN=CENTER ALIGN=LEFT>";
        String sCol = AppPreferences.projectView != 0 ? "<TD WIDTH=40% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>" : "<TD WIDTH=80% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>";
        String eCol = "</TD>";
        StringBuilder html = new StringBuilder();
        html.append(starthtml);
        html.append(startTable);
        List files = this.xliff.getFiles();
        int id = 1;
        for (int ii = 0; ii < files.size(); ++ii) {
            String hnote;
            XliffFile xfile = (XliffFile)files.get(ii);
            String name = xfile.getAttribute("original");
            if (name != null) {
                int fs = name.lastIndexOf(AppPreferences.fs);
                if (fs == -1 && (fs = name.lastIndexOf("/")) == -1) {
                    fs = name.lastIndexOf("\\");
                }
                if (fs != -1) {
                    name = name.substring(fs + 1);
                }
                html.append("\n");
                html.append("<tr><td colspan=\"4\" align=center bgcolor=#E5D9B7><b>");
                html.append(name);
                html.append("</b></td></tr>");
            }
            if ((hnote = xfile.getHeaderNote()) != null && hnote.trim().length() > 0) {
                html.append("\n");
                html.append("<tr><td colspan=\"4\" align=left bgcolor=#E5D9B7>");
                hnote = XMLHelper.resolveXMLEntities(hnote);
                hnote = hnote.replace("\n", "<br>");
                html.append("<p><i>");
                html.append(hnote);
                html.append("</i></p>");
                html.append("</td></tr>");
            }
            FileBody body = xfile.getBody();
            List tunits = body.getTransUnits();
            for (XLIFFUnit tu : tunits) {
                if (!tu.translate) continue;
                html.append("\n");
                html.append(sRow);
                html.append(sIDCol);
                html.append(Integer.toString(id));
                html.append(eCol);
                if (AppPreferences.projectView != 0) {
                    html.append(sCol);
                    html.append("<p>");
                    String source = tu.getCurrentSourceXMLText();
                    html.append(source);
                    html.append("</p>");
                    html.append(eCol);
                }
                html.append(sCol);
                html.append("<p>");
                String target = tu.getCurrentTargetXMLText();
                html.append(target);
                html.append("</p>");
                html.append(eCol);
                int columnType = 0;
                List atrans = tu.getAltTrans();
                if (atrans != null && atrans.size() > 0) {
                    columnType = 1;
                    html.append(HTMLFormat.TURightAltTransColumn);
                    for (AltTrans alt : atrans) {
                        String con;
                        XMLElement atut;
                        if (alt == null || (atut = alt.getTarget()) == null || (con = alt.getTargetText()).length() <= 0) continue;
                        html.append("<p>");
                        html.append(con);
                        html.append("</p>");
                    }
                }
                String ctx = tu.getContext();
                List notes = tu.getNotes();
                if (ctx != null) {
                    if (columnType == 0) {
                        html.append(notesColumn);
                    }
                    columnType = 2;
                    html.append("<p>");
                    html.append(ctx);
                    html.append("</p>");
                }
                if (notes != null && notes.size() > 0) {
                    if (columnType == 0) {
                        html.append(notesColumn);
                    }
                    columnType = 2;
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0 || con.equals("propagated")) continue;
                        html.append("<p>");
                        html.append("<i>");
                        con = this.findURLLink(con);
                        con = con.replace("\n", "<br>");
                        html.append(con);
                        html.append("</i>");
                        html.append("</p>");
                    }
                }
                if (columnType == 0) {
                    html.append(noNotesCol);
                    html.append("<p>");
                    html.append("<br>");
                    html.append("</p>");
                }
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                ++id;
            }
        }
        html.append(endTable);
        html.append(endhtml);
        return html.toString();
    }

    private String fetchHTMLCurrentContent(List tunits) {
        String starthtml = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body style=\"font-family:verdana;font-size:14px;\">";
        String endhtml = "</body></html>";
        String endTable = "</TABLE>";
        String startTable = "<TABLE WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLPADDING=2 CELLSPACING=2>";
        String sRow = "<TR>";
        String noNotesCol = "<TD BORDER=0 VALIGN=TOP ALIGN=LEFT>";
        String notesColumn = "<TD WIDTH=50% BORDER=0 COLOR=BLACK VALIGN=TOP ALIGN=LEFT>";
        String sIDCol = "<TD WIDTH=2% style=\"font-family:verdana;font-size:12px;\" BGCOLOR=#E5D9B7 BORDER=0 VALIGN=CENTER ALIGN=LEFT>";
        String sCol = AppPreferences.projectView != 0 ? "<TD WIDTH=40% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>" : "<TD WIDTH=80% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>";
        String eCol = "</TD>";
        StringBuilder html = new StringBuilder();
        html.append(starthtml);
        html.append(startTable);
        int id = 1;
        for (XLIFFUnit tu : tunits) {
            List notes;
            String ctx;
            if (!tu.translate) continue;
            html.append("\n");
            html.append(sRow);
            html.append(sIDCol);
            html.append(Integer.toString(id));
            html.append(eCol);
            if (AppPreferences.projectView != 0) {
                html.append(sCol);
                html.append("<p>");
                String source = tu.getCurrentSourceXMLText();
                html.append(source);
                html.append("</p>");
                html.append(eCol);
            }
            html.append(sCol);
            html.append("<p>");
            String target = tu.getCurrentTargetXMLText();
            html.append(target);
            html.append("</p>");
            html.append(eCol);
            int columnType = 0;
            List atrans = tu.getAltTrans();
            if (atrans != null && atrans.size() > 0) {
                columnType = 1;
                html.append(HTMLFormat.TURightAltTransColumn);
                for (AltTrans alt : atrans) {
                    String con;
                    XMLElement atut;
                    if (alt == null || (atut = alt.getTarget()) == null || (con = alt.getTargetText()).length() <= 0) continue;
                    html.append("<p>");
                    html.append(con);
                    html.append("</p>");
                }
            }
            if ((ctx = tu.getContext()) != null) {
                if (columnType == 0) {
                    html.append(notesColumn);
                }
                columnType = 2;
                html.append("<p>");
                html.append(ctx);
                html.append("</p>");
            }
            if ((notes = tu.getNotes()) != null && notes.size() > 0) {
                if (columnType == 0) {
                    html.append(notesColumn);
                }
                columnType = 2;
                for (DefaultXMLElement c : notes) {
                    String con;
                    Object o = c.getContent(0);
                    if (o == null || (con = o.toString()).length() <= 0 || con.equals("propagated")) continue;
                    html.append("<p>");
                    html.append("<i>");
                    con = this.findURLLink(con);
                    con = con.replace("\n", "<br>");
                    html.append(con);
                    html.append("</i>");
                    html.append("</p>");
                }
            }
            if (columnType == 0) {
                html.append(noNotesCol);
                html.append("<p>");
                html.append("<br>");
                html.append("</p>");
            }
            html.append(HTMLFormat.eCol);
            html.append(HTMLFormat.eRow);
            ++id;
        }
        html.append(endTable);
        html.append(endhtml);
        return html.toString();
    }

    public void replaceContent(int i) {
        List tunits;
        if (tunitsFilter != null) {
            tunits = tunitsFilter;
        } else if (tunitsSGlued != null) {
            tunits = tunitsSGlued;
        } else if (this.tunitsGlued != null) {
            tunits = this.tunitsGlued;
        } else {
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null) {
                FileBody body = file.getBody();
                tunits = body.getTransUnits();
            } else {
                return;
            }
        }
        try {
            JTextPane pane = this.prview.getProjectPane();
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            Element e = htmldoc.getElement(Integer.toString(i)).getElement(0);
            MutableAttributeSet att = (MutableAttributeSet)e.getAttributes();
            Enumeration<?> en = att.getAttributeNames();
            att.addAttribute("border", "1");
            XLIFFUnit tu = (XLIFFUnit)tunits.get(i);
            if (!tu.translate) {
                return;
            }
            String target = tu.getTargetXMLText();
            String source = tu.getSourceXMLText();
            if (source.length() == 0 && target.length() == 0) {
                return;
            }
            int k = i + 1;
            int marked = i;
            StringBuilder html = new StringBuilder();
            html.append("<div id=\"" + i + "\">");
            html.append("<A style=\"color:#FF6600\" HREF=#").append(i).append("><b>-").append(k).append("-</b></A>");
            html.append("</div>");
            htmldoc.setOuterHTML(e, html.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String fetchContent(boolean lang, int mode) {
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.projectStyles);
        html.append(HTMLFormat.startBody);
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            int size;
            FileBody body = file.getBody();
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            List tunits = tunitsFilter != null ? tunitsFilter : (tunitsSGlued != null ? tunitsSGlued : (this.tunitsGlued != null ? this.tunitsGlued : body.getTransUnits()));
            this.currentTUSize = size = tunits.size();
            if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int j = gap;
            int k = -1;
            html.append(HTMLFormat.startTableTarget);
            while (i < size) {
                XLIFFUnit tu = (XLIFFUnit)tunits.get(i);
                if (!tu.translate) {
                    ++i;
                    continue;
                }
                String content = lang ? tu.getCurrentTargetXMLText() : tu.getCurrentSourceXMLText();
                k = i + 1;
                html.append(HTMLFormat.sRow);
                XMLElement tut = tu.getTarget();
                int state = tu.getState();
                String column = tut != null ? (state == 1 || state == 2 ? (marked == i ? HTMLFormat.currentTUTargetReviewLeftCol : HTMLFormat.TUTargetReviewLeftCol) : (marked == i ? HTMLFormat.currentTUTargetLeftColumn : HTMLFormat.TUTargetLeftColumn)) : (marked == i ? HTMLFormat.currentTUTargetLeftColumn : HTMLFormat.TUTargetLeftColumn);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (tunitsFilter != null && this.queryType == 5 && this.query != null) {
                        StringBuffer sbHTML = new StringBuffer();
                        Pattern p = AppPreferences.searchCase ? Pattern.compile(this.query) : Pattern.compile(this.query, 66);
                        Matcher ma = p.matcher(content);
                        while (ma.find()) {
                            String m = ma.group();
                            String h = HTMLFormat.matchColorHTML + m + "</span>";
                            ma.appendReplacement(sbHTML, h);
                        }
                        ma.appendTail(sbHTML);
                        content = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(content);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                if (state == 1) {
                    html.append(HTMLFormat.TUTargetReviewStatusColumn);
                } else if (state == 2) {
                    html.append(HTMLFormat.TUTargetApprovedStatusColumn);
                } else if (state == 3) {
                    html.append(HTMLFormat.TUTargetRejectedStatusColumn);
                } else {
                    html.append(HTMLFormat.TUTargetStatusColumn);
                }
                if (tu.bookmark) {
                    html.append("<div style=\"color:red;font:bold\">B</div>");
                }
                if (marked == i) {
                    html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                } else {
                    html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                }
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                List atrans = tu.getAltTrans();
                if (atrans != null && atrans.size() > 0) {
                    for (AltTrans alt : atrans) {
                        String con;
                        XMLElement atut;
                        if (alt == null || (atut = alt.getTarget()) == null || (con = alt.getTargetText()).length() <= 0) continue;
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightTargetAltTransColumn);
                        html.append("<p>");
                        html.append(con);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        if (state == 1 || state == 2) {
                            html.append(HTMLFormat.TUTargetReviewStatusColumn);
                        } else {
                            html.append(HTMLFormat.TUTargetStatusColumn);
                        }
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                String ctx = tu.getContext();
                List notes = tu.getNotes();
                if (ctx != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.TURightTargetNotesColumn);
                    html.append("<p>");
                    html.append(ctx);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                if (notes != null && notes.size() > 0) {
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightTargetNotesColumn);
                        html.append("<p>");
                        html.append("<i>");
                        con = this.findURLLink(con);
                        con = con.replace("\n", "<br>");
                        html.append(con);
                        html.append("</i>");
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            html.append(HTMLFormat.endTable);
            html.append(HTMLFormat.endHTML);
        }
        return html.toString();
    }

    public String[] fetchContentSplit(boolean lang, int mode) {
        this.topui.getTargetView().setCurrentTUStatus("", "");
        boolean topGrid = true;
        StringBuilder header1 = new StringBuilder();
        StringBuilder header2 = new StringBuilder();
        header1.append(HTMLFormat.startHTML);
        header1.append(HTMLFormat.projectStyles);
        header1.append(HTMLFormat.startBody);
        header2.append(HTMLFormat.startHTML);
        header2.append(HTMLFormat.projectStyles);
        header2.append(HTMLFormat.startBody);
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            int size;
            FileBody body = file.getBody();
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            List tunits = tunitsFilter != null ? tunitsFilter : (tunitsSGlued != null ? tunitsSGlued : (this.tunitsGlued != null ? this.tunitsGlued : body.getTransUnits()));
            this.currentTUSize = size = tunits.size();
            if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                if (marked < gap) {
                    gap += marked;
                }
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int j = gap;
            int k = -1;
            header1.append(HTMLFormat.startTableTarget);
            header2.append(HTMLFormat.startTableTarget);
            while (i < size) {
                StringBuilder html = new StringBuilder();
                if (i > marked) {
                    topGrid = false;
                }
                XLIFFUnit tu = (XLIFFUnit)tunits.get(i);
                if (!tu.translate) {
                    ++i;
                    continue;
                }
                boolean prop = false;
                StringBuilder nhtml = new StringBuilder();
                int state = tu.getState();
                String ctx = tu.getContext();
                List notes = tu.getNotes();
                if (ctx != null) {
                    nhtml.append(HTMLFormat.sRow);
                    nhtml.append(HTMLFormat.TURightTargetNotesColumn);
                    nhtml.append("<p>");
                    nhtml.append(ctx);
                    nhtml.append("</p>");
                    nhtml.append(HTMLFormat.eCol);
                    if (state == 1 || state == 2) {
                        nhtml.append(HTMLFormat.TUTargetReviewStatusColumn);
                    } else {
                        nhtml.append(HTMLFormat.TUTargetStatusColumn);
                    }
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(HTMLFormat.eRow);
                }
                if (notes != null && notes.size() > 0) {
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        if (con.equals("propagated")) {
                            prop = true;
                            continue;
                        }
                        nhtml.append(HTMLFormat.sRow);
                        nhtml.append(HTMLFormat.TURightTargetNotesColumn);
                        nhtml.append("<p>");
                        nhtml.append("<i>");
                        con = this.findURLLink(con);
                        con = con.replace("\n", "<br>");
                        nhtml.append(con);
                        nhtml.append("</i>");
                        nhtml.append("</p>");
                        nhtml.append(HTMLFormat.eCol);
                        if (state == 1 || state == 2) {
                            nhtml.append(HTMLFormat.TUTargetReviewStatusColumn);
                        } else {
                            nhtml.append(HTMLFormat.TUTargetStatusColumn);
                        }
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.eRow);
                    }
                }
                if (marked != i || this.lastTU) {
                    String content = lang ? tu.getCurrentTargetXMLText() : tu.getCurrentSourceXMLText();
                    k = i + 1;
                    html.append(HTMLFormat.sRow);
                    XMLElement tut = tu.getTarget();
                    String column = tut != null ? (state == 2 ? HTMLFormat.TUTargetApprovedLeftCol : (state == 1 ? HTMLFormat.TUTargetReviewLeftCol : (state == 3 ? HTMLFormat.TUTargetRejectedLeftCol : HTMLFormat.TUTargetLeftColumn))) : HTMLFormat.TUTargetLeftColumn;
                    html.append(column);
                    html.append("<p id=").append(i).append(">");
                    html.append(content);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    if (state == 1) {
                        html.append(HTMLFormat.TUTargetReviewStatusColumn);
                    } else if (state == 2) {
                        html.append(HTMLFormat.TUTargetApprovedStatusColumn);
                    } else if (state == 3) {
                        html.append(HTMLFormat.TUTargetRejectedStatusColumn);
                    } else {
                        html.append(HTMLFormat.TUTargetStatusColumn);
                    }
                    html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                } else {
                    boolean subscript;
                    k = i + 1;
                    String currentID = "#" + i;
                    StringBuilder statusString = new StringBuilder(64);
                    statusString.append(HTMLFormat.startHTML);
                    statusString.append(HTMLFormat.startBody);
                    statusString.append(HTMLFormat.startStatusTable);
                    statusString.append(HTMLFormat.sRow);
                    if (tu.percent != null) {
                        subscript = false;
                        if (state == 1) {
                            statusString.append(HTMLFormat.TUReviewStatusColumn);
                        } else if (state == 2) {
                            statusString.append(HTMLFormat.TUApprovedStatusColumn);
                        } else if (state == 3) {
                            statusString.append(HTMLFormat.TURejectedStatusColumn);
                        } else {
                            statusString.append(HTMLFormat.TUStatusColumn);
                        }
                        statusString.append(k);
                        if (tu.bookmark) {
                            subscript = true;
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('B');
                        }
                        if (tu.locked) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('L');
                        }
                        if (tu.repetition || tu.repetitionFirst) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('R');
                        }
                        if (!tu.propagate) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append("nP");
                        } else if (prop || tu.autopropagated) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('P');
                        }
                        if (subscript) {
                            statusString.append(HTMLFormat.subEnd);
                        }
                        if (tunitsFilter != null) {
                            int realID = tu.getUnitID();
                            if (realID != k) {
                                statusString.append("<br>");
                                statusString.append("<span>");
                                statusString.append(tu.getUnitID());
                                statusString.append("</span>");
                            }
                            currentID = "$" + tu.getUnitID();
                        }
                        statusString.append("<br>");
                        if (tu.getMatch() < 100) {
                            statusString.append(HTMLFormat.matchFuzzySDL);
                        } else {
                            statusString.append(HTMLFormat.match100SDL);
                        }
                        statusString.append(tu.percent);
                        statusString.append("</span>");
                        if (tu.edited) {
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('*');
                            statusString.append(HTMLFormat.subEnd);
                        }
                    } else {
                        int t;
                        if (state == 1) {
                            statusString.append(HTMLFormat.TUReviewStatusColumn);
                        } else if (state == 2) {
                            statusString.append(HTMLFormat.TUApprovedStatusColumn);
                        } else if (state == 3) {
                            statusString.append(HTMLFormat.TURejectedStatusColumn);
                        } else {
                            statusString.append(HTMLFormat.TUStatusColumn);
                        }
                        statusString.append(k);
                        subscript = false;
                        if (tu.bookmark) {
                            subscript = true;
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('B');
                        }
                        if (tu.locked) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('L');
                        }
                        if (tu.repetition || tu.repetitionFirst) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('R');
                        }
                        if (!tu.propagate) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append("nP");
                        } else if (prop || tu.autopropagated) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('P');
                        }
                        if (subscript) {
                            statusString.append(HTMLFormat.subEnd);
                        }
                        if (tunitsFilter != null) {
                            int realID = tu.getUnitID();
                            if (realID != k) {
                                statusString.append("<br>");
                                statusString.append("<span>");
                                statusString.append(tu.getUnitID());
                                statusString.append("</span>");
                            }
                            currentID = "$" + tu.getUnitID();
                        }
                        if ((t = tu.getMatchType()) != -1) {
                            int v;
                            StringBuilder matchString = new StringBuilder();
                            if (t == 1) {
                                v = tu.getMatch();
                                if (v < 101) {
                                    matchString.append(HTMLFormat.match100);
                                } else if (v == 101) {
                                    matchString.append(HTMLFormat.match101);
                                } else if (v == 102) {
                                    matchString.append(HTMLFormat.match102);
                                }
                                matchString.append(v);
                                matchString.append("%");
                                matchString.append("</span>");
                            } else if (t == 2) {
                                v = tu.getMatch();
                                matchString.append(HTMLFormat.matchFuzzy);
                                matchString.append(v);
                                matchString.append("%");
                                matchString.append("</span>");
                            } else if (t == 3 && AppPreferences.labelAA) {
                                matchString.append(HTMLFormat.matchAA);
                                matchString.append("CT");
                                matchString.append("</span>");
                            } else if (t == 0 && AppPreferences.labelMT) {
                                matchString.append(HTMLFormat.matchAI);
                                matchString.append("AI");
                                matchString.append("</span>");
                            } else if (t == 4 && AppPreferences.labelMT) {
                                matchString.append(HTMLFormat.matchMT);
                                matchString.append("MT");
                                matchString.append("</span>");
                            } else if (t == 5 && AppPreferences.labelHT) {
                                matchString.append(HTMLFormat.matchHT);
                                matchString.append("HT");
                                matchString.append("</span>");
                            }
                            if (tu.edited && AppPreferences.labelEdited) {
                                matchString.append(HTMLFormat.subStart);
                                matchString.append('*');
                                matchString.append(HTMLFormat.subEnd);
                            }
                            statusString.append("<br>");
                            statusString.append((CharSequence)matchString);
                        }
                    }
                    statusString.append(HTMLFormat.eCol);
                    statusString.append(HTMLFormat.eRow);
                    statusString.append(HTMLFormat.endTable);
                    statusString.append(HTMLFormat.endHTML);
                    this.topui.getTargetView().setCurrentTUStatus(statusString.toString(), currentID);
                }
                List atrans = tu.getAltTrans();
                if (atrans != null && atrans.size() > 0) {
                    for (AltTrans alt : atrans) {
                        String con;
                        XMLElement atut;
                        if (alt == null || (atut = alt.getTarget()) == null || (con = alt.getTargetText()).length() <= 0) continue;
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightTargetAltTransColumn);
                        html.append("<p>");
                        html.append(con);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        if (state == 1 || state == 2) {
                            html.append(HTMLFormat.TUTargetReviewStatusColumn);
                        } else {
                            html.append(HTMLFormat.TUTargetStatusColumn);
                        }
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                if (nhtml.length() > 0) {
                    html.append((CharSequence)nhtml);
                }
                if (topGrid) {
                    header1.append((CharSequence)html);
                } else {
                    header2.append((CharSequence)html);
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            header1.append(HTMLFormat.endTable);
            header1.append(HTMLFormat.endHTML);
            header2.append(HTMLFormat.endTable);
            header2.append(HTMLFormat.endHTML);
        }
        this.lastTU = false;
        String[] arr = new String[]{header1.toString(), header2.toString()};
        return arr;
    }

    public String fetchQAGridContent(int mode) {
        StringBuilder html = new StringBuilder();
        if (mode == 2) {
            html.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head>");
        } else {
            html.append(HTMLFormat.startHTML);
        }
        html.append(HTMLFormat.projectStyles);
        html.append(HTMLFormat.startBody);
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            int multi = -1;
            int superMulti = -1;
            List list = this.prview.getProject().getProjects();
            if (list != null && list.size() > 1) {
                superMulti = list.size();
            } else {
                int nf = this.xliff.getFiles().size();
                if (nf > 1) {
                    multi = nf;
                }
            }
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            if (tunitsFilter == null) {
                return "";
            }
            List tunits = tunitsFilter;
            int size = tunits.size();
            if (mode == 2) {
                this.fromIndex = 0;
                gap = size;
            } else if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int j = gap;
            int k = -1;
            html.append(HTMLFormat.startTableQA);
            html.append("<tr><td colspan=2 align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">TRANSLATION UNITS: ").append(Integer.toString(size)).append("</td></tr>");
            int currentFileID = -1;
            int currentProjectID = -1;
            while (i < size) {
                XLIFFUnit tucontext;
                String h;
                String m;
                StringBuffer sbHTML;
                XLIFFUnit tucontext2;
                int state;
                XLIFFUnit tu = (XLIFFUnit)tunits.get(i);
                if (!tu.translate) {
                    ++i;
                    continue;
                }
                String target = tu.getCurrentTargetXMLText();
                String source = tu.getCurrentSourceXMLText();
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                int pid = tu.getProjectID();
                int fid = tu.getFileID();
                if (multi > 1 && fid != currentFileID) {
                    html.append("<tr><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(fid + 1).append('/').append(multi).append("</td><td></td></tr>");
                    currentFileID = fid;
                } else if (superMulti > 1 && pid != currentProjectID) {
                    html.append("<tr><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(pid + 1).append('/').append(superMulti).append("</td><td></td></tr>");
                    currentProjectID = pid;
                }
                k = i + 1;
                XMLElement tut = tu.getTarget();
                String column = tut != null ? ((state = tu.getState()) == 1 ? (marked == i ? HTMLFormat.currentTUReviewLeftCol : HTMLFormat.TUReviewLeftCol) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TUContentRightColumn)) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TURightColumn);
                String ctx = tu.getContext();
                List notes = tu.getNotes();
                boolean prop = false;
                StringBuilder nhtml = new StringBuilder();
                if (ctx != null) {
                    nhtml.append(HTMLFormat.sRow);
                    nhtml.append(HTMLFormat.TUNotesColumn);
                    nhtml.append("<p>");
                    nhtml.append(ctx);
                    nhtml.append("</p>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(HTMLFormat.TUStatusColumn);
                    nhtml.append("<a href=#").append(i).append("_C").append("><b>").append("C").append("</b></a>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(HTMLFormat.eRow);
                }
                if (notes != null && notes.size() > 0) {
                    int ncount = -1;
                    Iterator ai = notes.iterator();
                    while (ai.hasNext()) {
                        String con;
                        ++ncount;
                        DefaultXMLElement c = (DefaultXMLElement)ai.next();
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        if (con.equals("propagated")) {
                            prop = true;
                            continue;
                        }
                        nhtml.append(HTMLFormat.sRow);
                        nhtml.append(HTMLFormat.TUNotesColumn);
                        nhtml.append("<p>");
                        nhtml.append("<i>");
                        con = this.findURLLink(con);
                        con = con.replace("\n", "<br>");
                        nhtml.append(con);
                        nhtml.append("</i>");
                        nhtml.append("</p>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.TUStatusColumn);
                        nhtml.append("<a href=#").append(i).append("_N").append(ncount).append("><b>").append("N").append("</b></a>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.eRow);
                    }
                }
                List issues = tu.getIssues();
                Matcher qmatcher = null;
                boolean qlang = false;
                boolean firstIssue = true;
                for (Issue issue : issues) {
                    String message;
                    if (qmatcher == null) {
                        qmatcher = issue.getQuery();
                        qlang = issue.getQueryLanguage();
                    }
                    String[] messages = issue.getMessages();
                    for (int l = 0; l < messages.length && (message = messages[l]) != null; ++l) {
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightColQA);
                        html.append("<p style=\"color:white\">");
                        html.append(message);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        if (++l < messages.length) {
                            message = messages[l];
                            if (message != null) {
                                html.append(HTMLFormat.TURightColQA);
                                html.append("<p style=\"color:white\">");
                                html.append(message);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                            } else {
                                html.append(HTMLFormat.TULeftColQA);
                                html.append(HTMLFormat.eCol);
                            }
                        } else {
                            html.append(HTMLFormat.TULeftColQA);
                            html.append(HTMLFormat.eCol);
                        }
                        if (marked == i) {
                            html.append(HTMLFormat.TUStatusColumnCurrent);
                        } else {
                            html.append(HTMLFormat.TUStatusColumn);
                        }
                        if (firstIssue) {
                            firstIssue = false;
                            html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                            StringBuilder statusString = new StringBuilder(64);
                            if (tu.bookmark) {
                                statusString.append(HTMLFormat.subStart);
                                statusString.append('B');
                            }
                            if (tu.locked) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('L');
                            }
                            if (tu.repetition || tu.repetitionFirst) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('R');
                            }
                            if (!tu.propagate) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append("nP");
                            } else if (prop || tu.autopropagated) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('P');
                            }
                            if (tu.edited) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('*');
                            }
                            if (statusString.length() > 0) {
                                statusString.append(HTMLFormat.subEnd);
                                html.append((CharSequence)statusString);
                            }
                        }
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                if (marked == i && AppPreferences.contextInFilter && (tucontext2 = tu.getPreviousTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    String context = tucontext2.getCurrentSourceXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = tucontext2.getCurrentTargetXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                html.append(HTMLFormat.sRow);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        source = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(source);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && !qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        target = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(target);
                html.append("</p>");
                int id = tu.getUnitID();
                if (multi > 1 && this.tunitsGlued == null && tunitsSGlued == null) {
                    id = tu.getUnitNumber();
                }
                html.append("<div align=right>");
                html.append("<A HREF=$").append(id).append("><b>").append(id).append("</b></A>");
                html.append("</div>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                if (marked == i && AppPreferences.contextInFilter && (tucontext = tu.getNextTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    String context = tucontext.getCurrentSourceXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = tucontext.getCurrentTargetXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                if (nhtml.length() > 0) {
                    html.append((CharSequence)nhtml);
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            html.append(HTMLFormat.endTable);
            html.append(HTMLFormat.endHTML);
        }
        return html.toString();
    }

    public String[] fetchQAGridSplitContent(int mode) {
        boolean topGrid = true;
        StringBuilder header1 = new StringBuilder();
        StringBuilder header2 = new StringBuilder();
        header1.append(HTMLFormat.startHTML);
        header1.append(HTMLFormat.projectStyles);
        header1.append(HTMLFormat.startBody);
        header2.append(HTMLFormat.startHTML);
        header2.append(HTMLFormat.projectStyles);
        header2.append(HTMLFormat.startBody);
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            int multi = -1;
            int superMulti = -1;
            List list = this.prview.getProject().getProjects();
            if (list != null && list.size() > 1) {
                superMulti = list.size();
            } else {
                int nf = this.xliff.getFiles().size();
                if (nf > 1) {
                    multi = nf;
                }
            }
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            if (tunitsFilter == null) {
                String[] arr = new String[]{"", ""};
                return arr;
            }
            List tunits = tunitsFilter;
            int size = tunits.size();
            if (mode == 2) {
                this.fromIndex = 0;
                gap = size;
            } else if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                if (marked < gap) {
                    gap += marked;
                }
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int j = gap;
            int k = -1;
            header1.append(HTMLFormat.startTableQA);
            header2.append(HTMLFormat.startTableQA);
            header1.append("<tr><td colspan=2 align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">TRANSLATION UNITS: ").append(Integer.toString(size)).append("</td></tr>");
            int currentFileID = -1;
            int currentProjectID = -1;
            while (i < size) {
                XLIFFUnit tucontext;
                String h;
                String m;
                StringBuffer sbHTML;
                XLIFFUnit tucontext2;
                int state;
                StringBuilder html = new StringBuilder();
                if (i > marked) {
                    topGrid = false;
                }
                XLIFFUnit tu = (XLIFFUnit)tunits.get(i);
                if (!tu.translate) {
                    ++i;
                    continue;
                }
                String target = tu.getCurrentTargetXMLText();
                String source = tu.getCurrentSourceXMLText();
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                int pid = tu.getProjectID();
                int fid = tu.getFileID();
                if (multi > 1 && fid != currentFileID) {
                    html.append("<tr><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(fid + 1).append('/').append(multi).append("</td><td></td></tr>");
                    currentFileID = fid;
                } else if (superMulti > 1 && pid != currentProjectID) {
                    html.append("<tr><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td align=center style='color: white' BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(pid + 1).append('/').append(superMulti).append("</td><td></td></tr>");
                    currentProjectID = pid;
                }
                k = i + 1;
                XMLElement tut = tu.getTarget();
                String column = tut != null ? ((state = tu.getState()) == 1 ? (marked == i ? HTMLFormat.currentTUReviewLeftCol : HTMLFormat.TUReviewLeftCol) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TUContentRightColumn)) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TURightColumn);
                String ctx = tu.getContext();
                List notes = tu.getNotes();
                boolean prop = false;
                StringBuilder nhtml = new StringBuilder();
                if (ctx != null) {
                    nhtml.append(HTMLFormat.sRow);
                    nhtml.append(HTMLFormat.TUNotesColumn);
                    nhtml.append("<p>");
                    nhtml.append(ctx);
                    nhtml.append("</p>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(HTMLFormat.TUStatusColumn);
                    nhtml.append("<a href=#").append(i).append("_C").append("><b>").append("C").append("</b></a>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(HTMLFormat.eRow);
                }
                if (notes != null && notes.size() > 0) {
                    int ncount = -1;
                    Iterator ai = notes.iterator();
                    while (ai.hasNext()) {
                        String con;
                        ++ncount;
                        DefaultXMLElement c = (DefaultXMLElement)ai.next();
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        if (con.equals("propagated")) {
                            prop = true;
                            continue;
                        }
                        nhtml.append(HTMLFormat.sRow);
                        nhtml.append(HTMLFormat.TUNotesColumn);
                        nhtml.append("<p>");
                        nhtml.append("<i>");
                        con = this.findURLLink(con);
                        con = con.replace("\n", "<br>");
                        nhtml.append(con);
                        nhtml.append("</i>");
                        nhtml.append("</p>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.TUStatusColumn);
                        nhtml.append("<a href=#").append(i).append("_N").append(ncount).append("><b>").append("N").append("</b></a>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.eRow);
                    }
                }
                List issues = tu.getIssues();
                Matcher qmatcher = null;
                boolean qlang = false;
                boolean firstIssue = true;
                for (Issue issue : issues) {
                    String message;
                    if (qmatcher == null) {
                        qmatcher = issue.getQuery();
                        qlang = issue.getQueryLanguage();
                    }
                    String[] messages = issue.getMessages();
                    for (int l = 0; l < messages.length && (message = messages[l]) != null; ++l) {
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightColQA);
                        html.append("<p style=\"color:white\">");
                        html.append(message);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        if (++l < messages.length) {
                            message = messages[l];
                            if (message != null) {
                                html.append(HTMLFormat.TURightColQA);
                                html.append("<p style=\"color:white\">");
                                html.append(message);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                            } else {
                                html.append(HTMLFormat.TULeftColQA);
                                html.append(HTMLFormat.eCol);
                            }
                        } else {
                            html.append(HTMLFormat.TULeftColQA);
                            html.append(HTMLFormat.eCol);
                        }
                        if (marked == i) {
                            html.append(HTMLFormat.TUStatusColumnCurrent);
                        } else {
                            html.append(HTMLFormat.TUStatusColumn);
                        }
                        if (firstIssue) {
                            firstIssue = false;
                            html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                            StringBuilder statusString = new StringBuilder(64);
                            if (tu.bookmark) {
                                statusString.append(HTMLFormat.subStart);
                                statusString.append('B');
                            }
                            if (tu.locked) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('L');
                            }
                            if (tu.repetition || tu.repetitionFirst) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('R');
                            }
                            if (!tu.propagate) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append("nP");
                            } else if (prop || tu.autopropagated) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('P');
                            }
                            if (tu.edited) {
                                if (statusString.length() == 0) {
                                    statusString.append(HTMLFormat.subStart);
                                }
                                statusString.append('*');
                            }
                            if (statusString.length() > 0) {
                                statusString.append(HTMLFormat.subEnd);
                                html.append((CharSequence)statusString);
                            }
                        }
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                if (marked == i && AppPreferences.contextInFilter && (tucontext2 = tu.getPreviousTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    String context = tucontext2.getCurrentSourceXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = tucontext2.getCurrentTargetXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                html.append(HTMLFormat.sRow);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        source = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(source);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && !qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        target = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(target);
                html.append("</p>");
                int id = tu.getUnitID();
                if (multi > 1 && this.tunitsGlued == null && tunitsSGlued == null) {
                    id = tu.getUnitNumber();
                }
                html.append("<div align=right>");
                html.append("<A HREF=$").append(id).append("><b>").append(id).append("</b></A>");
                html.append("</div>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                if (marked == i && AppPreferences.contextInFilter && (tucontext = tu.getNextTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    String context = tucontext.getCurrentSourceXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = tucontext.getCurrentTargetXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                if (nhtml.length() > 0) {
                    html.append((CharSequence)nhtml);
                }
                if (topGrid) {
                    header1.append((CharSequence)html);
                } else {
                    header2.append((CharSequence)html);
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            header1.append(HTMLFormat.endTable);
            header1.append(HTMLFormat.endHTML);
            header2.append(HTMLFormat.endTable);
            header2.append(HTMLFormat.endHTML);
        }
        String[] arr = new String[]{header1.toString(), header2.toString()};
        return arr;
    }

    public String fetchGridContent(int mode) {
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.projectStyles);
        html.append(HTMLFormat.startBody);
        int multi = -1;
        int superMulti = -1;
        List list = this.prview.getProject().getProjects();
        if (list != null && list.size() > 1) {
            superMulti = list.size();
        } else {
            int nf = this.xliff.getFiles().size();
            if (nf > 1) {
                multi = nf;
            }
        }
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            int size;
            List tunits;
            html.append(HTMLFormat.startGrid);
            FileBody body = file.getBody();
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            String filterMode = "";
            if (tunitsFilter != null) {
                tunits = tunitsFilter;
                filterMode = "F";
            } else if (tunitsSGlued != null) {
                tunits = tunitsSGlued;
                filterMode = "G";
            } else if (this.tunitsGlued != null) {
                tunits = this.tunitsGlued;
                if (superMulti == -1) {
                    filterMode = "G";
                }
            } else {
                tunits = body.getTransUnits();
            }
            this.currentTUSize = size = tunits.size();
            html.append("<tr><td colspan=2 align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">TRANSLATION UNITS: ").append(Integer.toString(size)).append("</td></tr>");
            if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int k = -1;
            int currentFileID = -1;
            int currentProjectID = -1;
            while (i < size) {
                XLIFFUnit tucontext;
                String h;
                String m;
                Matcher ma;
                Pattern p;
                XLIFFUnit tucontext2;
                String con;
                Iterator ai;
                XLIFFUnit tu = (XLIFFUnit)tunits.get(i);
                if (!tu.translate) {
                    ++i;
                    continue;
                }
                int pid = tu.getProjectID();
                int fid = tu.getFileID();
                if (multi > 1 && fid != currentFileID) {
                    html.append("<tr><td align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(fid + 1).append('/').append(multi).append("</td>");
                    html.append("<td align=center COLOR=RED><b>");
                    html.append(filterMode);
                    html.append("</b></td></tr>");
                    currentFileID = fid;
                } else if (superMulti > 1 && pid != currentProjectID) {
                    html.append("<tr><td align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(pid + 1).append('/').append(superMulti).append("</td>");
                    html.append("<td align=center COLOR=RED><b>");
                    html.append(filterMode);
                    html.append("</b></td></tr>");
                    currentProjectID = pid;
                }
                String target = tu.getCurrentTargetXMLText();
                String source = tu.getCurrentSourceXMLText();
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                k = i + 1;
                int state = tu.getState();
                String column = marked == i || tu.isJoined() ? (state == 1 || state == 2 ? HTMLFormat.currentTUContentReviewColumn : HTMLFormat.currentTUContentRightColumn) : (state == 1 || state == 2 ? HTMLFormat.TUContentReviewColumn : HTMLFormat.TUContentRightColumn);
                String ctx = tu.getContext();
                List atrans = tu.getAltTrans();
                List notes = tu.getNotes();
                boolean prop = false;
                StringBuilder nhtml = new StringBuilder();
                if (ctx != null) {
                    String notesStatusCell = marked == i || tu.isJoined() ? HTMLFormat.TUStatusColumnCurrent : HTMLFormat.TUStatusColumn;
                    nhtml.append(HTMLFormat.sRow);
                    nhtml.append(HTMLFormat.TUNotesColumn);
                    nhtml.append("<p>");
                    nhtml.append(ctx);
                    nhtml.append("</p>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(notesStatusCell);
                    nhtml.append("<a href=#").append(i).append("_C").append("><b>").append("C").append("</b></a>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(HTMLFormat.eRow);
                }
                if (notes != null && notes.size() > 0) {
                    int ncount = -1;
                    String notesStatusCell = marked == i || tu.isJoined() ? HTMLFormat.TUStatusColumnCurrent : HTMLFormat.TUStatusColumn;
                    ai = notes.iterator();
                    while (ai.hasNext()) {
                        ++ncount;
                        DefaultXMLElement c = (DefaultXMLElement)ai.next();
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        if (con.equals("propagated")) {
                            prop = true;
                            continue;
                        }
                        nhtml.append(HTMLFormat.sRow);
                        nhtml.append(HTMLFormat.TUNotesColumn);
                        nhtml.append("<p>");
                        nhtml.append("<i>");
                        con = this.findURLLink(con);
                        con = con.replace("\n", "<br>");
                        nhtml.append(con);
                        nhtml.append("</i>");
                        nhtml.append("</p>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(notesStatusCell);
                        nhtml.append("<a href=#").append(i).append("_N").append(ncount).append("><b>").append("N").append("</b></a>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.eRow);
                    }
                }
                if (marked == i && tunitsFilter != null && AppPreferences.contextInFilter && (tucontext2 = tu.getPreviousTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    String context = tucontext2.getCurrentSourceXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = tucontext2.getCurrentTargetXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TUStatusColumn);
                    html.append("<a href=$").append(tucontext2.getUnitID()).append("><b>").append("CTX").append("</b></a>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                html.append(HTMLFormat.sRow);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (tunitsFilter != null && this.queryType == 4 && this.query != null) {
                        StringBuffer sbHTML = new StringBuffer();
                        p = AppPreferences.searchCase ? Pattern.compile("<.+?>|" + this.query) : Pattern.compile("<.+?>|" + this.query, 66);
                        ma = p.matcher(source);
                        while (ma.find()) {
                            m = ma.group();
                            if (m.startsWith("<") && m.endsWith(">")) {
                                ma.appendReplacement(sbHTML, m);
                                continue;
                            }
                            if (m.indexOf(36) != -1) {
                                m = m.replace("$", "\\$");
                            }
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            ma.appendReplacement(sbHTML, h);
                        }
                        ma.appendTail(sbHTML);
                        source = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(source);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (tunitsFilter != null && this.queryType == 5 && this.query != null) {
                        StringBuffer sbHTML = new StringBuffer();
                        p = AppPreferences.searchCase ? Pattern.compile("<.+?>|" + this.query) : Pattern.compile("<.+?>|" + this.query, 66);
                        ma = p.matcher(target);
                        while (ma.find()) {
                            m = ma.group();
                            if (m.startsWith("<") && m.endsWith(">")) {
                                ma.appendReplacement(sbHTML, m);
                                continue;
                            }
                            if (m.indexOf(36) != -1) {
                                m = m.replace("$", "\\$");
                            }
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            ma.appendReplacement(sbHTML, h);
                        }
                        ma.appendTail(sbHTML);
                        target = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(target);
                html.append("</p>");
                if (tunitsFilter != null) {
                    int id = tu.getUnitID();
                    if (multi > 1 && this.tunitsGlued == null && tunitsSGlued == null) {
                        id = tu.getUnitNumber();
                    }
                    html.append("<div align=right>");
                    html.append("<A HREF=$").append(id).append("><b>").append(id).append("</b></A>");
                    html.append("</div>");
                }
                html.append(HTMLFormat.eCol);
                StringBuilder statusString = new StringBuilder(64);
                if (tu.percent != null) {
                    if (state == 1) {
                        html.append(HTMLFormat.TUReviewStatusColumn);
                    } else if (state == 2) {
                        html.append(HTMLFormat.TUApprovedStatusColumn);
                    } else if (state == 3) {
                        html.append(HTMLFormat.TURejectedStatusColumn);
                    } else {
                        html.append(HTMLFormat.TUStatusColumn);
                    }
                    html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                    if (tu.bookmark) {
                        statusString.append(HTMLFormat.subStart);
                        statusString.append('B');
                    }
                    if (tu.locked) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append('L');
                    }
                    if (tu.repetition || tu.repetitionFirst) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append('R');
                    }
                    if (!tu.propagate) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append("nP");
                    } else if (prop || tu.autopropagated) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append('P');
                    }
                    if (statusString.length() > 0) {
                        statusString.append(HTMLFormat.subEnd);
                        html.append((CharSequence)statusString);
                    }
                    html.append("<br>");
                    if (tu.getMatch() < 100) {
                        html.append(HTMLFormat.matchFuzzySDL);
                    } else {
                        html.append(HTMLFormat.match100SDL);
                    }
                    html.append(tu.percent);
                    html.append("</span>");
                    if (tu.edited) {
                        html.append(HTMLFormat.subStart);
                        html.append('*');
                        html.append(HTMLFormat.subEnd);
                    }
                } else {
                    if (state == 1) {
                        html.append(HTMLFormat.TUReviewStatusColumn);
                    } else if (state == 2) {
                        html.append(HTMLFormat.TUApprovedStatusColumn);
                    } else if (state == 3) {
                        html.append(HTMLFormat.TURejectedStatusColumn);
                    } else {
                        html.append(HTMLFormat.TUStatusColumn);
                    }
                    html.append("<a href=#").append(i).append("><b>").append(k).append("\u200b</b></a>");
                    if (tu.bookmark) {
                        statusString.append(HTMLFormat.subStart);
                        statusString.append('B');
                    }
                    if (tu.locked) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append('L');
                    }
                    if (tu.repetition || tu.repetitionFirst) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append('R');
                    }
                    if (!tu.propagate) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append("nP");
                    } else if (prop || tu.autopropagated) {
                        if (statusString.length() == 0) {
                            statusString.append(HTMLFormat.subStart);
                        }
                        statusString.append('P');
                    }
                    if (statusString.length() > 0) {
                        statusString.append(HTMLFormat.subEnd);
                        html.append((CharSequence)statusString);
                    }
                    html.append("<br>");
                    int t = tu.getMatchType();
                    if (t != -1) {
                        StringBuilder matchString = new StringBuilder();
                        if (t == 1) {
                            int v = tu.getMatch();
                            if (v < 101) {
                                matchString.append(HTMLFormat.match100);
                            } else if (v == 101) {
                                matchString.append(HTMLFormat.match101);
                            } else if (v == 102) {
                                matchString.append(HTMLFormat.match102);
                            }
                            matchString.append(v);
                            matchString.append("%");
                            matchString.append("</span>");
                        } else if (t == 2) {
                            int v = tu.getMatch();
                            matchString.append(HTMLFormat.matchFuzzy);
                            matchString.append(v);
                            matchString.append("%");
                            matchString.append("</span>");
                        } else if (t == 3 && AppPreferences.labelAA) {
                            matchString.append(HTMLFormat.matchAA);
                            matchString.append("CT");
                            matchString.append("</span>");
                        } else if (t == 4 && AppPreferences.labelMT) {
                            matchString.append(HTMLFormat.matchMT);
                            matchString.append("MT");
                            matchString.append("</span>");
                        } else if (t == 0 && AppPreferences.labelMT) {
                            matchString.append(HTMLFormat.matchAI);
                            matchString.append("AI");
                            matchString.append("</span>");
                        } else if (t == 5 && AppPreferences.labelHT) {
                            matchString.append(HTMLFormat.matchHT);
                            matchString.append("HT");
                            matchString.append("</span>");
                        }
                        if (tu.edited && AppPreferences.labelEdited) {
                            matchString.append(HTMLFormat.subStart);
                            matchString.append('*');
                            matchString.append(HTMLFormat.subEnd);
                        }
                        html.append((CharSequence)matchString);
                    }
                }
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                if (marked == i && tunitsFilter != null && AppPreferences.contextInFilter && (tucontext = tu.getNextTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    String context = tucontext.getCurrentSourceXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = tucontext.getCurrentTargetXMLText();
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TUStatusColumn);
                    html.append("<a href=$").append(tucontext.getUnitID()).append("><b>").append("CTX").append("</b></a>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                if (marked == i && atrans != null && atrans.size() > 0) {
                    int acount = -1;
                    ai = atrans.iterator();
                    while (ai.hasNext()) {
                        XMLElement atut;
                        ++acount;
                        AltTrans alt = (AltTrans)ai.next();
                        if (alt == null || (atut = alt.getTarget()) == null || (con = alt.getTargetText()).length() <= 0) continue;
                        html.append(HTMLFormat.sRow);
                        if (state == 1 || state == 2) {
                            html.append(HTMLFormat.TUContentReviewColumn);
                        } else {
                            html.append(HTMLFormat.TUContentRightColumn);
                        }
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TURightAltTransColumn);
                        html.append("<p>");
                        html.append(con);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TUStatusColumnCurrent);
                        html.append("<a href=#").append(i).append("_A").append(acount).append("><b>").append("A").append(acount + 1).append("</b></a>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                if (nhtml.length() > 0) {
                    html.append((CharSequence)nhtml);
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            html.append(HTMLFormat.endTable);
            html.append(HTMLFormat.endHTML);
        }
        return html.toString();
    }

    public String[] fetchGridSplitContent(int mode) {
        this.topui.getTargetView().setCurrentTUStatus("", "");
        boolean topGrid = true;
        StringBuilder header1 = new StringBuilder();
        StringBuilder header2 = new StringBuilder();
        header1.append(HTMLFormat.startHTML);
        header1.append(HTMLFormat.projectStyles);
        header1.append(HTMLFormat.startBody);
        header2.append(HTMLFormat.startHTML);
        header2.append(HTMLFormat.projectStyles);
        header2.append(HTMLFormat.startBody);
        int multi = -1;
        int superMulti = -1;
        List list = this.prview.getProject().getProjects();
        if (list != null && list.size() > 1) {
            superMulti = list.size();
        } else {
            int nf = this.xliff.getFiles().size();
            if (nf > 1) {
                multi = nf;
            }
        }
        XliffFile file = this.xliff.getCurrentFile();
        if (file != null) {
            int size;
            List tunits;
            header1.append(HTMLFormat.startGrid);
            header2.append(HTMLFormat.startGrid);
            FileBody body = file.getBody();
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            String filterMode = "";
            if (tunitsFilter != null) {
                tunits = tunitsFilter;
                filterMode = "F";
            } else if (tunitsSGlued != null) {
                tunits = tunitsSGlued;
                filterMode = "G";
            } else if (this.tunitsGlued != null) {
                tunits = this.tunitsGlued;
                if (superMulti == -1) {
                    filterMode = "G";
                }
            } else {
                tunits = body.getTransUnits();
            }
            this.currentTUSize = size = tunits.size();
            header1.append("<tr><td WIDTH=100% colspan=2 align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">TRANSLATION UNITS: ").append(Integer.toString(size)).append("</td></tr>");
            if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                if (marked < gap) {
                    gap += marked;
                }
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int k = -1;
            int currentFileID = -1;
            int currentProjectID = -1;
            while (i < size) {
                StringBuilder html = new StringBuilder();
                if (i > marked) {
                    topGrid = false;
                }
                XLIFFUnit tu = (XLIFFUnit)tunits.get(i);
                if (!tu.translate) {
                    ++i;
                    continue;
                }
                int pid = tu.getProjectID();
                int fid = tu.getFileID();
                if (multi > 1 && fid != currentFileID) {
                    html.append("<tr><td width=50% align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td width=50% align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(fid + 1).append('/').append(multi).append("</td>");
                    html.append("<td width=5% align=center COLOR=RED><b>");
                    html.append(filterMode);
                    html.append("</b></td></tr>");
                    currentFileID = fid;
                } else if (superMulti > 1 && pid != currentProjectID) {
                    html.append("<tr><td width=50% align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">DOCUMENT:</td><td width=50% align=center COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(pid + 1).append('/').append(superMulti).append("</td>");
                    html.append("<td width=5% align=center COLOR=RED><b>");
                    html.append(filterMode);
                    html.append("</b></td></tr>");
                    currentProjectID = pid;
                }
                String target = tu.getCurrentTargetXMLText();
                String source = tu.getCurrentSourceXMLText();
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                k = i + 1;
                int state = tu.getState();
                String column = state == 2 && marked != i ? HTMLFormat.TUContentApprovedColumn : (state == 1 && marked != i ? HTMLFormat.TUContentReviewColumn : (state == 3 && marked != i ? HTMLFormat.TUContentRejectedColumn : (marked != i || this.lastTU ? HTMLFormat.TUContentRightColumn : HTMLFormat.TURightColumn)));
                String ctx = tu.getContext();
                List atrans = tu.getAltTrans();
                List notes = tu.getNotes();
                boolean prop = false;
                StringBuilder nhtml = new StringBuilder();
                if (ctx != null) {
                    String notesStatusCell = marked == i || tu.isJoined() ? HTMLFormat.TUStatusColumnCurrent : HTMLFormat.TUStatusColumn;
                    nhtml.append(HTMLFormat.sRow);
                    nhtml.append(HTMLFormat.TUNotesColumn);
                    nhtml.append("<p>");
                    nhtml.append(ctx);
                    nhtml.append("</p>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(notesStatusCell);
                    nhtml.append("<a href=#").append(i).append("_C").append("><b>").append("C").append("</b></a>");
                    nhtml.append(HTMLFormat.eCol);
                    nhtml.append(HTMLFormat.eRow);
                }
                if (notes != null && notes.size() > 0) {
                    int ncount = -1;
                    String notesStatusCell = marked == i || tu.isJoined() ? HTMLFormat.TUStatusColumnCurrent : HTMLFormat.TUStatusColumn;
                    Iterator ai = notes.iterator();
                    while (ai.hasNext()) {
                        String con;
                        ++ncount;
                        DefaultXMLElement c = (DefaultXMLElement)ai.next();
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        if (con.equals("propagated")) {
                            prop = true;
                            continue;
                        }
                        nhtml.append(HTMLFormat.sRow);
                        nhtml.append(HTMLFormat.TUNotesColumn);
                        nhtml.append("<p>");
                        nhtml.append("<i>");
                        con = this.findURLLink(con);
                        con = con.replace("\n", "<br>");
                        nhtml.append(con);
                        nhtml.append("</i>");
                        nhtml.append("</p>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(notesStatusCell);
                        nhtml.append("<a href=#").append(i).append("_N").append(ncount).append("><b>").append("N").append("</b></a>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.eRow);
                    }
                }
                if (marked != i || this.lastTU) {
                    html.append(HTMLFormat.sRow);
                    html.append(column);
                    html.append("<p id=").append(i).append(">");
                    html.append(source);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(column);
                    html.append("<p id=").append(i).append(">");
                    html.append(target);
                    html.append("</p>");
                    if (tunitsFilter != null) {
                        int id = tu.getUnitID();
                        if (multi > 1 && this.tunitsGlued == null && tunitsSGlued == null) {
                            id = tu.getUnitNumber();
                        }
                        html.append("<div align=right>");
                        html.append("<A HREF=$").append(id).append("><b>").append(id).append("</b></A>");
                        html.append("</div>");
                    }
                    html.append(HTMLFormat.eCol);
                    StringBuilder statusString = new StringBuilder(64);
                    if (tu.percent != null) {
                        if (state == 1) {
                            html.append(HTMLFormat.TUReviewStatusColumn);
                        } else if (state == 2) {
                            html.append(HTMLFormat.TUApprovedStatusColumn);
                        } else if (state == 3) {
                            html.append(HTMLFormat.TURejectedStatusColumn);
                        } else {
                            html.append(HTMLFormat.TUStatusColumn);
                        }
                        html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                        if (tu.bookmark) {
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('B');
                        }
                        if (tu.locked) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('L');
                        }
                        if (tu.repetition || tu.repetitionFirst) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('R');
                        }
                        if (!tu.propagate) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append("nP");
                        } else if (prop || tu.autopropagated) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('P');
                        }
                        if (statusString.length() > 0) {
                            html.append((CharSequence)statusString);
                            html.append(HTMLFormat.subEnd);
                        }
                        html.append("<br>");
                        if (tu.getMatch() < 100) {
                            html.append(HTMLFormat.matchFuzzySDL);
                        } else {
                            html.append(HTMLFormat.match100SDL);
                        }
                        html.append(tu.percent);
                        html.append("</span>");
                        if (tu.edited) {
                            html.append(HTMLFormat.subStart);
                            html.append('*');
                            html.append(HTMLFormat.subEnd);
                        }
                    } else {
                        if (state == 1) {
                            html.append(HTMLFormat.TUReviewStatusColumn);
                        } else if (state == 2) {
                            html.append(HTMLFormat.TUApprovedStatusColumn);
                        } else if (state == 3) {
                            html.append(HTMLFormat.TURejectedStatusColumn);
                        } else {
                            html.append(HTMLFormat.TUStatusColumn);
                        }
                        html.append("<a href=#").append(i).append("><b>").append(k).append("\u200b</b></a>");
                        if (tu.bookmark) {
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('B');
                        }
                        if (tu.locked) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('L');
                        }
                        if (tu.repetition || tu.repetitionFirst) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('R');
                        }
                        if (prop || tu.autopropagated) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('P');
                        } else if (!tu.propagate) {
                            if (statusString.length() == 0) {
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append("nP");
                        }
                        if (statusString.length() > 0) {
                            html.append((CharSequence)statusString);
                            html.append(HTMLFormat.subEnd);
                        }
                        html.append("<br>");
                        int t = tu.getMatchType();
                        if (t != -1) {
                            StringBuilder matchString = new StringBuilder();
                            if (t == 1) {
                                int v = tu.getMatch();
                                if (v < 101) {
                                    matchString.append(HTMLFormat.match100);
                                } else if (v == 101) {
                                    matchString.append(HTMLFormat.match101);
                                } else if (v == 102) {
                                    matchString.append(HTMLFormat.match102);
                                }
                                matchString.append(v);
                                matchString.append("%");
                                matchString.append("</span>");
                            } else if (t == 2) {
                                int v = tu.getMatch();
                                matchString.append(HTMLFormat.matchFuzzy);
                                matchString.append(v);
                                matchString.append("%");
                                matchString.append("</span>");
                            } else if (t == 3 && AppPreferences.labelAA) {
                                matchString.append(HTMLFormat.matchAA);
                                matchString.append("CT");
                                matchString.append("</span>");
                            } else if (t == 4 && AppPreferences.labelMT) {
                                matchString.append(HTMLFormat.matchMT);
                                matchString.append("MT");
                                matchString.append("</span>");
                            } else if (t == 0 && AppPreferences.labelMT) {
                                matchString.append(HTMLFormat.matchAI);
                                matchString.append("AI");
                                matchString.append("</span>");
                            } else if (t == 5 && AppPreferences.labelHT) {
                                matchString.append(HTMLFormat.matchHT);
                                matchString.append("HT");
                                matchString.append("</span>");
                            }
                            if (tu.edited && AppPreferences.labelEdited) {
                                matchString.append(HTMLFormat.subStart);
                                matchString.append('*');
                                matchString.append(HTMLFormat.subEnd);
                            }
                            html.append((CharSequence)matchString);
                        }
                    }
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                } else {
                    boolean subscript;
                    String currentID = "#" + i;
                    StringBuilder statusString = new StringBuilder(64);
                    statusString.append(HTMLFormat.startHTML);
                    statusString.append(HTMLFormat.startBody);
                    statusString.append(HTMLFormat.startStatusTable);
                    statusString.append(HTMLFormat.sRow);
                    if (tu.percent != null) {
                        subscript = false;
                        if (state == 1) {
                            statusString.append(HTMLFormat.TUReviewStatusColumn);
                        } else if (state == 2) {
                            statusString.append(HTMLFormat.TUApprovedStatusColumn);
                        } else if (state == 3) {
                            statusString.append(HTMLFormat.TURejectedStatusColumn);
                        } else {
                            statusString.append(HTMLFormat.TUStatusColumn);
                        }
                        statusString.append(k);
                        if (tu.bookmark) {
                            subscript = true;
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('B');
                        }
                        if (tu.locked) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('L');
                        }
                        if (tu.repetition || tu.repetitionFirst) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('R');
                        }
                        if (!tu.propagate) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append("nP");
                        } else if (prop || tu.autopropagated) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('P');
                        }
                        if (subscript) {
                            statusString.append(HTMLFormat.subEnd);
                        }
                        if (tunitsFilter != null) {
                            int realID = tu.getUnitID();
                            if (realID != k) {
                                statusString.append("<br>");
                                statusString.append("<span>");
                                statusString.append(tu.getUnitID());
                                statusString.append("</span>");
                            }
                            currentID = "$" + tu.getUnitID();
                        }
                        statusString.append("<br>");
                        if (tu.getMatch() < 100) {
                            statusString.append(HTMLFormat.matchFuzzySDL);
                        } else {
                            statusString.append(HTMLFormat.match100SDL);
                        }
                        statusString.append(tu.percent);
                        statusString.append("</span>");
                        if (tu.edited) {
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('*');
                            statusString.append(HTMLFormat.subEnd);
                        }
                    } else {
                        int t;
                        if (state == 1) {
                            statusString.append(HTMLFormat.TUReviewStatusColumn);
                        } else if (state == 2) {
                            statusString.append(HTMLFormat.TUApprovedStatusColumn);
                        } else if (state == 3) {
                            statusString.append(HTMLFormat.TURejectedStatusColumn);
                        } else {
                            statusString.append(HTMLFormat.TUStatusColumn);
                        }
                        statusString.append(k);
                        subscript = false;
                        if (tu.bookmark) {
                            subscript = true;
                            statusString.append(HTMLFormat.subStart);
                            statusString.append('B');
                        }
                        if (tu.locked) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('L');
                        }
                        if (tu.repetition || tu.repetitionFirst) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('R');
                        }
                        if (!tu.propagate) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append("nP");
                        } else if (prop || tu.autopropagated) {
                            if (!subscript) {
                                subscript = true;
                                statusString.append(HTMLFormat.subStart);
                            }
                            statusString.append('P');
                        }
                        if (subscript) {
                            statusString.append(HTMLFormat.subEnd);
                        }
                        if (tunitsFilter != null) {
                            int realID = tu.getUnitID();
                            if (realID != k) {
                                statusString.append("<br>");
                                statusString.append("<span>");
                                statusString.append(tu.getUnitID());
                                statusString.append("</span>");
                            }
                            currentID = "$" + tu.getUnitID();
                        }
                        if ((t = tu.getMatchType()) != -1) {
                            StringBuilder matchString = new StringBuilder();
                            if (t == 1) {
                                int v = tu.getMatch();
                                if (v < 101) {
                                    matchString.append(HTMLFormat.match100);
                                } else if (v == 101) {
                                    matchString.append(HTMLFormat.match101);
                                } else if (v == 102) {
                                    matchString.append(HTMLFormat.match102);
                                }
                                matchString.append(v);
                                matchString.append("%");
                                matchString.append("</span>");
                            } else if (t == 2) {
                                int v = tu.getMatch();
                                matchString.append(HTMLFormat.matchFuzzy);
                                matchString.append(v);
                                matchString.append("%");
                                matchString.append("</span>");
                            } else if (t == 3 && AppPreferences.labelAA) {
                                matchString.append(HTMLFormat.matchAA);
                                matchString.append("CT");
                                matchString.append("</span>");
                            } else if (t == 4 && AppPreferences.labelMT) {
                                matchString.append(HTMLFormat.matchMT);
                                matchString.append("MT");
                                matchString.append("</span>");
                            } else if (t == 0 && AppPreferences.labelMT) {
                                matchString.append(HTMLFormat.matchAI);
                                matchString.append("AI");
                                matchString.append("</span>");
                            } else if (t == 5 && AppPreferences.labelHT) {
                                matchString.append(HTMLFormat.matchHT);
                                matchString.append("HT");
                                matchString.append("</span>");
                            }
                            if (tu.edited && AppPreferences.labelEdited) {
                                matchString.append(HTMLFormat.subStart);
                                matchString.append('*');
                                matchString.append(HTMLFormat.subEnd);
                            }
                            statusString.append("<br>");
                            statusString.append((CharSequence)matchString);
                        }
                    }
                    statusString.append(HTMLFormat.eCol);
                    statusString.append(HTMLFormat.eRow);
                    statusString.append(HTMLFormat.endTable);
                    statusString.append(HTMLFormat.endHTML);
                    this.topui.getTargetView().setCurrentTUStatus(statusString.toString(), currentID);
                }
                if (marked == i && atrans != null && atrans.size() > 0) {
                    int acount = -1;
                    Iterator ai = atrans.iterator();
                    while (ai.hasNext()) {
                        String con;
                        XMLElement atut;
                        ++acount;
                        AltTrans alt = (AltTrans)ai.next();
                        if (alt == null || (atut = alt.getTarget()) == null || (con = alt.getTargetText()).length() <= 0) continue;
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightColumn);
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TURightAltTransColumn);
                        html.append("<p>");
                        html.append(con);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TUStatusColumnCurrent);
                        html.append("<a href=#").append(i).append("_A").append(acount).append("><b>").append("A").append(acount + 1).append("</b></a>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                if (nhtml.length() > 0) {
                    html.append((CharSequence)nhtml);
                }
                if (topGrid) {
                    header1.append((CharSequence)html);
                } else {
                    header2.append((CharSequence)html);
                }
                if (marked == i && tunitsFilter != null && AppPreferences.contextInFilter) {
                    XLIFFUnit tucontextNext;
                    XLIFFUnit tucontextPrev = tu.getPreviousTranslationUnit();
                    if (tucontextPrev != null) {
                        header1.append(HTMLFormat.sRow);
                        header1.append(HTMLFormat.currentTUContextRightColumn);
                        String context = tucontextPrev.getCurrentSourceXMLText();
                        header1.append("<p>");
                        header1.append(context);
                        header1.append("</p>");
                        header1.append(HTMLFormat.eCol);
                        header1.append(HTMLFormat.currentTUContextRightColumn);
                        context = tucontextPrev.getCurrentTargetXMLText();
                        header1.append("<p>");
                        header1.append(context);
                        header1.append("</p>");
                        header1.append(HTMLFormat.eCol);
                        header1.append(HTMLFormat.TUStatusColumn);
                        header1.append("<a href=$").append(tucontextPrev.getUnitID()).append("><b>").append("CTX").append("</b></a>");
                        header1.append(HTMLFormat.eCol);
                        header1.append(HTMLFormat.eRow);
                    }
                    if ((tucontextNext = tu.getNextTranslationUnit()) != null) {
                        header2.append(HTMLFormat.sRow);
                        header2.append(HTMLFormat.currentTUContextRightColumn);
                        String context = tucontextNext.getCurrentSourceXMLText();
                        header2.append("<p>");
                        header2.append(context);
                        header2.append("</p>");
                        header2.append(HTMLFormat.eCol);
                        header2.append(HTMLFormat.currentTUContextRightColumn);
                        context = tucontextNext.getCurrentTargetXMLText();
                        header2.append("<p>");
                        header2.append(context);
                        header2.append("</p>");
                        header2.append(HTMLFormat.eCol);
                        header2.append(HTMLFormat.TUStatusColumn);
                        header2.append("<a href=$").append(tucontextNext.getUnitID()).append("><b>").append("CTX").append("</b></a>");
                        header2.append(HTMLFormat.eCol);
                        header2.append(HTMLFormat.eRow);
                    }
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            header1.append(HTMLFormat.endTable);
            header1.append(HTMLFormat.endHTML);
            header2.append(HTMLFormat.endTable);
            header2.append(HTMLFormat.endHTML);
        }
        this.lastTU = false;
        String[] arr = new String[]{header1.toString(), header2.toString()};
        return arr;
    }

    public void showContent(String s, final boolean start) {
        try {
            JTextPane pane = this.prview.getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), s);
            JViewport vp = (JViewport)pane.getParent();
            final JScrollPane scroll = (JScrollPane)vp.getParent();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ XliffView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (start) {
                        scroll.getVerticalScrollBar().setValue(0);
                    } else {
                        JScrollBar bar = scroll.getVerticalScrollBar();
                        bar.setValue(bar.getMaximum());
                    }
                }
            });
            JTextPane pane2 = this.prview.getProjectPane2();
            if (pane2 != null) {
                type = pane2.getContentType();
                if (!type.equals("text/html")) {
                    pane2.setContentType("text/html");
                }
                htmldoc = (HTMLDocument)pane2.getDocument();
                htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), "<html></html>");
                pane2.setCaretPosition(0);
            }
            this.newSegment = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void showSplitContent(String[] arr, final boolean start) {
        try {
            JTextPane pane = this.prview.getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), arr[0]);
            JViewport vp = (JViewport)pane.getParent();
            final JScrollPane scroll = (JScrollPane)vp.getParent();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ XliffView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (start) {
                        scroll.getVerticalScrollBar().setValue(0);
                    } else {
                        JScrollBar bar = scroll.getVerticalScrollBar();
                        bar.setValue(bar.getMaximum());
                    }
                }
            });
            JTextPane pane2 = this.prview.getProjectPane2();
            if (pane2 != null) {
                String type2 = pane2.getContentType();
                if (!type2.equals("text/html")) {
                    pane2.setContentType("text/html");
                }
                HTMLDocument htmldoc2 = (HTMLDocument)pane2.getDocument();
                htmldoc2.setInnerHTML(htmldoc2.getDefaultRootElement(), arr[1]);
                pane2.setCaretPosition(0);
            }
            this.newSegment = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void replaceBeforeEdit(XLIFFUnit tu) {
        if (replaceString != null && !tu.locked) {
            if (replaceInSource) {
                XMLElement tus = tu.getSource();
                if (tus != null) {
                    boolean replaced = XMLHelper.replaceInXML(tus, searchPattern, replaceString);
                    if (this.xliff.isExternalToolXLIFF && replaced) {
                        tu.updateParentTargetSegment();
                    }
                }
            } else {
                XMLElement tut = tu.getTarget();
                if (tut != null) {
                    boolean replaced = XMLHelper.replaceInXML(tut, searchPattern, replaceString);
                    if (this.xliff.isExternalToolXLIFF && replaced) {
                        tu.updateParentTargetSegment();
                    }
                }
            }
        }
    }

    public void goToContent(String s, int i) {
        try {
            JTextPane pane = this.prview.getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), s);
            String text = htmldoc.getText(0, htmldoc.getLength());
            String ii = Integer.toString(i + 1) + "\u200b";
            int index = text.indexOf(ii);
            if (index != -1) {
                this.prview.scrollToSegment(index);
            }
            this.newSegment = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void goToSplitContent(String[] arr, int i) {
        this.prview.setAdjustmentType(false);
        try {
            JTextPane pane = this.prview.getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), arr[0]);
            JTextPane pane2 = this.prview.getProjectPane2();
            if (pane2 != null) {
                type = pane2.getContentType();
                if (!type.equals("text/html")) {
                    pane2.setContentType("text/html");
                }
                htmldoc = (HTMLDocument)pane2.getDocument();
                htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), arr[1]);
                pane2.setCaretPosition(0);
            }
            this.newSegment = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XliffView.this.prview.setAdjustmentType(true);
            }
        });
    }

    public void setViewMode(int mode) {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchQAGridContent(0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchQAGridSplitContent(0);
                this.showSplitContent(arr, false);
            }
        } else if (mode == 1) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchGridContent(0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchGridSplitContent(0);
                this.showSplitContent(arr, false);
            }
        } else if (mode == 0) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(true, 0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchContentSplit(true, 0);
                this.showSplitContent(arr, false);
            }
        } else if (mode == 2) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(false, 0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchContentSplit(false, 0);
                this.showSplitContent(arr, false);
            }
        }
    }

    public void refreshView() {
        if (this.currentTUIndex != -1) {
            this.browseToUnit(this.currentTUIndex);
        } else {
            this.setViewMode(AppPreferences.projectView);
        }
    }

    public void nextTUS() {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchQAGridContent(1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchQAGridSplitContent(1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(true, 1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(true, 1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchGridContent(1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchGridSplitContent(1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(false, 1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(false, 1);
                this.showSplitContent(arr, true);
            }
        }
    }

    public void previousTUS() {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchQAGridContent(-1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchQAGridSplitContent(-1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(true, -1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(true, -1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchGridContent(-1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchGridSplitContent(-1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(false, -1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(false, -1);
                this.showSplitContent(arr, true);
            }
        }
    }

    public void updateSegmentView() {
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile != null) {
            if (this.newSegment == AppPreferences.pagesize) {
                if (!qafilter) {
                    if (AppPreferences.windowsLayout != 6) {
                        String content = this.fetchGridContent(0);
                        this.showContent(content, false);
                    } else {
                        String[] arr = this.fetchGridSplitContent(0);
                        this.showSplitContent(arr, false);
                    }
                } else if (AppPreferences.windowsLayout != 6) {
                    String content = this.fetchQAGridContent(0);
                    this.showContent(content, false);
                } else {
                    String[] arr = this.fetchQAGridSplitContent(0);
                    this.showSplitContent(arr, false);
                }
                return;
            }
            ++this.newSegment;
            XLIFFUnit tu = currentFile.getBody().getlastTU();
            if (tu == null) {
                return;
            }
            try {
                StringBuilder html = new StringBuilder();
                String sCol = HTMLFormat.TUContentRightColumn;
                String eCol = "</TD>";
                String sRow = "<TR>";
                String eRow = "</TR>";
                JTextPane pane = this.prview.getProjectPane();
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                if (this.resetView) {
                    String startTable = HTMLFormat.startGrid;
                    String endTable = "</TABLE>";
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(HTMLFormat.projectStyles);
                    sb.append("<body>");
                    sb.append(startTable);
                    sb.append(endTable);
                    doc.setInnerHTML(doc.getDefaultRootElement(), sb.toString());
                    this.resetView = false;
                }
                String source = tu.getCurrentSourceXMLText();
                String target = tu.getCurrentTargetXMLText();
                int index = currentFile.getBody().getTransUnits().size() - 1;
                int k = index + 1;
                html.append(sRow);
                html.append(sCol);
                html.append("<p>");
                html.append(source);
                html.append("</p>");
                html.append(eCol);
                html.append(sCol);
                html.append("<p>");
                html.append(target);
                html.append("</p>");
                html.append(eCol);
                html.append(HTMLFormat.TUStatusColumn);
                html.append("<A HREF=#").append(index).append("><b>").append(k).append("\u200b</b></A>");
                html.append(eCol);
                html.append(eRow);
                int ne = doc.getDefaultRootElement().getElement(0).getElement(1).getElementCount();
                Element elem = doc.getDefaultRootElement().getElement(0).getElement(1).getElement(ne - 1);
                if (elem != null) {
                    doc.insertBeforeEnd(elem, html.toString());
                    JViewport vp = (JViewport)pane.getParent();
                    final JScrollPane scroll = (JScrollPane)vp.getParent();
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ XliffView this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            JScrollBar bar = scroll.getVerticalScrollBar();
                            bar.setValue(bar.getMaximum());
                        }
                    });
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(XliffView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(XliffView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void updateContentView() {
        XliffFile currentFile = this.xliff.getCurrentFile();
        if (currentFile != null) {
            if (this.newSegment == AppPreferences.pagesize) {
                if (!qafilter) {
                    if (AppPreferences.windowsLayout != 6) {
                        String content = this.fetchGridContent(0);
                        this.showContent(content, false);
                    } else {
                        String[] arr = this.fetchGridSplitContent(0);
                        this.showSplitContent(arr, false);
                    }
                } else if (AppPreferences.windowsLayout != 6) {
                    String content = this.fetchQAGridContent(0);
                    this.showContent(content, false);
                } else {
                    String[] arr = this.fetchQAGridSplitContent(0);
                    this.showSplitContent(arr, false);
                }
                return;
            }
            ++this.newSegment;
            XLIFFUnit tu = currentFile.getBody().getlastTU();
            if (tu == null) {
                return;
            }
            try {
                StringBuilder html = new StringBuilder();
                String sCol = HTMLFormat.TUTargetLeftColumn;
                String sTCol = "<TD BORDER=0 VALIGN=CENTER ALIGN=RIGHT>";
                String eCol = "</TD>";
                String sRow = "<TR>";
                String eRow = "</TR>";
                JTextPane pane = this.prview.getProjectPane();
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                if (this.resetView) {
                    String startTable = "<TABLE WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=1>";
                    String endTable = "</TABLE>";
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(HTMLFormat.projectStyles);
                    sb.append("<body>");
                    sb.append(startTable);
                    sb.append(endTable);
                    doc.setInnerHTML(doc.getDefaultRootElement(), sb.toString());
                    this.resetView = false;
                }
                String target = tu.getCurrentTargetXMLText();
                int index = currentFile.getBody().getTransUnits().size() - 1;
                int k = index + 1;
                html.append(sRow);
                html.append(sCol);
                html.append("<p>");
                html.append(target);
                html.append("</p>");
                html.append(eCol);
                html.append(sTCol);
                html.append("<A HREF=#").append(index).append("><b>").append(k).append("\u200b</b></A>");
                html.append(eCol);
                html.append(eRow);
                int ne = doc.getDefaultRootElement().getElement(0).getElement(1).getElementCount();
                Element elem = doc.getDefaultRootElement().getElement(0).getElement(1).getElement(ne - 1);
                if (elem != null) {
                    doc.insertBeforeEnd(elem, html.toString());
                    JViewport vp = (JViewport)pane.getParent();
                    final JScrollPane scroll = (JScrollPane)vp.getParent();
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ XliffView this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            JScrollBar bar = scroll.getVerticalScrollBar();
                            bar.setValue(bar.getMaximum());
                        }
                    });
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(XliffView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(XliffView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String findURLLink(String string) {
        Matcher m = this.urlPattern.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String group = m.group();
            if (group.indexOf(92) != -1) {
                group = group.replace("\\", "\\\\");
            }
            if (group.indexOf(36) != -1) {
                group = group.replace("$", "\\$");
            }
            StringBuilder sb2 = new StringBuilder();
            sb2.append("<a color=blue href=").append(group).append(">").append(group).append("</a>");
            m.appendReplacement(sb, sb2.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static {
        tunitsNestedFilter = new ArrayList();
        latinPattern = Pattern.compile("\\p{IsLatin}+");
        greekPattern = Pattern.compile("\\p{IsGreek}+");
        cyrillicPattern = Pattern.compile("\\p{IsCyrillic}+");
    }
}

