/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.swing;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.kordamp.ikonli.IkonHandler;

public class IkonResolver {
    private static final IkonResolver INSTANCE;
    private static final Set<IkonHandler> HANDLERS;

    private IkonResolver() {
    }

    public static IkonResolver getInstance() {
        return INSTANCE;
    }

    public IkonHandler resolve(String value) {
        Objects.requireNonNull(value, "Ikon description must not be null");
        for (IkonHandler handler : HANDLERS) {
            if (!handler.supports(value)) continue;
            return handler;
        }
        throw new UnsupportedOperationException("Cannot resolve '" + value + "'");
    }

    static {
        HANDLERS = new LinkedHashSet<IkonHandler>();
        INSTANCE = new IkonResolver();
        ClassLoader classLoader = IkonResolver.class.getClassLoader();
        ServiceLoader<IkonHandler> loader = ServiceLoader.load(IkonHandler.class, classLoader);
        for (IkonHandler handler : loader) {
            HANDLERS.add(handler);
            try {
                InputStream stream = classLoader.getResourceAsStream(handler.getFontResourcePath());
                Font font = Font.createFont(0, stream);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                stream.close();
                handler.setFont((Object)font);
            }
            catch (FontFormatException | IOException ffe) {
                throw new IllegalStateException(ffe);
            }
        }
    }
}

